/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.annotation.FlaggedApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.media.tv.flags.media_quality_fw")
public class ParameterCapability
implements Parcelable {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_LONG = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_STRING = 4;
    public static final String CAPABILITY_MAX = "max";
    public static final String CAPABILITY_MIN = "min";
    public static final String CAPABILITY_DEFAULT = "default";
    public static final String CAPABILITY_ENUM = "enum";
    @NonNull
    private final String mName;
    private final boolean mIsSupported;
    private final int mType;
    @NonNull
    private final Bundle mCaps;
    @NonNull
    public static final Parcelable.Creator<ParameterCapability> CREATOR = new Parcelable.Creator<ParameterCapability>(){

        @Override
        public ParameterCapability createFromParcel(Parcel in) {
            return new ParameterCapability(in);
        }

        public ParameterCapability[] newArray(int size) {
            return new ParameterCapability[size];
        }
    };

    protected ParameterCapability(Parcel in) {
        this.mName = in.readString();
        this.mIsSupported = in.readBoolean();
        this.mType = in.readInt();
        this.mCaps = in.readBundle();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeBoolean(this.mIsSupported);
        dest.writeInt(this.mType);
        dest.writeBundle(this.mCaps);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public ParameterCapability(@NonNull String name, boolean isSupported, int type, @NonNull Bundle caps) {
        this.mName = name;
        this.mIsSupported = isSupported;
        this.mType = type;
        this.mCaps = caps;
    }

    @NonNull
    public String getParameterName() {
        return this.mName;
    }

    public boolean isSupported() {
        return this.mIsSupported;
    }

    public int getParameterType() {
        return this.mType;
    }

    @NonNull
    public Bundle getCapabilities() {
        return new Bundle(this.mCaps);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Capability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ParameterType {
    }
}

