/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.media.quality.ActiveProcessingPicture;
import android.media.quality.AmbientBacklightEvent;
import android.media.quality.AmbientBacklightSettings;
import android.media.quality.IActiveProcessingPictureListener;
import android.media.quality.IAmbientBacklightCallback;
import android.media.quality.IMediaQualityManager;
import android.media.quality.IPictureProfileCallback;
import android.media.quality.ISoundProfileCallback;
import android.media.quality.ParameterCapability;
import android.media.quality.PictureProfile;
import android.media.quality.PictureProfileHandle;
import android.media.quality.SoundProfile;
import android.media.quality.SoundProfileHandle;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import com.android.internal.util.Preconditions;
import com.android.layoutlib.androidx.annotation.RequiresPermission;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@FlaggedApi(value="android.media.tv.flags.media_quality_fw")
public class MediaQualityManager {
    private static final String TAG = "MediaQualityManager";
    private final IMediaQualityManager mService;
    private final Context mContext;
    private final UserHandle mUserHandle;
    private final Object mPpLock = new Object();
    private final Object mSpLock = new Object();
    private final Object mAbLock = new Object();
    private final Object mApLock = new Object();
    private final List<PictureProfileCallbackRecord> mPpCallbackRecords = new ArrayList<PictureProfileCallbackRecord>();
    private final List<SoundProfileCallbackRecord> mSpCallbackRecords = new ArrayList<SoundProfileCallbackRecord>();
    private final List<AmbientBacklightCallbackRecord> mAbCallbackRecords = new ArrayList<AmbientBacklightCallbackRecord>();
    private final List<ActiveProcessingPictureListenerRecord> mApListenerRecords = new ArrayList<ActiveProcessingPictureListenerRecord>();
    public static final String OPTION_INCLUDE_PARAMETERS = "include_parameters";
    public static final int AMBIENT_BACKLIGHT_EVENT_ENABLED = 1;
    public static final int AMBIENT_BACKLIGHT_EVENT_DISABLED = 2;
    public static final int AMBIENT_BACKLIGHT_EVENT_METADATA = 3;
    public static final int AMBIENT_BACKLIGHT_EVENT_INTERRUPTED = 4;

    public MediaQualityManager(Context context, IMediaQualityManager service) {
        this.mContext = context;
        this.mUserHandle = context.getUser();
        this.mService = service;
        IPictureProfileCallback.Stub ppCallback = new IPictureProfileCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPictureProfileAdded(String profileId, PictureProfile profile) {
                Object object = MediaQualityManager.this.mPpLock;
                synchronized (object) {
                    for (PictureProfileCallbackRecord record : MediaQualityManager.this.mPpCallbackRecords) {
                        record.postPictureProfileAdded(profileId, profile);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPictureProfileUpdated(String profileId, PictureProfile profile) {
                Object object = MediaQualityManager.this.mPpLock;
                synchronized (object) {
                    for (PictureProfileCallbackRecord record : MediaQualityManager.this.mPpCallbackRecords) {
                        record.postPictureProfileUpdated(profileId, profile);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPictureProfileRemoved(String profileId, PictureProfile profile) {
                Object object = MediaQualityManager.this.mPpLock;
                synchronized (object) {
                    for (PictureProfileCallbackRecord record : MediaQualityManager.this.mPpCallbackRecords) {
                        record.postPictureProfileRemoved(profileId, profile);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onParameterCapabilitiesChanged(String profileId, List<ParameterCapability> caps) {
                Object object = MediaQualityManager.this.mPpLock;
                synchronized (object) {
                    for (PictureProfileCallbackRecord record : MediaQualityManager.this.mPpCallbackRecords) {
                        record.postParameterCapabilitiesChanged(profileId, caps);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String profileId, int err) {
                Object object = MediaQualityManager.this.mPpLock;
                synchronized (object) {
                    for (PictureProfileCallbackRecord record : MediaQualityManager.this.mPpCallbackRecords) {
                        record.postError(profileId, err);
                    }
                }
            }
        };
        ISoundProfileCallback.Stub spCallback = new ISoundProfileCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundProfileAdded(String profileId, SoundProfile profile) {
                Object object = MediaQualityManager.this.mSpLock;
                synchronized (object) {
                    for (SoundProfileCallbackRecord record : MediaQualityManager.this.mSpCallbackRecords) {
                        record.postSoundProfileAdded(profileId, profile);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundProfileUpdated(String profileId, SoundProfile profile) {
                Object object = MediaQualityManager.this.mSpLock;
                synchronized (object) {
                    for (SoundProfileCallbackRecord record : MediaQualityManager.this.mSpCallbackRecords) {
                        record.postSoundProfileUpdated(profileId, profile);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundProfileRemoved(String profileId, SoundProfile profile) {
                Object object = MediaQualityManager.this.mSpLock;
                synchronized (object) {
                    for (SoundProfileCallbackRecord record : MediaQualityManager.this.mSpCallbackRecords) {
                        record.postSoundProfileRemoved(profileId, profile);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onParameterCapabilitiesChanged(String profileId, List<ParameterCapability> caps) {
                Object object = MediaQualityManager.this.mSpLock;
                synchronized (object) {
                    for (SoundProfileCallbackRecord record : MediaQualityManager.this.mSpCallbackRecords) {
                        record.postParameterCapabilitiesChanged(profileId, caps);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String profileId, int err) {
                Object object = MediaQualityManager.this.mSpLock;
                synchronized (object) {
                    for (SoundProfileCallbackRecord record : MediaQualityManager.this.mSpCallbackRecords) {
                        record.postError(profileId, err);
                    }
                }
            }
        };
        IAmbientBacklightCallback.Stub abCallback = new IAmbientBacklightCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAmbientBacklightEvent(AmbientBacklightEvent event) {
                Object object = MediaQualityManager.this.mAbLock;
                synchronized (object) {
                    for (AmbientBacklightCallbackRecord record : MediaQualityManager.this.mAbCallbackRecords) {
                        record.postAmbientBacklightEvent(event);
                    }
                }
            }
        };
        IActiveProcessingPictureListener.Stub apListener = new IActiveProcessingPictureListener.Stub(){

            @Override
            public void onActiveProcessingPicturesChanged(List<ActiveProcessingPicture> aps) {
                ArrayList<ActiveProcessingPicture> nonGlobal = new ArrayList<ActiveProcessingPicture>();
                for (ActiveProcessingPicture ap : aps) {
                    if (ap.isForGlobal()) continue;
                    nonGlobal.add(ap);
                }
                for (ActiveProcessingPictureListenerRecord record : MediaQualityManager.this.mApListenerRecords) {
                    if (record.mIsGlobal) {
                        record.postActiveProcessingPicturesChanged(aps);
                        continue;
                    }
                    record.postActiveProcessingPicturesChanged(nonGlobal);
                }
            }
        };
        try {
            if (this.mService != null) {
                this.mService.registerPictureProfileCallback(ppCallback);
                this.mService.registerSoundProfileCallback(spCallback);
                this.mService.registerAmbientBacklightCallback(abCallback);
                this.mService.registerActiveProcessingPictureListener(apListener);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPictureProfileCallback(@NonNull Executor executor, @NonNull PictureProfileCallback callback) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(executor);
        Object object = this.mPpLock;
        synchronized (object) {
            this.mPpCallbackRecords.add(new PictureProfileCallbackRecord(callback, executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPictureProfileCallback(@NonNull PictureProfileCallback callback) {
        Preconditions.checkNotNull(callback);
        Object object = this.mPpLock;
        synchronized (object) {
            Iterator<PictureProfileCallbackRecord> it = this.mPpCallbackRecords.iterator();
            while (it.hasNext()) {
                PictureProfileCallbackRecord record = it.next();
                if (record.getCallback() != callback) continue;
                it.remove();
                break;
            }
        }
    }

    @Nullable
    public PictureProfile getPictureProfile(int type, @NonNull String name, @Nullable ProfileQueryParams options) {
        try {
            boolean includeParams = options == null || options.mParametersIncluded;
            return this.mService.getPictureProfile(type, name, includeParams, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    public List<PictureProfile> getPictureProfilesByPackage(@NonNull String packageName, @Nullable ProfileQueryParams options) {
        try {
            boolean includeParams = options == null || options.mParametersIncluded;
            return this.mService.getPictureProfilesByPackage(packageName, includeParams, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<PictureProfile> getAvailablePictureProfiles(@Nullable ProfileQueryParams options) {
        try {
            boolean includeParams = options == null || options.mParametersIncluded;
            return this.mService.getAvailablePictureProfiles(includeParams, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    @Nullable
    public PictureProfile getDefaultPictureProfile() {
        try {
            return this.mService.getDefaultPictureProfile();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    public boolean setDefaultPictureProfile(@Nullable String pictureProfileId) {
        try {
            return this.mService.setDefaultPictureProfile(pictureProfileId, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    public List<String> getPictureProfilePackageNames() {
        try {
            return this.mService.getPictureProfilePackageNames(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<PictureProfileHandle> getPictureProfileHandle(String[] id2) {
        try {
            return this.mService.getPictureProfileHandle(id2, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public long getPictureProfileForTvInput(String inputId) {
        try {
            return this.mService.getPictureProfileForTvInput(inputId, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public PictureProfile getCurrentPictureProfileForTvInput(String inputId) {
        try {
            return this.mService.getCurrentPictureProfileForTvInput(inputId, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<PictureProfile> getAllPictureProfilesForTvInput(String inputId) {
        try {
            return this.mService.getAllPictureProfilesForTvInput(inputId, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<SoundProfileHandle> getSoundProfileHandle(String[] id2) {
        try {
            return this.mService.getSoundProfileHandle(id2, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createPictureProfile(@NonNull PictureProfile pp) {
        try {
            this.mService.createPictureProfile(pp, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updatePictureProfile(@NonNull String profileId, @NonNull PictureProfile pp) {
        try {
            this.mService.updatePictureProfile(profileId, pp, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removePictureProfile(@NonNull String profileId) {
        try {
            this.mService.removePictureProfile(profileId, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void changeStreamStatus(@NonNull String profileId, @NonNull String newStatus) {
        try {
            this.mService.changeStreamStatus(profileId, newStatus, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSoundProfileCallback(@NonNull Executor executor, @NonNull SoundProfileCallback callback) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(executor);
        Object object = this.mSpLock;
        synchronized (object) {
            this.mSpCallbackRecords.add(new SoundProfileCallbackRecord(callback, executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSoundProfileCallback(@NonNull SoundProfileCallback callback) {
        Preconditions.checkNotNull(callback);
        Object object = this.mSpLock;
        synchronized (object) {
            Iterator<SoundProfileCallbackRecord> it = this.mSpCallbackRecords.iterator();
            while (it.hasNext()) {
                SoundProfileCallbackRecord record = it.next();
                if (record.getCallback() != callback) continue;
                it.remove();
                break;
            }
        }
    }

    @Nullable
    public SoundProfile getSoundProfile(int type, @NonNull String name, @Nullable ProfileQueryParams options) {
        try {
            boolean includeParams = options == null || options.mParametersIncluded;
            return this.mService.getSoundProfile(type, name, includeParams, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
    public List<SoundProfile> getSoundProfilesByPackage(@NonNull String packageName, @Nullable ProfileQueryParams options) {
        try {
            boolean includeParams = options == null || options.mParametersIncluded;
            return this.mService.getSoundProfilesByPackage(packageName, includeParams, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<SoundProfile> getAvailableSoundProfiles(@Nullable ProfileQueryParams options) {
        try {
            boolean includeParams = options == null || options.mParametersIncluded;
            return this.mService.getAvailableSoundProfiles(includeParams, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
    public boolean setDefaultSoundProfile(@Nullable String soundProfileId) {
        try {
            return this.mService.setDefaultSoundProfile(soundProfileId, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
    public List<String> getSoundProfilePackageNames() {
        try {
            return this.mService.getSoundProfilePackageNames(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createSoundProfile(@NonNull SoundProfile sp) {
        try {
            this.mService.createSoundProfile(sp, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateSoundProfile(@NonNull String profileId, @NonNull SoundProfile sp) {
        try {
            this.mService.updateSoundProfile(profileId, sp, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeSoundProfile(@NonNull String profileId) {
        try {
            this.mService.removeSoundProfile(profileId, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<ParameterCapability> getParameterCapabilities(@NonNull List<String> names) {
        try {
            return this.mService.getParameterCapabilities(names, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    @NonNull
    public List<String> getPictureProfileAllowList() {
        try {
            return this.mService.getPictureProfileAllowList(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    public void setPictureProfileAllowList(@NonNull List<String> packageNames) {
        try {
            this.mService.setPictureProfileAllowList(packageNames, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
    @NonNull
    public List<String> getSoundProfileAllowList() {
        try {
            return this.mService.getSoundProfileAllowList(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
    public void setSoundProfileAllowList(@NonNull List<String> packageNames) {
        try {
            this.mService.setSoundProfileAllowList(packageNames, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSupported() {
        try {
            return this.mService.isSupported(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    public void setAutoPictureQualityEnabled(boolean enabled) {
        try {
            this.mService.setAutoPictureQualityEnabled(enabled, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAutoPictureQualityEnabled() {
        try {
            return this.mService.isAutoPictureQualityEnabled(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    public void setSuperResolutionEnabled(boolean enabled) {
        try {
            this.mService.setSuperResolutionEnabled(enabled, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSuperResolutionEnabled() {
        try {
            return this.mService.isSuperResolutionEnabled(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
    public void setAutoSoundQualityEnabled(boolean enabled) {
        try {
            this.mService.setAutoSoundQualityEnabled(enabled, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAutoSoundQualityEnabled() {
        try {
            return this.mService.isAutoSoundQualityEnabled(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.READ_COLOR_ZONES")
    public void registerAmbientBacklightCallback(@NonNull Executor executor, @NonNull AmbientBacklightCallback callback) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(executor);
        Object object = this.mAbLock;
        synchronized (object) {
            this.mAbCallbackRecords.add(new AmbientBacklightCallbackRecord(callback, executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.READ_COLOR_ZONES")
    public void unregisterAmbientBacklightCallback(@NonNull AmbientBacklightCallback callback) {
        Preconditions.checkNotNull(callback);
        Object object = this.mAbLock;
        synchronized (object) {
            Iterator<AmbientBacklightCallbackRecord> it = this.mAbCallbackRecords.iterator();
            while (it.hasNext()) {
                AmbientBacklightCallbackRecord record = it.next();
                if (record.getCallback() != callback) continue;
                it.remove();
                break;
            }
        }
    }

    @RequiresPermission(value="android.permission.READ_COLOR_ZONES")
    public void setAmbientBacklightSettings(@NonNull AmbientBacklightSettings settings) {
        Preconditions.checkNotNull(settings);
        try {
            this.mService.setAmbientBacklightSettings(settings, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAmbientBacklightEnabled() {
        try {
            return this.mService.isAmbientBacklightEnabled(this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.READ_COLOR_ZONES")
    public void setAmbientBacklightEnabled(boolean enabled) {
        try {
            this.mService.setAmbientBacklightEnabled(enabled, this.mUserHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveProcessingPictureListener(@NonNull Executor executor, @NonNull Consumer<List<ActiveProcessingPicture>> listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        Object object = this.mApLock;
        synchronized (object) {
            this.mApListenerRecords.add(new ActiveProcessingPictureListenerRecord(listener, executor, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @SuppressLint(value={"PairedRegistration"})
    @RequiresPermission(value="android.permission.MANAGE_GLOBAL_PICTURE_QUALITY_SERVICE")
    public void addGlobalActiveProcessingPictureListener(@NonNull Executor executor, @NonNull Consumer<List<ActiveProcessingPicture>> listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        Object object = this.mApLock;
        synchronized (object) {
            this.mApListenerRecords.add(new ActiveProcessingPictureListenerRecord(listener, executor, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveProcessingPictureListener(@NonNull Consumer<List<ActiveProcessingPicture>> listener) {
        Preconditions.checkNotNull(listener);
        Object object = this.mApLock;
        synchronized (object) {
            Iterator<ActiveProcessingPictureListenerRecord> it = this.mApListenerRecords.iterator();
            while (it.hasNext()) {
                ActiveProcessingPictureListenerRecord record = it.next();
                if (record.getListener() != listener) continue;
                it.remove();
                break;
            }
        }
    }

    private static class PictureProfileCallbackRecord {
        private final PictureProfileCallback mCallback;
        private final Executor mExecutor;

        PictureProfileCallbackRecord(PictureProfileCallback callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        public PictureProfileCallback getCallback() {
            return this.mCallback;
        }

        public void postPictureProfileAdded(final String id2, final PictureProfile profile) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onPictureProfileAdded(id2, profile);
                }
            });
        }

        public void postPictureProfileUpdated(final String id2, final PictureProfile profile) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onPictureProfileUpdated(id2, profile);
                }
            });
        }

        public void postPictureProfileRemoved(final String id2, final PictureProfile profile) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onPictureProfileRemoved(id2, profile);
                }
            });
        }

        public void postParameterCapabilitiesChanged(final String id2, final List<ParameterCapability> caps) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onParameterCapabilitiesChanged(id2, caps);
                }
            });
        }

        public void postError(final String profileId, final int error) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onError(profileId, error);
                }
            });
        }
    }

    public static abstract class PictureProfileCallback {
        public void onPictureProfileAdded(@NonNull String profileId, @NonNull PictureProfile profile) {
        }

        public void onPictureProfileUpdated(@NonNull String profileId, @NonNull PictureProfile profile) {
        }

        public void onPictureProfileRemoved(@NonNull String profileId, @NonNull PictureProfile profile) {
        }

        public void onError(@Nullable String profileId, int errorCode) {
        }

        public void onParameterCapabilitiesChanged(@Nullable String profileId, @NonNull List<ParameterCapability> updatedCaps) {
        }
    }

    public static class ProfileQueryParams
    implements Parcelable {
        private final boolean mParametersIncluded;
        private static final ProfileQueryParams DEFAULT = new Builder().build();
        @NonNull
        public static final Parcelable.Creator<ProfileQueryParams> CREATOR = new Parcelable.Creator<ProfileQueryParams>(){

            @Override
            public ProfileQueryParams createFromParcel(Parcel in) {
                return new ProfileQueryParams(in);
            }

            public ProfileQueryParams[] newArray(int size) {
                return new ProfileQueryParams[size];
            }
        };

        private ProfileQueryParams(Parcel in) {
            this.mParametersIncluded = in.readBoolean();
        }

        public ProfileQueryParams(boolean parametersIncluded) {
            this.mParametersIncluded = parametersIncluded;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeBoolean(this.mParametersIncluded);
        }

        public boolean areParametersIncluded() {
            return this.mParametersIncluded;
        }

        private Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putBoolean(MediaQualityManager.OPTION_INCLUDE_PARAMETERS, this.mParametersIncluded);
            return bundle;
        }

        public static class Builder {
            private boolean mParametersIncluded;

            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            @NonNull
            public Builder setParametersIncluded(boolean included) {
                this.mParametersIncluded = included;
                return this;
            }

            @NonNull
            public ProfileQueryParams build() {
                return new ProfileQueryParams(this.mParametersIncluded);
            }
        }
    }

    private static class SoundProfileCallbackRecord {
        private final SoundProfileCallback mCallback;
        private final Executor mExecutor;

        SoundProfileCallbackRecord(SoundProfileCallback callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        public SoundProfileCallback getCallback() {
            return this.mCallback;
        }

        public void postSoundProfileAdded(final String id2, final SoundProfile profile) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onSoundProfileAdded(id2, profile);
                }
            });
        }

        public void postSoundProfileUpdated(final String id2, final SoundProfile profile) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onSoundProfileUpdated(id2, profile);
                }
            });
        }

        public void postSoundProfileRemoved(final String id2, final SoundProfile profile) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onSoundProfileRemoved(id2, profile);
                }
            });
        }

        public void postParameterCapabilitiesChanged(final String id2, final List<ParameterCapability> caps) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onParameterCapabilitiesChanged(id2, caps);
                }
            });
        }

        public void postError(final String profileId, final int error) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onError(profileId, error);
                }
            });
        }
    }

    public static abstract class SoundProfileCallback {
        public void onSoundProfileAdded(@NonNull String profileId, @NonNull SoundProfile profile) {
        }

        public void onSoundProfileUpdated(@NonNull String profileId, @NonNull SoundProfile profile) {
        }

        public void onSoundProfileRemoved(@NonNull String profileId, @NonNull SoundProfile profile) {
        }

        public void onError(@Nullable String profileId, int errorCode) {
        }

        public void onParameterCapabilitiesChanged(@Nullable String profileId, @NonNull List<ParameterCapability> updatedCaps) {
        }
    }

    private static class AmbientBacklightCallbackRecord {
        private final AmbientBacklightCallback mCallback;
        private final Executor mExecutor;

        AmbientBacklightCallbackRecord(AmbientBacklightCallback callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        public AmbientBacklightCallback getCallback() {
            return this.mCallback;
        }

        public void postAmbientBacklightEvent(final AmbientBacklightEvent event) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onAmbientBacklightEvent(event);
                }
            });
        }
    }

    public static interface AmbientBacklightCallback {
        public void onAmbientBacklightEvent(@NonNull AmbientBacklightEvent var1);
    }

    private static class ActiveProcessingPictureListenerRecord {
        private final Consumer<List<ActiveProcessingPicture>> mListener;
        private final Executor mExecutor;
        private final boolean mIsGlobal;

        ActiveProcessingPictureListenerRecord(Consumer<List<ActiveProcessingPicture>> listener, Executor executor, boolean isGlobal) {
            this.mListener = listener;
            this.mExecutor = executor;
            this.mIsGlobal = isGlobal;
        }

        public Consumer<List<ActiveProcessingPicture>> getListener() {
            return this.mListener;
        }

        public void postActiveProcessingPicturesChanged(final List<ActiveProcessingPicture> aps) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mListener.accept(aps);
                }
            });
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AmbientBacklightEventTypes {
    }
}

