/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.media.quality.ParameterCapability;
import android.media.quality.PictureProfile;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IPictureProfileCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.quality.IPictureProfileCallback";

    public void onPictureProfileAdded(String var1, PictureProfile var2) throws RemoteException;

    public void onPictureProfileUpdated(String var1, PictureProfile var2) throws RemoteException;

    public void onPictureProfileRemoved(String var1, PictureProfile var2) throws RemoteException;

    public void onParameterCapabilitiesChanged(String var1, List<ParameterCapability> var2) throws RemoteException;

    public void onError(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPictureProfileCallback {
        static final int TRANSACTION_onPictureProfileAdded = 1;
        static final int TRANSACTION_onPictureProfileUpdated = 2;
        static final int TRANSACTION_onPictureProfileRemoved = 3;
        static final int TRANSACTION_onParameterCapabilitiesChanged = 4;
        static final int TRANSACTION_onError = 5;

        public Stub() {
            this.attachInterface(this, IPictureProfileCallback.DESCRIPTOR);
        }

        public static IPictureProfileCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPictureProfileCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IPictureProfileCallback) {
                return (IPictureProfileCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPictureProfileCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    PictureProfile _arg1 = data.readTypedObject(PictureProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPictureProfileAdded(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    PictureProfile _arg1 = data.readTypedObject(PictureProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPictureProfileUpdated(_arg0, _arg1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    PictureProfile _arg1 = data.readTypedObject(PictureProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPictureProfileRemoved(_arg0, _arg1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    ArrayList<ParameterCapability> _arg1 = data.createTypedArrayList(ParameterCapability.CREATOR);
                    data.enforceNoDataAvail();
                    this.onParameterCapabilitiesChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IPictureProfileCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPictureProfileCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPictureProfileAdded(String id2, PictureProfile p) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPictureProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(p, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPictureProfileUpdated(String id2, PictureProfile p) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPictureProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(p, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPictureProfileRemoved(String id2, PictureProfile p) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPictureProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(p, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onParameterCapabilitiesChanged(String id2, List<ParameterCapability> caps) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPictureProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedList(caps, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String id2, int err) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPictureProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeInt(err);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPictureProfileCallback {
        @Override
        public void onPictureProfileAdded(String id2, PictureProfile p) throws RemoteException {
        }

        @Override
        public void onPictureProfileUpdated(String id2, PictureProfile p) throws RemoteException {
        }

        @Override
        public void onPictureProfileRemoved(String id2, PictureProfile p) throws RemoteException {
        }

        @Override
        public void onParameterCapabilitiesChanged(String id2, List<ParameterCapability> caps) throws RemoteException {
        }

        @Override
        public void onError(String id2, int err) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

