/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.metrics.LogSessionId;
import android.media.metrics.MediaMetricsManager;
import android.media.metrics.NetworkEvent;
import android.media.metrics.PlaybackErrorEvent;
import android.media.metrics.PlaybackMetrics;
import android.media.metrics.PlaybackStateEvent;
import android.media.metrics.TrackChangeEvent;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class PlaybackSession
implements AutoCloseable {
    @NonNull
    private final String mId;
    @NonNull
    private final MediaMetricsManager mManager;
    @NonNull
    private final LogSessionId mLogSessionId;
    private boolean mClosed = false;

    public PlaybackSession(@NonNull String id2, @NonNull MediaMetricsManager manager) {
        this.mId = id2;
        this.mManager = manager;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mId);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mManager);
        this.mLogSessionId = new LogSessionId(this.mId);
    }

    public void reportPlaybackMetrics(@NonNull PlaybackMetrics metrics) {
        this.mManager.reportPlaybackMetrics(this.mId, metrics);
    }

    public void reportPlaybackErrorEvent(@NonNull PlaybackErrorEvent event) {
        this.mManager.reportPlaybackErrorEvent(this.mId, event);
    }

    public void reportNetworkEvent(@NonNull NetworkEvent event) {
        this.mManager.reportNetworkEvent(this.mId, event);
    }

    public void reportPlaybackStateEvent(@NonNull PlaybackStateEvent event) {
        this.mManager.reportPlaybackStateEvent(this.mId, event);
    }

    public void reportTrackChangeEvent(@NonNull TrackChangeEvent event) {
        this.mManager.reportTrackChangeEvent(this.mId, event);
    }

    @NonNull
    public LogSessionId getSessionId() {
        return this.mLogSessionId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaybackSession that = (PlaybackSession)o;
        return Objects.equals(this.mId, that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mManager.releaseSessionId(this.mLogSessionId.getStringId());
    }
}

