/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.metrics.Event;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class NetworkEvent
extends Event
implements Parcelable {
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_OTHER = 1;
    public static final int NETWORK_TYPE_WIFI = 2;
    public static final int NETWORK_TYPE_ETHERNET = 3;
    public static final int NETWORK_TYPE_2G = 4;
    public static final int NETWORK_TYPE_3G = 5;
    public static final int NETWORK_TYPE_4G = 6;
    public static final int NETWORK_TYPE_5G_NSA = 7;
    public static final int NETWORK_TYPE_5G_SA = 8;
    public static final int NETWORK_TYPE_OFFLINE = 9;
    private final int mNetworkType;
    private final long mTimeSinceCreatedMillis;
    @NonNull
    public static final Parcelable.Creator<NetworkEvent> CREATOR = new Parcelable.Creator<NetworkEvent>(){

        public NetworkEvent[] newArray(int size) {
            return new NetworkEvent[size];
        }

        @Override
        public NetworkEvent createFromParcel(@NonNull Parcel in) {
            return new NetworkEvent(in);
        }
    };

    public static String networkTypeToString(int value) {
        switch (value) {
            case 0: {
                return "NETWORK_TYPE_UNKNOWN";
            }
            case 1: {
                return "NETWORK_TYPE_OTHER";
            }
            case 2: {
                return "NETWORK_TYPE_WIFI";
            }
            case 3: {
                return "NETWORK_TYPE_ETHERNET";
            }
            case 4: {
                return "NETWORK_TYPE_2G";
            }
            case 5: {
                return "NETWORK_TYPE_3G";
            }
            case 6: {
                return "NETWORK_TYPE_4G";
            }
            case 7: {
                return "NETWORK_TYPE_5G_NSA";
            }
            case 8: {
                return "NETWORK_TYPE_5G_SA";
            }
            case 9: {
                return "NETWORK_TYPE_OFFLINE";
            }
        }
        return Integer.toHexString(value);
    }

    private NetworkEvent(int type, long timeSinceCreatedMillis, @NonNull Bundle extras) {
        this.mNetworkType = type;
        this.mTimeSinceCreatedMillis = timeSinceCreatedMillis;
        this.mMetricsBundle = extras == null ? null : extras.deepCopy();
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    @Override
    public long getTimeSinceCreatedMillis() {
        return this.mTimeSinceCreatedMillis;
    }

    @Override
    @NonNull
    public Bundle getMetricsBundle() {
        return this.mMetricsBundle;
    }

    public String toString() {
        return "NetworkEvent { networkType = " + this.mNetworkType + ", timeSinceCreatedMillis = " + this.mTimeSinceCreatedMillis + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkEvent that = (NetworkEvent)o;
        return this.mNetworkType == that.mNetworkType && this.mTimeSinceCreatedMillis == that.mTimeSinceCreatedMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mNetworkType, this.mTimeSinceCreatedMillis);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mNetworkType);
        dest.writeLong(this.mTimeSinceCreatedMillis);
        dest.writeBundle(this.mMetricsBundle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private NetworkEvent(@NonNull Parcel in) {
        int type = in.readInt();
        long timeSinceCreatedMillis = in.readLong();
        Bundle extras = in.readBundle();
        this.mNetworkType = type;
        this.mTimeSinceCreatedMillis = timeSinceCreatedMillis;
        this.mMetricsBundle = extras;
    }

    public static class Builder {
        private int mNetworkType = 0;
        private long mTimeSinceCreatedMillis = -1L;
        private Bundle mMetricsBundle = new Bundle();

        @NonNull
        public Builder setNetworkType(int value) {
            this.mNetworkType = value;
            return this;
        }

        @NonNull
        public Builder setTimeSinceCreatedMillis(long value) {
            this.mTimeSinceCreatedMillis = value;
            return this;
        }

        @NonNull
        public Builder setMetricsBundle(@NonNull Bundle metricsBundle) {
            this.mMetricsBundle = metricsBundle;
            return this;
        }

        @NonNull
        public NetworkEvent build() {
            NetworkEvent o = new NetworkEvent(this.mNetworkType, this.mTimeSinceCreatedMillis, this.mMetricsBundle);
            return o;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkType {
    }
}

