/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.metrics.EditingEndedEvent;
import android.media.metrics.LogSessionId;
import android.media.metrics.MediaMetricsManager;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class EditingSession
implements AutoCloseable {
    @NonNull
    private final String mId;
    @NonNull
    private final MediaMetricsManager mManager;
    @NonNull
    private final LogSessionId mLogSessionId;

    public EditingSession(@NonNull String id2, @NonNull MediaMetricsManager manager) {
        this.mId = id2;
        this.mManager = manager;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mId);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mManager);
        this.mLogSessionId = new LogSessionId(this.mId);
    }

    @FlaggedApi(value="com.android.media.editing.flags.add_media_metrics_editing")
    public void reportEditingEndedEvent(@NonNull EditingEndedEvent editingEndedEvent) {
        this.mManager.reportEditingEndedEvent(this.mId, editingEndedEvent);
    }

    @NonNull
    public LogSessionId getSessionId() {
        return this.mLogSessionId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditingSession that = (EditingSession)o;
        return Objects.equals(this.mId, that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    @Override
    public void close() {
        this.mManager.releaseSessionId(this.mLogSessionId.getStringId());
    }
}

