/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.media.AudioManager;
import android.media.IAudioService;
import android.media.audiopolicy.AudioVolumeGroup;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.Objects;

@SystemApi
public class VolumeInfo
implements Parcelable {
    private static final String TAG = "VolumeInfo";
    private final boolean mUsesStreamType;
    private final boolean mHasMuteState;
    private final boolean mIsMuted;
    private final int mVolIndex;
    private final int mMinVolIndex;
    private final int mMaxVolIndex;
    @Nullable
    private final AudioVolumeGroup mVolGroup;
    private final int mStreamType;
    private static IAudioService sService;
    private static VolumeInfo sDefaultVolumeInfo;
    public static final int INDEX_NOT_SET = -100;
    @NonNull
    public static final Parcelable.Creator<VolumeInfo> CREATOR;

    private VolumeInfo(boolean usesStreamType, boolean hasMuteState, boolean isMuted, int volIndex, int minVolIndex, int maxVolIndex, AudioVolumeGroup volGroup, int streamType) {
        this.mUsesStreamType = usesStreamType;
        this.mHasMuteState = hasMuteState;
        this.mIsMuted = isMuted;
        this.mVolIndex = volIndex;
        this.mMinVolIndex = minVolIndex;
        this.mMaxVolIndex = maxVolIndex;
        this.mVolGroup = volGroup;
        this.mStreamType = streamType;
    }

    public boolean hasStreamType() {
        return this.mUsesStreamType;
    }

    public int getStreamType() {
        if (!this.mUsesStreamType) {
            throw new IllegalStateException("VolumeInfo doesn't use stream types");
        }
        return this.mStreamType;
    }

    public boolean hasVolumeGroup() {
        return !this.mUsesStreamType;
    }

    @NonNull
    public AudioVolumeGroup getVolumeGroup() {
        if (this.mUsesStreamType) {
            throw new IllegalStateException("VolumeInfo doesn't use AudioVolumeGroup");
        }
        return this.mVolGroup;
    }

    @Deprecated
    @FlaggedApi(value="android.media.audio.device_volume_apis")
    public boolean hasMuteCommand() {
        return this.mHasMuteState;
    }

    @FlaggedApi(value="android.media.audio.device_volume_apis")
    public boolean hasMuteState() {
        return this.mHasMuteState;
    }

    public boolean isMuted() {
        return this.mIsMuted;
    }

    public int getVolumeIndex() {
        return this.mVolIndex;
    }

    public int getMinVolumeIndex() {
        return this.mMinVolIndex;
    }

    public int getMaxVolumeIndex() {
        return this.mMaxVolIndex;
    }

    @NonNull
    public static VolumeInfo getDefaultVolumeInfo() {
        if (sService == null) {
            IBinder b = ServiceManager.getService("audio");
            sService = IAudioService.Stub.asInterface(b);
        }
        if (sDefaultVolumeInfo == null) {
            try {
                sDefaultVolumeInfo = sService.getDefaultVolumeInfo();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling getDefaultVolumeInfo", e);
                return new Builder(3).build();
            }
        }
        return sDefaultVolumeInfo;
    }

    public int hashCode() {
        return Objects.hash(this.mUsesStreamType, this.mHasMuteState, this.mStreamType, this.mIsMuted, this.mVolIndex, this.mMinVolIndex, this.mMaxVolIndex, this.mVolGroup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeInfo that = (VolumeInfo)o;
        return this.mUsesStreamType == that.mUsesStreamType && this.mStreamType == that.mStreamType && this.mHasMuteState == that.mHasMuteState && this.mIsMuted == that.mIsMuted && this.mVolIndex == that.mVolIndex && this.mMinVolIndex == that.mMinVolIndex && this.mMaxVolIndex == that.mMaxVolIndex && Objects.equals(this.mVolGroup, that.mVolGroup);
    }

    public String toString() {
        return new String("VolumeInfo:" + (this.mUsesStreamType ? " streamType:" + this.mStreamType : " volGroup:" + this.mVolGroup) + (this.mHasMuteState ? " muted:" + this.mIsMuted : "[no mute cmd]") + (this.mVolIndex != -100 ? " volIndex:" + this.mVolIndex : "") + (this.mMinVolIndex != -100 ? " min:" + this.mMinVolIndex : "") + (this.mMaxVolIndex != -100 ? " max:" + this.mMaxVolIndex : ""));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mUsesStreamType);
        dest.writeInt(this.mStreamType);
        dest.writeBoolean(this.mHasMuteState);
        dest.writeBoolean(this.mIsMuted);
        dest.writeInt(this.mVolIndex);
        dest.writeInt(this.mMinVolIndex);
        dest.writeInt(this.mMaxVolIndex);
        if (!this.mUsesStreamType) {
            this.mVolGroup.writeToParcel(dest, 0);
        }
    }

    private VolumeInfo(@NonNull Parcel in) {
        this.mUsesStreamType = in.readBoolean();
        this.mStreamType = in.readInt();
        this.mHasMuteState = in.readBoolean();
        this.mIsMuted = in.readBoolean();
        this.mVolIndex = in.readInt();
        this.mMinVolIndex = in.readInt();
        this.mMaxVolIndex = in.readInt();
        this.mVolGroup = !this.mUsesStreamType ? AudioVolumeGroup.CREATOR.createFromParcel(in) : null;
    }

    static {
        CREATOR = new Parcelable.Creator<VolumeInfo>(){

            @Override
            public VolumeInfo createFromParcel(Parcel p) {
                return new VolumeInfo(p);
            }

            public VolumeInfo[] newArray(int size) {
                return new VolumeInfo[size];
            }
        };
    }

    public static class Builder {
        private boolean mUsesStreamType = true;
        private int mStreamType = 3;
        private boolean mHasMuteState = false;
        private boolean mIsMuted = false;
        private int mVolIndex = -100;
        private int mMinVolIndex = -100;
        private int mMaxVolIndex = -100;
        @Nullable
        private AudioVolumeGroup mVolGroup;

        public Builder(int streamType) {
            if (!AudioManager.isPublicStreamType((int)streamType)) {
                throw new IllegalArgumentException("Not a valid public stream type " + streamType);
            }
            this.mUsesStreamType = true;
            this.mStreamType = streamType;
        }

        public Builder(@NonNull AudioVolumeGroup volGroup) {
            Objects.requireNonNull(volGroup);
            this.mUsesStreamType = false;
            this.mStreamType = Integer.MIN_VALUE;
            this.mVolGroup = volGroup;
        }

        public Builder(@NonNull VolumeInfo info) {
            Objects.requireNonNull(info);
            this.mUsesStreamType = info.mUsesStreamType;
            this.mStreamType = info.mStreamType;
            this.mHasMuteState = info.mHasMuteState;
            this.mIsMuted = info.mIsMuted;
            this.mVolIndex = info.mVolIndex;
            this.mMinVolIndex = info.mMinVolIndex;
            this.mMaxVolIndex = info.mMaxVolIndex;
            this.mVolGroup = info.mVolGroup;
        }

        @NonNull
        public Builder setMuted(boolean isMuted) {
            this.mHasMuteState = true;
            this.mIsMuted = isMuted;
            return this;
        }

        @NonNull
        public Builder setVolumeIndex(int volIndex) {
            if (volIndex != -100 && volIndex < 0) {
                throw new IllegalArgumentException("Volume index cannot be negative");
            }
            this.mVolIndex = volIndex;
            return this;
        }

        @NonNull
        public Builder setMinVolumeIndex(int minIndex) {
            if (minIndex != -100 && minIndex < 0) {
                throw new IllegalArgumentException("Min volume index cannot be negative");
            }
            this.mMinVolIndex = minIndex;
            return this;
        }

        @NonNull
        public Builder setMaxVolumeIndex(int maxIndex) {
            if (maxIndex != -100 && maxIndex < 0) {
                throw new IllegalArgumentException("Max volume index cannot be negative");
            }
            this.mMaxVolIndex = maxIndex;
            return this;
        }

        @NonNull
        public VolumeInfo build() {
            if (this.mVolIndex != -100) {
                if (this.mMinVolIndex != -100 && this.mVolIndex < this.mMinVolIndex) {
                    throw new IllegalArgumentException("Volume index:" + this.mVolIndex + " lower than min index:" + this.mMinVolIndex);
                }
                if (this.mMaxVolIndex != -100 && this.mVolIndex > this.mMaxVolIndex) {
                    throw new IllegalArgumentException("Volume index:" + this.mVolIndex + " greater than max index:" + this.mMaxVolIndex);
                }
            }
            if (this.mMinVolIndex != -100 && this.mMaxVolIndex != -100 && this.mMinVolIndex > this.mMaxVolIndex) {
                throw new IllegalArgumentException("Min volume index:" + this.mMinVolIndex + " greater than max index:" + this.mMaxVolIndex);
            }
            return new VolumeInfo(this.mUsesStreamType, this.mHasMuteState, this.mIsMuted, this.mVolIndex, this.mMinVolIndex, this.mMaxVolIndex, this.mVolGroup, this.mStreamType);
        }
    }
}

