/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.MediaSession2;
import android.media.Session2Link;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;

public class Session2Token
implements Parcelable {
    private static final String TAG = "Session2Token";
    @NonNull
    public static final Parcelable.Creator<Session2Token> CREATOR = new Parcelable.Creator<Session2Token>(){

        @Override
        public Session2Token createFromParcel(Parcel p) {
            return new Session2Token(p);
        }

        public Session2Token[] newArray(int size) {
            return new Session2Token[size];
        }
    };
    public static final int TYPE_SESSION = 0;
    public static final int TYPE_SESSION_SERVICE = 1;
    private final int mUid;
    private final int mType;
    private final String mPackageName;
    private final String mServiceName;
    private final Session2Link mSessionLink;
    private final ComponentName mComponentName;
    private final Bundle mExtras;

    public Session2Token(@NonNull Context context, @NonNull ComponentName serviceComponent) {
        if (context == null) {
            throw new IllegalArgumentException("context shouldn't be null");
        }
        if (serviceComponent == null) {
            throw new IllegalArgumentException("serviceComponent shouldn't be null");
        }
        PackageManager manager = context.getPackageManager();
        int uid = Session2Token.getUid(manager, serviceComponent.getPackageName());
        if (!Session2Token.isInterfaceDeclared(manager, "android.media.MediaSession2Service", serviceComponent)) {
            Log.w(TAG, serviceComponent + " doesn't implement MediaSession2Service.");
        }
        this.mComponentName = serviceComponent;
        this.mPackageName = serviceComponent.getPackageName();
        this.mServiceName = serviceComponent.getClassName();
        this.mUid = uid;
        this.mType = 1;
        this.mSessionLink = null;
        this.mExtras = Bundle.EMPTY;
    }

    Session2Token(int uid, int type, String packageName, Session2Link sessionLink, @NonNull Bundle tokenExtras) {
        this.mUid = uid;
        this.mType = type;
        this.mPackageName = packageName;
        this.mServiceName = null;
        this.mComponentName = null;
        this.mSessionLink = sessionLink;
        this.mExtras = tokenExtras;
    }

    Session2Token(Parcel in) {
        this.mUid = in.readInt();
        this.mType = in.readInt();
        this.mPackageName = in.readString();
        this.mServiceName = in.readString();
        this.mSessionLink = (Session2Link)in.readParcelable(null);
        this.mComponentName = ComponentName.unflattenFromString(in.readString());
        Bundle extras = in.readBundle();
        if (extras == null) {
            Log.w(TAG, "extras shouldn't be null.");
            extras = Bundle.EMPTY;
        } else if (MediaSession2.hasCustomParcelable(extras)) {
            Log.w(TAG, "extras contain custom parcelable. Ignoring.");
            extras = Bundle.EMPTY;
        }
        this.mExtras = extras;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mUid);
        dest.writeInt(this.mType);
        dest.writeString(this.mPackageName);
        dest.writeString(this.mServiceName);
        dest.writeParcelable(this.mSessionLink, flags);
        dest.writeString(this.mComponentName == null ? "" : this.mComponentName.flattenToString());
        dest.writeBundle(this.mExtras);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mUid, this.mPackageName, this.mServiceName, this.mSessionLink);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Session2Token)) {
            return false;
        }
        Session2Token other = (Session2Token)obj;
        return this.mUid == other.mUid && TextUtils.equals(this.mPackageName, other.mPackageName) && TextUtils.equals(this.mServiceName, other.mServiceName) && this.mType == other.mType && Objects.equals(this.mSessionLink, other.mSessionLink);
    }

    public String toString() {
        return "Session2Token {pkg=" + this.mPackageName + " type=" + this.mType + " service=" + this.mServiceName + " Session2Link=" + this.mSessionLink + "}";
    }

    public int getUid() {
        return this.mUid;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @Nullable
    public String getServiceName() {
        return this.mServiceName;
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public Bundle getExtras() {
        return new Bundle(this.mExtras);
    }

    Session2Link getSessionLink() {
        return this.mSessionLink;
    }

    private static boolean isInterfaceDeclared(PackageManager manager, String serviceInterface, ComponentName serviceComponent) {
        Intent serviceIntent = new Intent(serviceInterface);
        serviceIntent.setPackage(serviceComponent.getPackageName());
        List<ResolveInfo> list = manager.queryIntentServices(serviceIntent, 128);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ResolveInfo resolveInfo = list.get(i);
                if (resolveInfo == null || resolveInfo.serviceInfo == null || !TextUtils.equals(resolveInfo.serviceInfo.name, serviceComponent.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    private static int getUid(PackageManager manager, String packageName) {
        try {
            return manager.getApplicationInfo((String)packageName, (int)0).uid;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("Cannot find package " + packageName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TokenType {
    }
}

