/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.companion.virtual.VirtualDeviceManager;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioPlaybackConfiguration;
import android.media.IAudioService;
import android.media.IPlayer;
import android.media.VolumeShaper;
import android.media.VolumeShaperConfiguration;
import android.media.VolumeShaperOperation;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class PlayerBase {
    private static final String TAG = "PlayerBase";
    private static final boolean DEBUG_APP_OPS = false;
    private static final boolean DEBUG = false;
    private static IAudioService sService;
    protected AudioAttributes mAttributes;
    protected float mLeftVolume = 1.0f;
    protected float mRightVolume = 1.0f;
    protected float mAuxEffectSendLevel = 0.0f;
    private final Object mLock = new Object();
    @Nullable
    private IAppOpsService mAppOps;
    @Nullable
    private IAppOpsCallback mAppOpsCallback;
    @GuardedBy(value={"mLock"})
    private boolean mHasAppOpsPlayAudio = true;
    private final int mImplType;
    protected int mPlayerIId = -1;
    @GuardedBy(value={"mLock"})
    private int mState;
    @GuardedBy(value={"mLock"})
    private int mStartDelayMs = 0;
    @GuardedBy(value={"mLock"})
    private float mPanMultiplierL = 1.0f;
    @GuardedBy(value={"mLock"})
    private float mPanMultiplierR = 1.0f;
    @GuardedBy(value={"mLock"})
    private float mVolMultiplier = 1.0f;
    @GuardedBy(value={"mLock"})
    @NonNull
    private int[] mDeviceIds = AudioPlaybackConfiguration.PLAYER_DEVICEIDS_INVALID;

    PlayerBase(@NonNull AudioAttributes attr2, int implType) {
        if (attr2 == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        this.mAttributes = attr2;
        this.mImplType = implType;
        this.mState = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerIId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlayerIId;
        }
    }

    protected void baseRegisterPlayer(int sessionId) {
        try {
            this.mPlayerIId = PlayerBase.getService().trackPlayer(new PlayerIdCard(this.mImplType, this.mAttributes, new IPlayerWrapper(this), sessionId));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, player will not be tracked", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseUpdateAudioAttributes(@NonNull AudioAttributes attr2) {
        if (attr2 == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        try {
            PlayerBase.getService().playerAttributes(this.mPlayerIId, attr2);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, audio attributes will not be updated", e);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mAttributes = attr2;
        }
    }

    void baseUpdateSessionId(int sessionId) {
        try {
            PlayerBase.getService().playerSessionId(this.mPlayerIId, sessionId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, the session ID will not be updated", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseUpdateDeviceIds(@NonNull List<AudioDeviceInfo> deviceInfos) {
        int piid;
        int[] deviceIds = new int[deviceInfos.size()];
        for (int i = 0; i < deviceInfos.size(); ++i) {
            deviceIds[i] = deviceInfos.get(i).getId();
        }
        Object object = this.mLock;
        synchronized (object) {
            piid = this.mPlayerIId;
            this.mDeviceIds = deviceIds;
        }
        try {
            PlayerBase.getService().playerEvent(piid, 5, deviceIds);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, " + Arrays.toString(deviceIds) + " device id will not be tracked for piid=" + piid, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(int state, @NonNull int[] deviceIds) {
        int piid;
        Object object = this.mLock;
        synchronized (object) {
            this.mState = state;
            piid = this.mPlayerIId;
            this.mDeviceIds = deviceIds;
        }
        try {
            PlayerBase.getService().playerEvent(piid, state, deviceIds);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, " + AudioPlaybackConfiguration.toLogFriendlyPlayerState(state) + " state will not be tracked for piid=" + piid, e);
        }
    }

    void baseStart(@NonNull int[] deviceIds) {
        this.updateState(2, deviceIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseSetStartDelayMs(int delayMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mStartDelayMs = Math.max(delayMs, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getStartDelayMs() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mStartDelayMs;
        }
    }

    void basePause() {
        this.updateState(3, new int[0]);
    }

    void baseStop() {
        this.updateState(4, new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseSetPan(float pan) {
        float p = Math.min(Math.max(-1.0f, pan), 1.0f);
        Object object = this.mLock;
        synchronized (object) {
            if (p >= 0.0f) {
                this.mPanMultiplierL = 1.0f - p;
                this.mPanMultiplierR = 1.0f;
            } else {
                this.mPanMultiplierL = 1.0f;
                this.mPanMultiplierR = 1.0f + p;
            }
        }
        this.updatePlayerVolume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlayerVolume() {
        float finalRightVol;
        float finalLeftVol;
        Object object = this.mLock;
        synchronized (object) {
            finalLeftVol = this.mVolMultiplier * this.mLeftVolume * this.mPanMultiplierL;
            finalRightVol = this.mVolMultiplier * this.mRightVolume * this.mPanMultiplierR;
        }
        this.playerSetVolume(false, finalLeftVol, finalRightVol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setVolumeMultiplier(float vol) {
        Object object = this.mLock;
        synchronized (object) {
            this.mVolMultiplier = vol;
        }
        this.updatePlayerVolume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseSetVolume(float leftVolume, float rightVolume) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLeftVolume = leftVolume;
            this.mRightVolume = rightVolume;
        }
        this.updatePlayerVolume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int baseSetAuxEffectSendLevel(float level) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAuxEffectSendLevel = level;
        }
        return this.playerSetAuxEffectSendLevel(false, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void baseRelease() {
        boolean releasePlayer = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != 0) {
                releasePlayer = true;
                this.mState = 0;
            }
        }
        try {
            if (releasePlayer) {
                PlayerBase.getService().releasePlayer(this.mPlayerIId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to audio service, the player will still be tracked", e);
        }
        try {
            if (this.mAppOps != null) {
                this.mAppOps.stopWatchingMode(this.mAppOpsCallback);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    public void setStartDelayMs(int delayMs) {
        this.baseSetStartDelayMs(delayMs);
    }

    abstract void playerSetVolume(boolean var1, float var2, float var3);

    abstract int playerApplyVolumeShaper(@NonNull VolumeShaper.Configuration var1, @NonNull VolumeShaper.Operation var2);

    @Nullable
    abstract VolumeShaper.State playerGetVolumeShaperState(int var1);

    abstract int playerSetAuxEffectSendLevel(boolean var1, float var2);

    abstract void playerStart();

    abstract void playerPause();

    abstract void playerStop();

    public static void deprecateStreamTypeForPlayback(int streamType, @NonNull String className, @NonNull String opName) throws IllegalArgumentException {
        if (streamType == 10) {
            throw new IllegalArgumentException("Use of STREAM_ACCESSIBILITY is reserved for volume control");
        }
        Log.w(className, "Use of stream types is deprecated for operations other than volume control");
        Log.w(className, "See the documentation of " + opName + " for what to use instead with android.media.AudioAttributes to qualify your playback use case");
    }

    protected String getCurrentOpPackageName() {
        return TextUtils.emptyIfNull(ActivityThread.currentOpPackageName());
    }

    protected static int resolvePlaybackSessionId(@Nullable Context context, int requestedSessionId) {
        if (requestedSessionId != 0) {
            return requestedSessionId;
        }
        if (context == null) {
            return 0;
        }
        int deviceId = context.getDeviceId();
        if (deviceId == 0) {
            return 0;
        }
        VirtualDeviceManager vdm = context.getSystemService(VirtualDeviceManager.class);
        if (vdm == null || vdm.getDevicePolicy(deviceId, 1) == 0) {
            return 0;
        }
        return vdm.getAudioPlaybackSessionId(deviceId);
    }

    public static class PlayerIdCard
    implements Parcelable {
        public final int mPlayerType;
        public static final int AUDIO_ATTRIBUTES_NONE = 0;
        public static final int AUDIO_ATTRIBUTES_DEFINED = 1;
        public final AudioAttributes mAttributes;
        public final IPlayer mIPlayer;
        public final int mSessionId;
        @NonNull
        public static final Parcelable.Creator<PlayerIdCard> CREATOR = new Parcelable.Creator<PlayerIdCard>(){

            @Override
            public PlayerIdCard createFromParcel(Parcel p) {
                return new PlayerIdCard(p);
            }

            public PlayerIdCard[] newArray(int size) {
                return new PlayerIdCard[size];
            }
        };

        PlayerIdCard(int type, @NonNull AudioAttributes attr2, @NonNull IPlayer iplayer, int sessionId) {
            this.mPlayerType = type;
            this.mAttributes = attr2;
            this.mIPlayer = iplayer;
            this.mSessionId = sessionId;
        }

        public int hashCode() {
            return Objects.hash(this.mPlayerType, this.mSessionId);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mPlayerType);
            this.mAttributes.writeToParcel(dest, 0);
            dest.writeStrongBinder(this.mIPlayer == null ? null : this.mIPlayer.asBinder());
            dest.writeInt(this.mSessionId);
        }

        private PlayerIdCard(Parcel in) {
            this.mPlayerType = in.readInt();
            this.mAttributes = AudioAttributes.CREATOR.createFromParcel(in);
            IBinder b = in.readStrongBinder();
            this.mIPlayer = b == null ? null : IPlayer.Stub.asInterface(b);
            this.mSessionId = in.readInt();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof PlayerIdCard)) {
                return false;
            }
            PlayerIdCard that = (PlayerIdCard)o;
            return this.mPlayerType == that.mPlayerType && this.mAttributes.equals(that.mAttributes) && this.mSessionId == that.mSessionId;
        }
    }

    private static class IPlayerWrapper
    extends IPlayer.Stub {
        private final WeakReference<PlayerBase> mWeakPB;

        public IPlayerWrapper(PlayerBase pb) {
            this.mWeakPB = new WeakReference<PlayerBase>(pb);
        }

        @Override
        public void start() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerStart();
            }
        }

        @Override
        public void pause() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerPause();
            }
        }

        @Override
        public void stop() {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerStop();
            }
        }

        @Override
        public void setVolume(float vol) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.setVolumeMultiplier(vol);
            }
        }

        @Override
        public void setPan(float pan) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.baseSetPan(pan);
            }
        }

        @Override
        public void setStartDelayMs(int delayMs) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.baseSetStartDelayMs(delayMs);
            }
        }

        @Override
        public void applyVolumeShaper(@NonNull VolumeShaperConfiguration configuration, @NonNull VolumeShaperOperation operation) {
            PlayerBase pb = (PlayerBase)this.mWeakPB.get();
            if (pb != null) {
                pb.playerApplyVolumeShaper(VolumeShaper.Configuration.fromParcelable(configuration), VolumeShaper.Operation.fromParcelable(operation));
            }
        }
    }
}

