/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.ISpatializerHeadTrackingCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISpatializer
extends IInterface {
    public static final String DESCRIPTOR = "android.media.ISpatializer";

    public void release() throws RemoteException;

    public byte[] getSupportedLevels() throws RemoteException;

    public void setLevel(byte var1) throws RemoteException;

    public byte getLevel() throws RemoteException;

    public boolean isHeadTrackingSupported() throws RemoteException;

    public byte[] getSupportedHeadTrackingModes() throws RemoteException;

    public void setDesiredHeadTrackingMode(byte var1) throws RemoteException;

    public byte getActualHeadTrackingMode() throws RemoteException;

    public void recenterHeadTracker() throws RemoteException;

    public void setGlobalTransform(float[] var1) throws RemoteException;

    public void setHeadSensor(int var1) throws RemoteException;

    public void setScreenSensor(int var1) throws RemoteException;

    public void setDisplayOrientation(float var1) throws RemoteException;

    public void setHingeAngle(float var1) throws RemoteException;

    public void setFoldState(boolean var1) throws RemoteException;

    public byte[] getSupportedModes() throws RemoteException;

    public void registerHeadTrackingCallback(ISpatializerHeadTrackingCallback var1) throws RemoteException;

    public void setParameter(int var1, byte[] var2) throws RemoteException;

    public void getParameter(int var1, byte[] var2) throws RemoteException;

    public int getOutput() throws RemoteException;

    public int[] getSpatializedChannelMasks() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISpatializer {
        static final int TRANSACTION_release = 1;
        static final int TRANSACTION_getSupportedLevels = 2;
        static final int TRANSACTION_setLevel = 3;
        static final int TRANSACTION_getLevel = 4;
        static final int TRANSACTION_isHeadTrackingSupported = 5;
        static final int TRANSACTION_getSupportedHeadTrackingModes = 6;
        static final int TRANSACTION_setDesiredHeadTrackingMode = 7;
        static final int TRANSACTION_getActualHeadTrackingMode = 8;
        static final int TRANSACTION_recenterHeadTracker = 9;
        static final int TRANSACTION_setGlobalTransform = 10;
        static final int TRANSACTION_setHeadSensor = 11;
        static final int TRANSACTION_setScreenSensor = 12;
        static final int TRANSACTION_setDisplayOrientation = 13;
        static final int TRANSACTION_setHingeAngle = 14;
        static final int TRANSACTION_setFoldState = 15;
        static final int TRANSACTION_getSupportedModes = 16;
        static final int TRANSACTION_registerHeadTrackingCallback = 17;
        static final int TRANSACTION_setParameter = 18;
        static final int TRANSACTION_getParameter = 19;
        static final int TRANSACTION_getOutput = 20;
        static final int TRANSACTION_getSpatializedChannelMasks = 21;

        public Stub() {
            this.attachInterface(this, ISpatializer.DESCRIPTOR);
        }

        public static ISpatializer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISpatializer.DESCRIPTOR);
            if (iin != null && iin instanceof ISpatializer) {
                return (ISpatializer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISpatializer.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.release();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    byte[] _result = this.getSupportedLevels();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 3: {
                    byte _arg0 = data.readByte();
                    data.enforceNoDataAvail();
                    this.setLevel(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    byte _result = this.getLevel();
                    reply.writeNoException();
                    reply.writeByte(_result);
                    break;
                }
                case 5: {
                    boolean _result = this.isHeadTrackingSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    byte[] _result = this.getSupportedHeadTrackingModes();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 7: {
                    byte _arg0 = data.readByte();
                    data.enforceNoDataAvail();
                    this.setDesiredHeadTrackingMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    byte _result = this.getActualHeadTrackingMode();
                    reply.writeNoException();
                    reply.writeByte(_result);
                    break;
                }
                case 9: {
                    this.recenterHeadTracker();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.setGlobalTransform(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setHeadSensor(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setScreenSensor(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setDisplayOrientation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setHingeAngle(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setFoldState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    byte[] _result = this.getSupportedModes();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 17: {
                    ISpatializerHeadTrackingCallback _arg0 = ISpatializerHeadTrackingCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerHeadTrackingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.setParameter(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.getParameter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_arg1);
                    break;
                }
                case 20: {
                    int _result = this.getOutput();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 21: {
                    int[] _result = this.getSpatializedChannelMasks();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISpatializer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISpatializer.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void release() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getSupportedLevels() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLevel(byte level) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeByte(level);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte getLevel() throws RemoteException {
                byte _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readByte();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHeadTrackingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getSupportedHeadTrackingModes() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDesiredHeadTrackingMode(byte mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeByte(mode);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte getActualHeadTrackingMode() throws RemoteException {
                byte _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readByte();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recenterHeadTracker() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGlobalTransform(float[] screenToStage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeFloatArray(screenToStage);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHeadSensor(int sensorHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeInt(sensorHandle);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScreenSensor(int sensorHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeInt(sensorHandle);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayOrientation(float physicalToLogicalAngle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeFloat(physicalToLogicalAngle);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHingeAngle(float hingeAngle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeFloat(hingeAngle);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFoldState(boolean folded) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeBoolean(folded);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getSupportedModes() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerHeadTrackingCallback(ISpatializerHeadTrackingCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setParameter(int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getParameter(int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _reply.readByteArray(value);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getOutput() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSpatializedChannelMasks() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISpatializer.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISpatializer {
        @Override
        public void release() throws RemoteException {
        }

        @Override
        public byte[] getSupportedLevels() throws RemoteException {
            return null;
        }

        @Override
        public void setLevel(byte level) throws RemoteException {
        }

        @Override
        public byte getLevel() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isHeadTrackingSupported() throws RemoteException {
            return false;
        }

        @Override
        public byte[] getSupportedHeadTrackingModes() throws RemoteException {
            return null;
        }

        @Override
        public void setDesiredHeadTrackingMode(byte mode) throws RemoteException {
        }

        @Override
        public byte getActualHeadTrackingMode() throws RemoteException {
            return 0;
        }

        @Override
        public void recenterHeadTracker() throws RemoteException {
        }

        @Override
        public void setGlobalTransform(float[] screenToStage) throws RemoteException {
        }

        @Override
        public void setHeadSensor(int sensorHandle) throws RemoteException {
        }

        @Override
        public void setScreenSensor(int sensorHandle) throws RemoteException {
        }

        @Override
        public void setDisplayOrientation(float physicalToLogicalAngle) throws RemoteException {
        }

        @Override
        public void setHingeAngle(float hingeAngle) throws RemoteException {
        }

        @Override
        public void setFoldState(boolean folded) throws RemoteException {
        }

        @Override
        public byte[] getSupportedModes() throws RemoteException {
            return null;
        }

        @Override
        public void registerHeadTrackingCallback(ISpatializerHeadTrackingCallback callback) throws RemoteException {
        }

        @Override
        public void setParameter(int key, byte[] value) throws RemoteException {
        }

        @Override
        public void getParameter(int key, byte[] value) throws RemoteException {
        }

        @Override
        public int getOutput() throws RemoteException {
            return 0;
        }

        @Override
        public int[] getSpatializedChannelMasks() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

