/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.SoundDoseRecord;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.Objects;
import java.util.StringJoiner;

public interface ISoundDose
extends IInterface {
    public static final String DESCRIPTOR = "android.media.ISoundDose";

    public void setOutputRs2UpperBound(float var1) throws RemoteException;

    public void resetCsd(float var1, SoundDoseRecord[] var2) throws RemoteException;

    public void updateAttenuation(float var1, int var2) throws RemoteException;

    public void setCsdEnabled(boolean var1) throws RemoteException;

    public void initCachedAudioDeviceCategories(AudioDeviceCategory[] var1) throws RemoteException;

    public void setAudioDeviceCategory(AudioDeviceCategory var1) throws RemoteException;

    public float getOutputRs2UpperBound() throws RemoteException;

    public float getCsd() throws RemoteException;

    public boolean isSoundDoseHalSupported() throws RemoteException;

    public void forceUseFrameworkMel(boolean var1) throws RemoteException;

    public void forceComputeCsdOnAllDevices(boolean var1) throws RemoteException;

    public static class AudioDeviceCategory
    implements Parcelable {
        public String address;
        public int internalAudioType = 0;
        public boolean csdCompatible = false;
        public static final Parcelable.Creator<AudioDeviceCategory> CREATOR = new Parcelable.Creator<AudioDeviceCategory>(){

            @Override
            public AudioDeviceCategory createFromParcel(Parcel _aidl_source) {
                AudioDeviceCategory _aidl_out = new AudioDeviceCategory();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public AudioDeviceCategory[] newArray(int _aidl_size) {
                return new AudioDeviceCategory[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeString(this.address);
            _aidl_parcel.writeInt(this.internalAudioType);
            _aidl_parcel.writeBoolean(this.csdCompatible);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.address = _aidl_parcel.readString();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.internalAudioType = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.csdCompatible = _aidl_parcel.readBoolean();
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        public String toString() {
            StringJoiner _aidl_sj = new StringJoiner(", ", "{", "}");
            _aidl_sj.add("address: " + Objects.toString(this.address));
            _aidl_sj.add("internalAudioType: " + this.internalAudioType);
            _aidl_sj.add("csdCompatible: " + this.csdCompatible);
            return "AudioDeviceCategory" + ((Object)_aidl_sj).toString();
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask;
        }
    }

    public static abstract class Stub
    extends Binder
    implements ISoundDose {
        static final int TRANSACTION_setOutputRs2UpperBound = 1;
        static final int TRANSACTION_resetCsd = 2;
        static final int TRANSACTION_updateAttenuation = 3;
        static final int TRANSACTION_setCsdEnabled = 4;
        static final int TRANSACTION_initCachedAudioDeviceCategories = 5;
        static final int TRANSACTION_setAudioDeviceCategory = 6;
        static final int TRANSACTION_getOutputRs2UpperBound = 7;
        static final int TRANSACTION_getCsd = 8;
        static final int TRANSACTION_isSoundDoseHalSupported = 9;
        static final int TRANSACTION_forceUseFrameworkMel = 10;
        static final int TRANSACTION_forceComputeCsdOnAllDevices = 11;

        public Stub() {
            this.attachInterface(this, ISoundDose.DESCRIPTOR);
        }

        public static ISoundDose asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISoundDose.DESCRIPTOR);
            if (iin != null && iin instanceof ISoundDose) {
                return (ISoundDose)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISoundDose.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setOutputRs2UpperBound(_arg0);
                    break;
                }
                case 2: {
                    float _arg0 = data.readFloat();
                    SoundDoseRecord[] _arg1 = data.createTypedArray(SoundDoseRecord.CREATOR);
                    data.enforceNoDataAvail();
                    this.resetCsd(_arg0, _arg1);
                    break;
                }
                case 3: {
                    float _arg0 = data.readFloat();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateAttenuation(_arg0, _arg1);
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setCsdEnabled(_arg0);
                    break;
                }
                case 5: {
                    AudioDeviceCategory[] _arg0 = data.createTypedArray(AudioDeviceCategory.CREATOR);
                    data.enforceNoDataAvail();
                    this.initCachedAudioDeviceCategories(_arg0);
                    break;
                }
                case 6: {
                    AudioDeviceCategory _arg0 = data.readTypedObject(AudioDeviceCategory.CREATOR);
                    data.enforceNoDataAvail();
                    this.setAudioDeviceCategory(_arg0);
                    break;
                }
                case 7: {
                    float _result = this.getOutputRs2UpperBound();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 8: {
                    float _result = this.getCsd();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 9: {
                    boolean _result = this.isSoundDoseHalSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceUseFrameworkMel(_arg0);
                    break;
                }
                case 11: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceComputeCsdOnAllDevices(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISoundDose {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISoundDose.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOutputRs2UpperBound(float rs2Value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    _data.writeFloat(rs2Value);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetCsd(float currentCsd, SoundDoseRecord[] records) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    _data.writeFloat(currentCsd);
                    _data.writeTypedArray(records, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAttenuation(float attenuationDB, int device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    _data.writeFloat(attenuationDB);
                    _data.writeInt(device);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCsdEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initCachedAudioDeviceCategories(AudioDeviceCategory[] audioDevices) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    _data.writeTypedArray(audioDevices, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAudioDeviceCategory(AudioDeviceCategory audioDevice) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    _data.writeTypedObject(audioDevice, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getOutputRs2UpperBound() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getCsd() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSoundDoseHalSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceUseFrameworkMel(boolean useFrameworkMel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    _data.writeBoolean(useFrameworkMel);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceComputeCsdOnAllDevices(boolean computeCsdOnAllDevices) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDose.DESCRIPTOR);
                    _data.writeBoolean(computeCsdOnAllDevices);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISoundDose {
        @Override
        public void setOutputRs2UpperBound(float rs2Value) throws RemoteException {
        }

        @Override
        public void resetCsd(float currentCsd, SoundDoseRecord[] records) throws RemoteException {
        }

        @Override
        public void updateAttenuation(float attenuationDB, int device) throws RemoteException {
        }

        @Override
        public void setCsdEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void initCachedAudioDeviceCategories(AudioDeviceCategory[] audioDevices) throws RemoteException {
        }

        @Override
        public void setAudioDeviceCategory(AudioDeviceCategory audioDevice) throws RemoteException {
        }

        @Override
        public float getOutputRs2UpperBound() throws RemoteException {
            return 0.0f;
        }

        @Override
        public float getCsd() throws RemoteException {
            return 0.0f;
        }

        @Override
        public boolean isSoundDoseHalSupported() throws RemoteException {
            return false;
        }

        @Override
        public void forceUseFrameworkMel(boolean useFrameworkMel) throws RemoteException {
        }

        @Override
        public void forceComputeCsdOnAllDevices(boolean computeCsdOnAllDevices) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

