/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaParceledListSlice;
import android.media.Session2Token;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMediaCommunicationServiceCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMediaCommunicationServiceCallback";

    public void onSession2Created(Session2Token var1, int var2) throws RemoteException;

    public void onSession2Changed(MediaParceledListSlice var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaCommunicationServiceCallback {
        static final int TRANSACTION_onSession2Created = 1;
        static final int TRANSACTION_onSession2Changed = 2;

        public Stub() {
            this.attachInterface(this, IMediaCommunicationServiceCallback.DESCRIPTOR);
        }

        public static IMediaCommunicationServiceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaCommunicationServiceCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaCommunicationServiceCallback) {
                return (IMediaCommunicationServiceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSession2Created";
                }
                case 2: {
                    return "onSession2Changed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaCommunicationServiceCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    Session2Token _arg0 = data.readTypedObject(Session2Token.CREATOR);
                    int _arg1 = data.readInt();
                    this.onSession2Created(_arg0, _arg1);
                    break;
                }
                case 2: {
                    MediaParceledListSlice _arg0 = data.readTypedObject(MediaParceledListSlice.CREATOR);
                    this.onSession2Changed(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IMediaCommunicationServiceCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaCommunicationServiceCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSession2Created(Session2Token token, int pid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationServiceCallback.DESCRIPTOR);
                    _data.writeTypedObject(token, 0);
                    _data.writeInt(pid);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSession2Changed(MediaParceledListSlice tokens) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationServiceCallback.DESCRIPTOR);
                    _data.writeTypedObject(tokens, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaCommunicationServiceCallback {
        @Override
        public void onSession2Created(Session2Token token, int pid) throws RemoteException {
        }

        @Override
        public void onSession2Changed(MediaParceledListSlice tokens) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

