/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioMixerAttributes;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.media.AudioPortConfig;
import android.media.AudioProfile;
import android.media.INativeAudioVolumeGroupCallback;
import android.media.INativeSpatializerCallback;
import android.media.ISoundDose;
import android.media.ISoundDoseCallback;
import android.media.ISpatializer;
import android.media.MicrophoneInfo;
import android.media.audio.common.AidlConversion;
import android.media.audiofx.AudioEffect;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.media.audiopolicy.AudioProductStrategy;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Vibrator;
import android.telephony.TelephonyManager;
import android.util.IntArray;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.android.media.audio.Flags;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AudioSystem {
    private static final boolean DEBUG_VOLUME = false;
    private static final String TAG = "AudioSystem";
    public static final int STREAM_DEFAULT = -1;
    public static final int STREAM_VOICE_CALL = 0;
    public static final int STREAM_SYSTEM = 1;
    public static final int STREAM_RING = 2;
    public static final int STREAM_MUSIC = 3;
    public static final int STREAM_ALARM = 4;
    public static final int STREAM_NOTIFICATION = 5;
    public static final int STREAM_BLUETOOTH_SCO = 6;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int STREAM_SYSTEM_ENFORCED = 7;
    public static final int STREAM_DTMF = 8;
    public static final int STREAM_TTS = 9;
    public static final int STREAM_ACCESSIBILITY = 10;
    public static final int STREAM_ASSISTANT = 11;
    public static final int NUM_STREAMS = 5;
    public static final int OUT_CHANNEL_COUNT_MAX = AudioSystem.native_getMaxChannelCount();
    public static final int SAMPLE_RATE_HZ_MAX = AudioSystem.native_getMaxSampleRate();
    public static final int SAMPLE_RATE_HZ_MIN = AudioSystem.native_getMinSampleRate();
    public static final int FCC_24 = 24;
    private static final int NUM_STREAM_TYPES = 12;
    public static final String[] STREAM_NAMES = new String[]{"STREAM_VOICE_CALL", "STREAM_SYSTEM", "STREAM_RING", "STREAM_MUSIC", "STREAM_ALARM", "STREAM_NOTIFICATION", "STREAM_BLUETOOTH_SCO", "STREAM_SYSTEM_ENFORCED", "STREAM_DTMF", "STREAM_TTS", "STREAM_ACCESSIBILITY", "STREAM_ASSISTANT"};
    public static final int MODE_INVALID = -2;
    public static final int MODE_CURRENT = -1;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_RINGTONE = 1;
    public static final int MODE_IN_CALL = 2;
    public static final int MODE_IN_COMMUNICATION = 3;
    public static final int MODE_CALL_SCREENING = 4;
    public static final int MODE_CALL_REDIRECT = 5;
    public static final int MODE_COMMUNICATION_REDIRECT = 6;
    public static final int NUM_MODES = 7;
    public static final int AUDIO_FORMAT_INVALID = -1;
    public static final int AUDIO_FORMAT_DEFAULT = 0;
    public static final int AUDIO_FORMAT_AAC = 0x4000000;
    public static final int AUDIO_FORMAT_SBC = 0x1F000000;
    public static final int AUDIO_FORMAT_APTX = 0x20000000;
    public static final int AUDIO_FORMAT_APTX_HD = 0x21000000;
    public static final int AUDIO_FORMAT_LDAC = 0x23000000;
    public static final int AUDIO_FORMAT_LC3 = 0x2B000000;
    public static final int AUDIO_FORMAT_OPUS = 0x8000000;
    public static final int AUDIO_FORMAT_OPUS_HI_RES = 0x8000001;
    private static final int BLUETOOTH_LE_AUDIO_CODEC_CONFIG_SOURCE_CODEC_TYPE_OPUS_HI_RES = 2;
    @Deprecated
    public static final int ROUTE_EARPIECE = 1;
    @Deprecated
    public static final int ROUTE_SPEAKER = 2;
    @Deprecated
    public static final int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static final int ROUTE_HEADSET = 8;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static final int ROUTE_ALL = -1;
    public static final int AUDIO_SESSION_ALLOCATE = 0;
    public static final int AUDIO_STATUS_OK = 0;
    public static final int AUDIO_STATUS_ERROR = 1;
    public static final int AUDIO_STATUS_SERVER_DIED = 100;
    private static ErrorCallback sErrorCallback;
    private static final int DYNAMIC_POLICY_EVENT_MIX_STATE_UPDATE = 0;
    private static DynamicPolicyCallback sDynPolicyCallback;
    private static AudioRecordingCallback sRecordingCallback;
    @GuardedBy(value={"AudioSystem.class"})
    private static RoutingUpdateCallback sRoutingUpdateCallback;
    @GuardedBy(value={"AudioSystem.class"})
    private static VolumeRangeInitRequestCallback sVolRangeInitReqCallback;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int BAD_VALUE = -2;
    public static final int INVALID_OPERATION = -3;
    public static final int PERMISSION_DENIED = -4;
    public static final int NO_INIT = -5;
    public static final int DEAD_OBJECT = -6;
    public static final int WOULD_BLOCK = -7;
    public static final int DEVICE_NONE = 0;
    public static final int DEVICE_BIT_IN = Integer.MIN_VALUE;
    public static final int DEVICE_BIT_DEFAULT = 0x40000000;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_EARPIECE = 1;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_SPEAKER = 2;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_WIRED_HEADSET = 4;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_WIRED_HEADPHONE = 8;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_SCO = 16;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_AUX_DIGITAL = 1024;
    public static final int DEVICE_OUT_HDMI = 1024;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_ANLG_DOCK_HEADSET = 2048;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_DGTL_DOCK_HEADSET = 4096;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_USB_ACCESSORY = 8192;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_USB_DEVICE = 16384;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_REMOTE_SUBMIX = 32768;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_TELEPHONY_TX = 65536;
    public static final int DEVICE_OUT_LINE = 131072;
    public static final int DEVICE_OUT_HDMI_ARC = 262144;
    public static final int DEVICE_OUT_HDMI_EARC = 262145;
    public static final int DEVICE_OUT_SPDIF = 524288;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_FM = 0x100000;
    public static final int DEVICE_OUT_AUX_LINE = 0x200000;
    public static final int DEVICE_OUT_SPEAKER_SAFE = 0x400000;
    public static final int DEVICE_OUT_IP = 0x800000;
    public static final int DEVICE_OUT_MULTICHANNEL_GROUP = 0x800001;
    public static final int DEVICE_OUT_BUS = 0x1000000;
    public static final int DEVICE_OUT_PROXY = 0x2000000;
    public static final int DEVICE_OUT_USB_HEADSET = 0x4000000;
    public static final int DEVICE_OUT_HEARING_AID = 0x8000000;
    public static final int DEVICE_OUT_ECHO_CANCELLER = 0x10000000;
    public static final int DEVICE_OUT_BLE_HEADSET = 0x20000000;
    public static final int DEVICE_OUT_BLE_SPEAKER = 0x20000001;
    public static final int DEVICE_OUT_BLE_BROADCAST = 0x20000002;
    public static final int DEVICE_OUT_DEFAULT = 0x40000000;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_ALL_USB = 0x4006000;
    public static final Set<Integer> DEVICE_OUT_ALL_SET;
    public static final Set<Integer> DEVICE_OUT_ALL_A2DP_SET;
    public static final Set<Integer> DEVICE_OUT_ALL_SCO_SET;
    public static final Set<Integer> DEVICE_OUT_ALL_USB_SET;
    public static final Set<Integer> DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO_SET;
    public static final Set<Integer> DEVICE_ALL_HDMI_SYSTEM_AUDIO_AND_SPEAKER_SET;
    public static final Set<Integer> DEVICE_OUT_ALL_BLE_SET;
    public static final Set<Integer> DEVICE_OUT_PICK_FOR_VOLUME_SET;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_COMMUNICATION = -2147483647;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_AMBIENT = -2147483646;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_BUILTIN_MIC = -2147483644;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_BLUETOOTH_SCO_HEADSET = -2147483640;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_WIRED_HEADSET = -2147483632;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_AUX_DIGITAL = -2147483616;
    public static final int DEVICE_IN_HDMI = -2147483616;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_VOICE_CALL = -2147483584;
    public static final int DEVICE_IN_TELEPHONY_RX = -2147483584;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_BACK_MIC = -2147483520;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_REMOTE_SUBMIX = -2147483392;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_ANLG_DOCK_HEADSET = -2147483136;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_DGTL_DOCK_HEADSET = -2147482624;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_USB_ACCESSORY = -2147481600;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_USB_DEVICE = -2147479552;
    public static final int DEVICE_IN_FM_TUNER = -2147475456;
    public static final int DEVICE_IN_TV_TUNER = -2147467264;
    public static final int DEVICE_IN_LINE = -2147450880;
    public static final int DEVICE_IN_SPDIF = -2147418112;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_BLUETOOTH_A2DP = -2147352576;
    public static final int DEVICE_IN_LOOPBACK = -2147221504;
    public static final int DEVICE_IN_IP = -2146959360;
    public static final int DEVICE_IN_BUS = -2146435072;
    public static final int DEVICE_IN_PROXY = -2130706432;
    public static final int DEVICE_IN_USB_HEADSET = -2113929216;
    public static final int DEVICE_IN_BLUETOOTH_BLE = -2080374784;
    public static final int DEVICE_IN_HDMI_ARC = -2013265920;
    public static final int DEVICE_IN_HDMI_EARC = -2013265919;
    public static final int DEVICE_IN_ECHO_REFERENCE = -1879048192;
    public static final int DEVICE_IN_BLE_HEADSET = -1610612736;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_DEFAULT = -1073741824;
    public static final Set<Integer> DEVICE_IN_ALL_SET;
    public static final Set<Integer> DEVICE_IN_ALL_SCO_SET;
    public static final Set<Integer> DEVICE_IN_ALL_USB_SET;
    public static final Set<Integer> DEVICE_IN_ALL_BLE_SET;
    public static final String LEGACY_REMOTE_SUBMIX_ADDRESS = "0";
    @UnsupportedAppUsage
    public static final int DEVICE_STATE_UNAVAILABLE = 0;
    @UnsupportedAppUsage
    public static final int DEVICE_STATE_AVAILABLE = 1;
    private static final int NUM_DEVICE_STATES = 1;
    public static final String DEVICE_OUT_EARPIECE_NAME = "earpiece";
    public static final String DEVICE_OUT_SPEAKER_NAME = "speaker";
    public static final String DEVICE_OUT_WIRED_HEADSET_NAME = "headset";
    public static final String DEVICE_OUT_WIRED_HEADPHONE_NAME = "headphone";
    public static final String DEVICE_OUT_BLUETOOTH_SCO_NAME = "bt_sco";
    public static final String DEVICE_OUT_BLUETOOTH_SCO_HEADSET_NAME = "bt_sco_hs";
    public static final String DEVICE_OUT_BLUETOOTH_SCO_CARKIT_NAME = "bt_sco_carkit";
    public static final String DEVICE_OUT_BLUETOOTH_A2DP_NAME = "bt_a2dp";
    public static final String DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES_NAME = "bt_a2dp_hp";
    public static final String DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER_NAME = "bt_a2dp_spk";
    public static final String DEVICE_OUT_AUX_DIGITAL_NAME = "aux_digital";
    public static final String DEVICE_OUT_HDMI_NAME = "hdmi";
    public static final String DEVICE_OUT_ANLG_DOCK_HEADSET_NAME = "analog_dock";
    public static final String DEVICE_OUT_DGTL_DOCK_HEADSET_NAME = "digital_dock";
    public static final String DEVICE_OUT_USB_ACCESSORY_NAME = "usb_accessory";
    public static final String DEVICE_OUT_USB_DEVICE_NAME = "usb_device";
    public static final String DEVICE_OUT_REMOTE_SUBMIX_NAME = "remote_submix";
    public static final String DEVICE_OUT_TELEPHONY_TX_NAME = "telephony_tx";
    public static final String DEVICE_OUT_LINE_NAME = "line";
    public static final String DEVICE_OUT_HDMI_ARC_NAME = "hdmi_arc";
    public static final String DEVICE_OUT_HDMI_EARC_NAME = "hdmi_earc";
    public static final String DEVICE_OUT_SPDIF_NAME = "spdif";
    public static final String DEVICE_OUT_FM_NAME = "fm_transmitter";
    public static final String DEVICE_OUT_AUX_LINE_NAME = "aux_line";
    public static final String DEVICE_OUT_SPEAKER_SAFE_NAME = "speaker_safe";
    public static final String DEVICE_OUT_IP_NAME = "ip";
    public static final String DEVICE_OUT_MULTICHANNEL_GROUP_NAME = "multichannel_group";
    public static final String DEVICE_OUT_BUS_NAME = "bus";
    public static final String DEVICE_OUT_PROXY_NAME = "proxy";
    public static final String DEVICE_OUT_USB_HEADSET_NAME = "usb_headset";
    public static final String DEVICE_OUT_HEARING_AID_NAME = "hearing_aid_out";
    public static final String DEVICE_OUT_ECHO_CANCELLER_NAME = "echo_canceller";
    public static final String DEVICE_OUT_BLE_HEADSET_NAME = "ble_headset";
    public static final String DEVICE_OUT_BLE_SPEAKER_NAME = "ble_speaker";
    public static final String DEVICE_OUT_BLE_BROADCAST_NAME = "ble_broadcast";
    public static final String DEVICE_IN_COMMUNICATION_NAME = "communication";
    public static final String DEVICE_IN_AMBIENT_NAME = "ambient";
    public static final String DEVICE_IN_BUILTIN_MIC_NAME = "mic";
    public static final String DEVICE_IN_BLUETOOTH_SCO_HEADSET_NAME = "bt_sco_hs";
    public static final String DEVICE_IN_WIRED_HEADSET_NAME = "headset";
    public static final String DEVICE_IN_AUX_DIGITAL_NAME = "aux_digital";
    public static final String DEVICE_IN_TELEPHONY_RX_NAME = "telephony_rx";
    public static final String DEVICE_IN_BACK_MIC_NAME = "back_mic";
    public static final String DEVICE_IN_REMOTE_SUBMIX_NAME = "remote_submix";
    public static final String DEVICE_IN_ANLG_DOCK_HEADSET_NAME = "analog_dock";
    public static final String DEVICE_IN_DGTL_DOCK_HEADSET_NAME = "digital_dock";
    public static final String DEVICE_IN_USB_ACCESSORY_NAME = "usb_accessory";
    public static final String DEVICE_IN_USB_DEVICE_NAME = "usb_device";
    public static final String DEVICE_IN_FM_TUNER_NAME = "fm_tuner";
    public static final String DEVICE_IN_TV_TUNER_NAME = "tv_tuner";
    public static final String DEVICE_IN_LINE_NAME = "line";
    public static final String DEVICE_IN_SPDIF_NAME = "spdif";
    public static final String DEVICE_IN_BLUETOOTH_A2DP_NAME = "bt_a2dp";
    public static final String DEVICE_IN_LOOPBACK_NAME = "loopback";
    public static final String DEVICE_IN_IP_NAME = "ip";
    public static final String DEVICE_IN_BUS_NAME = "bus";
    public static final String DEVICE_IN_PROXY_NAME = "proxy";
    public static final String DEVICE_IN_USB_HEADSET_NAME = "usb_headset";
    public static final String DEVICE_IN_BLUETOOTH_BLE_NAME = "bt_ble";
    public static final String DEVICE_IN_ECHO_REFERENCE_NAME = "echo_reference";
    public static final String DEVICE_IN_HDMI_ARC_NAME = "hdmi_arc";
    public static final String DEVICE_IN_HDMI_EARC_NAME = "hdmi_earc";
    public static final String DEVICE_IN_BLE_HEADSET_NAME = "ble_headset";
    public static final int PHONE_STATE_OFFCALL = 0;
    public static final int PHONE_STATE_RINGING = 1;
    public static final int PHONE_STATE_INCALL = 2;
    @UnsupportedAppUsage
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SPEAKER = 1;
    public static final int FORCE_HEADPHONES = 2;
    public static final int FORCE_BT_SCO = 3;
    public static final int FORCE_BT_A2DP = 4;
    public static final int FORCE_WIRED_ACCESSORY = 5;
    @UnsupportedAppUsage
    public static final int FORCE_BT_CAR_DOCK = 6;
    @UnsupportedAppUsage
    public static final int FORCE_BT_DESK_DOCK = 7;
    @UnsupportedAppUsage
    public static final int FORCE_ANALOG_DOCK = 8;
    @UnsupportedAppUsage
    public static final int FORCE_DIGITAL_DOCK = 9;
    public static final int FORCE_NO_BT_A2DP = 10;
    public static final int FORCE_SYSTEM_ENFORCED = 11;
    public static final int FORCE_HDMI_SYSTEM_AUDIO_ENFORCED = 12;
    public static final int FORCE_ENCODED_SURROUND_NEVER = 13;
    public static final int FORCE_ENCODED_SURROUND_ALWAYS = 14;
    public static final int FORCE_ENCODED_SURROUND_MANUAL = 15;
    public static final int FORCE_BT_BLE = 16;
    public static final int NUM_FORCE_CONFIG = 17;
    public static final int FORCE_DEFAULT = 0;
    public static final int FOR_COMMUNICATION = 0;
    public static final int FOR_MEDIA = 1;
    public static final int FOR_RECORD = 2;
    public static final int FOR_DOCK = 3;
    public static final int FOR_SYSTEM = 4;
    public static final int FOR_HDMI_SYSTEM_AUDIO = 5;
    public static final int FOR_ENCODED_SURROUND = 6;
    public static final int FOR_VIBRATE_RINGING = 7;
    private static final int NUM_FORCE_USE = 8;
    public static final int DEVICE_ROLE_NONE = 0;
    public static final int DEVICE_ROLE_PREFERRED = 1;
    public static final int DEVICE_ROLE_DISABLED = 2;
    public static final int SYNC_EVENT_NONE = 0;
    public static final int SYNC_EVENT_PRESENTATION_COMPLETE = 1;
    public static final int SYNC_EVENT_SHARE_AUDIO_HISTORY = 100;
    private static final int MAX_DEVICE_ROUTING = 4;
    public static final int AUDIO_HW_SYNC_INVALID = 0;
    public static final int DIRECT_NOT_SUPPORTED = 0;
    public static final int DIRECT_OFFLOAD_SUPPORTED = 1;
    public static final int DIRECT_OFFLOAD_GAPLESS_SUPPORTED = 3;
    public static final int DIRECT_BITSTREAM_SUPPORTED = 4;
    public static final int OFFLOAD_NOT_SUPPORTED = 0;
    public static final int OFFLOAD_SUPPORTED = 1;
    public static final int OFFLOAD_GAPLESS_SUPPORTED = 2;
    public static final int PLAY_SOUND_DELAY = 300;
    public static final String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    public static int[] DEFAULT_STREAM_VOLUME;
    public static final int PLATFORM_DEFAULT = 0;
    public static final int PLATFORM_VOICE = 1;
    public static final int PLATFORM_TELEVISION = 2;
    public static final int PLATFORM_AUTOMOTIVE = 3;
    public static final int PLATFORM_PC = 4;
    public static final int DEFAULT_MUTE_STREAMS_AFFECTED = 111;
    static final int NATIVE_EVENT_ROUTING_CHANGE = 1000;

    private AudioSystem() {
        throw new UnsupportedOperationException("Trying to instantiate AudioSystem");
    }

    private static int native_getMaxChannelCount() {
        return OverrideMethod.invokeI("android.media.AudioSystem#native_getMaxChannelCount()I", true, null);
    }

    private static int native_getMaxSampleRate() {
        return OverrideMethod.invokeI("android.media.AudioSystem#native_getMaxSampleRate()I", true, null);
    }

    private static int native_getMinSampleRate() {
        return OverrideMethod.invokeI("android.media.AudioSystem#native_getMinSampleRate()I", true, null);
    }

    @UnsupportedAppUsage
    public static int getNumStreamTypes() {
        return 12;
    }

    @UnsupportedAppUsage
    public static int muteMicrophone(boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#muteMicrophone(Z)I", true, null);
    }

    @UnsupportedAppUsage
    public static boolean isMicrophoneMuted() {
        return OverrideMethod.invokeI("android.media.AudioSystem#isMicrophoneMuted()Z", true, null) != 0;
    }

    public static String modeToString(int mode) {
        switch (mode) {
            case -1: {
                return "MODE_CURRENT";
            }
            case 2: {
                return "MODE_IN_CALL";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case -2: {
                return "MODE_INVALID";
            }
            case 0: {
                return "MODE_NORMAL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
            case 4: {
                return "MODE_CALL_SCREENING";
            }
            case 5: {
                return "MODE_CALL_REDIRECT";
            }
            case 6: {
                return "MODE_COMMUNICATION_REDIRECT";
            }
        }
        return "unknown mode (" + mode + ")";
    }

    public static int audioFormatToBluetoothSourceCodec(int audioFormat) {
        switch (audioFormat) {
            case 0x4000000: {
                return 1;
            }
            case 0x1F000000: {
                return 0;
            }
            case 0x20000000: {
                return 2;
            }
            case 0x21000000: {
                return 3;
            }
            case 0x23000000: {
                return 4;
            }
            case 0x2B000000: {
                return 5;
            }
            case 0x8000000: {
                return 6;
            }
        }
        Log.e(TAG, "Unknown audio format 0x" + Integer.toHexString(audioFormat) + " for conversion to BT codec");
        return 1000000;
    }

    public static int audioFormatToBluetoothLeAudioSourceCodec(int audioFormat) {
        switch (audioFormat) {
            case 0x2B000000: {
                return 0;
            }
            case 0x8000000: {
                return 1;
            }
            case 0x8000001: {
                return 2;
            }
        }
        Log.e(TAG, "Unknown audio format 0x" + Integer.toHexString(audioFormat) + " for conversion to BT LE audio codec");
        return 1000000;
    }

    public static int bluetoothA2dpCodecToAudioFormat(int btCodec) {
        switch (btCodec) {
            case 0: {
                return 0x1F000000;
            }
            case 1: {
                return 0x4000000;
            }
            case 2: {
                return 0x20000000;
            }
            case 3: {
                return 0x21000000;
            }
            case 4: {
                return 0x23000000;
            }
            case 5: {
                return 0x2B000000;
            }
            case 6: {
                return 0x8000000;
            }
        }
        Log.e(TAG, "Unknown A2DP BT codec 0x" + Integer.toHexString(btCodec) + " for conversion to audio format");
        return 0;
    }

    public static int bluetoothLeCodecToAudioFormat(int btCodec) {
        switch (btCodec) {
            case 0: {
                return 0x2B000000;
            }
            case 1: {
                return 0x8000000;
            }
            case 2: {
                return 0x8000001;
            }
        }
        Log.e(TAG, "Unknown LE Audio BT codec 0x" + Integer.toHexString(btCodec) + " for conversion to audio format");
        return 0;
    }

    public static String audioFormatToString(int audioFormat) {
        switch (audioFormat) {
            case -1: {
                return "AUDIO_FORMAT_INVALID";
            }
            case 0: {
                return "AUDIO_FORMAT_DEFAULT";
            }
            case 0x1000000: {
                return "AUDIO_FORMAT_MP3";
            }
            case 0x2000000: {
                return "AUDIO_FORMAT_AMR_NB";
            }
            case 0x3000000: {
                return "AUDIO_FORMAT_AMR_WB";
            }
            case 0x4000000: {
                return "AUDIO_FORMAT_AAC";
            }
            case 0x5000000: {
                return "AUDIO_FORMAT_HE_AAC_V1";
            }
            case 0x6000000: {
                return "AUDIO_FORMAT_HE_AAC_V2";
            }
            case 0x7000000: {
                return "AUDIO_FORMAT_VORBIS";
            }
            case 0x8000000: {
                return "AUDIO_FORMAT_OPUS";
            }
            case 0x8000001: {
                return "AUDIO_FORMAT_OPUS_HI_RES";
            }
            case 0x9000000: {
                return "AUDIO_FORMAT_AC3";
            }
            case 0xA000000: {
                return "AUDIO_FORMAT_E_AC3";
            }
            case 0xB000000: {
                return "AUDIO_FORMAT_DTS";
            }
            case 0xC000000: {
                return "AUDIO_FORMAT_DTS_HD";
            }
            case 0xD000000: {
                return "AUDIO_FORMAT_IEC61937";
            }
            case 0xE000000: {
                return "AUDIO_FORMAT_DOLBY_TRUEHD";
            }
            case 0x10000000: {
                return "AUDIO_FORMAT_EVRC";
            }
            case 0x11000000: {
                return "AUDIO_FORMAT_EVRCB";
            }
            case 0x12000000: {
                return "AUDIO_FORMAT_EVRCWB";
            }
            case 0x13000000: {
                return "AUDIO_FORMAT_EVRCNW";
            }
            case 0x14000000: {
                return "AUDIO_FORMAT_AAC_ADIF";
            }
            case 0x15000000: {
                return "AUDIO_FORMAT_WMA";
            }
            case 0x16000000: {
                return "AUDIO_FORMAT_WMA_PRO";
            }
            case 0x17000000: {
                return "AUDIO_FORMAT_AMR_WB_PLUS";
            }
            case 0x18000000: {
                return "AUDIO_FORMAT_MP2";
            }
            case 0x19000000: {
                return "AUDIO_FORMAT_QCELP";
            }
            case 0x1A000000: {
                return "AUDIO_FORMAT_DSD";
            }
            case 0x1B000000: {
                return "AUDIO_FORMAT_FLAC";
            }
            case 0x1C000000: {
                return "AUDIO_FORMAT_ALAC";
            }
            case 0x1D000000: {
                return "AUDIO_FORMAT_APE";
            }
            case 0x1E000000: {
                return "AUDIO_FORMAT_AAC_ADTS";
            }
            case 0x1F000000: {
                return "AUDIO_FORMAT_SBC";
            }
            case 0x20000000: {
                return "AUDIO_FORMAT_APTX";
            }
            case 0x21000000: {
                return "AUDIO_FORMAT_APTX_HD";
            }
            case 0x22000000: {
                return "AUDIO_FORMAT_AC4";
            }
            case 0x23000000: {
                return "AUDIO_FORMAT_LDAC";
            }
            case 0x24000000: {
                return "AUDIO_FORMAT_MAT";
            }
            case 0x25000000: {
                return "AUDIO_FORMAT_AAC_LATM";
            }
            case 0x26000000: {
                return "AUDIO_FORMAT_CELT";
            }
            case 0x27000000: {
                return "AUDIO_FORMAT_APTX_ADAPTIVE";
            }
            case 0x28000000: {
                return "AUDIO_FORMAT_LHDC";
            }
            case 0x29000000: {
                return "AUDIO_FORMAT_LHDC_LL";
            }
            case 0x2A000000: {
                return "AUDIO_FORMAT_APTX_TWSP";
            }
            case 0x2B000000: {
                return "AUDIO_FORMAT_LC3";
            }
            case 0x2C000000: {
                return "AUDIO_FORMAT_MPEGH";
            }
            case 0x2D000000: {
                return "AUDIO_FORMAT_IEC60958";
            }
            case 0x2E000000: {
                return "AUDIO_FORMAT_DTS_UHD";
            }
            case 0x2F000000: {
                return "AUDIO_FORMAT_DRA";
            }
            case 0x30000000: {
                return "AUDIO_FORMAT_APTX_ADAPTIVE_QLEA";
            }
            case 0x31000000: {
                return "AUDIO_FORMAT_APTX_ADAPTIVE_R4";
            }
            case 0x32000000: {
                return "AUDIO_FORMAT_DTS_HD_MA";
            }
            case 0x33000000: {
                return "AUDIO_FORMAT_DTS_UHD_P2";
            }
            case 1: {
                return "AUDIO_FORMAT_PCM_16_BIT";
            }
            case 2: {
                return "AUDIO_FORMAT_PCM_8_BIT";
            }
            case 3: {
                return "AUDIO_FORMAT_PCM_32_BIT";
            }
            case 4: {
                return "AUDIO_FORMAT_PCM_8_24_BIT";
            }
            case 5: {
                return "AUDIO_FORMAT_PCM_FLOAT";
            }
            case 6: {
                return "AUDIO_FORMAT_PCM_24_BIT_PACKED";
            }
            case 0x4000001: {
                return "AUDIO_FORMAT_AAC_MAIN";
            }
            case 0x4000002: {
                return "AUDIO_FORMAT_AAC_LC";
            }
            case 0x4000004: {
                return "AUDIO_FORMAT_AAC_SSR";
            }
            case 0x4000008: {
                return "AUDIO_FORMAT_AAC_LTP";
            }
            case 0x4000010: {
                return "AUDIO_FORMAT_AAC_HE_V1";
            }
            case 0x4000020: {
                return "AUDIO_FORMAT_AAC_SCALABLE";
            }
            case 0x4000040: {
                return "AUDIO_FORMAT_AAC_ERLC";
            }
            case 0x4000080: {
                return "AUDIO_FORMAT_AAC_LD";
            }
            case 0x4000100: {
                return "AUDIO_FORMAT_AAC_HE_V2";
            }
            case 0x4000200: {
                return "AUDIO_FORMAT_AAC_ELD";
            }
            case 0x4000300: {
                return "AUDIO_FORMAT_AAC_XHE";
            }
            case 0x1E000001: {
                return "AUDIO_FORMAT_AAC_ADTS_MAIN";
            }
            case 503316482: {
                return "AUDIO_FORMAT_AAC_ADTS_LC";
            }
            case 503316484: {
                return "AUDIO_FORMAT_AAC_ADTS_SSR";
            }
            case 503316488: {
                return "AUDIO_FORMAT_AAC_ADTS_LTP";
            }
            case 0x1E000010: {
                return "AUDIO_FORMAT_AAC_ADTS_HE_V1";
            }
            case 503316512: {
                return "AUDIO_FORMAT_AAC_ADTS_SCALABLE";
            }
            case 503316544: {
                return "AUDIO_FORMAT_AAC_ADTS_ERLC";
            }
            case 503316608: {
                return "AUDIO_FORMAT_AAC_ADTS_LD";
            }
            case 0x1E000100: {
                return "AUDIO_FORMAT_AAC_ADTS_HE_V2";
            }
            case 503316992: {
                return "AUDIO_FORMAT_AAC_ADTS_ELD";
            }
            case 503317248: {
                return "AUDIO_FORMAT_AAC_ADTS_XHE";
            }
            case 0x25000002: {
                return "AUDIO_FORMAT_AAC_LATM_LC";
            }
            case 620757008: {
                return "AUDIO_FORMAT_AAC_LATM_HE_V1";
            }
            case 620757248: {
                return "AUDIO_FORMAT_AAC_LATM_HE_V2";
            }
            case 0xA000001: {
                return "AUDIO_FORMAT_E_AC3_JOC";
            }
            case 0x22000001: {
                return "AUDIO_FORMAT_AC4_L4";
            }
            case 603979777: {
                return "AUDIO_FORMAT_MAT_1_0";
            }
            case 0x24000002: {
                return "AUDIO_FORMAT_MAT_2_0";
            }
            case 603979779: {
                return "AUDIO_FORMAT_MAT_2_1";
            }
            case 738197523: {
                return "AUDIO_FORMAT_MPEGH_SUB_BL_L3";
            }
            case 738197524: {
                return "AUDIO_FORMAT_MPEGH_SUB_BL_L4";
            }
            case 738197539: {
                return "AUDIO_FORMAT_MPEGH_SUB_LC_L3";
            }
            case 738197540: {
                return "AUDIO_FORMAT_MPEGH_SUB_LC_L4";
            }
            case 872480769: {
                return "AUDIO_FORMAT_IAMF_SIMPLE_OPUS";
            }
            case 872480770: {
                return "AUDIO_FORMAT_IAMF_SIMPLE_AAC";
            }
            case 872480772: {
                return "AUDIO_FORMAT_IAMF_SIMPLE_FLAC";
            }
            case 872480776: {
                return "AUDIO_FORMAT_IAMF_SIMPLE_PCM";
            }
            case 872546305: {
                return "AUDIO_FORMAT_IAMF_BASE_OPUS";
            }
            case 872546306: {
                return "AUDIO_FORMAT_IAMF_BASE_AAC";
            }
            case 872546308: {
                return "AUDIO_FORMAT_IAMF_BASE_FLAC";
            }
            case 872546312: {
                return "AUDIO_FORMAT_IAMF_BASE_PCM";
            }
            case 872677377: {
                return "AUDIO_FORMAT_IAMF_BASE_ENHANCED_OPUS";
            }
            case 872677378: {
                return "AUDIO_FORMAT_IAMF_BASE_ENHANCED_AAC";
            }
            case 0x34040004: {
                return "AUDIO_FORMAT_IAMF_BASE_ENHANCED_FLAC";
            }
            case 872677384: {
                return "AUDIO_FORMAT_IAMF_BASE_ENHANCED_PCM";
            }
        }
        return "AUDIO_FORMAT_(" + audioFormat + ")";
    }

    @UnsupportedAppUsage
    public static boolean isStreamActive(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#isStreamActive(II)Z", true, null) != 0;
    }

    public static boolean isStreamActiveRemotely(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#isStreamActiveRemotely(II)Z", true, null) != 0;
    }

    @UnsupportedAppUsage
    public static boolean isSourceActive(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#isSourceActive(I)Z", true, null) != 0;
    }

    public static int newAudioSessionId() {
        return OverrideMethod.invokeI("android.media.AudioSystem#newAudioSessionId()I", true, null);
    }

    public static int newAudioPlayerId() {
        return OverrideMethod.invokeI("android.media.AudioSystem#newAudioPlayerId()I", true, null);
    }

    public static int newAudioRecorderId() {
        return OverrideMethod.invokeI("android.media.AudioSystem#newAudioRecorderId()I", true, null);
    }

    @UnsupportedAppUsage
    public static int setParameters(String string2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setParameters(Ljava/lang/String;)I", true, null);
    }

    @UnsupportedAppUsage
    public static String getParameters(String string2) {
        return (String)OverrideMethod.invokeA("android.media.AudioSystem#getParameters(Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setErrorCallback(ErrorCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sErrorCallback = cb;
            if (cb != null) {
                cb.onError(AudioSystem.checkAudioFlinger());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private static void errorCallbackFromNative(int error) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            ErrorCallback errorCallback = sErrorCallback;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (errorCallback != null) {
                errorCallback.onError(error);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDynamicPolicyCallback(DynamicPolicyCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sDynPolicyCallback = cb;
            AudioSystem.native_register_dynamic_policy_callback();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static void dynamicPolicyCallbackFromNative(int event, String regId, int val) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            DynamicPolicyCallback cb = sDynPolicyCallback;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (cb != null) {
                switch (event) {
                    case 0: {
                        cb.onDynamicPolicyMixStateUpdate(regId, val);
                        break;
                    }
                    default: {
                        Log.e(TAG, "dynamicPolicyCallbackFromNative: unknown event " + event);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRecordingCallback(AudioRecordingCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sRecordingCallback = cb;
            AudioSystem.native_register_recording_callback();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static void recordingCallbackFromNative(int event, int riid, int uid, int session, int source, int portId, boolean silenced, int[] recordingFormat, AudioEffect.Descriptor[] clientEffects, AudioEffect.Descriptor[] effects, int activeSource) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            String effectName;
            AudioRecordingCallback cb = sRecordingCallback;
            // ** MonitorExit[var12_11] (shouldn't be in output)
            String clientEffectName = clientEffects.length == 0 ? "None" : clientEffects[0].name;
            String string2 = effectName = effects.length == 0 ? "None" : effects[0].name;
            if (cb != null) {
                ArrayList audioPatches = new ArrayList();
                if (AudioManager.listAudioPatches(audioPatches) == 0) {
                    boolean patchFound = false;
                    int patchHandle = recordingFormat[6];
                    for (AudioPatch patch : audioPatches) {
                        if (patch.id() != patchHandle) continue;
                        patchFound = true;
                        break;
                    }
                    if (!patchFound) {
                        AudioManager.resetAudioPortGeneration();
                    }
                }
                cb.onRecordingConfigurationChanged(event, riid, uid, session, source, portId, silenced, recordingFormat, clientEffects, effects, activeSource, "");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRoutingCallback(RoutingUpdateCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sRoutingUpdateCallback = cb;
            AudioSystem.native_register_routing_callback();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void routingCallbackFromNative() {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            RoutingUpdateCallback cb = sRoutingUpdateCallback;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (cb == null) {
                Log.e(TAG, "routing update from APM was not captured");
                return;
            }
            cb.onRoutingUpdated();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVolumeRangeInitRequestCallback(VolumeRangeInitRequestCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sVolRangeInitReqCallback = cb;
            AudioSystem.native_register_vol_range_init_req_callback();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void volRangeInitReqCallbackFromNative() {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            VolumeRangeInitRequestCallback cb = sVolRangeInitReqCallback;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (cb == null) {
                Log.e(TAG, "APM requested volume range initialization, but no callback found");
                return;
            }
            cb.onVolumeRangeInitializationRequested();
            return;
        }
    }

    public static String audioSystemErrorToString(int error) {
        switch (error) {
            case 0: {
                return "SUCCESS";
            }
            case -1: {
                return "ERROR";
            }
            case -2: {
                return "BAD_VALUE";
            }
            case -3: {
                return "INVALID_OPERATION";
            }
            case -4: {
                return "PERMISSION_DENIED";
            }
            case -5: {
                return "NO_INIT";
            }
            case -6: {
                return "DEAD_OBJECT";
            }
            case -7: {
                return "WOULD_BLOCK";
            }
        }
        return "unknown error:" + error;
    }

    public static boolean isInputDevice(int deviceType) {
        return (deviceType & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public static boolean isBluetoothDevice(int deviceType) {
        return AudioSystem.isBluetoothA2dpOutDevice(deviceType) || AudioSystem.isBluetoothScoDevice(deviceType) || AudioSystem.isBluetoothLeDevice(deviceType);
    }

    public static boolean isBluetoothOutDevice(int deviceType) {
        return AudioSystem.isBluetoothA2dpOutDevice(deviceType) || AudioSystem.isBluetoothScoOutDevice(deviceType) || AudioSystem.isBluetoothLeOutDevice(deviceType);
    }

    public static boolean isBluetoothInDevice(int deviceType) {
        return AudioSystem.isBluetoothScoInDevice(deviceType) || AudioSystem.isBluetoothLeInDevice(deviceType);
    }

    public static boolean isBluetoothA2dpOutDevice(int deviceType) {
        return DEVICE_OUT_ALL_A2DP_SET.contains(deviceType);
    }

    public static boolean isBluetoothScoOutDevice(int deviceType) {
        return DEVICE_OUT_ALL_SCO_SET.contains(deviceType);
    }

    public static boolean isBluetoothScoInDevice(int deviceType) {
        return DEVICE_IN_ALL_SCO_SET.contains(deviceType);
    }

    public static boolean isBluetoothScoDevice(int deviceType) {
        return AudioSystem.isBluetoothScoOutDevice(deviceType) || AudioSystem.isBluetoothScoInDevice(deviceType);
    }

    public static boolean isBluetoothLeOutDevice(int deviceType) {
        return DEVICE_OUT_ALL_BLE_SET.contains(deviceType);
    }

    public static boolean isBluetoothLeInDevice(int deviceType) {
        return DEVICE_IN_ALL_BLE_SET.contains(deviceType);
    }

    public static boolean isBluetoothLeDevice(int deviceType) {
        return AudioSystem.isBluetoothLeOutDevice(deviceType) || AudioSystem.isBluetoothLeInDevice(deviceType);
    }

    public static boolean isRemoteSubmixDevice(int deviceType) {
        return deviceType == -2147483392 || deviceType == 32768;
    }

    public static String deviceStateToString(int state) {
        switch (state) {
            case 0: {
                return "DEVICE_STATE_UNAVAILABLE";
            }
            case 1: {
                return "DEVICE_STATE_AVAILABLE";
            }
        }
        return "unknown state (" + state + ")";
    }

    @UnsupportedAppUsage
    public static String getOutputDeviceName(int device) {
        switch (device) {
            case 1: {
                return DEVICE_OUT_EARPIECE_NAME;
            }
            case 2: {
                return DEVICE_OUT_SPEAKER_NAME;
            }
            case 4: {
                return "headset";
            }
            case 8: {
                return DEVICE_OUT_WIRED_HEADPHONE_NAME;
            }
            case 16: {
                return DEVICE_OUT_BLUETOOTH_SCO_NAME;
            }
            case 32: {
                return "bt_sco_hs";
            }
            case 64: {
                return DEVICE_OUT_BLUETOOTH_SCO_CARKIT_NAME;
            }
            case 128: {
                return "bt_a2dp";
            }
            case 256: {
                return DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES_NAME;
            }
            case 512: {
                return DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER_NAME;
            }
            case 1024: {
                return DEVICE_OUT_HDMI_NAME;
            }
            case 2048: {
                return "analog_dock";
            }
            case 4096: {
                return "digital_dock";
            }
            case 8192: {
                return "usb_accessory";
            }
            case 16384: {
                return "usb_device";
            }
            case 32768: {
                return "remote_submix";
            }
            case 65536: {
                return DEVICE_OUT_TELEPHONY_TX_NAME;
            }
            case 131072: {
                return "line";
            }
            case 262144: {
                return "hdmi_arc";
            }
            case 262145: {
                return "hdmi_earc";
            }
            case 524288: {
                return "spdif";
            }
            case 0x100000: {
                return DEVICE_OUT_FM_NAME;
            }
            case 0x200000: {
                return DEVICE_OUT_AUX_LINE_NAME;
            }
            case 0x400000: {
                return DEVICE_OUT_SPEAKER_SAFE_NAME;
            }
            case 0x800000: {
                return "ip";
            }
            case 0x800001: {
                return DEVICE_OUT_MULTICHANNEL_GROUP_NAME;
            }
            case 0x1000000: {
                return "bus";
            }
            case 0x2000000: {
                return "proxy";
            }
            case 0x4000000: {
                return "usb_headset";
            }
            case 0x8000000: {
                return DEVICE_OUT_HEARING_AID_NAME;
            }
            case 0x10000000: {
                return DEVICE_OUT_ECHO_CANCELLER_NAME;
            }
            case 0x20000000: {
                return "ble_headset";
            }
            case 0x20000001: {
                return DEVICE_OUT_BLE_SPEAKER_NAME;
            }
            case 0x20000002: {
                return DEVICE_OUT_BLE_BROADCAST_NAME;
            }
        }
        return "0x" + Integer.toHexString(device);
    }

    public static String getInputDeviceName(int device) {
        switch (device) {
            case -2147483647: {
                return DEVICE_IN_COMMUNICATION_NAME;
            }
            case -2147483646: {
                return DEVICE_IN_AMBIENT_NAME;
            }
            case -2147483644: {
                return DEVICE_IN_BUILTIN_MIC_NAME;
            }
            case -2147483640: {
                return "bt_sco_hs";
            }
            case -2147483632: {
                return "headset";
            }
            case -2147483616: {
                return "aux_digital";
            }
            case -2147483584: {
                return DEVICE_IN_TELEPHONY_RX_NAME;
            }
            case -2147483520: {
                return DEVICE_IN_BACK_MIC_NAME;
            }
            case -2147483392: {
                return "remote_submix";
            }
            case -2147483136: {
                return "analog_dock";
            }
            case -2147482624: {
                return "digital_dock";
            }
            case -2147481600: {
                return "usb_accessory";
            }
            case -2147479552: {
                return "usb_device";
            }
            case -2147475456: {
                return DEVICE_IN_FM_TUNER_NAME;
            }
            case -2147467264: {
                return DEVICE_IN_TV_TUNER_NAME;
            }
            case -2147450880: {
                return "line";
            }
            case -2147418112: {
                return "spdif";
            }
            case -2147352576: {
                return "bt_a2dp";
            }
            case -2147221504: {
                return DEVICE_IN_LOOPBACK_NAME;
            }
            case -2146959360: {
                return "ip";
            }
            case -2146435072: {
                return "bus";
            }
            case -2130706432: {
                return "proxy";
            }
            case -2113929216: {
                return "usb_headset";
            }
            case -2080374784: {
                return DEVICE_IN_BLUETOOTH_BLE_NAME;
            }
            case -1879048192: {
                return DEVICE_IN_ECHO_REFERENCE_NAME;
            }
            case -2013265920: {
                return "hdmi_arc";
            }
            case -2013265919: {
                return "hdmi_earc";
            }
            case -1610612736: {
                return "ble_headset";
            }
        }
        return Integer.toString(device);
    }

    @NonNull
    public static String getDeviceName(int device) {
        if (AudioSystem.isInputDevice(device)) {
            return AudioSystem.getInputDeviceName(device);
        }
        return AudioSystem.getOutputDeviceName(device);
    }

    public static String forceUseConfigToString(int config) {
        switch (config) {
            case 0: {
                return "FORCE_NONE";
            }
            case 1: {
                return "FORCE_SPEAKER";
            }
            case 2: {
                return "FORCE_HEADPHONES";
            }
            case 3: {
                return "FORCE_BT_SCO";
            }
            case 4: {
                return "FORCE_BT_A2DP";
            }
            case 5: {
                return "FORCE_WIRED_ACCESSORY";
            }
            case 6: {
                return "FORCE_BT_CAR_DOCK";
            }
            case 7: {
                return "FORCE_BT_DESK_DOCK";
            }
            case 8: {
                return "FORCE_ANALOG_DOCK";
            }
            case 9: {
                return "FORCE_DIGITAL_DOCK";
            }
            case 10: {
                return "FORCE_NO_BT_A2DP";
            }
            case 11: {
                return "FORCE_SYSTEM_ENFORCED";
            }
            case 12: {
                return "FORCE_HDMI_SYSTEM_AUDIO_ENFORCED";
            }
            case 13: {
                return "FORCE_ENCODED_SURROUND_NEVER";
            }
            case 14: {
                return "FORCE_ENCODED_SURROUND_ALWAYS";
            }
            case 15: {
                return "FORCE_ENCODED_SURROUND_MANUAL";
            }
            case 16: {
                return "FORCE_BT_BLE";
            }
        }
        return "unknown config (" + config + ")";
    }

    public static String forceUseUsageToString(int usage) {
        switch (usage) {
            case 0: {
                return "FOR_COMMUNICATION";
            }
            case 1: {
                return "FOR_MEDIA";
            }
            case 2: {
                return "FOR_RECORD";
            }
            case 3: {
                return "FOR_DOCK";
            }
            case 4: {
                return "FOR_SYSTEM";
            }
            case 5: {
                return "FOR_HDMI_SYSTEM_AUDIO";
            }
            case 6: {
                return "FOR_ENCODED_SURROUND";
            }
            case 7: {
                return "FOR_VIBRATE_RINGING";
            }
        }
        return "unknown usage (" + usage + ")";
    }

    public static int setStreamVolumeIndexAS(int stream, int index, boolean muted, int device) {
        return AudioSystem.setStreamVolumeIndex(stream, index, muted, device);
    }

    @UnsupportedAppUsage
    public static int setDeviceConnectionState(AudioDeviceAttributes attributes, int state, int codecFormat) {
        return AudioSystem.setDeviceConnectionState(attributes, state, codecFormat, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setDeviceConnectionState(AudioDeviceAttributes attributes, int state, int codecFormat, boolean deviceSwitch) {
        android.media.audio.common.AudioPort port = AidlConversion.api2aidl_AudioDeviceAttributes_AudioPort(attributes);
        Parcel parcel = Parcel.obtain();
        port.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        try {
            int n = AudioSystem.setDeviceConnectionState(state, parcel, codecFormat, deviceSwitch);
            return n;
        }
        finally {
            parcel.recycle();
        }
    }

    @UnsupportedAppUsage
    public static int setDeviceConnectionState(int n, Parcel parcel, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setDeviceConnectionState(ILandroid/os/Parcel;IZ)I", true, null);
    }

    @UnsupportedAppUsage
    public static int getDeviceConnectionState(int n, String string2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getDeviceConnectionState(ILjava/lang/String;)I", true, null);
    }

    public static int handleDeviceConfigChange(int n, String string2, String string3, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#handleDeviceConfigChange(ILjava/lang/String;Ljava/lang/String;I)I", true, null);
    }

    @UnsupportedAppUsage
    public static int setPhoneState(int state) {
        Log.w(TAG, "Do not use this method! Use AudioManager.setMode() instead.");
        return 0;
    }

    public static int setPhoneState(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setPhoneState(II)I", true, null);
    }

    @UnsupportedAppUsage
    public static int setForceUse(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setForceUse(II)I", true, null);
    }

    @UnsupportedAppUsage
    public static int getForceUse(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getForceUse(I)I", true, null);
    }

    @UnsupportedAppUsage
    public static int setDeviceAbsoluteVolumeEnabled(int n, @NonNull String string2, boolean bl, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setDeviceAbsoluteVolumeEnabled(ILjava/lang/String;ZI)I", true, null);
    }

    @UnsupportedAppUsage
    public static int initStreamVolume(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.media.AudioSystem#initStreamVolume(III)I", true, null);
    }

    @UnsupportedAppUsage
    private static int setStreamVolumeIndex(int n, int n2, boolean bl, int n3) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setStreamVolumeIndex(IIZI)I", true, null);
    }

    public static int getStreamVolumeIndex(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getStreamVolumeIndex(II)I", true, null);
    }

    public static int setVolumeIndexForAttributes(@NonNull AudioAttributes audioAttributes, int n, boolean bl, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setVolumeIndexForAttributes(Landroid/media/AudioAttributes;IZI)I", true, null);
    }

    public static int getVolumeIndexForAttributes(@NonNull AudioAttributes audioAttributes, int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getVolumeIndexForAttributes(Landroid/media/AudioAttributes;I)I", true, null);
    }

    public static int getMinVolumeIndexForAttributes(@NonNull AudioAttributes audioAttributes) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getMinVolumeIndexForAttributes(Landroid/media/AudioAttributes;)I", true, null);
    }

    public static int getMaxVolumeIndexForAttributes(@NonNull AudioAttributes audioAttributes) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getMaxVolumeIndexForAttributes(Landroid/media/AudioAttributes;)I", true, null);
    }

    public static int setVolumeIndexForGroup(int n, int n2, boolean bl, int n3) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setVolumeIndexForGroup(IIZI)I", true, null);
    }

    public static int getVolumeIndexForGroup(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getVolumeIndexForGroup(II)I", true, null);
    }

    public static int getMinVolumeIndexForGroup(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getMinVolumeIndexForGroup(I)I", true, null);
    }

    public static int setMinVolumeIndexForGroup(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setMinVolumeIndexForGroup(II)I", true, null);
    }

    public static int getMaxVolumeIndexForGroup(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getMaxVolumeIndexForGroup(I)I", true, null);
    }

    public static int setMaxVolumeIndexForGroup(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setMaxVolumeIndexForGroup(II)I", true, null);
    }

    public static int setMasterVolume(float f) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setMasterVolume(F)I", true, null);
    }

    public static float getMasterVolume() {
        return OverrideMethod.invokeF("android.media.AudioSystem#getMasterVolume()F", true, null);
    }

    @UnsupportedAppUsage
    public static int setMasterMute(boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setMasterMute(Z)I", true, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean getMasterMute() {
        return OverrideMethod.invokeI("android.media.AudioSystem#getMasterMute()Z", true, null) != 0;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static int getDevicesForStream(int stream) {
        AudioAttributes attr2 = AudioProductStrategy.getAudioAttributesForStrategyWithLegacyStreamType(stream);
        return AudioSystem.getDeviceMaskFromSet(AudioSystem.generateAudioDeviceTypesSet(AudioSystem.getDevicesForAttributes(attr2, true)));
    }

    public static int getDeviceMaskFromSet(@NonNull Set<AudioDeviceAttributes> deviceSet) {
        int deviceMask = 0;
        int deviceInChecksum = Integer.MIN_VALUE;
        for (AudioDeviceAttributes deviceAttr : deviceSet) {
            int device = deviceAttr.getInternalType();
            if ((device & device - 1 & Integer.MAX_VALUE) != 0) {
                Log.i(TAG, "getDeviceMaskFromSet skipping multi-bit device value " + device);
                continue;
            }
            deviceMask |= device;
            deviceInChecksum &= device;
        }
        if (!deviceSet.isEmpty() && deviceInChecksum != (deviceMask & Integer.MIN_VALUE)) {
            Log.e(TAG, "getDeviceMaskFromSet: Invalid set: " + AudioSystem.deviceSetToString(deviceSet));
        }
        return deviceMask;
    }

    @NonNull
    public static String deviceSetToString(@NonNull Set<AudioDeviceAttributes> devices) {
        int n = 0;
        StringBuilder sb = new StringBuilder();
        for (AudioDeviceAttributes device : devices) {
            if (n++ > 0) {
                sb.append(", ");
            }
            sb.append(AudioSystem.getDeviceName(device.getInternalType()));
            sb.append("(").append(Integer.toHexString(device.getInternalType())).append(")");
        }
        return sb.toString();
    }

    @NonNull
    public static ArrayList<AudioDeviceAttributes> getDevicesForAttributes(@NonNull AudioAttributes attributes, boolean forVolume) {
        Objects.requireNonNull(attributes);
        AudioDeviceAttributes[] devices = new AudioDeviceAttributes[4];
        int res = AudioSystem.getDevicesForAttributes(attributes, devices, forVolume);
        ArrayList<AudioDeviceAttributes> routeDevices = new ArrayList<AudioDeviceAttributes>();
        if (res != 0) {
            Log.e(TAG, "error " + res + " in getDevicesForAttributes attributes: " + attributes + " forVolume: " + forVolume);
            return routeDevices;
        }
        for (AudioDeviceAttributes device : devices) {
            if (device == null) continue;
            routeDevices.add(device);
        }
        return routeDevices;
    }

    private static int getDevicesForAttributes(@NonNull AudioAttributes audioAttributes, @NonNull AudioDeviceAttributes[] audioDeviceAttributesArray, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getDevicesForAttributes(Landroid/media/AudioAttributes;[Landroid/media/AudioDeviceAttributes;Z)I", true, null);
    }

    public static boolean getMasterMono() {
        return OverrideMethod.invokeI("android.media.AudioSystem#getMasterMono()Z", true, null) != 0;
    }

    public static int setMasterMono(boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setMasterMono(Z)I", true, null);
    }

    public static int setRttEnabled(boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setRttEnabled(Z)I", true, null);
    }

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS")
    public static float getMasterBalance() {
        return OverrideMethod.invokeF("android.media.AudioSystem#getMasterBalance()F", true, null);
    }

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS")
    public static int setMasterBalance(float f) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setMasterBalance(F)I", true, null);
    }

    @UnsupportedAppUsage(trackingBug=134049522L)
    public static int getPrimaryOutputSamplingRate() {
        return OverrideMethod.invokeI("android.media.AudioSystem#getPrimaryOutputSamplingRate()I", true, null);
    }

    @UnsupportedAppUsage(trackingBug=134049522L)
    public static int getPrimaryOutputFrameCount() {
        return OverrideMethod.invokeI("android.media.AudioSystem#getPrimaryOutputFrameCount()I", true, null);
    }

    @UnsupportedAppUsage
    public static int getOutputLatency(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getOutputLatency(I)I", true, null);
    }

    public static int setLowRamDevice(boolean bl, long l) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setLowRamDevice(ZJ)I", true, null);
    }

    @UnsupportedAppUsage
    public static int checkAudioFlinger() {
        return OverrideMethod.invokeI("android.media.AudioSystem#checkAudioFlinger()I", true, null);
    }

    public static void setAudioFlingerBinder(IBinder iBinder) {
        OverrideMethod.invokeV("android.media.AudioSystem#setAudioFlingerBinder(Landroid/os/IBinder;)V", true, null);
    }

    public static int listAudioPorts(ArrayList<AudioPort> arrayList, int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#listAudioPorts(Ljava/util/ArrayList;[I)I", true, null);
    }

    public static int getSupportedDeviceTypes(int n, IntArray intArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getSupportedDeviceTypes(ILandroid/util/IntArray;)I", true, null);
    }

    public static int createAudioPatch(AudioPatch[] audioPatchArray, AudioPortConfig[] audioPortConfigArray, AudioPortConfig[] audioPortConfigArray2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#createAudioPatch([Landroid/media/AudioPatch;[Landroid/media/AudioPortConfig;[Landroid/media/AudioPortConfig;)I", true, null);
    }

    public static int releaseAudioPatch(AudioPatch audioPatch) {
        return OverrideMethod.invokeI("android.media.AudioSystem#releaseAudioPatch(Landroid/media/AudioPatch;)I", true, null);
    }

    public static int listAudioPatches(ArrayList<AudioPatch> arrayList, int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#listAudioPatches(Ljava/util/ArrayList;[I)I", true, null);
    }

    public static int setAudioPortConfig(AudioPortConfig audioPortConfig) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setAudioPortConfig(Landroid/media/AudioPortConfig;)I", true, null);
    }

    public static int startAudioSource(AudioPortConfig audioPortConfig, AudioAttributes audioAttributes) {
        return OverrideMethod.invokeI("android.media.AudioSystem#startAudioSource(Landroid/media/AudioPortConfig;Landroid/media/AudioAttributes;)I", true, null);
    }

    public static int stopAudioSource(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#stopAudioSource(I)I", true, null);
    }

    private static void native_register_dynamic_policy_callback() {
        OverrideMethod.invokeV("android.media.AudioSystem#native_register_dynamic_policy_callback()V", true, null);
    }

    private static void native_register_recording_callback() {
        OverrideMethod.invokeV("android.media.AudioSystem#native_register_recording_callback()V", true, null);
    }

    private static void native_register_routing_callback() {
        OverrideMethod.invokeV("android.media.AudioSystem#native_register_routing_callback()V", true, null);
    }

    private static void native_register_vol_range_init_req_callback() {
        OverrideMethod.invokeV("android.media.AudioSystem#native_register_vol_range_init_req_callback()V", true, null);
    }

    public static int getAudioHwSyncForSession(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getAudioHwSyncForSession(I)I", true, null);
    }

    public static int registerPolicyMixes(ArrayList<AudioMix> arrayList, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#registerPolicyMixes(Ljava/util/ArrayList;Z)I", true, null);
    }

    public static int getRegisteredPolicyMixes(@NonNull List<AudioMix> list) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getRegisteredPolicyMixes(Ljava/util/List;)I", true, null);
    }

    public static int updatePolicyMixes(AudioMix[] audioMixArray, AudioMixingRule[] audioMixingRuleArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#updatePolicyMixes([Landroid/media/audiopolicy/AudioMix;[Landroid/media/audiopolicy/AudioMixingRule;)I", true, null);
    }

    public static int setUidDeviceAffinities(int n, @NonNull int[] nArray, @NonNull String[] stringArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setUidDeviceAffinities(I[I[Ljava/lang/String;)I", true, null);
    }

    public static int removeUidDeviceAffinities(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#removeUidDeviceAffinities(I)I", true, null);
    }

    public static int setUserIdDeviceAffinities(int n, @NonNull int[] nArray, @NonNull String[] stringArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setUserIdDeviceAffinities(I[I[Ljava/lang/String;)I", true, null);
    }

    public static int removeUserIdDeviceAffinities(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#removeUserIdDeviceAffinities(I)I", true, null);
    }

    public static int systemReady() {
        return OverrideMethod.invokeI("android.media.AudioSystem#systemReady()I", true, null);
    }

    public static float getStreamVolumeDB(int n, int n2, int n3) {
        return OverrideMethod.invokeF("android.media.AudioSystem#getStreamVolumeDB(III)F", true, null);
    }

    public static int setSupportedSystemUsages(int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setSupportedSystemUsages([I)I", true, null);
    }

    public static int setAllowedCapturePolicy(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setAllowedCapturePolicy(II)I", true, null);
    }

    public static int getDirectPlaybackSupport(@NonNull AudioFormat audioFormat, @NonNull AudioAttributes audioAttributes) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getDirectPlaybackSupport(Landroid/media/AudioFormat;Landroid/media/AudioAttributes;)I", true, null);
    }

    static int getOffloadSupport(@NonNull AudioFormat format, @NonNull AudioAttributes attr2) {
        return AudioSystem.native_get_offload_support(format.getEncoding(), format.getSampleRate(), format.getChannelMask(), format.getChannelIndexMask(), attr2.getVolumeControlStream());
    }

    private static int native_get_offload_support(int n, int n2, int n3, int n4, int n5) {
        return OverrideMethod.invokeI("android.media.AudioSystem#native_get_offload_support(IIIII)I", true, null);
    }

    public static int getMicrophones(ArrayList<MicrophoneInfo> arrayList) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getMicrophones(Ljava/util/ArrayList;)I", true, null);
    }

    public static int getSurroundFormats(Map<Integer, Boolean> map) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getSurroundFormats(Ljava/util/Map;)I", true, null);
    }

    public static int getReportedSurroundFormats(ArrayList<Integer> arrayList) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getReportedSurroundFormats(Ljava/util/ArrayList;)I", true, null);
    }

    public static int getHwOffloadFormatsSupportedForBluetoothMedia(int n, ArrayList<Integer> arrayList) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getHwOffloadFormatsSupportedForBluetoothMedia(ILjava/util/ArrayList;)I", true, null);
    }

    public static int setSurroundFormatEnabled(int n, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setSurroundFormatEnabled(IZ)I", true, null);
    }

    public static int setActiveAssistantServicesUids(int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setActiveAssistantServicesUids([I)I", true, null);
    }

    public static int setAssistantServicesUids(int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setAssistantServicesUids([I)I", true, null);
    }

    public static int setA11yServicesUids(int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setA11yServicesUids([I)I", true, null);
    }

    public static int setCurrentImeUid(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setCurrentImeUid(I)I", true, null);
    }

    public static boolean isHapticPlaybackSupported() {
        return OverrideMethod.invokeI("android.media.AudioSystem#isHapticPlaybackSupported()Z", true, null) != 0;
    }

    public static boolean isUltrasoundSupported() {
        return OverrideMethod.invokeI("android.media.AudioSystem#isUltrasoundSupported()Z", true, null) != 0;
    }

    public static int setAudioHalPids(int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setAudioHalPids([I)I", true, null);
    }

    public static boolean isCallScreeningModeSupported() {
        return OverrideMethod.invokeI("android.media.AudioSystem#isCallScreeningModeSupported()Z", true, null) != 0;
    }

    public static int setDevicesRoleForStrategy(int strategy, int role, @NonNull List<AudioDeviceAttributes> devices) {
        if (devices.isEmpty()) {
            return -2;
        }
        int[] types = new int[devices.size()];
        String[] addresses = new String[devices.size()];
        for (int i = 0; i < devices.size(); ++i) {
            types[i] = devices.get(i).getInternalType();
            addresses[i] = devices.get(i).getAddress();
        }
        return AudioSystem.setDevicesRoleForStrategy(strategy, role, types, addresses);
    }

    private static int setDevicesRoleForStrategy(int n, int n2, @NonNull int[] nArray, @NonNull String[] stringArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setDevicesRoleForStrategy(II[I[Ljava/lang/String;)I", true, null);
    }

    public static int removeDevicesRoleForStrategy(int strategy, int role, @NonNull List<AudioDeviceAttributes> devices) {
        if (devices.isEmpty()) {
            return -2;
        }
        int[] types = new int[devices.size()];
        String[] addresses = new String[devices.size()];
        for (int i = 0; i < devices.size(); ++i) {
            types[i] = devices.get(i).getInternalType();
            addresses[i] = devices.get(i).getAddress();
        }
        return AudioSystem.removeDevicesRoleForStrategy(strategy, role, types, addresses);
    }

    public static int removeDevicesRoleForStrategy(int n, int n2, @NonNull int[] nArray, @NonNull String[] stringArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#removeDevicesRoleForStrategy(II[I[Ljava/lang/String;)I", true, null);
    }

    public static int clearDevicesRoleForStrategy(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#clearDevicesRoleForStrategy(II)I", true, null);
    }

    public static int getDevicesForRoleAndStrategy(int n, int n2, @NonNull List<AudioDeviceAttributes> list) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getDevicesForRoleAndStrategy(IILjava/util/List;)I", true, null);
    }

    private static Pair<int[], String[]> populateInputDevicesTypeAndAddress(@NonNull List<AudioDeviceAttributes> devices) {
        int[] types = new int[devices.size()];
        String[] addresses = new String[devices.size()];
        for (int i = 0; i < devices.size(); ++i) {
            types[i] = devices.get(i).getInternalType();
            if (types[i] == 0) {
                types[i] = AudioDeviceInfo.convertDeviceTypeToInternalInputDevice(devices.get(i).getType(), devices.get(i).getAddress());
            }
            addresses[i] = devices.get(i).getAddress();
        }
        return new Pair<int[], String[]>(types, addresses);
    }

    public static int setDevicesRoleForCapturePreset(int capturePreset, int role, @NonNull List<AudioDeviceAttributes> devices) {
        if (devices.isEmpty()) {
            return -2;
        }
        Pair<int[], String[]> typeAddresses = AudioSystem.populateInputDevicesTypeAndAddress(devices);
        return AudioSystem.setDevicesRoleForCapturePreset(capturePreset, role, (int[])typeAddresses.first, (String[])typeAddresses.second);
    }

    private static int setDevicesRoleForCapturePreset(int n, int n2, @NonNull int[] nArray, @NonNull String[] stringArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setDevicesRoleForCapturePreset(II[I[Ljava/lang/String;)I", true, null);
    }

    public static int addDevicesRoleForCapturePreset(int capturePreset, int role, @NonNull List<AudioDeviceAttributes> devices) {
        if (devices.isEmpty()) {
            return -2;
        }
        Pair<int[], String[]> typeAddresses = AudioSystem.populateInputDevicesTypeAndAddress(devices);
        return AudioSystem.addDevicesRoleForCapturePreset(capturePreset, role, (int[])typeAddresses.first, (String[])typeAddresses.second);
    }

    private static int addDevicesRoleForCapturePreset(int n, int n2, @NonNull int[] nArray, @NonNull String[] stringArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#addDevicesRoleForCapturePreset(II[I[Ljava/lang/String;)I", true, null);
    }

    public static int removeDevicesRoleForCapturePreset(int capturePreset, int role, @NonNull List<AudioDeviceAttributes> devices) {
        if (devices.isEmpty()) {
            return -2;
        }
        Pair<int[], String[]> typeAddresses = AudioSystem.populateInputDevicesTypeAndAddress(devices);
        return AudioSystem.removeDevicesRoleForCapturePreset(capturePreset, role, (int[])typeAddresses.first, (String[])typeAddresses.second);
    }

    private static int removeDevicesRoleForCapturePreset(int n, int n2, @NonNull int[] nArray, @NonNull String[] stringArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#removeDevicesRoleForCapturePreset(II[I[Ljava/lang/String;)I", true, null);
    }

    public static int clearDevicesRoleForCapturePreset(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#clearDevicesRoleForCapturePreset(II)I", true, null);
    }

    public static int getDevicesForRoleAndCapturePreset(int n, int n2, @NonNull List<AudioDeviceAttributes> list) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getDevicesForRoleAndCapturePreset(IILjava/util/List;)I", true, null);
    }

    public static int setVibratorInfos(@NonNull List<Vibrator> list) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setVibratorInfos(Ljava/util/List;)I", true, null);
    }

    @Nullable
    public static ISpatializer getSpatializer(INativeSpatializerCallback callback) {
        return ISpatializer.Stub.asInterface(AudioSystem.nativeGetSpatializer(callback));
    }

    private static IBinder nativeGetSpatializer(INativeSpatializerCallback iNativeSpatializerCallback) {
        return (IBinder)OverrideMethod.invokeA("android.media.AudioSystem#nativeGetSpatializer(Landroid/media/INativeSpatializerCallback;)Landroid/os/IBinder;", true, null);
    }

    public static boolean canBeSpatialized(AudioAttributes audioAttributes, AudioFormat audioFormat, AudioDeviceAttributes[] audioDeviceAttributesArray) {
        return OverrideMethod.invokeI("android.media.AudioSystem#canBeSpatialized(Landroid/media/AudioAttributes;Landroid/media/AudioFormat;[Landroid/media/AudioDeviceAttributes;)Z", true, null) != 0;
    }

    @Nullable
    public static ISoundDose getSoundDoseInterface(ISoundDoseCallback callback) {
        return ISoundDose.Stub.asInterface(AudioSystem.nativeGetSoundDose(callback));
    }

    private static IBinder nativeGetSoundDose(ISoundDoseCallback iSoundDoseCallback) {
        return (IBinder)OverrideMethod.invokeA("android.media.AudioSystem#nativeGetSoundDose(Landroid/media/ISoundDoseCallback;)Landroid/os/IBinder;", true, null);
    }

    public static int getDirectProfilesForAttributes(@NonNull AudioAttributes audioAttributes, @NonNull ArrayList<AudioProfile> arrayList) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getDirectProfilesForAttributes(Landroid/media/AudioAttributes;Ljava/util/ArrayList;)I", true, null);
    }

    public static int getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    public static int getDefaultStreamVolume(int streamType) {
        return DEFAULT_STREAM_VOLUME[streamType];
    }

    @NonNull
    public static String streamToString(int stream) {
        if (stream >= 0 && stream < STREAM_NAMES.length) {
            return STREAM_NAMES[stream];
        }
        if (stream == Integer.MIN_VALUE) {
            return "USE_DEFAULT_STREAM_TYPE";
        }
        return "UNKNOWN_STREAM_" + stream;
    }

    public static int getPlatformType(Context context) {
        if (context.getPackageManager().hasSystemFeature("android.hardware.type.automotive")) {
            return 3;
        }
        if (context.getSystemService(TelephonyManager.class).isVoiceCapable()) {
            return 1;
        }
        if (context.getPackageManager().hasSystemFeature("android.software.leanback")) {
            return 2;
        }
        if (Flags.enablePlatformPcType() && context.getPackageManager().hasSystemFeature("android.hardware.type.pc")) {
            return 4;
        }
        return 0;
    }

    public static boolean isSingleVolume(Context context) {
        boolean forceSingleVolume = context.getResources().getBoolean(17891920);
        return AudioSystem.getPlatformType(context) == 2 || forceSingleVolume;
    }

    @NonNull
    public static Set<AudioDeviceAttributes> generateAudioDeviceTypesSet(@NonNull List<AudioDeviceAttributes> deviceList) {
        return Set.copyOf(deviceList);
    }

    public static Set<AudioDeviceAttributes> intersectionAudioDeviceTypes(@NonNull Set<Integer> a, @NonNull Set<AudioDeviceAttributes> b) {
        HashSet<AudioDeviceAttributes> result = new HashSet<AudioDeviceAttributes>();
        b.forEach(ada -> {
            if (a.contains(ada.getInternalType())) {
                result.add((AudioDeviceAttributes)ada);
            }
        });
        return result;
    }

    public static boolean isSingleAudioDeviceType(@NonNull Set<Integer> types, int type) {
        return types.size() == 1 && types.contains(type);
    }

    public static boolean isLeAudioDeviceType(int type) {
        return DEVICE_OUT_ALL_BLE_SET.contains(type);
    }

    public static int getSupportedMixerAttributes(int n, @NonNull List<AudioMixerAttributes> list) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getSupportedMixerAttributes(ILjava/util/List;)I", true, null);
    }

    public static int setPreferredMixerAttributes(@NonNull AudioAttributes audioAttributes, int n, int n2, @NonNull AudioMixerAttributes audioMixerAttributes) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setPreferredMixerAttributes(Landroid/media/AudioAttributes;IILandroid/media/AudioMixerAttributes;)I", true, null);
    }

    public static int getPreferredMixerAttributes(@NonNull AudioAttributes audioAttributes, int n, List<AudioMixerAttributes> list) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getPreferredMixerAttributes(Landroid/media/AudioAttributes;ILjava/util/List;)I", true, null);
    }

    public static int clearPreferredMixerAttributes(@NonNull AudioAttributes audioAttributes, int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#clearPreferredMixerAttributes(Landroid/media/AudioAttributes;II)I", true, null);
    }

    public static boolean supportsBluetoothVariableLatency() {
        return OverrideMethod.invokeI("android.media.AudioSystem#supportsBluetoothVariableLatency()Z", true, null) != 0;
    }

    public static int setBluetoothVariableLatencyEnabled(boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setBluetoothVariableLatencyEnabled(Z)I", true, null);
    }

    public static boolean isBluetoothVariableLatencyEnabled() {
        return OverrideMethod.invokeI("android.media.AudioSystem#isBluetoothVariableLatencyEnabled()Z", true, null) != 0;
    }

    public static long listenForSystemPropertyChange(String string2, Runnable runnable) {
        return OverrideMethod.invokeL("android.media.AudioSystem#listenForSystemPropertyChange(Ljava/lang/String;Ljava/lang/Runnable;)J", true, null);
    }

    public static void triggerSystemPropertyUpdate(long l) {
        OverrideMethod.invokeV("android.media.AudioSystem#triggerSystemPropertyUpdate(J)V", true, null);
    }

    public static int registerAudioVolumeGroupCallback(INativeAudioVolumeGroupCallback iNativeAudioVolumeGroupCallback) {
        return OverrideMethod.invokeI("android.media.AudioSystem#registerAudioVolumeGroupCallback(Landroid/media/INativeAudioVolumeGroupCallback;)I", true, null);
    }

    public static int unregisterAudioVolumeGroupCallback(INativeAudioVolumeGroupCallback iNativeAudioVolumeGroupCallback) {
        return OverrideMethod.invokeI("android.media.AudioSystem#unregisterAudioVolumeGroupCallback(Landroid/media/INativeAudioVolumeGroupCallback;)I", true, null);
    }

    public static int setSimulateDeviceConnections(boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setSimulateDeviceConnections(Z)I", true, null);
    }

    static {
        DEVICE_OUT_ALL_SET = new HashSet<Integer>();
        DEVICE_OUT_ALL_SET.add(1);
        DEVICE_OUT_ALL_SET.add(2);
        DEVICE_OUT_ALL_SET.add(4);
        DEVICE_OUT_ALL_SET.add(8);
        DEVICE_OUT_ALL_SET.add(16);
        DEVICE_OUT_ALL_SET.add(32);
        DEVICE_OUT_ALL_SET.add(64);
        DEVICE_OUT_ALL_SET.add(128);
        DEVICE_OUT_ALL_SET.add(256);
        DEVICE_OUT_ALL_SET.add(512);
        DEVICE_OUT_ALL_SET.add(1024);
        DEVICE_OUT_ALL_SET.add(2048);
        DEVICE_OUT_ALL_SET.add(4096);
        DEVICE_OUT_ALL_SET.add(8192);
        DEVICE_OUT_ALL_SET.add(16384);
        DEVICE_OUT_ALL_SET.add(32768);
        DEVICE_OUT_ALL_SET.add(65536);
        DEVICE_OUT_ALL_SET.add(131072);
        DEVICE_OUT_ALL_SET.add(262144);
        DEVICE_OUT_ALL_SET.add(262145);
        DEVICE_OUT_ALL_SET.add(524288);
        DEVICE_OUT_ALL_SET.add(0x100000);
        DEVICE_OUT_ALL_SET.add(0x200000);
        DEVICE_OUT_ALL_SET.add(0x400000);
        DEVICE_OUT_ALL_SET.add(0x800000);
        DEVICE_OUT_ALL_SET.add(0x800001);
        DEVICE_OUT_ALL_SET.add(0x1000000);
        DEVICE_OUT_ALL_SET.add(0x2000000);
        DEVICE_OUT_ALL_SET.add(0x4000000);
        DEVICE_OUT_ALL_SET.add(0x8000000);
        DEVICE_OUT_ALL_SET.add(0x10000000);
        DEVICE_OUT_ALL_SET.add(0x20000000);
        DEVICE_OUT_ALL_SET.add(0x20000001);
        DEVICE_OUT_ALL_SET.add(0x20000002);
        DEVICE_OUT_ALL_SET.add(0x40000000);
        DEVICE_OUT_ALL_A2DP_SET = new HashSet<Integer>();
        DEVICE_OUT_ALL_A2DP_SET.add(128);
        DEVICE_OUT_ALL_A2DP_SET.add(256);
        DEVICE_OUT_ALL_A2DP_SET.add(512);
        DEVICE_OUT_ALL_SCO_SET = new HashSet<Integer>();
        DEVICE_OUT_ALL_SCO_SET.add(16);
        DEVICE_OUT_ALL_SCO_SET.add(32);
        DEVICE_OUT_ALL_SCO_SET.add(64);
        DEVICE_OUT_ALL_USB_SET = new HashSet<Integer>();
        DEVICE_OUT_ALL_USB_SET.add(8192);
        DEVICE_OUT_ALL_USB_SET.add(16384);
        DEVICE_OUT_ALL_USB_SET.add(0x4000000);
        DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO_SET = new HashSet<Integer>();
        DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO_SET.add(0x200000);
        DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO_SET.add(262144);
        DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO_SET.add(262145);
        DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO_SET.add(524288);
        DEVICE_ALL_HDMI_SYSTEM_AUDIO_AND_SPEAKER_SET = new HashSet<Integer>();
        DEVICE_ALL_HDMI_SYSTEM_AUDIO_AND_SPEAKER_SET.addAll(DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO_SET);
        DEVICE_ALL_HDMI_SYSTEM_AUDIO_AND_SPEAKER_SET.add(2);
        DEVICE_OUT_ALL_BLE_SET = new HashSet<Integer>();
        DEVICE_OUT_ALL_BLE_SET.add(0x20000000);
        DEVICE_OUT_ALL_BLE_SET.add(0x20000001);
        DEVICE_OUT_ALL_BLE_SET.add(0x20000002);
        DEVICE_OUT_PICK_FOR_VOLUME_SET = new HashSet<Integer>();
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(4);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(8);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(16384);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(0x4000000);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(128);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(256);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(512);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(16);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(32);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(64);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(0x8000000);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(0x20000000);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(0x20000001);
        DEVICE_OUT_PICK_FOR_VOLUME_SET.add(0x20000002);
        DEVICE_IN_ALL_SET = new HashSet<Integer>();
        DEVICE_IN_ALL_SET.add(-2147483647);
        DEVICE_IN_ALL_SET.add(-2147483646);
        DEVICE_IN_ALL_SET.add(-2147483644);
        DEVICE_IN_ALL_SET.add(-2147483640);
        DEVICE_IN_ALL_SET.add(-2147483632);
        DEVICE_IN_ALL_SET.add(-2147483616);
        DEVICE_IN_ALL_SET.add(-2147483584);
        DEVICE_IN_ALL_SET.add(-2147483520);
        DEVICE_IN_ALL_SET.add(-2147483392);
        DEVICE_IN_ALL_SET.add(-2147483136);
        DEVICE_IN_ALL_SET.add(-2147482624);
        DEVICE_IN_ALL_SET.add(-2147481600);
        DEVICE_IN_ALL_SET.add(-2147479552);
        DEVICE_IN_ALL_SET.add(-2147475456);
        DEVICE_IN_ALL_SET.add(-2147467264);
        DEVICE_IN_ALL_SET.add(-2147450880);
        DEVICE_IN_ALL_SET.add(-2147418112);
        DEVICE_IN_ALL_SET.add(-2147352576);
        DEVICE_IN_ALL_SET.add(-2147221504);
        DEVICE_IN_ALL_SET.add(-2146959360);
        DEVICE_IN_ALL_SET.add(-2146435072);
        DEVICE_IN_ALL_SET.add(-2130706432);
        DEVICE_IN_ALL_SET.add(-2113929216);
        DEVICE_IN_ALL_SET.add(-2080374784);
        DEVICE_IN_ALL_SET.add(-2013265920);
        DEVICE_IN_ALL_SET.add(-2013265919);
        DEVICE_IN_ALL_SET.add(-1879048192);
        DEVICE_IN_ALL_SET.add(-1610612736);
        DEVICE_IN_ALL_SET.add(-1073741824);
        DEVICE_IN_ALL_SCO_SET = new HashSet<Integer>();
        DEVICE_IN_ALL_SCO_SET.add(-2147483640);
        DEVICE_IN_ALL_USB_SET = new HashSet<Integer>();
        DEVICE_IN_ALL_USB_SET.add(-2147481600);
        DEVICE_IN_ALL_USB_SET.add(-2147479552);
        DEVICE_IN_ALL_USB_SET.add(-2113929216);
        DEVICE_IN_ALL_BLE_SET = new HashSet<Integer>();
        DEVICE_IN_ALL_BLE_SET.add(-1610612736);
        DEFAULT_STREAM_VOLUME = new int[]{4, 7, 5, 5, 6, 5, 7, 7, 5, 5, 5, 5};
    }

    public static interface ErrorCallback {
        public void onError(int var1);
    }

    public static interface DynamicPolicyCallback {
        public void onDynamicPolicyMixStateUpdate(String var1, int var2);
    }

    public static interface AudioRecordingCallback {
        public void onRecordingConfigurationChanged(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7, int[] var8, AudioEffect.Descriptor[] var9, AudioEffect.Descriptor[] var10, int var11, String var12);
    }

    public static interface RoutingUpdateCallback {
        public void onRoutingUpdated();
    }

    public static interface VolumeRangeInitRequestCallback {
        public void onVolumeRangeInitializationRequested();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioSystemError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BtOffloadDeviceType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioFormatNativeEnumForBtLeAudioCodec {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioFormatNativeEnumForBtCodec {
    }
}

