/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.icu.util.ULocale;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class AudioPresentation
implements Parcelable {
    private final int mPresentationId;
    private final int mProgramId;
    private final ULocale mLanguage;
    public static final int CONTENT_UNKNOWN = -1;
    public static final int CONTENT_MAIN = 0;
    public static final int CONTENT_MUSIC_AND_EFFECTS = 1;
    public static final int CONTENT_VISUALLY_IMPAIRED = 2;
    public static final int CONTENT_HEARING_IMPAIRED = 3;
    public static final int CONTENT_DIALOG = 4;
    public static final int CONTENT_COMMENTARY = 5;
    public static final int CONTENT_EMERGENCY = 6;
    public static final int CONTENT_VOICEOVER = 7;
    private final int mMasteringIndication;
    private final boolean mAudioDescriptionAvailable;
    private final boolean mSpokenSubtitlesAvailable;
    private final boolean mDialogueEnhancementAvailable;
    private final HashMap<ULocale, String> mLabels;
    public static final int MASTERING_NOT_INDICATED = 0;
    public static final int MASTERED_FOR_STEREO = 1;
    public static final int MASTERED_FOR_SURROUND = 2;
    public static final int MASTERED_FOR_3D = 3;
    public static final int MASTERED_FOR_HEADPHONE = 4;
    public static final int PRESENTATION_ID_UNKNOWN = -1;
    public static final int PROGRAM_ID_UNKNOWN = -1;
    @NonNull
    public static final Parcelable.Creator<AudioPresentation> CREATOR = new Parcelable.Creator<AudioPresentation>(){

        @Override
        public AudioPresentation createFromParcel(@NonNull Parcel in) {
            return new AudioPresentation(in);
        }

        public AudioPresentation[] newArray(int size) {
            return new AudioPresentation[size];
        }
    };

    private AudioPresentation(int presentationId, int programId, @NonNull ULocale language, int masteringIndication, boolean audioDescriptionAvailable, boolean spokenSubtitlesAvailable, boolean dialogueEnhancementAvailable, @NonNull Map<ULocale, String> labels) {
        this.mPresentationId = presentationId;
        this.mProgramId = programId;
        this.mLanguage = language;
        this.mMasteringIndication = masteringIndication;
        this.mAudioDescriptionAvailable = audioDescriptionAvailable;
        this.mSpokenSubtitlesAvailable = spokenSubtitlesAvailable;
        this.mDialogueEnhancementAvailable = dialogueEnhancementAvailable;
        this.mLabels = new HashMap<ULocale, String>(labels);
    }

    private AudioPresentation(@NonNull Parcel in) {
        this.mPresentationId = in.readInt();
        this.mProgramId = in.readInt();
        this.mLanguage = in.readSerializable(ULocale.class.getClassLoader(), ULocale.class);
        this.mMasteringIndication = in.readInt();
        this.mAudioDescriptionAvailable = in.readBoolean();
        this.mSpokenSubtitlesAvailable = in.readBoolean();
        this.mDialogueEnhancementAvailable = in.readBoolean();
        this.mLabels = in.readSerializable(HashMap.class.getClassLoader(), HashMap.class);
    }

    public int getPresentationId() {
        return this.mPresentationId;
    }

    public int getProgramId() {
        return this.mProgramId;
    }

    public Map<Locale, String> getLabels() {
        HashMap<Locale, String> localeLabels = new HashMap<Locale, String>(this.mLabels.size());
        for (Map.Entry<ULocale, String> entry : this.mLabels.entrySet()) {
            localeLabels.put(entry.getKey().toLocale(), entry.getValue());
        }
        return localeLabels;
    }

    private Map<ULocale, String> getULabels() {
        return this.mLabels;
    }

    public Locale getLocale() {
        return this.mLanguage.toLocale();
    }

    private ULocale getULocale() {
        return this.mLanguage;
    }

    public int getMasteringIndication() {
        return this.mMasteringIndication;
    }

    public boolean hasAudioDescription() {
        return this.mAudioDescriptionAvailable;
    }

    public boolean hasSpokenSubtitles() {
        return this.mSpokenSubtitlesAvailable;
    }

    public boolean hasDialogueEnhancement() {
        return this.mDialogueEnhancementAvailable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AudioPresentation)) {
            return false;
        }
        AudioPresentation obj = (AudioPresentation)o;
        return this.mPresentationId == obj.getPresentationId() && this.mProgramId == obj.getProgramId() && ((Object)this.mLanguage).equals(obj.getULocale()) && this.mMasteringIndication == obj.getMasteringIndication() && this.mAudioDescriptionAvailable == obj.hasAudioDescription() && this.mSpokenSubtitlesAvailable == obj.hasSpokenSubtitles() && this.mDialogueEnhancementAvailable == obj.hasDialogueEnhancement() && this.mLabels.equals(obj.getULabels());
    }

    public int hashCode() {
        return Objects.hash(this.mPresentationId, this.mProgramId, ((Object)this.mLanguage).hashCode(), this.mMasteringIndication, this.mAudioDescriptionAvailable, this.mSpokenSubtitlesAvailable, this.mDialogueEnhancementAvailable, this.mLabels.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " ");
        sb.append("{ presentation id=" + this.mPresentationId);
        sb.append(", program id=" + this.mProgramId);
        sb.append(", language=" + this.mLanguage);
        sb.append(", labels=" + this.mLabels);
        sb.append(", mastering indication=" + this.mMasteringIndication);
        sb.append(", audio description=" + this.mAudioDescriptionAvailable);
        sb.append(", spoken subtitles=" + this.mSpokenSubtitlesAvailable);
        sb.append(", dialogue enhancement=" + this.mDialogueEnhancementAvailable);
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.getPresentationId());
        dest.writeInt(this.getProgramId());
        dest.writeSerializable(this.getULocale());
        dest.writeInt(this.getMasteringIndication());
        dest.writeBoolean(this.hasAudioDescription());
        dest.writeBoolean(this.hasSpokenSubtitles());
        dest.writeBoolean(this.hasDialogueEnhancement());
        dest.writeSerializable(this.mLabels);
    }

    public static class Builder {
        private final int mPresentationId;
        private int mProgramId = -1;
        private ULocale mLanguage = new ULocale("");
        private int mMasteringIndication = 0;
        private boolean mAudioDescriptionAvailable = false;
        private boolean mSpokenSubtitlesAvailable = false;
        private boolean mDialogueEnhancementAvailable = false;
        private HashMap<ULocale, String> mLabels = new HashMap();

        public Builder(int presentationId) {
            this.mPresentationId = presentationId;
        }

        @NonNull
        public Builder setProgramId(int programId) {
            this.mProgramId = programId;
            return this;
        }

        @NonNull
        public Builder setLocale(@NonNull ULocale language) {
            this.mLanguage = language;
            return this;
        }

        @NonNull
        public Builder setMasteringIndication(int masteringIndication) {
            if (masteringIndication != 0 && masteringIndication != 1 && masteringIndication != 2 && masteringIndication != 3 && masteringIndication != 4) {
                throw new IllegalArgumentException("Unknown mastering indication: " + masteringIndication);
            }
            this.mMasteringIndication = masteringIndication;
            return this;
        }

        @NonNull
        public Builder setLabels(@NonNull Map<ULocale, CharSequence> labels) {
            this.mLabels.clear();
            for (Map.Entry<ULocale, CharSequence> entry : labels.entrySet()) {
                this.mLabels.put(entry.getKey(), entry.getValue().toString());
            }
            return this;
        }

        @NonNull
        public Builder setHasAudioDescription(boolean audioDescriptionAvailable) {
            this.mAudioDescriptionAvailable = audioDescriptionAvailable;
            return this;
        }

        @NonNull
        public Builder setHasSpokenSubtitles(boolean spokenSubtitlesAvailable) {
            this.mSpokenSubtitlesAvailable = spokenSubtitlesAvailable;
            return this;
        }

        @NonNull
        public Builder setHasDialogueEnhancement(boolean dialogueEnhancementAvailable) {
            this.mDialogueEnhancementAvailable = dialogueEnhancementAvailable;
            return this;
        }

        @NonNull
        public AudioPresentation build() {
            return new AudioPresentation(this.mPresentationId, this.mProgramId, this.mLanguage, this.mMasteringIndication, this.mAudioDescriptionAvailable, this.mSpokenSubtitlesAvailable, this.mDialogueEnhancementAvailable, this.mLabels);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MasteringIndicationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentClassifier {
    }
}

