/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import android.util.TimeUtils;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class GnssMeasurementRequest
implements Parcelable {
    public static final int PASSIVE_INTERVAL = Integer.MAX_VALUE;
    private final boolean mCorrelationVectorOutputsEnabled;
    private final boolean mFullTracking;
    private final int mIntervalMillis;
    private WorkSource mWorkSource;
    @NonNull
    public static final Parcelable.Creator<GnssMeasurementRequest> CREATOR = new Parcelable.Creator<GnssMeasurementRequest>(){

        @Override
        @NonNull
        public GnssMeasurementRequest createFromParcel(@NonNull Parcel parcel) {
            return new GnssMeasurementRequest(parcel.readBoolean(), parcel.readBoolean(), parcel.readInt(), parcel.readTypedObject(WorkSource.CREATOR));
        }

        public GnssMeasurementRequest[] newArray(int i) {
            return new GnssMeasurementRequest[i];
        }
    };

    private GnssMeasurementRequest(boolean fullTracking, boolean correlationVectorOutputsEnabled, int intervalMillis, WorkSource workSource) {
        this.mFullTracking = fullTracking;
        this.mCorrelationVectorOutputsEnabled = correlationVectorOutputsEnabled;
        this.mIntervalMillis = intervalMillis;
        this.mWorkSource = Objects.requireNonNull(workSource);
    }

    @SystemApi
    public boolean isCorrelationVectorOutputsEnabled() {
        return this.mCorrelationVectorOutputsEnabled;
    }

    public boolean isFullTracking() {
        return this.mFullTracking;
    }

    public int getIntervalMillis() {
        return this.mIntervalMillis;
    }

    @SystemApi
    @FlaggedApi(value="android.location.flags.gnss_api_measurement_request_work_source")
    @NonNull
    public WorkSource getWorkSource() {
        return this.mWorkSource;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeBoolean(this.mFullTracking);
        parcel.writeBoolean(this.mCorrelationVectorOutputsEnabled);
        parcel.writeInt(this.mIntervalMillis);
        parcel.writeTypedObject(this.mWorkSource, 0);
    }

    @NonNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("GnssMeasurementRequest[");
        if (this.mIntervalMillis == Integer.MAX_VALUE) {
            s.append("passive");
        } else {
            s.append("@");
            TimeUtils.formatDuration((long)this.mIntervalMillis, s);
        }
        if (this.mFullTracking) {
            s.append(", FullTracking");
        }
        if (this.mCorrelationVectorOutputsEnabled) {
            s.append(", CorrelationVectorOutputs");
        }
        if (this.mWorkSource != null && !this.mWorkSource.isEmpty()) {
            s.append(", ").append(this.mWorkSource);
        }
        s.append(']');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GnssMeasurementRequest)) {
            return false;
        }
        GnssMeasurementRequest other = (GnssMeasurementRequest)obj;
        if (this.mFullTracking != other.mFullTracking) {
            return false;
        }
        if (this.mCorrelationVectorOutputsEnabled != other.mCorrelationVectorOutputsEnabled) {
            return false;
        }
        if (this.mIntervalMillis != other.mIntervalMillis) {
            return false;
        }
        return Objects.equals(this.mWorkSource, other.mWorkSource);
    }

    public int hashCode() {
        return Objects.hash(this.mFullTracking, this.mCorrelationVectorOutputsEnabled, this.mIntervalMillis, this.mWorkSource);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private boolean mCorrelationVectorOutputsEnabled;
        private boolean mFullTracking;
        private int mIntervalMillis;
        private WorkSource mWorkSource;

        public Builder() {
        }

        public Builder(@NonNull GnssMeasurementRequest request) {
            this.mCorrelationVectorOutputsEnabled = request.isCorrelationVectorOutputsEnabled();
            this.mFullTracking = request.isFullTracking();
            this.mIntervalMillis = request.getIntervalMillis();
            this.mWorkSource = request.getWorkSource();
        }

        @SystemApi
        @NonNull
        public Builder setCorrelationVectorOutputsEnabled(boolean value) {
            this.mCorrelationVectorOutputsEnabled = value;
            return this;
        }

        @NonNull
        public Builder setFullTracking(boolean value) {
            this.mFullTracking = value;
            return this;
        }

        @NonNull
        public Builder setIntervalMillis(int value) {
            this.mIntervalMillis = Preconditions.checkArgumentInRange(value, 0, Integer.MAX_VALUE, "intervalMillis");
            return this;
        }

        @SystemApi
        @FlaggedApi(value="android.location.flags.gnss_api_measurement_request_work_source")
        @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
        @NonNull
        public Builder setWorkSource(@Nullable WorkSource workSource) {
            this.mWorkSource = workSource;
            return this;
        }

        @NonNull
        public GnssMeasurementRequest build() {
            return new GnssMeasurementRequest(this.mFullTracking, this.mCorrelationVectorOutputsEnabled, this.mIntervalMillis, new WorkSource(this.mWorkSource));
        }
    }
}

