/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.location.GnssReflectingPlane;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@SystemApi
public class GnssExcessPathInfo
implements Parcelable {
    private static final int HAS_EXCESS_PATH_LENGTH_MASK = 1;
    private static final int HAS_EXCESS_PATH_LENGTH_UNC_MASK = 2;
    private static final int HAS_REFLECTING_PLANE_MASK = 4;
    private static final int HAS_ATTENUATION_MASK = 8;
    private final int mFlags;
    private final float mExcessPathLengthMeters;
    private final float mExcessPathLengthUncertaintyMeters;
    @Nullable
    private final GnssReflectingPlane mReflectingPlane;
    private final float mAttenuationDb;
    @NonNull
    public static final Parcelable.Creator<GnssExcessPathInfo> CREATOR = new Parcelable.Creator<GnssExcessPathInfo>(){

        @Override
        @NonNull
        public GnssExcessPathInfo createFromParcel(@NonNull Parcel parcel) {
            int flags = parcel.readInt();
            float excessPathLengthMeters = (flags & 1) != 0 ? parcel.readFloat() : 0.0f;
            float excessPathLengthUncertaintyMeters = (flags & 2) != 0 ? parcel.readFloat() : 0.0f;
            GnssReflectingPlane reflectingPlane = (flags & 4) != 0 ? GnssReflectingPlane.CREATOR.createFromParcel(parcel) : null;
            float attenuationDb = (flags & 8) != 0 ? parcel.readFloat() : 0.0f;
            return new GnssExcessPathInfo(flags, excessPathLengthMeters, excessPathLengthUncertaintyMeters, reflectingPlane, attenuationDb);
        }

        public GnssExcessPathInfo[] newArray(int i) {
            return new GnssExcessPathInfo[i];
        }
    };

    private GnssExcessPathInfo(int flags, float excessPathLengthMeters, float excessPathLengthUncertaintyMeters, @Nullable GnssReflectingPlane reflectingPlane, float attenuationDb) {
        this.mFlags = flags;
        this.mExcessPathLengthMeters = excessPathLengthMeters;
        this.mExcessPathLengthUncertaintyMeters = excessPathLengthUncertaintyMeters;
        this.mReflectingPlane = reflectingPlane;
        this.mAttenuationDb = attenuationDb;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean hasExcessPathLength() {
        return (this.mFlags & 1) != 0;
    }

    public float getExcessPathLengthMeters() {
        if (!this.hasExcessPathLength()) {
            throw new UnsupportedOperationException("getExcessPathLengthMeters() is not supported when hasExcessPathLength() is false");
        }
        return this.mExcessPathLengthMeters;
    }

    public boolean hasExcessPathLengthUncertainty() {
        return (this.mFlags & 2) != 0;
    }

    public float getExcessPathLengthUncertaintyMeters() {
        if (!this.hasExcessPathLengthUncertainty()) {
            throw new UnsupportedOperationException("getExcessPathLengthUncertaintyMeters() is not supported when hasExcessPathLengthUncertainty() is false");
        }
        return this.mExcessPathLengthUncertaintyMeters;
    }

    public boolean hasReflectingPlane() {
        return (this.mFlags & 4) != 0;
    }

    @NonNull
    public GnssReflectingPlane getReflectingPlane() {
        if (!this.hasReflectingPlane()) {
            throw new UnsupportedOperationException("getReflectingPlane() is not supported when hasReflectingPlane() is false");
        }
        return this.mReflectingPlane;
    }

    public boolean hasAttenuation() {
        return (this.mFlags & 8) != 0;
    }

    public float getAttenuationDb() {
        if (!this.hasAttenuation()) {
            throw new UnsupportedOperationException("getAttenuationDb() is not supported when hasAttenuation() is false");
        }
        return this.mAttenuationDb;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int parcelFlags) {
        parcel.writeInt(this.mFlags);
        if (this.hasExcessPathLength()) {
            parcel.writeFloat(this.mExcessPathLengthMeters);
        }
        if (this.hasExcessPathLengthUncertainty()) {
            parcel.writeFloat(this.mExcessPathLengthUncertaintyMeters);
        }
        if (this.hasReflectingPlane()) {
            this.mReflectingPlane.writeToParcel(parcel, parcelFlags);
        }
        if (this.hasAttenuation()) {
            parcel.writeFloat(this.mAttenuationDb);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof GnssExcessPathInfo) {
            GnssExcessPathInfo that = (GnssExcessPathInfo)obj;
            return !(this.mFlags != that.mFlags || this.hasExcessPathLength() && Float.compare(this.mExcessPathLengthMeters, that.mExcessPathLengthMeters) != 0 || this.hasExcessPathLengthUncertainty() && Float.compare(this.mExcessPathLengthUncertaintyMeters, that.mExcessPathLengthUncertaintyMeters) != 0 || this.hasReflectingPlane() && !Objects.equals(this.mReflectingPlane, that.mReflectingPlane) || this.hasAttenuation() && Float.compare(this.mAttenuationDb, that.mAttenuationDb) != 0);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mFlags, Float.valueOf(this.mExcessPathLengthMeters), Float.valueOf(this.mExcessPathLengthUncertaintyMeters), this.mReflectingPlane, Float.valueOf(this.mAttenuationDb));
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder("GnssExcessPathInfo[");
        if (this.hasExcessPathLength()) {
            builder.append(" ExcessPathLengthMeters=").append(this.mExcessPathLengthMeters);
        }
        if (this.hasExcessPathLengthUncertainty()) {
            builder.append(" ExcessPathLengthUncertaintyMeters=").append(this.mExcessPathLengthUncertaintyMeters);
        }
        if (this.hasReflectingPlane()) {
            builder.append(" ReflectingPlane=").append(this.mReflectingPlane);
        }
        if (this.hasAttenuation()) {
            builder.append(" AttenuationDb=").append(this.mAttenuationDb);
        }
        builder.append(']');
        return builder.toString();
    }

    public static class Builder {
        private int mFlags;
        private float mExcessPathLengthMeters;
        private float mExcessPathLengthUncertaintyMeters;
        @Nullable
        private GnssReflectingPlane mReflectingPlane;
        private float mAttenuationDb;

        @NonNull
        public Builder setExcessPathLengthMeters(float excessPathLengthMeters) {
            Preconditions.checkArgumentInRange(excessPathLengthMeters, 0.0f, Float.MAX_VALUE, "excessPathLengthMeters");
            this.mExcessPathLengthMeters = excessPathLengthMeters;
            this.mFlags |= 1;
            return this;
        }

        @NonNull
        public Builder clearExcessPathLengthMeters() {
            this.mExcessPathLengthMeters = 0.0f;
            this.mFlags &= 0xFFFFFFFE;
            return this;
        }

        @NonNull
        public Builder setExcessPathLengthUncertaintyMeters(float excessPathLengthUncertaintyMeters) {
            Preconditions.checkArgumentInRange(excessPathLengthUncertaintyMeters, 0.0f, Float.MAX_VALUE, "excessPathLengthUncertaintyMeters");
            this.mExcessPathLengthUncertaintyMeters = excessPathLengthUncertaintyMeters;
            this.mFlags |= 2;
            return this;
        }

        @NonNull
        public Builder clearExcessPathLengthUncertaintyMeters() {
            this.mExcessPathLengthUncertaintyMeters = 0.0f;
            this.mFlags &= 0xFFFFFFFD;
            return this;
        }

        @NonNull
        public Builder setReflectingPlane(@Nullable GnssReflectingPlane reflectingPlane) {
            this.mReflectingPlane = reflectingPlane;
            this.mFlags = reflectingPlane != null ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
            return this;
        }

        @NonNull
        public Builder setAttenuationDb(float attenuationDb) {
            Preconditions.checkArgumentInRange(attenuationDb, 0.0f, Float.MAX_VALUE, "attenuationDb");
            this.mAttenuationDb = attenuationDb;
            this.mFlags |= 8;
            return this;
        }

        @NonNull
        public Builder clearAttenuationDb() {
            this.mAttenuationDb = 0.0f;
            this.mFlags &= 0xFFFFFFF7;
            return this;
        }

        @NonNull
        public GnssExcessPathInfo build() {
            return new GnssExcessPathInfo(this.mFlags, this.mExcessPathLengthMeters, this.mExcessPathLengthUncertaintyMeters, this.mReflectingPlane, this.mAttenuationDb);
        }
    }
}

