/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.migration;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.InternalExternalRecordConverter;
import android.health.connect.migration.MigrationPayload;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class RecordMigrationPayload
extends MigrationPayload
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<RecordMigrationPayload> CREATOR = new Parcelable.Creator<RecordMigrationPayload>(){

        @Override
        public RecordMigrationPayload createFromParcel(Parcel in) {
            in.readInt();
            return new RecordMigrationPayload(in);
        }

        public RecordMigrationPayload[] newArray(int size) {
            return new RecordMigrationPayload[size];
        }
    };
    private final RecordInternal<?> mRecordInternal;
    @Nullable
    private Record mRecord;

    private RecordMigrationPayload(@NonNull String originPackageName, @NonNull String originAppName, @NonNull Record record) {
        this.mRecordInternal = record.toRecordInternal();
        this.mRecordInternal.setPackageName(originPackageName);
        this.mRecordInternal.setAppName(originAppName);
        this.mRecord = record;
    }

    RecordMigrationPayload(@NonNull Parcel in) {
        this.mRecordInternal = InternalExternalRecordConverter.getInstance().newInternalRecord(in);
        Objects.requireNonNull(this.mRecordInternal.getAppName());
        Objects.requireNonNull(this.mRecordInternal.getPackageName());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(2);
        dest.writeInt(this.mRecordInternal.getRecordType());
        this.mRecordInternal.writeToParcel(dest);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String getOriginPackageName() {
        return Objects.requireNonNull(this.mRecordInternal.getPackageName());
    }

    @NonNull
    public String getOriginAppName() {
        return Objects.requireNonNull(this.mRecordInternal.getAppName());
    }

    @NonNull
    public Record getRecord() {
        if (this.mRecord == null) {
            this.mRecord = this.mRecordInternal.toExternalRecord();
        }
        return this.mRecord;
    }

    public RecordInternal<?> getRecordInternal() {
        return this.mRecordInternal;
    }

    public static class Builder {
        private String mOriginPackageName;
        private String mOriginAppName;
        private Record mRecord;

        public Builder(@NonNull String originPackageName, @NonNull String originAppName, @NonNull Record record) {
            Objects.requireNonNull(originPackageName);
            Objects.requireNonNull(originAppName);
            Objects.requireNonNull(record);
            this.mOriginPackageName = originPackageName;
            this.mOriginAppName = originAppName;
            this.mRecord = record;
        }

        @NonNull
        public Builder setOriginPackageName(@NonNull String originPackageName) {
            Objects.requireNonNull(originPackageName);
            this.mOriginPackageName = originPackageName;
            return this;
        }

        @NonNull
        public Builder setOriginAppName(@NonNull String originAppName) {
            Objects.requireNonNull(originAppName);
            this.mOriginAppName = originAppName;
            return this;
        }

        @NonNull
        public Builder setRecord(@NonNull Record record) {
            Objects.requireNonNull(record);
            this.mRecord = record;
            return this;
        }

        @NonNull
        public RecordMigrationPayload build() {
            return new RecordMigrationPayload(this.mOriginPackageName, this.mOriginAppName, this.mRecord);
        }
    }
}

