/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.ExercisePerformanceGoal;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.units.Power;
import android.health.connect.datatypes.units.Velocity;
import android.os.Parcel;
import java.util.ArrayList;
import java.util.List;

public abstract class ExercisePerformanceGoalInternal {
    public abstract ExercisePerformanceGoal toExternalObject();

    abstract void writeFieldsToParcel(Parcel var1);

    public abstract int getTypeId();

    public static void writeToParcel(List<ExercisePerformanceGoalInternal> performanceGoals, Parcel parcel) {
        parcel.writeInt(performanceGoals.size());
        for (ExercisePerformanceGoalInternal performanceGoal : performanceGoals) {
            parcel.writeInt(performanceGoal.getTypeId());
            performanceGoal.writeFieldsToParcel(parcel);
        }
    }

    public static List<ExercisePerformanceGoalInternal> readFromParcel(Parcel parcel) {
        ArrayList<ExercisePerformanceGoalInternal> result = new ArrayList<ExercisePerformanceGoalInternal>();
        int count = parcel.readInt();
        block10: for (int i = 0; i < count; ++i) {
            int goalTypeId = parcel.readInt();
            switch (goalTypeId) {
                case 1: {
                    result.add(PowerGoalInternal.readFieldsFromParcel(parcel));
                    continue block10;
                }
                case 2: {
                    result.add(SpeedGoalInternal.readFieldsFromParcel(parcel));
                    continue block10;
                }
                case 3: {
                    result.add(CadenceGoalInternal.readFieldsFromParcel(parcel));
                    continue block10;
                }
                case 4: {
                    result.add(HeartRateGoalInternal.readFieldsFromParcel(parcel));
                    continue block10;
                }
                case 5: {
                    result.add(WeightGoalInternal.readFieldsFromParcel(parcel));
                    continue block10;
                }
                case 6: {
                    result.add(RateOfPerceivedExertionGoalInternal.readFieldsFromParcel(parcel));
                    continue block10;
                }
                case 7: {
                    result.add(AmrapGoalInternal.INSTANCE);
                    continue block10;
                }
                case 0: {
                    result.add(UnknownGoalInternal.INSTANCE);
                    continue block10;
                }
            }
        }
        return result;
    }

    public static ExercisePerformanceGoalInternal fromExternalObject(ExercisePerformanceGoal externalObject) {
        if (externalObject instanceof ExercisePerformanceGoal.PowerGoal) {
            ExercisePerformanceGoal.PowerGoal goal = (ExercisePerformanceGoal.PowerGoal)externalObject;
            return new PowerGoalInternal(goal.getMinPower(), goal.getMaxPower());
        }
        if (externalObject instanceof ExercisePerformanceGoal.SpeedGoal) {
            ExercisePerformanceGoal.SpeedGoal goal = (ExercisePerformanceGoal.SpeedGoal)externalObject;
            return new SpeedGoalInternal(goal.getMinSpeed(), goal.getMaxSpeed());
        }
        if (externalObject instanceof ExercisePerformanceGoal.CadenceGoal) {
            ExercisePerformanceGoal.CadenceGoal goal = (ExercisePerformanceGoal.CadenceGoal)externalObject;
            return new CadenceGoalInternal(goal.getMinRpm(), goal.getMaxRpm());
        }
        if (externalObject instanceof ExercisePerformanceGoal.HeartRateGoal) {
            ExercisePerformanceGoal.HeartRateGoal goal = (ExercisePerformanceGoal.HeartRateGoal)externalObject;
            return new HeartRateGoalInternal(goal.getMinBpm(), goal.getMaxBpm());
        }
        if (externalObject instanceof ExercisePerformanceGoal.WeightGoal) {
            ExercisePerformanceGoal.WeightGoal goal = (ExercisePerformanceGoal.WeightGoal)externalObject;
            return new WeightGoalInternal(goal.getMass());
        }
        if (externalObject instanceof ExercisePerformanceGoal.RateOfPerceivedExertionGoal) {
            ExercisePerformanceGoal.RateOfPerceivedExertionGoal goal = (ExercisePerformanceGoal.RateOfPerceivedExertionGoal)externalObject;
            return new RateOfPerceivedExertionGoalInternal(goal.getRpe());
        }
        if (externalObject instanceof ExercisePerformanceGoal.AmrapGoal) {
            return AmrapGoalInternal.INSTANCE;
        }
        return UnknownGoalInternal.INSTANCE;
    }

    public static class PowerGoalInternal
    extends ExercisePerformanceGoalInternal {
        public static final int POWER_GOAL_TYPE_ID = 1;
        private final Power mMinPower;
        private final Power mMaxPower;

        @Override
        void writeFieldsToParcel(Parcel parcel) {
            parcel.writeDouble(this.mMinPower.getInWatts());
            parcel.writeDouble(this.mMaxPower.getInWatts());
        }

        static PowerGoalInternal readFieldsFromParcel(Parcel parcel) {
            return new PowerGoalInternal(Power.fromWatts(parcel.readDouble()), Power.fromWatts(parcel.readDouble()));
        }

        @Override
        public int getTypeId() {
            return 1;
        }

        public PowerGoalInternal(Power minPower, Power maxPower) {
            this.mMinPower = minPower;
            this.mMaxPower = maxPower;
        }

        public Power getMinPower() {
            return this.mMinPower;
        }

        public Power getMaxPower() {
            return this.mMaxPower;
        }

        @Override
        public ExercisePerformanceGoal toExternalObject() {
            return new ExercisePerformanceGoal.PowerGoal(this.mMinPower, this.mMaxPower);
        }
    }

    public static class SpeedGoalInternal
    extends ExercisePerformanceGoalInternal {
        public static final int SPEED_GOAL_TYPE_ID = 2;
        private final Velocity mMinSpeed;
        private final Velocity mMaxSpeed;

        @Override
        void writeFieldsToParcel(Parcel parcel) {
            parcel.writeDouble(this.mMinSpeed.getInMetersPerSecond());
            parcel.writeDouble(this.mMaxSpeed.getInMetersPerSecond());
        }

        static SpeedGoalInternal readFieldsFromParcel(Parcel parcel) {
            return new SpeedGoalInternal(Velocity.fromMetersPerSecond(parcel.readDouble()), Velocity.fromMetersPerSecond(parcel.readDouble()));
        }

        @Override
        public int getTypeId() {
            return 2;
        }

        public SpeedGoalInternal(Velocity minSpeed, Velocity maxSpeed) {
            this.mMinSpeed = minSpeed;
            this.mMaxSpeed = maxSpeed;
        }

        public Velocity getMinSpeed() {
            return this.mMinSpeed;
        }

        public Velocity getMaxSpeed() {
            return this.mMaxSpeed;
        }

        @Override
        public ExercisePerformanceGoal toExternalObject() {
            return new ExercisePerformanceGoal.SpeedGoal(this.mMinSpeed, this.mMaxSpeed);
        }
    }

    public static class CadenceGoalInternal
    extends ExercisePerformanceGoalInternal {
        public static final int CADENCE_GOAL_TYPE_ID = 3;
        private final double mMinRpm;
        private final double mMaxRpm;

        @Override
        void writeFieldsToParcel(Parcel parcel) {
            parcel.writeDouble(this.mMinRpm);
            parcel.writeDouble(this.mMaxRpm);
        }

        static CadenceGoalInternal readFieldsFromParcel(Parcel parcel) {
            return new CadenceGoalInternal(parcel.readDouble(), parcel.readDouble());
        }

        @Override
        public int getTypeId() {
            return 3;
        }

        public CadenceGoalInternal(double minRpm, double maxRpm) {
            this.mMinRpm = minRpm;
            this.mMaxRpm = maxRpm;
        }

        public double getMinRpm() {
            return this.mMinRpm;
        }

        public double getMaxRpm() {
            return this.mMaxRpm;
        }

        @Override
        public ExercisePerformanceGoal toExternalObject() {
            return new ExercisePerformanceGoal.CadenceGoal(this.mMinRpm, this.mMaxRpm);
        }
    }

    public static class HeartRateGoalInternal
    extends ExercisePerformanceGoalInternal {
        public static final int HEART_RATE_GOAL_TYPE_ID = 4;
        private final int mMinBpm;
        private final int mMaxBpm;

        @Override
        void writeFieldsToParcel(Parcel parcel) {
            parcel.writeInt(this.mMinBpm);
            parcel.writeInt(this.mMaxBpm);
        }

        static HeartRateGoalInternal readFieldsFromParcel(Parcel parcel) {
            return new HeartRateGoalInternal(parcel.readInt(), parcel.readInt());
        }

        @Override
        public int getTypeId() {
            return 4;
        }

        public HeartRateGoalInternal(int minBpm, int maxBpm) {
            this.mMinBpm = minBpm;
            this.mMaxBpm = maxBpm;
        }

        public int getMinBpm() {
            return this.mMinBpm;
        }

        public int getMaxBpm() {
            return this.mMaxBpm;
        }

        @Override
        public ExercisePerformanceGoal toExternalObject() {
            return new ExercisePerformanceGoal.HeartRateGoal(this.mMinBpm, this.mMaxBpm);
        }
    }

    public static class WeightGoalInternal
    extends ExercisePerformanceGoalInternal {
        public static final int WEIGHT_GOAL_TYPE_ID = 5;
        private final Mass mMass;

        @Override
        void writeFieldsToParcel(Parcel parcel) {
            parcel.writeDouble(this.mMass.getInGrams());
        }

        static WeightGoalInternal readFieldsFromParcel(Parcel parcel) {
            return new WeightGoalInternal(Mass.fromGrams(parcel.readDouble()));
        }

        @Override
        public int getTypeId() {
            return 5;
        }

        public WeightGoalInternal(Mass mass) {
            this.mMass = mass;
        }

        public Mass getMass() {
            return this.mMass;
        }

        @Override
        public ExercisePerformanceGoal toExternalObject() {
            return new ExercisePerformanceGoal.WeightGoal(this.mMass);
        }
    }

    public static class RateOfPerceivedExertionGoalInternal
    extends ExercisePerformanceGoalInternal {
        public static final int RATE_OF_PERCEIVED_EXERTION_TYPE_ID = 6;
        private final int mRpe;

        @Override
        void writeFieldsToParcel(Parcel parcel) {
            parcel.writeInt(this.mRpe);
        }

        static RateOfPerceivedExertionGoalInternal readFieldsFromParcel(Parcel parcel) {
            return new RateOfPerceivedExertionGoalInternal(parcel.readInt());
        }

        @Override
        public int getTypeId() {
            return 6;
        }

        public RateOfPerceivedExertionGoalInternal(int rpe) {
            this.mRpe = rpe;
        }

        public int getRpe() {
            return this.mRpe;
        }

        @Override
        public ExercisePerformanceGoal toExternalObject() {
            return new ExercisePerformanceGoal.RateOfPerceivedExertionGoal(this.mRpe);
        }
    }

    public static class AmrapGoalInternal
    extends ExercisePerformanceGoalInternal {
        public static final AmrapGoalInternal INSTANCE = new AmrapGoalInternal();
        public static final int AMRAP_GOAL_TYPE_ID = 7;

        @Override
        void writeFieldsToParcel(Parcel parcel) {
        }

        @Override
        public int getTypeId() {
            return 7;
        }

        AmrapGoalInternal() {
        }

        @Override
        public ExercisePerformanceGoal toExternalObject() {
            return ExercisePerformanceGoal.AmrapGoal.INSTANCE;
        }
    }

    public static class UnknownGoalInternal
    extends ExercisePerformanceGoalInternal {
        public static final UnknownGoalInternal INSTANCE = new UnknownGoalInternal();
        public static final int UNKNOWN_GOAL_TYPE_ID = 0;

        @Override
        void writeFieldsToParcel(Parcel parcel) {
        }

        @Override
        public int getTypeId() {
            return 0;
        }

        UnknownGoalInternal() {
        }

        @Override
        public ExercisePerformanceGoal toExternalObject() {
            return ExercisePerformanceGoal.UnknownGoal.INSTANCE;
        }
    }
}

