/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.SexualActivityRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=28)
public class SexualActivityRecord
extends InstantRecord {
    private final int mProtectionUsed;

    private SexualActivityRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, int protectionUsed, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        ValidationUtils.validateIntDefValue(protectionUsed, SexualActivityProtectionUsed.VALID_TYPES, SexualActivityProtectionUsed.class.getSimpleName());
        this.mProtectionUsed = protectionUsed;
    }

    public int getProtectionUsed() {
        return this.mProtectionUsed;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SexualActivityRecord)) {
            return false;
        }
        SexualActivityRecord that = (SexualActivityRecord)o;
        return this.getProtectionUsed() == that.getProtectionUsed();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getProtectionUsed());
    }

    public SexualActivityRecordInternal toRecordInternal() {
        SexualActivityRecordInternal recordInternal = (SexualActivityRecordInternal)new SexualActivityRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setProtectionUsed(this.mProtectionUsed);
        return recordInternal;
    }

    public static class SexualActivityProtectionUsed {
        public static final int PROTECTION_USED_UNKNOWN = 0;
        public static final int PROTECTION_USED_PROTECTED = 1;
        public static final int PROTECTION_USED_UNPROTECTED = 2;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));

        SexualActivityProtectionUsed() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SexualActivityProtectionUsedTypes {
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mProtectionUsed;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, int protectionUsed) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mProtectionUsed = protectionUsed;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public SexualActivityRecord buildWithoutValidation() {
            return new SexualActivityRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mProtectionUsed, true);
        }

        @NonNull
        public SexualActivityRecord build() {
            return new SexualActivityRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mProtectionUsed, false);
        }
    }
}

