/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Power;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.PowerRecordInternal;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

@Identifier(recordIdentifier=13)
public class PowerRecord
extends IntervalRecord {
    private final List<PowerRecordSample> mSamples;
    @NonNull
    public static final AggregationType<Power> POWER_MAX = new AggregationType<Power>(9, 0, 13, Power.class);
    @NonNull
    public static final AggregationType<Power> POWER_MIN = new AggregationType<Power>(8, 1, 13, Power.class);
    @NonNull
    public static final AggregationType<Power> POWER_AVG = new AggregationType<Power>(10, 2, 13, Power.class);

    private PowerRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull List<PowerRecordSample> samples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(samples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, samples.stream().map(PowerRecordSample::getTime).toList());
        }
        this.mSamples = samples;
    }

    @NonNull
    public List<PowerRecordSample> getSamples() {
        return this.mSamples;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (super.equals(object) && object instanceof PowerRecord) {
            PowerRecord other = (PowerRecord)object;
            return Objects.equals(this.getSamples(), other.getSamples());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public PowerRecordInternal toRecordInternal() {
        HashSet<PowerRecordInternal.PowerRecordSample> samples = new HashSet<PowerRecordInternal.PowerRecordSample>(this.getSamples().size());
        for (PowerRecordSample powerRecordSample : this.getSamples()) {
            samples.add(new PowerRecordInternal.PowerRecordSample(powerRecordSample.getPower().getInWatts(), powerRecordSample.getTime().toEpochMilli()));
        }
        PowerRecordInternal recordInternal = (PowerRecordInternal)new PowerRecordInternal(samples).setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        return recordInternal;
    }

    public static class PowerRecordSample {
        private final Power mPower;
        private final Instant mTime;

        public PowerRecordSample(@NonNull Power power, @NonNull Instant time) {
            this(power, time, false);
        }

        public PowerRecordSample(@NonNull Power power, @NonNull Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            Objects.requireNonNull(power);
            if (!skipValidation) {
                ValidationUtils.requireInRange(power.getInWatts(), 0.0, 100000.0, "power");
            }
            this.mTime = time;
            this.mPower = power;
        }

        @NonNull
        public Power getPower() {
            return this.mPower;
        }

        @NonNull
        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PowerRecordSample)) {
                return false;
            }
            PowerRecordSample that = (PowerRecordSample)object;
            return Objects.equals(this.mPower, that.mPower) && this.mTime.toEpochMilli() == that.mTime.toEpochMilli();
        }

        public int hashCode() {
            return Objects.hash(this.getPower(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<PowerRecordSample> mSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, @NonNull List<PowerRecordSample> powerRecordSamples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(powerRecordSamples);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            if (Flags.sampleTimeOrdering()) {
                TreeSet<PowerRecordSample> sampleSet = new TreeSet<PowerRecordSample>(Comparator.comparing(PowerRecordSample::getTime));
                sampleSet.addAll(powerRecordSamples);
                this.mSamples = sampleSet.stream().toList();
            } else {
                this.mSamples = powerRecordSamples;
            }
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public PowerRecord buildWithoutValidation() {
            return new PowerRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, true);
        }

        @NonNull
        public PowerRecord build() {
            return new PowerRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, false);
        }
    }
}

