/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.ExerciseSessionType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.PlannedExerciseBlock;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.internal.datatypes.PlannedExerciseSessionRecordInternal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

@Identifier(recordIdentifier=40)
public class PlannedExerciseSessionRecord
extends IntervalRecord {
    private final Boolean mHasExplicitTime;
    private final int mExerciseType;
    @Nullable
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mNotes;
    private final List<PlannedExerciseBlock> mBlocks;
    @Nullable
    private final String mCompletedExerciseSessionId;

    private PlannedExerciseSessionRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull Boolean hasExplicitTime, @Nullable CharSequence title, @Nullable CharSequence notes, int exerciseType, @NonNull List<PlannedExerciseBlock> blocks, @Nullable String completedExerciseSessionId, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, false);
        this.mHasExplicitTime = hasExplicitTime;
        this.mTitle = title;
        this.mNotes = notes;
        this.mExerciseType = exerciseType;
        this.mBlocks = blocks;
        this.mCompletedExerciseSessionId = completedExerciseSessionId;
    }

    public int getExerciseType() {
        return this.mExerciseType;
    }

    @Nullable
    public CharSequence getNotes() {
        return this.mNotes;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @NonNull
    public LocalDate getStartDate() {
        return this.getStartTime().atOffset(this.getStartZoneOffset()).toLocalDate();
    }

    @NonNull
    public Duration getDuration() {
        return Duration.between(this.getStartTime(), this.getEndTime());
    }

    public boolean hasExplicitTime() {
        return this.mHasExplicitTime;
    }

    @Nullable
    public String getCompletedExerciseSessionId() {
        return this.mCompletedExerciseSessionId;
    }

    @NonNull
    public List<PlannedExerciseBlock> getBlocks() {
        return this.mBlocks;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlannedExerciseSessionRecord)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlannedExerciseSessionRecord that = (PlannedExerciseSessionRecord)o;
        return RecordUtils.isEqualNullableCharSequences(this.getNotes(), that.getNotes()) && RecordUtils.isEqualNullableCharSequences(this.getTitle(), that.getTitle()) && this.getExerciseType() == that.getExerciseType() && this.hasExplicitTime() == that.hasExplicitTime() && Objects.equals(this.getCompletedExerciseSessionId(), that.getCompletedExerciseSessionId()) && Objects.equals(this.getBlocks(), that.getBlocks());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNotes(), this.getTitle(), this.getExerciseType(), this.hasExplicitTime(), this.getCompletedExerciseSessionId(), this.getBlocks());
    }

    public PlannedExerciseSessionRecordInternal toRecordInternal() {
        CharSequence title;
        PlannedExerciseSessionRecordInternal recordInternal = (PlannedExerciseSessionRecordInternal)new PlannedExerciseSessionRecordInternal(this.getBlocks().stream().map(it -> it.toInternalObject()).collect(Collectors.toList())).setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        CharSequence notes = this.getNotes();
        if (notes != null) {
            recordInternal.setNotes(notes.toString());
        }
        if ((title = this.getTitle()) != null) {
            recordInternal.setTitle(title.toString());
        }
        recordInternal.setExerciseType(this.getExerciseType());
        recordInternal.setHasExplicitTime(this.hasExplicitTime());
        String completedSessionId = this.getCompletedExerciseSessionId();
        if (completedSessionId != null) {
            recordInternal.setCompletedExerciseSessionId(UUID.fromString(completedSessionId));
        }
        return recordInternal;
    }

    public static class Builder {
        @NonNull
        private Metadata mMetadata;
        @NonNull
        private Instant mStartTime;
        @NonNull
        private Instant mEndTime;
        @NonNull
        private ZoneOffset mStartZoneOffset;
        @NonNull
        private ZoneOffset mEndZoneOffset;
        private int mExerciseType;
        @Nullable
        private CharSequence mNotes;
        @Nullable
        private CharSequence mTitle;
        private Boolean mHasExplicitTime;
        private final List<PlannedExerciseBlock> mBlocks = new ArrayList<PlannedExerciseBlock>();
        @Nullable
        private String mCompletedExerciseSessionId;

        public Builder(@NonNull Metadata metadata, int exerciseType, @NonNull Instant startTime, @NonNull Instant endTime) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mExerciseType = exerciseType;
            this.mHasExplicitTime = true;
            this.mStartTime = startTime;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(this.mStartTime);
            this.mEndTime = endTime;
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(this.mEndTime);
        }

        public Builder(@NonNull Metadata metadata, int exerciseType, @NonNull LocalDate startDate, @NonNull Duration duration) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startDate);
            Objects.requireNonNull(duration);
            this.mMetadata = metadata;
            this.mExerciseType = exerciseType;
            this.mHasExplicitTime = false;
            this.mStartTime = startDate.atTime(LocalTime.NOON).atZone(ZoneId.systemDefault()).toInstant();
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(this.mStartTime);
            this.mEndTime = this.mStartTime.plus(duration);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(this.mEndTime);
        }

        @NonNull
        public Builder setMetadata(@NonNull Metadata metadata) {
            Objects.requireNonNull(metadata);
            this.mMetadata = metadata;
            return this;
        }

        @NonNull
        public Builder setExerciseType(int exerciseType) {
            this.mExerciseType = exerciseType;
            return this;
        }

        @NonNull
        public Builder setStartTime(@NonNull Instant startTime) {
            Objects.requireNonNull(startTime);
            this.mStartTime = startTime;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(this.mStartTime);
            return this;
        }

        @NonNull
        public Builder setEndTime(@NonNull Instant endTime) {
            Objects.requireNonNull(endTime);
            this.mEndTime = endTime;
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(this.mEndTime);
            return this;
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder setNotes(@Nullable CharSequence notes) {
            this.mNotes = notes;
            return this;
        }

        @NonNull
        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public Builder addBlock(@NonNull PlannedExerciseBlock block) {
            Objects.requireNonNull(block);
            this.mBlocks.add(block);
            return this;
        }

        @NonNull
        public Builder setBlocks(@NonNull List<PlannedExerciseBlock> blocks) {
            Objects.requireNonNull(blocks);
            this.mBlocks.clear();
            this.mBlocks.addAll(blocks);
            return this;
        }

        @NonNull
        public Builder clearBlocks() {
            this.mBlocks.clear();
            return this;
        }

        @NonNull
        public Builder setCompletedExerciseSessionId(@Nullable String id2) {
            this.mCompletedExerciseSessionId = id2;
            return this;
        }

        @NonNull
        public PlannedExerciseSessionRecord buildWithoutValidation() {
            return new PlannedExerciseSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mHasExplicitTime, this.mTitle, this.mNotes, this.mExerciseType, List.copyOf(this.mBlocks), this.mCompletedExerciseSessionId, true);
        }

        @NonNull
        public PlannedExerciseSessionRecord build() {
            if (!ExerciseSessionType.isKnownSessionType(this.mExerciseType)) {
                throw new IllegalArgumentException("Invalid exercise session type");
            }
            return new PlannedExerciseSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mHasExplicitTime, this.mTitle, this.mNotes, this.mExerciseType, List.copyOf(this.mBlocks), this.mCompletedExerciseSessionId, false);
        }
    }
}

