/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Length;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.HeightRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=24)
public class HeightRecord
extends InstantRecord {
    private final Length mHeight;
    @NonNull
    public static final AggregationType<Length> HEIGHT_AVG = new AggregationType<Length>(54, 2, 24, Length.class);
    @NonNull
    public static final AggregationType<Length> HEIGHT_MIN = new AggregationType<Length>(56, 1, 24, Length.class);
    @NonNull
    public static final AggregationType<Length> HEIGHT_MAX = new AggregationType<Length>(55, 0, 24, Length.class);

    private HeightRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, @NonNull Length height, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(height);
        if (!skipValidation) {
            ValidationUtils.requireInRange(height.getInMeters(), 0.0, 3.0, "height");
        }
        this.mHeight = height;
    }

    @NonNull
    public Length getHeight() {
        return this.mHeight;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof HeightRecord)) {
            return false;
        }
        HeightRecord that = (HeightRecord)o;
        return this.getHeight().equals(that.getHeight());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getHeight());
    }

    public HeightRecordInternal toRecordInternal() {
        HeightRecordInternal recordInternal = (HeightRecordInternal)new HeightRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setHeight(this.mHeight.getInMeters());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final Length mHeight;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, @NonNull Length height) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(height);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mHeight = height;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public HeightRecord buildWithoutValidation() {
            return new HeightRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mHeight, true);
        }

        @NonNull
        public HeightRecord build() {
            return new HeightRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mHeight, false);
        }
    }
}

