/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.BodyTemperatureMeasurementLocation;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Temperature;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BodyTemperatureRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=29)
public class BodyTemperatureRecord
extends InstantRecord {
    private final int mMeasurementLocation;
    private final Temperature mTemperature;

    private BodyTemperatureRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, int measurementLocation, @NonNull Temperature temperature, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(temperature);
        ValidationUtils.validateIntDefValue(measurementLocation, BodyTemperatureMeasurementLocation.VALID_TYPES, BodyTemperatureMeasurementLocation.class.getSimpleName());
        if (!skipValidation) {
            ValidationUtils.requireInRange(temperature.getInCelsius(), 0.0, 100.0, "temperature");
        }
        this.mMeasurementLocation = measurementLocation;
        this.mTemperature = temperature;
    }

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    @NonNull
    public Temperature getTemperature() {
        return this.mTemperature;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof BodyTemperatureRecord)) {
            return false;
        }
        BodyTemperatureRecord that = (BodyTemperatureRecord)o;
        return this.getMeasurementLocation() == that.getMeasurementLocation() && this.getTemperature().equals(that.getTemperature());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeasurementLocation(), this.getTemperature());
    }

    public BodyTemperatureRecordInternal toRecordInternal() {
        BodyTemperatureRecordInternal recordInternal = (BodyTemperatureRecordInternal)new BodyTemperatureRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setMeasurementLocation(this.mMeasurementLocation);
        recordInternal.setTemperature(this.mTemperature.getInCelsius());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mMeasurementLocation;
        private final Temperature mTemperature;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, int measurementLocation, @NonNull Temperature temperature) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(temperature);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mMeasurementLocation = measurementLocation;
            this.mTemperature = temperature;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public BodyTemperatureRecord buildWithoutValidation() {
            return new BodyTemperatureRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementLocation, this.mTemperature, true);
        }

        @NonNull
        public BodyTemperatureRecord build() {
            return new BodyTemperatureRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementLocation, this.mTemperature, false);
        }
    }
}

