/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.changelog;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.MedicalResource;
import android.health.connect.datatypes.Record;
import android.health.connect.datatypes.RecordTypeIdentifier;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import com.android.healthfitness.flags.AconfigFlagHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ChangeLogTokenRequest
implements Parcelable {
    private final Set<String> mPackageNames;
    private final Set<Integer> mRecordTypeIds;
    private final Set<Integer> mMedicalResourceTypes;
    @NonNull
    public static final Parcelable.Creator<ChangeLogTokenRequest> CREATOR = new Parcelable.Creator<ChangeLogTokenRequest>(){

        @Override
        public ChangeLogTokenRequest createFromParcel(@NonNull Parcel in) {
            return new ChangeLogTokenRequest(in);
        }

        public ChangeLogTokenRequest[] newArray(int size) {
            return new ChangeLogTokenRequest[size];
        }
    };

    private ChangeLogTokenRequest(@NonNull Set<String> packageNames, @NonNull Set<Integer> recordTypeIds, @NonNull Set<Integer> medicalResourceTypes) {
        ChangeLogTokenRequest.validate(recordTypeIds, medicalResourceTypes);
        this.mPackageNames = Objects.requireNonNull(packageNames);
        this.mRecordTypeIds = Objects.requireNonNull(recordTypeIds);
        this.mMedicalResourceTypes = Objects.requireNonNull(medicalResourceTypes);
    }

    private ChangeLogTokenRequest(@NonNull Parcel in) {
        ArraySet<Integer> recordTypeIds = new ArraySet<Integer>();
        for (int recordTypeId : in.createIntArray()) {
            recordTypeIds.add(recordTypeId);
        }
        this.mRecordTypeIds = recordTypeIds;
        this.mPackageNames = Set.copyOf(in.createStringArrayList());
        ArraySet<Integer> medicalResourceTypes = new ArraySet<Integer>();
        for (int resourceType : in.createIntArray()) {
            medicalResourceTypes.add(resourceType);
        }
        this.mMedicalResourceTypes = medicalResourceTypes;
    }

    @NonNull
    public Set<DataOrigin> getDataOriginFilters() {
        return this.mPackageNames.stream().map(packageName -> new DataOrigin.Builder().setPackageName((String)packageName).build()).collect(Collectors.toSet());
    }

    @NonNull
    public Set<Class<? extends Record>> getRecordTypes() {
        Map<Integer, Class<? extends Record>> map = HealthConnectMappings.getInstance().getRecordIdToExternalRecordClassMap();
        return this.mRecordTypeIds.stream().map(map::get).collect(Collectors.toSet());
    }

    @NonNull
    public Set<String> getPackageNamesToFilter() {
        return this.mPackageNames;
    }

    @NonNull
    public Set<Integer> getRecordTypeIds() {
        return this.mRecordTypeIds;
    }

    @NonNull
    @FlaggedApi(value="com.android.healthfitness.flags.phr_change_logs")
    public Set<Integer> getMedicalResourceTypes() {
        return this.mMedicalResourceTypes;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeIntArray(this.toIntArray(this.mRecordTypeIds));
        dest.writeStringList(List.copyOf(this.mPackageNames));
        dest.writeIntArray(this.toIntArray(this.mMedicalResourceTypes));
    }

    @NonNull
    private int[] toIntArray(Collection<Integer> collection) {
        return collection.stream().mapToInt(Integer::intValue).toArray();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChangeLogTokenRequest)) {
            return false;
        }
        ChangeLogTokenRequest that = (ChangeLogTokenRequest)o;
        return Objects.equals(this.mPackageNames, that.mPackageNames) && Objects.equals(this.mRecordTypeIds, that.mRecordTypeIds) && Objects.equals(this.mMedicalResourceTypes, that.mMedicalResourceTypes);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageNames, this.mRecordTypeIds, this.mMedicalResourceTypes);
    }

    private static void validate(@NonNull Set<Integer> recordTypeIds, @NonNull Set<Integer> medicalResourceTypes) {
        if (AconfigFlagHelper.isPhrChangeLogsEnabled()) {
            if (recordTypeIds.isEmpty() && medicalResourceTypes.isEmpty()) {
                throw new IllegalStateException("At least one Record type or Medical Resource type must be set");
            }
            if (!recordTypeIds.isEmpty() && !medicalResourceTypes.isEmpty()) {
                throw new IllegalStateException("Record types and Medical Resource types can't both be set");
            }
        } else if (recordTypeIds.isEmpty()) {
            throw new IllegalStateException("Requested record types must not be empty");
        }
        try {
            Set<Integer> allRecordTypeIdentifiers = HealthConnectMappings.getInstance().getAllRecordTypeIdentifiers();
            recordTypeIds.forEach(recordTypeId -> ValidationUtils.validateIntDefValue(recordTypeId, allRecordTypeIdentifiers, RecordTypeIdentifier.RecordType.class.getSimpleName()));
            if (AconfigFlagHelper.isPhrChangeLogsEnabled()) {
                medicalResourceTypes.forEach(MedicalResource::validateMedicalResourceType);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Builder {
        private final Set<Class<? extends Record>> mRecordTypes = new ArraySet<Class<? extends Record>>();
        private final Set<String> mPackageNames = new ArraySet<String>();
        private final Set<Integer> mMedicalResourceTypes = new ArraySet<Integer>();

        @NonNull
        public Builder addRecordType(@NonNull Class<? extends Record> recordType) {
            Objects.requireNonNull(recordType);
            if (AconfigFlagHelper.isPhrChangeLogsEnabled() && !this.mMedicalResourceTypes.isEmpty()) {
                throw new IllegalArgumentException("Record types and Medical Resource types can't both be set");
            }
            this.mRecordTypes.add(recordType);
            return this;
        }

        @NonNull
        public Builder addDataOriginFilter(@NonNull DataOrigin dataOriginFilter) {
            Objects.requireNonNull(dataOriginFilter);
            this.mPackageNames.add(dataOriginFilter.getPackageName());
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.healthfitness.flags.phr_change_logs")
        public Builder addMedicalResourceType(int medicalResourceType) {
            if (!this.mRecordTypes.isEmpty()) {
                throw new IllegalArgumentException("Record types and Medical Resource types can't both be set");
            }
            this.mMedicalResourceTypes.add(medicalResourceType);
            return this;
        }

        @NonNull
        public ChangeLogTokenRequest build() {
            HealthConnectMappings mappings = HealthConnectMappings.getInstance();
            Set invalidRecordTypes = this.mRecordTypes.stream().filter(recordClass -> !mappings.hasRecordType((Class<? extends Record>)recordClass)).map(Class::getName).collect(Collectors.toSet());
            if (!invalidRecordTypes.isEmpty()) {
                throw new IllegalStateException("Requested record types must not contain any of " + invalidRecordTypes);
            }
            Set<Integer> recordTypeIds = this.mRecordTypes.stream().map(mappings::getRecordType).collect(Collectors.toSet());
            return new ChangeLogTokenRequest(this.mPackageNames, recordTypeIds, this.mMedicalResourceTypes);
        }
    }
}

