/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.health.connect.RecordIdFilter;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public class RecordIdFiltersParcel
implements Parcelable {
    private static final String TAG = RecordIdFiltersParcel.class.getSimpleName();
    public static final Parcelable.Creator<RecordIdFiltersParcel> CREATOR = new Parcelable.Creator<RecordIdFiltersParcel>(){

        @Override
        public RecordIdFiltersParcel createFromParcel(Parcel in) {
            return new RecordIdFiltersParcel(in);
        }

        public RecordIdFiltersParcel[] newArray(int size) {
            return new RecordIdFiltersParcel[size];
        }
    };
    private final List<RecordIdFilter> mRecordIdFilters;

    public RecordIdFiltersParcel(List<RecordIdFilter> recordIdFilters) {
        this.mRecordIdFilters = recordIdFilters;
    }

    private RecordIdFiltersParcel(Parcel in) {
        int size = in.readInt();
        this.mRecordIdFilters = new ArrayList<RecordIdFilter>(size);
        for (int i = 0; i < size; ++i) {
            String id2 = in.readString();
            String clientRecordId = in.readString();
            int recordId = in.readInt();
            Class<? extends Record> recordType = HealthConnectMappings.getInstance().getRecordIdToExternalRecordClassMap().get(recordId);
            if (recordType == null) {
                Log.w(TAG, "Unknown record type for record id " + recordId);
                continue;
            }
            if (id2 != null) {
                this.mRecordIdFilters.add(RecordIdFilter.fromId(recordType, id2));
                continue;
            }
            if (clientRecordId != null) {
                this.mRecordIdFilters.add(RecordIdFilter.fromClientRecordId(recordType, clientRecordId));
                continue;
            }
            Log.w(TAG, "Filter with both id and client record id null " + recordId);
        }
    }

    public List<RecordIdFilter> getRecordIdFilters() {
        return this.mRecordIdFilters;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mRecordIdFilters.size());
        this.mRecordIdFilters.forEach(recordId -> {
            dest.writeString(recordId.getId());
            dest.writeString(recordId.getClientRecordId());
            dest.writeInt(HealthConnectMappings.getInstance().getRecordType(recordId.getRecordType()));
        });
    }
}

