/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class GetMedicalDataSourcesRequest
implements Parcelable {
    @NonNull
    private final Set<String> mPackageNames;
    private static final String PACKAGE_NAME_REGEX = "^([A-Za-z][a-zA-Z0-9_]*\\.)+[A-Za-z][a-zA-Z0-9_]*$";
    @NonNull
    public static final Parcelable.Creator<GetMedicalDataSourcesRequest> CREATOR = new Parcelable.Creator<GetMedicalDataSourcesRequest>(){

        @Override
        public GetMedicalDataSourcesRequest createFromParcel(Parcel in) {
            return new GetMedicalDataSourcesRequest(in);
        }

        public GetMedicalDataSourcesRequest[] newArray(int size) {
            return new GetMedicalDataSourcesRequest[size];
        }
    };

    private GetMedicalDataSourcesRequest(@NonNull Set<String> packageNames) {
        Objects.requireNonNull(packageNames);
        GetMedicalDataSourcesRequest.validatePackageNames(packageNames);
        this.mPackageNames = packageNames;
    }

    private GetMedicalDataSourcesRequest(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mPackageNames = new ArraySet<String>((Collection)Objects.requireNonNull(in.createStringArrayList()));
        GetMedicalDataSourcesRequest.validatePackageNames(this.mPackageNames);
    }

    @NonNull
    public Set<String> getPackageNames() {
        return new ArraySet<String>(this.mPackageNames);
    }

    private static void validatePackageNames(Set<String> packageNames) {
        Pattern pattern = Pattern.compile(PACKAGE_NAME_REGEX);
        HashSet<String> invalidPackageNames = new HashSet<String>();
        for (String packageName : packageNames) {
            Matcher matcher = pattern.matcher(packageName);
            if (matcher.matches()) continue;
            invalidPackageNames.add(packageName);
        }
        if (!invalidPackageNames.isEmpty()) {
            throw new IllegalArgumentException("Invalid package name(s): " + invalidPackageNames);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeStringList(new ArrayList<String>(this.mPackageNames));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMedicalDataSourcesRequest)) {
            return false;
        }
        GetMedicalDataSourcesRequest that = (GetMedicalDataSourcesRequest)o;
        return this.mPackageNames.equals(that.mPackageNames);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("packageNames=").append(this.mPackageNames);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private final Set<String> mPackageNames = new ArraySet<String>();

        public Builder() {
        }

        public Builder(@NonNull Builder other) {
            Objects.requireNonNull(other);
            this.mPackageNames.addAll(other.mPackageNames);
        }

        public Builder(@NonNull GetMedicalDataSourcesRequest other) {
            Objects.requireNonNull(other);
            this.mPackageNames.addAll(other.getPackageNames());
        }

        @NonNull
        public Builder addPackageName(@NonNull String packageName) {
            Objects.requireNonNull(packageName);
            GetMedicalDataSourcesRequest.validatePackageNames(Set.of(packageName));
            this.mPackageNames.add(packageName);
            return this;
        }

        @NonNull
        public Builder clearPackageNames() {
            this.mPackageNames.clear();
            return this;
        }

        @NonNull
        public GetMedicalDataSourcesRequest build() {
            return new GetMedicalDataSourcesRequest(this.mPackageNames);
        }
    }
}

