/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class UsbRequest {
    private static final String TAG = "UsbRequest";
    static final int MAX_USBFS_BUFFER_SIZE = 16384;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mNativeContext;
    private UsbEndpoint mEndpoint;
    @UnsupportedAppUsage
    private ByteBuffer mBuffer;
    @UnsupportedAppUsage
    private int mLength;
    private Object mClientData;
    private UsbDeviceConnection mConnection;
    private boolean mIsUsingNewQueue;
    private ByteBuffer mTempBuffer;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final Object mLock = new Object();

    public boolean initialize(UsbDeviceConnection connection, UsbEndpoint endpoint) {
        this.mEndpoint = endpoint;
        this.mConnection = Objects.requireNonNull(connection, "connection");
        boolean wasInitialized = this.native_init(connection, endpoint.getAddress(), endpoint.getAttributes(), endpoint.getMaxPacketSize(), endpoint.getInterval());
        if (wasInitialized) {
            this.mCloseGuard.open("UsbRequest.close");
        }
        return wasInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeContext != 0L) {
                this.mEndpoint = null;
                this.mConnection = null;
                this.native_close();
                this.mCloseGuard.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public UsbEndpoint getEndpoint() {
        return this.mEndpoint;
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public void setClientData(Object data) {
        this.mClientData = data;
    }

    @Deprecated
    public boolean queue(ByteBuffer buffer, int length) {
        UsbDeviceConnection connection = this.mConnection;
        if (connection == null) {
            throw new NullPointerException("invalid connection");
        }
        return connection.queueRequest(this, buffer, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean queueIfConnectionOpen(ByteBuffer buffer, int length) {
        boolean result;
        boolean out;
        UsbDeviceConnection connection = this.mConnection;
        if (connection == null || !connection.isOpen()) {
            throw new NullPointerException("invalid connection");
        }
        boolean bl = out = this.mEndpoint.getDirection() == 0;
        if (connection.getContext().getApplicationInfo().targetSdkVersion < 28 && length > 16384) {
            length = 16384;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mBuffer = buffer;
            this.mLength = length;
            if (buffer.isDirect()) {
                result = this.native_queue_direct(buffer, length, out);
            } else if (buffer.hasArray()) {
                result = this.native_queue_array(buffer.array(), length, out);
            } else {
                throw new IllegalArgumentException("buffer is not direct and has no array");
            }
            if (!result) {
                this.mBuffer = null;
                this.mLength = 0;
            }
        }
        return result;
    }

    public boolean queue(@Nullable ByteBuffer buffer) {
        UsbDeviceConnection connection = this.mConnection;
        if (connection == null) {
            throw new IllegalStateException("invalid connection");
        }
        return connection.queueRequest(this, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean queueIfConnectionOpen(@Nullable ByteBuffer buffer) {
        boolean wasQueued;
        UsbDeviceConnection connection = this.mConnection;
        if (connection == null || !connection.isOpen()) {
            throw new IllegalStateException("invalid connection");
        }
        Preconditions.checkState(this.mNativeContext != 0L, "request is not initialized");
        Preconditions.checkState(!this.mIsUsingNewQueue, "this request is currently queued");
        boolean isSend = this.mEndpoint.getDirection() == 0;
        Object object = this.mLock;
        synchronized (object) {
            this.mBuffer = buffer;
            if (buffer == null) {
                this.mIsUsingNewQueue = true;
                wasQueued = this.native_queue(null, 0, 0);
            } else {
                if (connection.getContext().getApplicationInfo().targetSdkVersion < 28) {
                    Preconditions.checkArgumentInRange(buffer.remaining(), 0, 16384, "number of remaining bytes");
                }
                Preconditions.checkArgument(!buffer.isReadOnly() || isSend, "buffer can not be read-only when receiving data");
                if (!buffer.isDirect()) {
                    this.mTempBuffer = ByteBuffer.allocateDirect(this.mBuffer.remaining());
                    if (isSend) {
                        this.mBuffer.mark();
                        this.mTempBuffer.put(this.mBuffer);
                        this.mTempBuffer.flip();
                        this.mBuffer.reset();
                    }
                    buffer = this.mTempBuffer;
                }
                this.mIsUsingNewQueue = true;
                wasQueued = this.native_queue(buffer, buffer.position(), buffer.remaining());
            }
        }
        if (!wasQueued) {
            this.mIsUsingNewQueue = false;
            this.mTempBuffer = null;
            this.mBuffer = null;
        }
        return wasQueued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue(boolean useBufferOverflowInsteadOfIllegalArg) {
        boolean isSend = this.mEndpoint.getDirection() == 0;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsUsingNewQueue) {
                int bytesTransferred = this.native_dequeue_direct();
                this.mIsUsingNewQueue = false;
                if (this.mBuffer != null) {
                    if (this.mTempBuffer == null) {
                        this.mBuffer.position(this.mBuffer.position() + bytesTransferred);
                    } else {
                        this.mTempBuffer.limit(bytesTransferred);
                        try {
                            if (isSend) {
                                this.mBuffer.position(this.mBuffer.position() + bytesTransferred);
                            }
                            this.mBuffer.put(this.mTempBuffer);
                        }
                        finally {
                            this.mTempBuffer = null;
                        }
                    }
                }
            } else {
                int bytesTransferred = this.mBuffer.isDirect() ? this.native_dequeue_direct() : this.native_dequeue_array(this.mBuffer.array(), this.mLength, isSend);
                if (bytesTransferred >= 0) {
                    int bytesToStore = Math.min(bytesTransferred, this.mLength);
                    try {
                        this.mBuffer.position(bytesToStore);
                    }
                    catch (IllegalArgumentException e) {
                        if (useBufferOverflowInsteadOfIllegalArg) {
                            Log.e(TAG, "Buffer " + this.mBuffer + " does not have enough space to read " + bytesToStore + " bytes", e);
                            throw new BufferOverflowException();
                        }
                        throw e;
                    }
                }
            }
            this.mBuffer = null;
            this.mLength = 0;
        }
    }

    public boolean cancel() {
        UsbDeviceConnection connection = this.mConnection;
        if (connection == null) {
            return false;
        }
        return connection.cancelRequest(this);
    }

    boolean cancelIfOpen() {
        UsbDeviceConnection connection = this.mConnection;
        if (this.mNativeContext == 0L || connection != null && !connection.isOpen()) {
            Log.w(TAG, "Detected attempt to cancel a request on a connection which isn't open");
            return false;
        }
        return this.native_cancel();
    }

    private boolean native_init(UsbDeviceConnection usbDeviceConnection, int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_init(Landroid/hardware/usb/UsbDeviceConnection;IIII)Z", true, this) != 0;
    }

    private void native_close() {
        OverrideMethod.invokeV("android.hardware.usb.UsbRequest#native_close()V", true, this);
    }

    private boolean native_queue(ByteBuffer byteBuffer, int n, int n2) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_queue(Ljava/nio/ByteBuffer;II)Z", true, this) != 0;
    }

    private boolean native_queue_array(byte[] byArray, int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_queue_array([BIZ)Z", true, this) != 0;
    }

    private int native_dequeue_array(byte[] byArray, int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_dequeue_array([BIZ)I", true, this);
    }

    private boolean native_queue_direct(ByteBuffer byteBuffer, int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_queue_direct(Ljava/nio/ByteBuffer;IZ)Z", true, this) != 0;
    }

    private int native_dequeue_direct() {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_dequeue_direct()I", true, this);
    }

    private boolean native_cancel() {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_cancel()Z", true, this) != 0;
    }
}

