/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.annotation.NonNull;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbPort;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.Immutable;

@Immutable
public class ParcelableUsbPort
implements Parcelable {
    @NonNull
    private final String mId;
    private final int mSupportedModes;
    private final int mSupportedContaminantProtectionModes;
    private final boolean mSupportsEnableContaminantPresenceProtection;
    private final boolean mSupportsEnableContaminantPresenceDetection;
    private final boolean mSupportsComplianceWarnings;
    private final int mSupportedAltModesMask;
    @NonNull
    public static final Parcelable.Creator<ParcelableUsbPort> CREATOR = new Parcelable.Creator<ParcelableUsbPort>(){

        @Override
        public ParcelableUsbPort createFromParcel(Parcel in) {
            String id2 = in.readString();
            int supportedModes = in.readInt();
            int supportedContaminantProtectionModes = in.readInt();
            boolean supportsEnableContaminantPresenceProtection = in.readBoolean();
            boolean supportsEnableContaminantPresenceDetection = in.readBoolean();
            boolean supportsComplianceWarnings = in.readBoolean();
            int supportedAltModesMask = in.readInt();
            return new ParcelableUsbPort(id2, supportedModes, supportedContaminantProtectionModes, supportsEnableContaminantPresenceProtection, supportsEnableContaminantPresenceDetection, supportsComplianceWarnings, supportedAltModesMask);
        }

        public ParcelableUsbPort[] newArray(int size) {
            return new ParcelableUsbPort[size];
        }
    };

    private ParcelableUsbPort(@NonNull String id2, int supportedModes, int supportedContaminantProtectionModes, boolean supportsEnableContaminantPresenceProtection, boolean supportsEnableContaminantPresenceDetection, boolean supportsComplianceWarnings, int supportedAltModesMask) {
        this.mId = id2;
        this.mSupportedModes = supportedModes;
        this.mSupportedContaminantProtectionModes = supportedContaminantProtectionModes;
        this.mSupportsEnableContaminantPresenceProtection = supportsEnableContaminantPresenceProtection;
        this.mSupportsEnableContaminantPresenceDetection = supportsEnableContaminantPresenceDetection;
        this.mSupportsComplianceWarnings = supportsComplianceWarnings;
        this.mSupportedAltModesMask = supportedAltModesMask;
    }

    @NonNull
    public static ParcelableUsbPort of(@NonNull UsbPort port) {
        return new ParcelableUsbPort(port.getId(), port.getSupportedModes(), port.getSupportedContaminantProtectionModes(), port.supportsEnableContaminantPresenceProtection(), port.supportsEnableContaminantPresenceDetection(), port.supportsComplianceWarnings(), port.getSupportedAltModesMask());
    }

    @NonNull
    public UsbPort getUsbPort(@NonNull UsbManager usbManager) {
        return new UsbPort(usbManager, this.mId, this.mSupportedModes, this.mSupportedContaminantProtectionModes, this.mSupportsEnableContaminantPresenceProtection, this.mSupportsEnableContaminantPresenceDetection, this.mSupportsComplianceWarnings, this.mSupportedAltModesMask);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mSupportedModes);
        dest.writeInt(this.mSupportedContaminantProtectionModes);
        dest.writeBoolean(this.mSupportsEnableContaminantPresenceProtection);
        dest.writeBoolean(this.mSupportsEnableContaminantPresenceDetection);
        dest.writeBoolean(this.mSupportsComplianceWarnings);
        dest.writeInt(this.mSupportedAltModesMask);
    }
}

