/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.UniqueProgramIdentifier;
import android.hardware.radio.Utils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

@SystemApi
public class ProgramList
implements AutoCloseable {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<ProgramSelector.Identifier, ArrayMap<UniqueProgramIdentifier, RadioManager.ProgramInfo>> mPrograms = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final List<ListCallback> mListCallbacks = new ArrayList<ListCallback>();
    @GuardedBy(value={"mLock"})
    private final List<OnCompleteListener> mOnCompleteListeners = new ArrayList<OnCompleteListener>();
    @GuardedBy(value={"mLock"})
    private OnCloseListener mOnCloseListener;
    @GuardedBy(value={"mLock"})
    private boolean mIsClosed;
    @GuardedBy(value={"mLock"})
    private boolean mIsComplete;

    ProgramList() {
    }

    public void registerListCallback(final @NonNull Executor executor, final @NonNull ListCallback callback) {
        this.registerListCallback(new ListCallback(this){

            @Override
            public void onItemChanged(@NonNull ProgramSelector.Identifier id2) {
                executor.execute(() -> callback.onItemChanged(id2));
            }

            @Override
            public void onItemRemoved(@NonNull ProgramSelector.Identifier id2) {
                executor.execute(() -> callback.onItemRemoved(id2));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListCallback(@NonNull ListCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mListCallbacks.add(Objects.requireNonNull(callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListCallback(@NonNull ListCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mListCallbacks.remove(Objects.requireNonNull(callback));
        }
    }

    public void addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener listener) {
        this.addOnCompleteListener(() -> executor.execute(listener::onComplete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCompleteListener(@NonNull OnCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mOnCompleteListeners.add(Objects.requireNonNull(listener));
            if (this.mIsComplete) {
                listener.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnCompleteListener(@NonNull OnCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mOnCompleteListeners.remove(Objects.requireNonNull(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOnCloseListener(@Nullable OnCloseListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOnCloseListener != null) {
                throw new IllegalStateException("Close callback is already set");
            }
            this.mOnCloseListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        OnCloseListener onCompleteListenersCopied = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
            this.mPrograms.clear();
            this.mListCallbacks.clear();
            this.mOnCompleteListeners.clear();
            if (this.mOnCloseListener != null) {
                onCompleteListenersCopied = this.mOnCloseListener;
                this.mOnCloseListener = null;
            }
        }
        if (onCompleteListenersCopied != null) {
            onCompleteListenersCopied.onClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(Chunk chunk) {
        ArrayList<ListCallback> listCallbacksCopied;
        ArrayList<ProgramSelector.Identifier> removedList = new ArrayList<ProgramSelector.Identifier>();
        ArraySet<ProgramSelector.Identifier> changedSet = new ArraySet<ProgramSelector.Identifier>();
        ArrayList<Object> onCompleteListenersCopied = new ArrayList();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsComplete = false;
            listCallbacksCopied = new ArrayList<ListCallback>(this.mListCallbacks);
            if (chunk.isPurge()) {
                Iterator<Map.Entry<ProgramSelector.Identifier, ArrayMap<UniqueProgramIdentifier, RadioManager.ProgramInfo>>> programsIterator = this.mPrograms.entrySet().iterator();
                while (programsIterator.hasNext()) {
                    Map.Entry<ProgramSelector.Identifier, ArrayMap<UniqueProgramIdentifier, RadioManager.ProgramInfo>> removed = programsIterator.next();
                    if (removed.getValue() != null) {
                        removedList.add(removed.getKey());
                    }
                    programsIterator.remove();
                }
            }
            Iterator<UniqueProgramIdentifier> removedIterator = chunk.getRemoved().iterator();
            while (removedIterator.hasNext()) {
                this.removeLocked(removedIterator.next(), removedList);
            }
            Iterator<RadioManager.ProgramInfo> modifiedIterator = chunk.getModified().iterator();
            while (modifiedIterator.hasNext()) {
                this.putLocked(modifiedIterator.next(), changedSet);
            }
            if (chunk.isComplete()) {
                this.mIsComplete = true;
                onCompleteListenersCopied = new ArrayList<OnCompleteListener>(this.mOnCompleteListeners);
            }
        }
        for (int i = 0; i < removedList.size(); ++i) {
            for (int cbIndex = 0; cbIndex < listCallbacksCopied.size(); ++cbIndex) {
                ((ListCallback)listCallbacksCopied.get(cbIndex)).onItemRemoved((ProgramSelector.Identifier)removedList.get(i));
            }
        }
        for (ProgramSelector.Identifier changedId : changedSet) {
            for (int cbIndex = 0; cbIndex < listCallbacksCopied.size(); ++cbIndex) {
                ((ListCallback)listCallbacksCopied.get(cbIndex)).onItemChanged(changedId);
            }
        }
        if (chunk.isComplete()) {
            for (int cbIndex = 0; cbIndex < onCompleteListenersCopied.size(); ++cbIndex) {
                ((OnCompleteListener)onCompleteListenersCopied.get(cbIndex)).onComplete();
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void putLocked(RadioManager.ProgramInfo value, Set<ProgramSelector.Identifier> changedIdentifierSet) {
        UniqueProgramIdentifier key = new UniqueProgramIdentifier(value.getSelector());
        ProgramSelector.Identifier primaryKey = Objects.requireNonNull(key.getPrimaryId());
        if (!this.mPrograms.containsKey(primaryKey)) {
            this.mPrograms.put(primaryKey, new ArrayMap());
        }
        this.mPrograms.get(primaryKey).put(key, value);
        changedIdentifierSet.add(primaryKey);
    }

    @GuardedBy(value={"mLock"})
    private void removeLocked(UniqueProgramIdentifier key, List<ProgramSelector.Identifier> removedIdentifierList) {
        ProgramSelector.Identifier primaryKey = Objects.requireNonNull(key.getPrimaryId());
        if (!this.mPrograms.containsKey(primaryKey)) {
            return;
        }
        Map entries = this.mPrograms.get(primaryKey);
        RadioManager.ProgramInfo removed = (RadioManager.ProgramInfo)entries.remove(Objects.requireNonNull(key));
        if (removed == null) {
            return;
        }
        if (entries.size() == 0) {
            removedIdentifierList.add(primaryKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<RadioManager.ProgramInfo> toList() {
        ArrayList<RadioManager.ProgramInfo> list = new ArrayList<RadioManager.ProgramInfo>();
        Object object = this.mLock;
        synchronized (object) {
            for (int index = 0; index < this.mPrograms.size(); ++index) {
                ArrayMap<UniqueProgramIdentifier, RadioManager.ProgramInfo> entries = this.mPrograms.valueAt(index);
                list.addAll(entries.values());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public RadioManager.ProgramInfo get(@NonNull ProgramSelector.Identifier id2) {
        Map entries;
        Object object = this.mLock;
        synchronized (object) {
            entries = this.mPrograms.get(Objects.requireNonNull(id2, "Primary identifier can not be null"));
        }
        if (entries == null) {
            return null;
        }
        return (RadioManager.ProgramInfo)entries.entrySet().iterator().next().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<RadioManager.ProgramInfo> getProgramInfos(@NonNull ProgramSelector.Identifier id2) {
        ArrayMap<UniqueProgramIdentifier, RadioManager.ProgramInfo> entries;
        Objects.requireNonNull(id2, "Primary identifier can not be null");
        Object object = this.mLock;
        synchronized (object) {
            entries = this.mPrograms.get(id2);
        }
        if (entries == null) {
            return new ArrayList<RadioManager.ProgramInfo>();
        }
        return new ArrayList<RadioManager.ProgramInfo>(entries.values());
    }

    public static abstract class ListCallback {
        public void onItemChanged(@NonNull ProgramSelector.Identifier id2) {
        }

        public void onItemRemoved(@NonNull ProgramSelector.Identifier id2) {
        }
    }

    public static interface OnCompleteListener {
        public void onComplete();
    }

    static interface OnCloseListener {
        public void onClose();
    }

    public static class Chunk
    implements Parcelable {
        private final boolean mPurge;
        private final boolean mComplete;
        @NonNull
        private final Set<RadioManager.ProgramInfo> mModified;
        @NonNull
        private final Set<UniqueProgramIdentifier> mRemoved;
        @NonNull
        public static final Parcelable.Creator<Chunk> CREATOR = new Parcelable.Creator<Chunk>(){

            @Override
            public Chunk createFromParcel(Parcel in) {
                return new Chunk(in);
            }

            public Chunk[] newArray(int size) {
                return new Chunk[size];
            }
        };

        public Chunk(boolean purge, boolean complete, @Nullable Set<RadioManager.ProgramInfo> modified, @Nullable Set<UniqueProgramIdentifier> removed) {
            this.mPurge = purge;
            this.mComplete = complete;
            this.mModified = modified != null ? modified : Collections.emptySet();
            this.mRemoved = removed != null ? removed : Collections.emptySet();
        }

        private Chunk(@NonNull Parcel in) {
            this.mPurge = in.readByte() != 0;
            this.mComplete = in.readByte() != 0;
            this.mModified = Utils.createSet(in, RadioManager.ProgramInfo.CREATOR);
            this.mRemoved = Utils.createSet(in, UniqueProgramIdentifier.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByte((byte)(this.mPurge ? 1 : 0));
            dest.writeByte((byte)(this.mComplete ? 1 : 0));
            Utils.writeSet(dest, this.mModified);
            Utils.writeSet(dest, this.mRemoved);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean isPurge() {
            return this.mPurge;
        }

        public boolean isComplete() {
            return this.mComplete;
        }

        @NonNull
        public Set<RadioManager.ProgramInfo> getModified() {
            return this.mModified;
        }

        @NonNull
        public Set<UniqueProgramIdentifier> getRemoved() {
            return this.mRemoved;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Chunk)) {
                return false;
            }
            Chunk other = (Chunk)obj;
            if (this.mPurge != other.mPurge) {
                return false;
            }
            if (this.mComplete != other.mComplete) {
                return false;
            }
            if (!Objects.equals(this.mModified, other.mModified)) {
                return false;
            }
            return Objects.equals(this.mRemoved, other.mRemoved);
        }

        public String toString() {
            return "Chunk [mPurge=" + this.mPurge + ", mComplete=" + this.mComplete + ", mModified=" + this.mModified + ", mRemoved=" + this.mRemoved + "]";
        }
    }

    public static class Filter
    implements Parcelable {
        @NonNull
        private final Set<Integer> mIdentifierTypes;
        @NonNull
        private final Set<ProgramSelector.Identifier> mIdentifiers;
        private final boolean mIncludeCategories;
        private final boolean mExcludeModifications;
        @Nullable
        private final Map<String, String> mVendorFilter;
        @NonNull
        public static final Parcelable.Creator<Filter> CREATOR = new Parcelable.Creator<Filter>(){

            @Override
            public Filter createFromParcel(Parcel in) {
                return new Filter(in);
            }

            public Filter[] newArray(int size) {
                return new Filter[size];
            }
        };

        public Filter(@NonNull Set<Integer> identifierTypes, @NonNull Set<ProgramSelector.Identifier> identifiers, boolean includeCategories, boolean excludeModifications) {
            this.mIdentifierTypes = Objects.requireNonNull(identifierTypes);
            this.mIdentifiers = Objects.requireNonNull(identifiers);
            this.mIncludeCategories = includeCategories;
            this.mExcludeModifications = excludeModifications;
            this.mVendorFilter = null;
        }

        public Filter() {
            this.mIdentifierTypes = Collections.emptySet();
            this.mIdentifiers = Collections.emptySet();
            this.mIncludeCategories = false;
            this.mExcludeModifications = false;
            this.mVendorFilter = null;
        }

        public Filter(@Nullable Map<String, String> vendorFilter) {
            this.mIdentifierTypes = Collections.emptySet();
            this.mIdentifiers = Collections.emptySet();
            this.mIncludeCategories = false;
            this.mExcludeModifications = false;
            this.mVendorFilter = vendorFilter;
        }

        private Filter(@NonNull Parcel in) {
            this.mIdentifierTypes = Utils.createIntSet(in);
            this.mIdentifiers = Utils.createSet(in, ProgramSelector.Identifier.CREATOR);
            this.mIncludeCategories = in.readByte() != 0;
            this.mExcludeModifications = in.readByte() != 0;
            this.mVendorFilter = Utils.readStringMap(in);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            Utils.writeIntSet(dest, this.mIdentifierTypes);
            Utils.writeSet(dest, this.mIdentifiers);
            dest.writeByte((byte)(this.mIncludeCategories ? 1 : 0));
            dest.writeByte((byte)(this.mExcludeModifications ? 1 : 0));
            Utils.writeStringMap(dest, this.mVendorFilter);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Map<String, String> getVendorFilter() {
            return this.mVendorFilter;
        }

        @NonNull
        public Set<Integer> getIdentifierTypes() {
            return this.mIdentifierTypes;
        }

        @NonNull
        public Set<ProgramSelector.Identifier> getIdentifiers() {
            return this.mIdentifiers;
        }

        public boolean areCategoriesIncluded() {
            return this.mIncludeCategories;
        }

        public boolean areModificationsExcluded() {
            return this.mExcludeModifications;
        }

        public int hashCode() {
            return Objects.hash(this.mIdentifierTypes, this.mIdentifiers, this.mIncludeCategories, this.mExcludeModifications);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)obj;
            if (this.mIncludeCategories != other.mIncludeCategories) {
                return false;
            }
            if (this.mExcludeModifications != other.mExcludeModifications) {
                return false;
            }
            if (!Objects.equals(this.mIdentifierTypes, other.mIdentifierTypes)) {
                return false;
            }
            return Objects.equals(this.mIdentifiers, other.mIdentifiers);
        }

        @NonNull
        public String toString() {
            return "Filter [mIdentifierTypes=" + this.mIdentifierTypes + ", mIdentifiers=" + this.mIdentifiers + ", mIncludeCategories=" + this.mIncludeCategories + ", mExcludeModifications=" + this.mExcludeModifications + "]";
        }
    }
}

