/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.NonNull;
import android.hardware.location.ContextHubTransaction;
import android.hardware.location.IContextHubTransactionCallback;
import android.hardware.location.NanoAppState;
import android.util.Log;
import java.util.List;
import java.util.Objects;

public class ContextHubTransactionHelper {
    private static final String TAG = "ContextHubTransactionHelper";

    public static IContextHubTransactionCallback createNanoAppQueryCallback(final @NonNull ContextHubTransaction<List<NanoAppState>> transaction) {
        Objects.requireNonNull(transaction, "transaction cannot be null");
        return new IContextHubTransactionCallback.Stub(){

            @Override
            public void onQueryResponse(int result, List<NanoAppState> nanoappList) {
                transaction.setResponse(new ContextHubTransaction.Response<List<NanoAppState>>(result, nanoappList));
            }

            @Override
            public void onTransactionComplete(int result) {
                Log.e(ContextHubTransactionHelper.TAG, "Received a non-query callback on a query request");
                transaction.setResponse(new ContextHubTransaction.Response<Object>(7, null));
            }
        };
    }

    public static IContextHubTransactionCallback createTransactionCallback(final @NonNull ContextHubTransaction<Void> transaction) {
        Objects.requireNonNull(transaction, "transaction cannot be null");
        return new IContextHubTransactionCallback.Stub(){

            @Override
            public void onQueryResponse(int result, List<NanoAppState> nanoappList) {
                Log.e(ContextHubTransactionHelper.TAG, "Received a query callback on a non-query request");
                transaction.setResponse(new ContextHubTransaction.Response<Object>(7, null));
            }

            @Override
            public void onTransactionComplete(int result) {
                transaction.setResponse(new ContextHubTransaction.Response<Object>(result, null));
            }
        };
    }
}

