/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.hardware.input.IVirtualInputDevice;
import android.hardware.input.VirtualInputDevice;
import android.hardware.input.VirtualStylusButtonEvent;
import android.hardware.input.VirtualStylusConfig;
import android.hardware.input.VirtualStylusMotionEvent;
import android.os.RemoteException;
import android.util.Log;

@SystemApi
public class VirtualStylus
extends VirtualInputDevice {
    public VirtualStylus(VirtualStylusConfig config, IVirtualInputDevice virtualInputDevice) {
        super(config, virtualInputDevice);
    }

    public void sendMotionEvent(@NonNull VirtualStylusMotionEvent event) {
        try {
            if (!this.mVirtualInputDevice.sendStylusMotionEvent(event)) {
                Log.w("VirtualInputDevice", "Failed to send motion event from virtual stylus " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendButtonEvent(@NonNull VirtualStylusButtonEvent event) {
        try {
            if (!this.mVirtualInputDevice.sendStylusButtonEvent(event)) {
                Log.w("VirtualInputDevice", "Failed to send button event from virtual stylus " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

