/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.hardware.input.IVirtualInputDevice;
import android.hardware.input.VirtualInputDeviceConfig;
import android.os.RemoteException;
import android.util.Log;
import java.io.Closeable;

abstract class VirtualInputDevice
implements Closeable {
    protected static final String TAG = "VirtualInputDevice";
    protected final IVirtualInputDevice mVirtualInputDevice;
    protected final VirtualInputDeviceConfig mConfig;

    VirtualInputDevice(VirtualInputDeviceConfig config, IVirtualInputDevice virtualDevice) {
        this.mConfig = config;
        this.mVirtualInputDevice = virtualDevice;
    }

    public int getInputDeviceId() {
        try {
            return this.mVirtualInputDevice.getInputDeviceId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void close() {
        Log.d(TAG, "Closing virtual input device " + this.mConfig.getInputDeviceName());
        try {
            this.mVirtualInputDevice.close();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String toString() {
        return this.mConfig.toString();
    }
}

