/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.input.KeyboardLayout;
import android.text.TextUtils;
import android.util.SparseIntArray;
import android.view.KeyCharacterMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

class PhysicalKeyLayout {
    private static final String TAG = "KeyboardLayoutPreview";
    private static final int SCANCODE_1 = 2;
    private static final int SCANCODE_2 = 3;
    private static final int SCANCODE_3 = 4;
    private static final int SCANCODE_4 = 5;
    private static final int SCANCODE_5 = 6;
    private static final int SCANCODE_6 = 7;
    private static final int SCANCODE_7 = 8;
    private static final int SCANCODE_8 = 9;
    private static final int SCANCODE_9 = 10;
    private static final int SCANCODE_0 = 11;
    private static final int SCANCODE_MINUS = 12;
    private static final int SCANCODE_EQUALS = 13;
    private static final int SCANCODE_Q = 16;
    private static final int SCANCODE_W = 17;
    private static final int SCANCODE_E = 18;
    private static final int SCANCODE_R = 19;
    private static final int SCANCODE_T = 20;
    private static final int SCANCODE_Y = 21;
    private static final int SCANCODE_U = 22;
    private static final int SCANCODE_I = 23;
    private static final int SCANCODE_O = 24;
    private static final int SCANCODE_P = 25;
    private static final int SCANCODE_LEFT_BRACKET = 26;
    private static final int SCANCODE_RIGHT_BRACKET = 27;
    private static final int SCANCODE_A = 30;
    private static final int SCANCODE_S = 31;
    private static final int SCANCODE_D = 32;
    private static final int SCANCODE_F = 33;
    private static final int SCANCODE_G = 34;
    private static final int SCANCODE_H = 35;
    private static final int SCANCODE_J = 36;
    private static final int SCANCODE_K = 37;
    private static final int SCANCODE_L = 38;
    private static final int SCANCODE_SEMICOLON = 39;
    private static final int SCANCODE_APOSTROPHE = 40;
    private static final int SCANCODE_GRAVE = 41;
    private static final int SCANCODE_BACKSLASH1 = 43;
    private static final int SCANCODE_Z = 44;
    private static final int SCANCODE_X = 45;
    private static final int SCANCODE_C = 46;
    private static final int SCANCODE_V = 47;
    private static final int SCANCODE_B = 48;
    private static final int SCANCODE_N = 49;
    private static final int SCANCODE_M = 50;
    private static final int SCANCODE_COMMA = 51;
    private static final int SCANCODE_PERIOD = 52;
    private static final int SCANCODE_SLASH = 53;
    private static final int SCANCODE_BACKSLASH2 = 86;
    private static final int SCANCODE_YEN = 124;
    private static final SparseIntArray DEFAULT_KEYCODE_FOR_SCANCODE = new SparseIntArray();
    private LayoutKey[][] mKeys = null;
    private EnterKey mEnterKey = null;

    public PhysicalKeyLayout(@NonNull KeyCharacterMap kcm, @Nullable KeyboardLayout layout2) {
        this.initLayoutKeys(kcm, layout2);
    }

    private void initLayoutKeys(KeyCharacterMap kcm, KeyboardLayout layout2) {
        if (layout2 == null) {
            this.createIsoLayout(kcm);
            return;
        }
        if (layout2.isAnsiLayout()) {
            this.createAnsiLayout(kcm);
        } else if (layout2.isJisLayout()) {
            this.createJisLayout(kcm);
        } else {
            this.createIsoLayout(kcm);
        }
    }

    public LayoutKey[][] getKeys() {
        return this.mKeys;
    }

    @Nullable
    public EnterKey getEnterKey() {
        return this.mEnterKey;
    }

    private void createAnsiLayout(KeyCharacterMap kcm) {
        this.mKeys = new LayoutKey[][]{{PhysicalKeyLayout.getKey(kcm, 41), PhysicalKeyLayout.getKey(kcm, 2), PhysicalKeyLayout.getKey(kcm, 3), PhysicalKeyLayout.getKey(kcm, 4), PhysicalKeyLayout.getKey(kcm, 5), PhysicalKeyLayout.getKey(kcm, 6), PhysicalKeyLayout.getKey(kcm, 7), PhysicalKeyLayout.getKey(kcm, 8), PhysicalKeyLayout.getKey(kcm, 9), PhysicalKeyLayout.getKey(kcm, 10), PhysicalKeyLayout.getKey(kcm, 11), PhysicalKeyLayout.getKey(kcm, 12), PhysicalKeyLayout.getKey(kcm, 13), PhysicalKeyLayout.getKey(67, 1.5f)}, {PhysicalKeyLayout.getKey(61, 1.5f), PhysicalKeyLayout.getKey(kcm, 16), PhysicalKeyLayout.getKey(kcm, 17), PhysicalKeyLayout.getKey(kcm, 18), PhysicalKeyLayout.getKey(kcm, 19), PhysicalKeyLayout.getKey(kcm, 20), PhysicalKeyLayout.getKey(kcm, 21), PhysicalKeyLayout.getKey(kcm, 22), PhysicalKeyLayout.getKey(kcm, 23), PhysicalKeyLayout.getKey(kcm, 24), PhysicalKeyLayout.getKey(kcm, 25), PhysicalKeyLayout.getKey(kcm, 26), PhysicalKeyLayout.getKey(kcm, 27), PhysicalKeyLayout.getKey(kcm, 43)}, {PhysicalKeyLayout.getKey(115, 1.75f), PhysicalKeyLayout.getKey(kcm, 30), PhysicalKeyLayout.getKey(kcm, 31), PhysicalKeyLayout.getKey(kcm, 32), PhysicalKeyLayout.getKey(kcm, 33), PhysicalKeyLayout.getKey(kcm, 34), PhysicalKeyLayout.getKey(kcm, 35), PhysicalKeyLayout.getKey(kcm, 36), PhysicalKeyLayout.getKey(kcm, 37), PhysicalKeyLayout.getKey(kcm, 38), PhysicalKeyLayout.getKey(kcm, 39), PhysicalKeyLayout.getKey(kcm, 40), PhysicalKeyLayout.getKey(66, 1.75f)}, {PhysicalKeyLayout.getKey(59, 2.5f), PhysicalKeyLayout.getKey(kcm, 44), PhysicalKeyLayout.getKey(kcm, 45), PhysicalKeyLayout.getKey(kcm, 46), PhysicalKeyLayout.getKey(kcm, 47), PhysicalKeyLayout.getKey(kcm, 48), PhysicalKeyLayout.getKey(kcm, 49), PhysicalKeyLayout.getKey(kcm, 50), PhysicalKeyLayout.getKey(kcm, 51), PhysicalKeyLayout.getKey(kcm, 52), PhysicalKeyLayout.getKey(kcm, 53), PhysicalKeyLayout.getKey(60, 2.5f)}, {PhysicalKeyLayout.getKey(113, 1.0f), PhysicalKeyLayout.getKey(119, 1.0f), PhysicalKeyLayout.getKey(117, 1.0f), PhysicalKeyLayout.getKey(57, 1.0f), PhysicalKeyLayout.getKey(62, 6.5f), PhysicalKeyLayout.getKey(58, 1.0f), PhysicalKeyLayout.getKey(118, 1.0f), PhysicalKeyLayout.getKey(82, 1.0f), PhysicalKeyLayout.getKey(114, 1.0f)}};
    }

    private void createIsoLayout(KeyCharacterMap kcm) {
        this.mKeys = new LayoutKey[][]{{PhysicalKeyLayout.getKey(kcm, 41), PhysicalKeyLayout.getKey(kcm, 2), PhysicalKeyLayout.getKey(kcm, 3), PhysicalKeyLayout.getKey(kcm, 4), PhysicalKeyLayout.getKey(kcm, 5), PhysicalKeyLayout.getKey(kcm, 6), PhysicalKeyLayout.getKey(kcm, 7), PhysicalKeyLayout.getKey(kcm, 8), PhysicalKeyLayout.getKey(kcm, 9), PhysicalKeyLayout.getKey(kcm, 10), PhysicalKeyLayout.getKey(kcm, 11), PhysicalKeyLayout.getKey(kcm, 12), PhysicalKeyLayout.getKey(kcm, 13), PhysicalKeyLayout.getKey(67, 1.5f)}, {PhysicalKeyLayout.getKey(61, 1.15f), PhysicalKeyLayout.getKey(kcm, 16), PhysicalKeyLayout.getKey(kcm, 17), PhysicalKeyLayout.getKey(kcm, 18), PhysicalKeyLayout.getKey(kcm, 19), PhysicalKeyLayout.getKey(kcm, 20), PhysicalKeyLayout.getKey(kcm, 21), PhysicalKeyLayout.getKey(kcm, 22), PhysicalKeyLayout.getKey(kcm, 23), PhysicalKeyLayout.getKey(kcm, 24), PhysicalKeyLayout.getKey(kcm, 25), PhysicalKeyLayout.getKey(kcm, 26), PhysicalKeyLayout.getKey(kcm, 27), PhysicalKeyLayout.getKey(66, 1.35f)}, {PhysicalKeyLayout.getKey(61, 1.5f), PhysicalKeyLayout.getKey(kcm, 30), PhysicalKeyLayout.getKey(kcm, 31), PhysicalKeyLayout.getKey(kcm, 32), PhysicalKeyLayout.getKey(kcm, 33), PhysicalKeyLayout.getKey(kcm, 34), PhysicalKeyLayout.getKey(kcm, 35), PhysicalKeyLayout.getKey(kcm, 36), PhysicalKeyLayout.getKey(kcm, 37), PhysicalKeyLayout.getKey(kcm, 38), PhysicalKeyLayout.getKey(kcm, 39), PhysicalKeyLayout.getKey(kcm, 40), PhysicalKeyLayout.getKey(kcm, 43), PhysicalKeyLayout.getKey(66, 1.0f)}, {PhysicalKeyLayout.getKey(59, 1.15f), PhysicalKeyLayout.getKey(kcm, 86), PhysicalKeyLayout.getKey(kcm, 44), PhysicalKeyLayout.getKey(kcm, 45), PhysicalKeyLayout.getKey(kcm, 46), PhysicalKeyLayout.getKey(kcm, 47), PhysicalKeyLayout.getKey(kcm, 48), PhysicalKeyLayout.getKey(kcm, 49), PhysicalKeyLayout.getKey(kcm, 50), PhysicalKeyLayout.getKey(kcm, 51), PhysicalKeyLayout.getKey(kcm, 52), PhysicalKeyLayout.getKey(kcm, 53), PhysicalKeyLayout.getKey(60, 2.35f)}, {PhysicalKeyLayout.getKey(113, 1.0f), PhysicalKeyLayout.getKey(119, 1.0f), PhysicalKeyLayout.getKey(117, 1.0f), PhysicalKeyLayout.getKey(57, 1.0f), PhysicalKeyLayout.getKey(62, 6.5f), PhysicalKeyLayout.getKey(58, 1.0f), PhysicalKeyLayout.getKey(118, 1.0f), PhysicalKeyLayout.getKey(82, 1.0f), PhysicalKeyLayout.getKey(114, 1.0f)}};
        this.mEnterKey = new EnterKey(1, 13, 1.35f, 1.0f);
    }

    private void createJisLayout(KeyCharacterMap kcm) {
        this.mKeys = new LayoutKey[][]{{PhysicalKeyLayout.getKey(kcm, 41), PhysicalKeyLayout.getKey(kcm, 2), PhysicalKeyLayout.getKey(kcm, 3), PhysicalKeyLayout.getKey(kcm, 4), PhysicalKeyLayout.getKey(kcm, 5), PhysicalKeyLayout.getKey(kcm, 6), PhysicalKeyLayout.getKey(kcm, 7), PhysicalKeyLayout.getKey(kcm, 8), PhysicalKeyLayout.getKey(kcm, 9), PhysicalKeyLayout.getKey(kcm, 10), PhysicalKeyLayout.getKey(kcm, 11), PhysicalKeyLayout.getKey(kcm, 12, 0.8f), PhysicalKeyLayout.getKey(kcm, 13, 0.8f), PhysicalKeyLayout.getKey(kcm, 124, 0.8f), PhysicalKeyLayout.getKey(67, 1.1f)}, {PhysicalKeyLayout.getKey(61, 1.15f), PhysicalKeyLayout.getKey(kcm, 16), PhysicalKeyLayout.getKey(kcm, 17), PhysicalKeyLayout.getKey(kcm, 18), PhysicalKeyLayout.getKey(kcm, 19), PhysicalKeyLayout.getKey(kcm, 20), PhysicalKeyLayout.getKey(kcm, 21), PhysicalKeyLayout.getKey(kcm, 22), PhysicalKeyLayout.getKey(kcm, 23), PhysicalKeyLayout.getKey(kcm, 24), PhysicalKeyLayout.getKey(kcm, 25), PhysicalKeyLayout.getKey(kcm, 26), PhysicalKeyLayout.getKey(kcm, 27), PhysicalKeyLayout.getKey(66, 1.35f)}, {PhysicalKeyLayout.getKey(61, 1.5f), PhysicalKeyLayout.getKey(kcm, 30), PhysicalKeyLayout.getKey(kcm, 31), PhysicalKeyLayout.getKey(kcm, 32), PhysicalKeyLayout.getKey(kcm, 33), PhysicalKeyLayout.getKey(kcm, 34), PhysicalKeyLayout.getKey(kcm, 35), PhysicalKeyLayout.getKey(kcm, 36), PhysicalKeyLayout.getKey(kcm, 37), PhysicalKeyLayout.getKey(kcm, 38), PhysicalKeyLayout.getKey(kcm, 39), PhysicalKeyLayout.getKey(kcm, 40), PhysicalKeyLayout.getKey(kcm, 86), PhysicalKeyLayout.getKey(66, 1.0f)}, {PhysicalKeyLayout.getKey(59, 1.15f), PhysicalKeyLayout.getKey(kcm, 44), PhysicalKeyLayout.getKey(kcm, 45), PhysicalKeyLayout.getKey(kcm, 46), PhysicalKeyLayout.getKey(kcm, 47), PhysicalKeyLayout.getKey(kcm, 48), PhysicalKeyLayout.getKey(kcm, 49), PhysicalKeyLayout.getKey(kcm, 50), PhysicalKeyLayout.getKey(kcm, 51), PhysicalKeyLayout.getKey(kcm, 52), PhysicalKeyLayout.getKey(kcm, 53), PhysicalKeyLayout.getKey(kcm, 43), PhysicalKeyLayout.getKey(60, 2.35f)}, {PhysicalKeyLayout.getKey(113, 1.0f), PhysicalKeyLayout.getKey(119, 1.0f), PhysicalKeyLayout.getKey(117, 1.0f), PhysicalKeyLayout.getKey(57, 1.0f), PhysicalKeyLayout.getKey(0, 1.0f), PhysicalKeyLayout.getKey(62, 3.5f), PhysicalKeyLayout.getKey(0, 1.0f), PhysicalKeyLayout.getKey(0, 1.0f), PhysicalKeyLayout.getKey(58, 1.0f), PhysicalKeyLayout.getKey(118, 1.0f), PhysicalKeyLayout.getKey(82, 1.0f), PhysicalKeyLayout.getKey(114, 1.0f)}};
        this.mEnterKey = new EnterKey(1, 13, 1.35f, 1.0f);
    }

    private static LayoutKey getKey(KeyCharacterMap kcm, int scanCode, float keyWeight) {
        int keyCode = kcm.getMappedKeyOrDefault(scanCode, DEFAULT_KEYCODE_FOR_SCANCODE.get(scanCode, 0));
        return new LayoutKey(keyCode, scanCode, keyWeight, new KeyGlyph(kcm, keyCode));
    }

    private static LayoutKey getKey(KeyCharacterMap kcm, int scanCode) {
        return PhysicalKeyLayout.getKey(kcm, scanCode, 1.0f);
    }

    private static String getKeyText(KeyCharacterMap kcm, int keyCode, int modifierState) {
        if (PhysicalKeyLayout.isSpecialKey(keyCode)) {
            return "";
        }
        int utf8Char = kcm.get(keyCode, modifierState) & Integer.MAX_VALUE;
        if (utf8Char == 0) {
            return "";
        }
        if (Character.isValidCodePoint(utf8Char)) {
            return String.valueOf(Character.toChars(utf8Char));
        }
        return "\u25a1";
    }

    private static LayoutKey getKey(int keyCode, float keyWeight) {
        return new LayoutKey(keyCode, keyCode, keyWeight, null);
    }

    private static boolean isSpecialKey(int keyCode) {
        switch (keyCode) {
            case 0: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 82: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpecialKey(LayoutKey key) {
        return PhysicalKeyLayout.isSpecialKey(key.keyCode);
    }

    public static boolean isKeyPositionUnsure(LayoutKey key) {
        switch (key.scanCode) {
            case 41: 
            case 43: 
            case 86: {
                return true;
            }
        }
        return false;
    }

    static {
        DEFAULT_KEYCODE_FOR_SCANCODE.put(2, 8);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(3, 9);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(4, 10);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(5, 11);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(6, 12);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(7, 13);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(8, 14);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(9, 15);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(10, 16);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(11, 7);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(12, 69);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(13, 70);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(16, 45);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(17, 51);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(18, 33);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(19, 46);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(20, 48);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(21, 53);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(22, 49);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(23, 37);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(24, 43);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(25, 44);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(26, 71);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(27, 72);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(30, 29);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(31, 47);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(32, 32);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(33, 34);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(34, 35);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(35, 36);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(36, 38);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(37, 39);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(38, 40);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(39, 74);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(40, 75);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(41, 68);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(43, 73);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(44, 54);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(45, 52);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(46, 31);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(47, 50);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(48, 30);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(49, 42);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(50, 41);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(51, 55);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(52, 56);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(53, 76);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(86, 73);
        DEFAULT_KEYCODE_FOR_SCANCODE.put(124, 216);
    }

    public static class LayoutKey
    extends Record {
        private final int keyCode;
        private final int scanCode;
        private final float keyWeight;
        private final KeyGlyph glyph;

        public LayoutKey(int keyCode, int scanCode, float keyWeight, KeyGlyph glyph) {
            this.keyCode = keyCode;
            this.scanCode = scanCode;
            this.keyWeight = keyWeight;
            this.glyph = glyph;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LayoutKey.class, "keyCode;scanCode;keyWeight;glyph", "keyCode", "scanCode", "keyWeight", "glyph"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LayoutKey.class, "keyCode;scanCode;keyWeight;glyph", "keyCode", "scanCode", "keyWeight", "glyph"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LayoutKey.class, "keyCode;scanCode;keyWeight;glyph", "keyCode", "scanCode", "keyWeight", "glyph"}, this, o);
        }

        public int keyCode() {
            return this.keyCode;
        }

        public int scanCode() {
            return this.scanCode;
        }

        public float keyWeight() {
            return this.keyWeight;
        }

        public KeyGlyph glyph() {
            return this.glyph;
        }
    }

    public static class EnterKey
    extends Record {
        private final int row;
        private final int column;
        private final float topKeyWeight;
        private final float bottomKeyWeight;

        public EnterKey(int row, int column, float topKeyWeight, float bottomKeyWeight) {
            this.row = row;
            this.column = column;
            this.topKeyWeight = topKeyWeight;
            this.bottomKeyWeight = bottomKeyWeight;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnterKey.class, "row;column;topKeyWeight;bottomKeyWeight", "row", "column", "topKeyWeight", "bottomKeyWeight"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnterKey.class, "row;column;topKeyWeight;bottomKeyWeight", "row", "column", "topKeyWeight", "bottomKeyWeight"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnterKey.class, "row;column;topKeyWeight;bottomKeyWeight", "row", "column", "topKeyWeight", "bottomKeyWeight"}, this, o);
        }

        public int row() {
            return this.row;
        }

        public int column() {
            return this.column;
        }

        public float topKeyWeight() {
            return this.topKeyWeight;
        }

        public float bottomKeyWeight() {
            return this.bottomKeyWeight;
        }
    }

    public static class KeyGlyph {
        private final String mBaseText;
        private final String mShiftText;
        private final String mAltGrText;
        private final String mAltGrShiftText;

        public KeyGlyph(KeyCharacterMap kcm, int keyCode) {
            this.mBaseText = PhysicalKeyLayout.getKeyText(kcm, keyCode, 0x100000);
            this.mShiftText = PhysicalKeyLayout.getKeyText(kcm, keyCode, 65);
            this.mAltGrText = PhysicalKeyLayout.getKeyText(kcm, keyCode, 0x100022);
            this.mAltGrShiftText = PhysicalKeyLayout.getKeyText(kcm, keyCode, 99);
        }

        public String getBaseText() {
            return this.mBaseText;
        }

        public String getShiftText() {
            return this.mShiftText;
        }

        public String getAltGrText() {
            return this.mAltGrText;
        }

        public String getAltGrShiftText() {
            return this.mAltGrShiftText;
        }

        public boolean hasBaseText() {
            return !TextUtils.isEmpty(this.mBaseText);
        }

        public boolean hasValidShiftText() {
            return !TextUtils.isEmpty(this.mShiftText) && !TextUtils.equals(this.mBaseText, this.mShiftText);
        }

        public boolean hasValidAltGrText() {
            return !TextUtils.isEmpty(this.mAltGrText) && !TextUtils.equals(this.mBaseText, this.mAltGrText) && !TextUtils.equals(this.mShiftText, this.mAltGrText);
        }

        public boolean hasValidAltGrShiftText() {
            return !TextUtils.isEmpty(this.mAltGrShiftText) && !TextUtils.equals(this.mBaseText, this.mAltGrShiftText) && !TextUtils.equals(this.mAltGrText, this.mAltGrShiftText) && !TextUtils.equals(this.mShiftText, this.mAltGrShiftText);
        }
    }
}

