/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.input.AidlInputGestureData;
import android.hardware.input.AppLaunchData;
import android.view.KeyEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;

public class InputGestureData {
    public static final int TOUCHPAD_GESTURE_TYPE_UNKNOWN = 0;
    public static final int TOUCHPAD_GESTURE_TYPE_THREE_FINGER_TAP = 1;
    @NonNull
    private final AidlInputGestureData mInputGestureData;

    public InputGestureData(@NonNull AidlInputGestureData inputGestureData) {
        this.mInputGestureData = inputGestureData;
        this.validate();
    }

    public Trigger getTrigger() {
        return InputGestureData.createTriggerFromAidlTrigger(this.mInputGestureData.trigger);
    }

    public Action getAction() {
        return new Action(this.mInputGestureData.gestureType, this.getAppLaunchData());
    }

    private void validate() {
        Trigger trigger = this.getTrigger();
        Action action = this.getAction();
        if (trigger == null) {
            throw new IllegalArgumentException("No trigger found");
        }
        if (action.keyGestureType == 0) {
            throw new IllegalArgumentException("No system action found");
        }
        if (action.keyGestureType == 51 && action.appLaunchData == null) {
            throw new IllegalArgumentException("No app launch data for system action launch application");
        }
    }

    public AidlInputGestureData getAidlData() {
        return this.mInputGestureData;
    }

    @Nullable
    private AppLaunchData getAppLaunchData() {
        if (this.mInputGestureData.gestureType != 51) {
            return null;
        }
        return AppLaunchData.createLaunchData(this.mInputGestureData.appLaunchCategory, this.mInputGestureData.appLaunchRole, this.mInputGestureData.appLaunchPackageName, this.mInputGestureData.appLaunchClassName);
    }

    public String toString() {
        return "InputGestureData { trigger = " + this.getTrigger() + ", action = " + this.getAction() + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputGestureData that = (InputGestureData)o;
        return Objects.equals(this.mInputGestureData, that.mInputGestureData);
    }

    public int hashCode() {
        return this.mInputGestureData.hashCode();
    }

    public static Trigger createKeyTrigger(int keycode, int modifierState) {
        return new KeyTrigger(keycode, modifierState);
    }

    public static Trigger createTouchpadTrigger(int touchpadGestureType) {
        return new TouchpadTrigger(touchpadGestureType);
    }

    public static Trigger createTriggerFromAidlTrigger(AidlInputGestureData.Trigger aidlTrigger) {
        switch (aidlTrigger.getTag()) {
            case 0: {
                AidlInputGestureData.KeyTrigger trigger = aidlTrigger.getKey();
                if (trigger == null) {
                    throw new RuntimeException("aidlTrigger is corrupted, null key trigger!");
                }
                return new KeyTrigger(trigger);
            }
            case 1: {
                AidlInputGestureData.TouchpadGestureTrigger trigger = aidlTrigger.getTouchpadGesture();
                if (trigger == null) {
                    throw new RuntimeException("aidlTrigger is corrupted, null touchpad trigger!");
                }
                return new TouchpadTrigger(trigger);
            }
        }
        throw new RuntimeException("aidlTrigger is corrupted, invalid trigger type!");
    }

    public static interface Trigger {
        public AidlInputGestureData.Trigger getAidlTrigger();
    }

    public static class Action
    extends Record {
        private final int keyGestureType;
        @Nullable
        private final AppLaunchData appLaunchData;

        public Action(int keyGestureType, @Nullable AppLaunchData appLaunchData) {
            this.keyGestureType = keyGestureType;
            this.appLaunchData = appLaunchData;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Action.class, "keyGestureType;appLaunchData", "keyGestureType", "appLaunchData"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Action.class, "keyGestureType;appLaunchData", "keyGestureType", "appLaunchData"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Action.class, "keyGestureType;appLaunchData", "keyGestureType", "appLaunchData"}, this, o);
        }

        public int keyGestureType() {
            return this.keyGestureType;
        }

        @Nullable
        public AppLaunchData appLaunchData() {
            return this.appLaunchData;
        }
    }

    public static class KeyTrigger
    implements Trigger {
        AidlInputGestureData.KeyTrigger mAidlKeyTrigger;

        private KeyTrigger(@NonNull AidlInputGestureData.KeyTrigger aidlKeyTrigger) {
            this.mAidlKeyTrigger = aidlKeyTrigger;
        }

        private KeyTrigger(int keycode, int modifierState) {
            if (keycode <= 0 || keycode > KeyEvent.getMaxKeyCode()) {
                throw new IllegalArgumentException("Invalid keycode = " + keycode);
            }
            this.mAidlKeyTrigger = new AidlInputGestureData.KeyTrigger();
            this.mAidlKeyTrigger.keycode = keycode;
            this.mAidlKeyTrigger.modifierState = modifierState;
        }

        public int getKeycode() {
            return this.mAidlKeyTrigger.keycode;
        }

        public int getModifierState() {
            return this.mAidlKeyTrigger.modifierState;
        }

        @Override
        public AidlInputGestureData.Trigger getAidlTrigger() {
            AidlInputGestureData.Trigger trigger = new AidlInputGestureData.Trigger();
            trigger.setKey(this.mAidlKeyTrigger);
            return trigger;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyTrigger)) {
                return false;
            }
            KeyTrigger that = (KeyTrigger)o;
            return Objects.equals(this.mAidlKeyTrigger, that.mAidlKeyTrigger);
        }

        public int hashCode() {
            return this.mAidlKeyTrigger.hashCode();
        }

        public String toString() {
            return "KeyTrigger{mKeycode=" + KeyEvent.keyCodeToString(this.mAidlKeyTrigger.keycode) + ", mModifierState=" + this.mAidlKeyTrigger.modifierState + '}';
        }
    }

    public static class TouchpadTrigger
    implements Trigger {
        AidlInputGestureData.TouchpadGestureTrigger mAidlTouchpadTrigger;

        private TouchpadTrigger(@NonNull AidlInputGestureData.TouchpadGestureTrigger aidlTouchpadTrigger) {
            this.mAidlTouchpadTrigger = aidlTouchpadTrigger;
        }

        private TouchpadTrigger(int touchpadGestureType) {
            if (touchpadGestureType != 1) {
                throw new IllegalArgumentException("Invalid touchpadGestureType = " + touchpadGestureType);
            }
            this.mAidlTouchpadTrigger = new AidlInputGestureData.TouchpadGestureTrigger();
            this.mAidlTouchpadTrigger.gestureType = touchpadGestureType;
        }

        public int getTouchpadGestureType() {
            return this.mAidlTouchpadTrigger.gestureType;
        }

        @Override
        public AidlInputGestureData.Trigger getAidlTrigger() {
            AidlInputGestureData.Trigger trigger = new AidlInputGestureData.Trigger();
            trigger.setTouchpadGesture(this.mAidlTouchpadTrigger);
            return trigger;
        }

        public String toString() {
            return "TouchpadTrigger{mTouchpadGestureType=" + this.mAidlTouchpadTrigger.gestureType + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TouchpadTrigger)) {
                return false;
            }
            TouchpadTrigger that = (TouchpadTrigger)o;
            return Objects.equals(this.mAidlTouchpadTrigger, that.mAidlTouchpadTrigger);
        }

        public int hashCode() {
            return this.mAidlTouchpadTrigger.hashCode();
        }
    }

    public static enum Filter {
        KEY(0),
        TOUCHPAD(1);

        @AidlInputGestureData.Trigger.Tag
        private final int mTag;

        private Filter(int tag) {
            this.mTag = tag;
        }

        @Nullable
        public static Filter of(@AidlInputGestureData.Trigger.Tag int tag) {
            Filter filter;
            switch (tag) {
                case 0: {
                    filter = KEY;
                    break;
                }
                case 1: {
                    filter = TOUCHPAD;
                    break;
                }
                default: {
                    filter = null;
                }
            }
            return filter;
        }

        @AidlInputGestureData.Trigger.Tag
        public int getTag() {
            return this.mTag;
        }

        public boolean matches(@NonNull InputGestureData inputGestureData) {
            return this.mTag == inputGestureData.mInputGestureData.trigger.getTag();
        }
    }

    public static class Builder {
        @Nullable
        private Trigger mTrigger = null;
        private int mKeyGestureType = 0;
        @Nullable
        private AppLaunchData mAppLaunchData = null;

        public Builder setTrigger(Trigger trigger) {
            this.mTrigger = trigger;
            return this;
        }

        public Builder setKeyGestureType(int keyGestureType) {
            this.mKeyGestureType = keyGestureType;
            return this;
        }

        public Builder setAppLaunchData(@NonNull AppLaunchData appLaunchData) {
            this.mKeyGestureType = 51;
            this.mAppLaunchData = appLaunchData;
            return this;
        }

        public InputGestureData build() throws IllegalArgumentException {
            if (this.mTrigger == null) {
                throw new IllegalArgumentException("No trigger found");
            }
            if (this.mKeyGestureType == 0) {
                throw new IllegalArgumentException("No system action found");
            }
            if (this.mKeyGestureType == 51 && this.mAppLaunchData == null) {
                throw new IllegalArgumentException("No app launch data for system action launch application");
            }
            AidlInputGestureData data = new AidlInputGestureData();
            data.trigger = this.mTrigger.getAidlTrigger();
            data.gestureType = this.mKeyGestureType;
            if (this.mAppLaunchData != null) {
                AppLaunchData appLaunchData = this.mAppLaunchData;
                if (appLaunchData instanceof AppLaunchData.CategoryData) {
                    AppLaunchData.CategoryData categoryData = (AppLaunchData.CategoryData)appLaunchData;
                    data.appLaunchCategory = categoryData.getCategory();
                } else {
                    appLaunchData = this.mAppLaunchData;
                    if (appLaunchData instanceof AppLaunchData.RoleData) {
                        AppLaunchData.RoleData roleData = (AppLaunchData.RoleData)appLaunchData;
                        data.appLaunchRole = roleData.getRole();
                    } else {
                        appLaunchData = this.mAppLaunchData;
                        if (appLaunchData instanceof AppLaunchData.ComponentData) {
                            AppLaunchData.ComponentData componentData = (AppLaunchData.ComponentData)appLaunchData;
                            data.appLaunchPackageName = componentData.getPackageName();
                            data.appLaunchClassName = componentData.getClassName();
                        } else {
                            throw new IllegalArgumentException("AppLaunchData type is invalid!");
                        }
                    }
                }
            }
            return new InputGestureData(data);
        }
    }
}

