/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.graphics.PointF;
import android.hardware.input.VirtualKeyEvent;
import android.hardware.input.VirtualMouseButtonEvent;
import android.hardware.input.VirtualMouseRelativeEvent;
import android.hardware.input.VirtualMouseScrollEvent;
import android.hardware.input.VirtualRotaryEncoderScrollEvent;
import android.hardware.input.VirtualStylusButtonEvent;
import android.hardware.input.VirtualStylusMotionEvent;
import android.hardware.input.VirtualTouchEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IVirtualInputDevice
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.input.IVirtualInputDevice";

    public void close() throws RemoteException;

    public int getInputDeviceId() throws RemoteException;

    public int getAssociatedDisplayId() throws RemoteException;

    public boolean sendDpadKeyEvent(VirtualKeyEvent var1) throws RemoteException;

    public boolean sendKeyEvent(VirtualKeyEvent var1) throws RemoteException;

    public boolean sendMouseButtonEvent(VirtualMouseButtonEvent var1) throws RemoteException;

    public boolean sendMouseRelativeEvent(VirtualMouseRelativeEvent var1) throws RemoteException;

    public boolean sendMouseScrollEvent(VirtualMouseScrollEvent var1) throws RemoteException;

    public boolean sendTouchEvent(VirtualTouchEvent var1) throws RemoteException;

    public boolean sendStylusMotionEvent(VirtualStylusMotionEvent var1) throws RemoteException;

    public boolean sendStylusButtonEvent(VirtualStylusButtonEvent var1) throws RemoteException;

    public boolean sendRotaryEncoderScrollEvent(VirtualRotaryEncoderScrollEvent var1) throws RemoteException;

    public PointF getCursorPosition() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualInputDevice {
        static final int TRANSACTION_close = 1;
        static final int TRANSACTION_getInputDeviceId = 2;
        static final int TRANSACTION_getAssociatedDisplayId = 3;
        static final int TRANSACTION_sendDpadKeyEvent = 4;
        static final int TRANSACTION_sendKeyEvent = 5;
        static final int TRANSACTION_sendMouseButtonEvent = 6;
        static final int TRANSACTION_sendMouseRelativeEvent = 7;
        static final int TRANSACTION_sendMouseScrollEvent = 8;
        static final int TRANSACTION_sendTouchEvent = 9;
        static final int TRANSACTION_sendStylusMotionEvent = 10;
        static final int TRANSACTION_sendStylusButtonEvent = 11;
        static final int TRANSACTION_sendRotaryEncoderScrollEvent = 12;
        static final int TRANSACTION_getCursorPosition = 13;

        public Stub() {
            this.attachInterface(this, IVirtualInputDevice.DESCRIPTOR);
        }

        public static IVirtualInputDevice asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualInputDevice.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualInputDevice) {
                return (IVirtualInputDevice)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "close";
                }
                case 2: {
                    return "getInputDeviceId";
                }
                case 3: {
                    return "getAssociatedDisplayId";
                }
                case 4: {
                    return "sendDpadKeyEvent";
                }
                case 5: {
                    return "sendKeyEvent";
                }
                case 6: {
                    return "sendMouseButtonEvent";
                }
                case 7: {
                    return "sendMouseRelativeEvent";
                }
                case 8: {
                    return "sendMouseScrollEvent";
                }
                case 9: {
                    return "sendTouchEvent";
                }
                case 10: {
                    return "sendStylusMotionEvent";
                }
                case 11: {
                    return "sendStylusButtonEvent";
                }
                case 12: {
                    return "sendRotaryEncoderScrollEvent";
                }
                case 13: {
                    return "getCursorPosition";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualInputDevice.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _result = this.getInputDeviceId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    int _result = this.getAssociatedDisplayId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    VirtualKeyEvent _arg0 = data.readTypedObject(VirtualKeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendDpadKeyEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    VirtualKeyEvent _arg0 = data.readTypedObject(VirtualKeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendKeyEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    VirtualMouseButtonEvent _arg0 = data.readTypedObject(VirtualMouseButtonEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendMouseButtonEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    VirtualMouseRelativeEvent _arg0 = data.readTypedObject(VirtualMouseRelativeEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendMouseRelativeEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    VirtualMouseScrollEvent _arg0 = data.readTypedObject(VirtualMouseScrollEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendMouseScrollEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    VirtualTouchEvent _arg0 = data.readTypedObject(VirtualTouchEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendTouchEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    VirtualStylusMotionEvent _arg0 = data.readTypedObject(VirtualStylusMotionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendStylusMotionEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    VirtualStylusButtonEvent _arg0 = data.readTypedObject(VirtualStylusButtonEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendStylusButtonEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    VirtualRotaryEncoderScrollEvent _arg0 = data.readTypedObject(VirtualRotaryEncoderScrollEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendRotaryEncoderScrollEvent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    PointF _result = this.getCursorPosition();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 12;
        }

        private static class Proxy
        implements IVirtualInputDevice {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualInputDevice.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInputDeviceId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAssociatedDisplayId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendDpadKeyEvent(VirtualKeyEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendKeyEvent(VirtualKeyEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendMouseButtonEvent(VirtualMouseButtonEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendMouseRelativeEvent(VirtualMouseRelativeEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendMouseScrollEvent(VirtualMouseScrollEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendTouchEvent(VirtualTouchEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendStylusMotionEvent(VirtualStylusMotionEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendStylusButtonEvent(VirtualStylusButtonEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendRotaryEncoderScrollEvent(VirtualRotaryEncoderScrollEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PointF getCursorPosition() throws RemoteException {
                PointF _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualInputDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PointF.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IVirtualInputDevice {
        @Override
        public void close() throws RemoteException {
        }

        @Override
        public int getInputDeviceId() throws RemoteException {
            return 0;
        }

        @Override
        public int getAssociatedDisplayId() throws RemoteException {
            return 0;
        }

        @Override
        public boolean sendDpadKeyEvent(VirtualKeyEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendKeyEvent(VirtualKeyEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendMouseButtonEvent(VirtualMouseButtonEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendMouseRelativeEvent(VirtualMouseRelativeEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendMouseScrollEvent(VirtualMouseScrollEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendTouchEvent(VirtualTouchEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendStylusMotionEvent(VirtualStylusMotionEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendStylusButtonEvent(VirtualStylusButtonEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendRotaryEncoderScrollEvent(VirtualRotaryEncoderScrollEvent event) throws RemoteException {
            return false;
        }

        @Override
        public PointF getCursorPosition() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

