/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.graphics.ColorSpace;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SessionConfiguration
implements Parcelable {
    private static final String TAG = "SessionConfiguration";
    public static final int SESSION_REGULAR = 0;
    public static final int SESSION_HIGH_SPEED = 1;
    @SystemApi
    @FlaggedApi(value="com.android.internal.camera.flags.camera_multi_client")
    public static final int SESSION_SHARED = 2;
    public static final int SESSION_VENDOR_START = 32768;
    @NonNull
    private final List<OutputConfiguration> mOutputConfigurations;
    private CameraCaptureSession.StateCallback mStateCallback = null;
    private int mSessionType;
    private Executor mExecutor = null;
    private InputConfiguration mInputConfig = null;
    private CaptureRequest mSessionParameters = null;
    private int mColorSpace;
    @NonNull
    public static final Parcelable.Creator<SessionConfiguration> CREATOR = new Parcelable.Creator<SessionConfiguration>(){

        @Override
        public SessionConfiguration createFromParcel(Parcel source) {
            return new SessionConfiguration(source);
        }

        public SessionConfiguration[] newArray(int size) {
            return new SessionConfiguration[size];
        }
    };

    public SessionConfiguration(int sessionType, @NonNull List<OutputConfiguration> outputs, @NonNull Executor executor, @NonNull CameraCaptureSession.StateCallback cb) {
        this.mSessionType = sessionType;
        this.mOutputConfigurations = Collections.unmodifiableList(new ArrayList<OutputConfiguration>(outputs));
        this.mStateCallback = cb;
        this.mExecutor = executor;
    }

    public SessionConfiguration(int sessionType, @NonNull List<OutputConfiguration> outputs) {
        this.mSessionType = sessionType;
        this.mOutputConfigurations = Collections.unmodifiableList(new ArrayList<OutputConfiguration>(outputs));
    }

    private SessionConfiguration(@NonNull Parcel source) {
        int sessionType = source.readInt();
        int inputWidth = source.readInt();
        int inputHeight = source.readInt();
        int inputFormat = source.readInt();
        boolean isInputMultiResolution = source.readBoolean();
        ArrayList<OutputConfiguration> outConfigs = new ArrayList<OutputConfiguration>();
        source.readTypedList(outConfigs, OutputConfiguration.CREATOR);
        boolean hasSessionParameters = source.readBoolean();
        if (hasSessionParameters) {
            CameraMetadataNative settings = new CameraMetadataNative();
            settings.readFromParcel(source);
        }
        if (inputWidth > 0 && inputHeight > 0 && inputFormat != -1) {
            this.mInputConfig = new InputConfiguration(inputWidth, inputHeight, inputFormat, isInputMultiResolution);
        }
        this.mSessionType = sessionType;
        this.mOutputConfigurations = outConfigs;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        dest.writeInt(this.mSessionType);
        if (this.mInputConfig != null) {
            dest.writeInt(this.mInputConfig.getWidth());
            dest.writeInt(this.mInputConfig.getHeight());
            dest.writeInt(this.mInputConfig.getFormat());
            dest.writeBoolean(this.mInputConfig.isMultiResolution());
        } else {
            dest.writeInt(0);
            dest.writeInt(0);
            dest.writeInt(-1);
            dest.writeBoolean(false);
        }
        dest.writeTypedList(this.mOutputConfigurations);
        if (this.mSessionParameters != null) {
            dest.writeBoolean(true);
            CameraMetadataNative metadata = this.mSessionParameters.getNativeCopy();
            metadata.writeToParcel(dest, 0);
        } else {
            dest.writeBoolean(false);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof SessionConfiguration) {
            SessionConfiguration other = (SessionConfiguration)obj;
            if (this.mInputConfig != other.mInputConfig || this.mSessionType != other.mSessionType || this.mOutputConfigurations.size() != other.mOutputConfigurations.size()) {
                return false;
            }
            for (int i = 0; i < this.mOutputConfigurations.size(); ++i) {
                if (this.mOutputConfigurations.get(i).equals(other.mOutputConfigurations.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mOutputConfigurations.hashCode(), Objects.hashCode(this.mInputConfig), this.mSessionType);
    }

    public int getSessionType() {
        return this.mSessionType;
    }

    public List<OutputConfiguration> getOutputConfigurations() {
        return this.mOutputConfigurations;
    }

    public CameraCaptureSession.StateCallback getStateCallback() {
        return this.mStateCallback;
    }

    public Executor getExecutor() {
        return this.mExecutor;
    }

    public void setInputConfiguration(@NonNull InputConfiguration input) {
        if (this.mSessionType == 1) {
            throw new UnsupportedOperationException("Method not supported for high speed session types");
        }
        this.mInputConfig = input;
    }

    public InputConfiguration getInputConfiguration() {
        return this.mInputConfig;
    }

    public void setSessionParameters(CaptureRequest params) {
        this.mSessionParameters = params;
    }

    public CaptureRequest getSessionParameters() {
        return this.mSessionParameters;
    }

    public void setColorSpace(@NonNull ColorSpace.Named colorSpace) {
        this.mColorSpace = colorSpace.ordinal();
        for (OutputConfiguration outputConfiguration : this.mOutputConfigurations) {
            outputConfiguration.setColorSpace(colorSpace);
        }
    }

    public void clearColorSpace() {
        this.mColorSpace = -1;
        for (OutputConfiguration outputConfiguration : this.mOutputConfigurations) {
            outputConfiguration.clearColorSpace();
        }
    }

    @SuppressLint(value={"MethodNameUnits"})
    @Nullable
    public ColorSpace getColorSpace() {
        if (this.mColorSpace != -1) {
            return ColorSpace.get(ColorSpace.Named.values()[this.mColorSpace]);
        }
        return null;
    }

    public void setStateCallback(@NonNull Executor executor, @NonNull CameraCaptureSession.StateCallback cb) {
        this.mStateCallback = cb;
        this.mExecutor = executor;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionMode {
    }
}

