/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.CaptureFailure;
import android.hardware.camera2.extension.ParcelCaptureResult;
import android.hardware.camera2.extension.ParcelTotalCaptureResult;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IRequestCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IRequestCallback";

    public void onCaptureStarted(int var1, long var2, long var4) throws RemoteException;

    public void onCaptureProgressed(int var1, ParcelCaptureResult var2) throws RemoteException;

    public void onCaptureCompleted(int var1, ParcelTotalCaptureResult var2) throws RemoteException;

    public void onCaptureFailed(int var1, CaptureFailure var2) throws RemoteException;

    public void onCaptureBufferLost(int var1, long var2, int var4) throws RemoteException;

    public void onCaptureSequenceCompleted(int var1, long var2) throws RemoteException;

    public void onCaptureSequenceAborted(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRequestCallback {
        static final int TRANSACTION_onCaptureStarted = 1;
        static final int TRANSACTION_onCaptureProgressed = 2;
        static final int TRANSACTION_onCaptureCompleted = 3;
        static final int TRANSACTION_onCaptureFailed = 4;
        static final int TRANSACTION_onCaptureBufferLost = 5;
        static final int TRANSACTION_onCaptureSequenceCompleted = 6;
        static final int TRANSACTION_onCaptureSequenceAborted = 7;

        public Stub() {
            this.attachInterface(this, IRequestCallback.DESCRIPTOR);
        }

        public static IRequestCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRequestCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IRequestCallback) {
                return (IRequestCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCaptureStarted";
                }
                case 2: {
                    return "onCaptureProgressed";
                }
                case 3: {
                    return "onCaptureCompleted";
                }
                case 4: {
                    return "onCaptureFailed";
                }
                case 5: {
                    return "onCaptureBufferLost";
                }
                case 6: {
                    return "onCaptureSequenceCompleted";
                }
                case 7: {
                    return "onCaptureSequenceAborted";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRequestCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onCaptureStarted(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    ParcelCaptureResult _arg1 = data.readTypedObject(ParcelCaptureResult.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCaptureProgressed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    ParcelTotalCaptureResult _arg1 = data.readTypedObject(ParcelTotalCaptureResult.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCaptureCompleted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    CaptureFailure _arg1 = data.readTypedObject(CaptureFailure.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCaptureFailed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCaptureBufferLost(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onCaptureSequenceCompleted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCaptureSequenceAborted(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IRequestCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRequestCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureStarted(int requestId, long frameNumber, long timestamp) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeLong(frameNumber);
                    _data.writeLong(timestamp);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureProgressed(int requestId, ParcelCaptureResult partialResult) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(partialResult, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureCompleted(int requestId, ParcelTotalCaptureResult totalCaptureResult) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(totalCaptureResult, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureFailed(int requestId, CaptureFailure captureFailure) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(captureFailure, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureBufferLost(int requestId, long frameNumber, int outputStreamId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeLong(frameNumber);
                    _data.writeInt(outputStreamId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSequenceCompleted(int sequenceId, long frameNumber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(sequenceId);
                    _data.writeLong(frameNumber);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSequenceAborted(int sequenceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestCallback.DESCRIPTOR);
                    _data.writeInt(sequenceId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRequestCallback {
        @Override
        public void onCaptureStarted(int requestId, long frameNumber, long timestamp) throws RemoteException {
        }

        @Override
        public void onCaptureProgressed(int requestId, ParcelCaptureResult partialResult) throws RemoteException {
        }

        @Override
        public void onCaptureCompleted(int requestId, ParcelTotalCaptureResult totalCaptureResult) throws RemoteException {
        }

        @Override
        public void onCaptureFailed(int requestId, CaptureFailure captureFailure) throws RemoteException {
        }

        @Override
        public void onCaptureBufferLost(int requestId, long frameNumber, int outputStreamId) throws RemoteException {
        }

        @Override
        public void onCaptureSequenceCompleted(int sequenceId, long frameNumber) throws RemoteException {
        }

        @Override
        public void onCaptureSequenceAborted(int sequenceId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

