/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.events;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.BiometricRequestConstants;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class AuthenticationStartedInfo
implements Parcelable {
    @NonNull
    private final BiometricSourceType mBiometricSourceType;
    private final int mRequestReason;
    @NonNull
    public static final Parcelable.Creator<AuthenticationStartedInfo> CREATOR = new Parcelable.Creator<AuthenticationStartedInfo>(){

        public AuthenticationStartedInfo[] newArray(int size) {
            return new AuthenticationStartedInfo[size];
        }

        @Override
        public AuthenticationStartedInfo createFromParcel(@NonNull Parcel in) {
            return new AuthenticationStartedInfo(in);
        }
    };

    AuthenticationStartedInfo(@NonNull BiometricSourceType biometricSourceType, int requestReason) {
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
    }

    @NonNull
    public BiometricSourceType getBiometricSourceType() {
        return this.mBiometricSourceType;
    }

    public int getRequestReason() {
        return this.mRequestReason;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationStartedInfo that = (AuthenticationStartedInfo)o;
        return Objects.equals(this.mBiometricSourceType, that.mBiometricSourceType) && this.mRequestReason == that.mRequestReason;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mBiometricSourceType);
        _hash = 31 * _hash + this.mRequestReason;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mBiometricSourceType, flags);
        dest.writeInt(this.mRequestReason);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AuthenticationStartedInfo(@NonNull Parcel in) {
        BiometricSourceType biometricSourceType = in.readTypedObject(BiometricSourceType.CREATOR);
        int requestReason = in.readInt();
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        @NonNull
        private BiometricSourceType mBiometricSourceType;
        private int mRequestReason;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull BiometricSourceType biometricSourceType, int requestReason) {
            this.mBiometricSourceType = biometricSourceType;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
            this.mRequestReason = requestReason;
            AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        }

        @NonNull
        public Builder setBiometricSourceType(@NonNull BiometricSourceType value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mBiometricSourceType = value;
            return this;
        }

        @NonNull
        public Builder setRequestReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mRequestReason = value;
            return this;
        }

        @NonNull
        public AuthenticationStartedInfo build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            AuthenticationStartedInfo o = new AuthenticationStartedInfo(this.mBiometricSourceType, this.mRequestReason);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 4L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

