/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.events;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.BiometricRequestConstants;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class AuthenticationHelpInfo
implements Parcelable {
    @NonNull
    private final BiometricSourceType mBiometricSourceType;
    private final int mRequestReason;
    @Nullable
    private final String mHelpString;
    private final int mHelpCode;
    @NonNull
    public static final Parcelable.Creator<AuthenticationHelpInfo> CREATOR = new Parcelable.Creator<AuthenticationHelpInfo>(){

        public AuthenticationHelpInfo[] newArray(int size) {
            return new AuthenticationHelpInfo[size];
        }

        @Override
        public AuthenticationHelpInfo createFromParcel(@NonNull Parcel in) {
            return new AuthenticationHelpInfo(in);
        }
    };

    AuthenticationHelpInfo(@NonNull BiometricSourceType biometricSourceType, int requestReason, @Nullable String helpString, int helpCode) {
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        this.mHelpString = helpString;
        this.mHelpCode = helpCode;
    }

    @NonNull
    public BiometricSourceType getBiometricSourceType() {
        return this.mBiometricSourceType;
    }

    public int getRequestReason() {
        return this.mRequestReason;
    }

    @Nullable
    public String getHelpString() {
        return this.mHelpString;
    }

    public int getHelpCode() {
        return this.mHelpCode;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationHelpInfo that = (AuthenticationHelpInfo)o;
        return Objects.equals(this.mBiometricSourceType, that.mBiometricSourceType) && this.mRequestReason == that.mRequestReason && Objects.equals(this.mHelpString, that.mHelpString) && this.mHelpCode == that.mHelpCode;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mBiometricSourceType);
        _hash = 31 * _hash + this.mRequestReason;
        _hash = 31 * _hash + Objects.hashCode(this.mHelpString);
        _hash = 31 * _hash + this.mHelpCode;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mHelpString != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mBiometricSourceType, flags);
        dest.writeInt(this.mRequestReason);
        if (this.mHelpString != null) {
            dest.writeString(this.mHelpString);
        }
        dest.writeInt(this.mHelpCode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AuthenticationHelpInfo(@NonNull Parcel in) {
        byte flg = in.readByte();
        BiometricSourceType biometricSourceType = in.readTypedObject(BiometricSourceType.CREATOR);
        int requestReason = in.readInt();
        String helpString = (flg & 4) == 0 ? null : in.readString();
        int helpCode = in.readInt();
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        this.mHelpString = helpString;
        this.mHelpCode = helpCode;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        @NonNull
        private BiometricSourceType mBiometricSourceType;
        private int mRequestReason;
        @Nullable
        private String mHelpString;
        private int mHelpCode;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull BiometricSourceType biometricSourceType, int requestReason, @Nullable String helpString, int helpCode) {
            this.mBiometricSourceType = biometricSourceType;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
            this.mRequestReason = requestReason;
            AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
            this.mHelpString = helpString;
            this.mHelpCode = helpCode;
        }

        @NonNull
        public Builder setBiometricSourceType(@NonNull BiometricSourceType value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mBiometricSourceType = value;
            return this;
        }

        @NonNull
        public Builder setRequestReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mRequestReason = value;
            return this;
        }

        @NonNull
        public Builder setHelpString(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mHelpString = value;
            return this;
        }

        @NonNull
        public Builder setHelpCode(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mHelpCode = value;
            return this;
        }

        @NonNull
        public AuthenticationHelpInfo build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            AuthenticationHelpInfo o = new AuthenticationHelpInfo(this.mBiometricSourceType, this.mRequestReason, this.mHelpString, this.mHelpCode);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x10L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

