/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.util.IntArray;
import java.util.ArrayList;

@FlaggedApi(value="android.hardware.flags.luts_api")
public class DisplayLuts {
    private ArrayList<Entry> mEntries = new ArrayList();
    private IntArray mOffsets = new IntArray();
    private int mTotalLength = 0;

    @FlaggedApi(value="android.hardware.flags.luts_api")
    public DisplayLuts() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DisplayLuts{");
        sb.append("\n");
        for (Entry entry : this.mEntries) {
            sb.append(entry.toString());
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private void addEntry(Entry entry) {
        this.mEntries.add(entry);
        this.mOffsets.add(this.mTotalLength);
        this.mTotalLength += entry.getBuffer().length;
    }

    private void clear() {
        this.mOffsets.clear();
        this.mTotalLength = 0;
        this.mEntries.clear();
    }

    @FlaggedApi(value="android.hardware.flags.luts_api")
    public void set(@NonNull Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("The entry is null!");
        }
        this.clear();
        this.addEntry(entry);
    }

    @FlaggedApi(value="android.hardware.flags.luts_api")
    public void set(@NonNull Entry first, @NonNull Entry second) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("The entry is null!");
        }
        if (first.getDimension() != 1 || second.getDimension() != 3) {
            throw new IllegalArgumentException("The entries should be 1D and 3D in order!");
        }
        this.clear();
        this.addEntry(first);
        this.addEntry(second);
    }

    public boolean valid() {
        return this.mEntries.size() > 0;
    }

    public float[] getLutBuffers() {
        float[] buffer = new float[this.mTotalLength];
        for (int i = 0; i < this.mEntries.size(); ++i) {
            float[] lutBuffer = this.mEntries.get(i).getBuffer();
            System.arraycopy(lutBuffer, 0, buffer, this.mOffsets.get(i), lutBuffer.length);
        }
        return buffer;
    }

    public int[] getOffsets() {
        return this.mOffsets.toArray();
    }

    public int[] getLutSizes() {
        int[] sizes = new int[this.mEntries.size()];
        for (int i = 0; i < this.mEntries.size(); ++i) {
            sizes[i] = this.mEntries.get(i).getSize();
        }
        return sizes;
    }

    public int[] getLutDimensions() {
        int[] dimensions = new int[this.mEntries.size()];
        for (int i = 0; i < this.mEntries.size(); ++i) {
            dimensions[i] = this.mEntries.get(i).getDimension();
        }
        return dimensions;
    }

    public int[] getLutSamplingKeys() {
        int[] samplingKeys = new int[this.mEntries.size()];
        for (int i = 0; i < this.mEntries.size(); ++i) {
            samplingKeys[i] = this.mEntries.get(i).getSamplingKey();
        }
        return samplingKeys;
    }

    @FlaggedApi(value="android.hardware.flags.luts_api")
    public static class Entry {
        private float[] mBuffer;
        private int mDimension;
        private int mSize;
        private int mSamplingKey;
        private static final int LUT_LENGTH_LIMIT = 100000;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @FlaggedApi(value="android.hardware.flags.luts_api")
        public Entry(@NonNull float[] buffer, int dimension, int samplingKey) {
            if (buffer == null || buffer.length < 1) {
                throw new IllegalArgumentException("The buffer cannot be empty!");
            }
            if (buffer.length >= 100000) {
                throw new IllegalArgumentException("The lut length is too big to handle!");
            }
            if (dimension != 1 && dimension != 3) {
                throw new IllegalArgumentException("The dimension should be either 1D or 3D!");
            }
            if (dimension == 3) {
                if (buffer.length <= 3) {
                    throw new IllegalArgumentException("The 3d lut size of each dimension should be over 1!");
                }
                int lengthPerChannel = buffer.length;
                if (lengthPerChannel % 3 != 0) {
                    throw new IllegalArgumentException("The lut buffer of 3dlut should have 3 channels!");
                }
                double size = Math.cbrt(lengthPerChannel /= 3);
                if (size != (double)((int)size)) throw new IllegalArgumentException("Cannot get the cube root of the 3d lut buffer!");
                this.mSize = (int)size;
            } else {
                this.mSize = buffer.length;
            }
            this.mBuffer = buffer;
            this.mDimension = dimension;
            this.mSamplingKey = samplingKey;
        }

        @FlaggedApi(value="android.hardware.flags.luts_api")
        public int getDimension() {
            return this.mDimension;
        }

        public int getSize() {
            return this.mSize;
        }

        @FlaggedApi(value="android.hardware.flags.luts_api")
        @NonNull
        public float[] getBuffer() {
            return this.mBuffer;
        }

        @FlaggedApi(value="android.hardware.flags.luts_api")
        public int getSamplingKey() {
            return this.mSamplingKey;
        }

        public String toString() {
            return "Entry{dimension=" + Entry.dimensionToString(this.getDimension()) + ", size(each dimension)=" + this.getSize() + ", samplingKey=" + Entry.samplingKeyToString(this.getSamplingKey()) + "}";
        }

        private static String dimensionToString(int dimension) {
            switch (dimension) {
                case 1: {
                    return "ONE_DIMENSION";
                }
                case 3: {
                    return "THREE_DIMENSION";
                }
            }
            return "";
        }

        private static String samplingKeyToString(int key) {
            switch (key) {
                case 0: {
                    return "SAMPLING_KEY_RGB";
                }
                case 1: {
                    return "SAMPLING_KEY_MAX_RGB";
                }
                case 2: {
                    return "SAMPLING_KEY_CIE_Y";
                }
            }
            return "";
        }
    }
}

