/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.text.LineBreakConfig;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Log;
import com.android.internal.util.Preconditions;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.NeverInline;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import java.util.Objects;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class MeasuredText {
    private static final String TAG = "MeasuredText";
    private final long mNativePtr;
    private final boolean mComputeHyphenation;
    private final boolean mComputeLayout;
    private final boolean mComputeBounds;
    @NonNull
    private final char[] mChars;
    private final int mTop;
    private final int mBottom;

    private MeasuredText(long ptr, @NonNull char[] chars, boolean computeHyphenation, boolean computeLayout, boolean computeBounds, int top, int bottom) {
        this.mNativePtr = ptr;
        this.mChars = chars;
        this.mComputeHyphenation = computeHyphenation;
        this.mComputeLayout = computeLayout;
        this.mComputeBounds = computeBounds;
        this.mTop = top;
        this.mBottom = bottom;
    }

    @NonNull
    public char[] getChars() {
        return this.mChars;
    }

    private void rangeCheck(int start, int end) {
        if (start < 0 || start > end || end > this.mChars.length) {
            this.throwRangeError(start, end);
        }
    }

    @NeverInline
    private void throwRangeError(int start, int end) {
        throw new IllegalArgumentException(String.format(Locale.US, "start(%d) end(%d) length(%d) out of bounds", start, end, this.mChars.length));
    }

    private void offsetCheck(int offset) {
        if (offset < 0 || offset >= this.mChars.length) {
            this.throwOffsetError(offset);
        }
    }

    @NeverInline
    private void throwOffsetError(int offset) {
        throw new IllegalArgumentException(String.format(Locale.US, "offset (%d) length(%d) out of bounds", offset, this.mChars.length));
    }

    public float getWidth(int start, int end) {
        this.rangeCheck(start, end);
        return MeasuredText.nGetWidth(this.mNativePtr, start, end);
    }

    public int getMemoryUsage() {
        return MeasuredText.nGetMemoryUsage(this.mNativePtr);
    }

    public void getBounds(int start, int end, @NonNull Rect rect) {
        this.rangeCheck(start, end);
        Preconditions.checkNotNull(rect);
        MeasuredText.nGetBounds(this.mNativePtr, this.mChars, start, end, rect);
    }

    public void getFontMetricsInt(int start, int end, @NonNull Paint.FontMetricsInt outMetrics) {
        this.rangeCheck(start, end);
        Objects.requireNonNull(outMetrics);
        long packed = MeasuredText.nGetExtent(this.mNativePtr, this.mChars, start, end);
        outMetrics.ascent = (int)(packed >> 32);
        outMetrics.descent = (int)(packed & 0xFFFFFFFFFFFFFFFFL);
        outMetrics.top = Math.min(outMetrics.ascent, this.mTop);
        outMetrics.bottom = Math.max(outMetrics.descent, this.mBottom);
    }

    public float getCharWidthAt(int offset) {
        this.offsetCheck(offset);
        return MeasuredText.nGetCharWidthAt(this.mNativePtr, offset);
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    @CriticalNative
    private static native float nGetWidth(long var0, int var2, int var3);

    @CriticalNative
    private static native long nGetReleaseFunc();

    @CriticalNative
    private static native int nGetMemoryUsage(long var0);

    private static native void nGetBounds(long var0, char[] var2, int var3, int var4, Rect var5);

    @CriticalNative
    private static native float nGetCharWidthAt(long var0, int var2);

    private static native long nGetExtent(long var0, char[] var2, int var3, int var4);

    public static final class Builder {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(MeasuredText.class.getClassLoader(), MeasuredText.nGetReleaseFunc());
        private long mNativePtr;
        @NonNull
        private final char[] mText;
        private boolean mComputeHyphenation = false;
        private boolean mComputeLayout = true;
        private boolean mComputeBounds = true;
        private boolean mFastHyphenation = false;
        private int mCurrentOffset = 0;
        @Nullable
        private MeasuredText mHintMt = null;
        private int mTop = 0;
        private int mBottom = 0;
        private Paint.FontMetricsInt mCachedMetrics = new Paint.FontMetricsInt();
        public static final int HYPHENATION_MODE_NONE = 0;
        public static final int HYPHENATION_MODE_NORMAL = 1;
        public static final int HYPHENATION_MODE_FAST = 2;

        public Builder(@NonNull char[] text) {
            Preconditions.checkNotNull(text);
            this.mText = text;
            this.mNativePtr = Builder.nInitBuilder();
        }

        public Builder(@NonNull MeasuredText text) {
            Preconditions.checkNotNull(text);
            this.mText = text.mChars;
            this.mNativePtr = Builder.nInitBuilder();
            if (!text.mComputeLayout) {
                throw new IllegalArgumentException("The input MeasuredText must not be created with setComputeLayout(false).");
            }
            this.mComputeHyphenation = text.mComputeHyphenation;
            this.mComputeLayout = text.mComputeLayout;
            this.mHintMt = text;
        }

        @NonNull
        public Builder appendStyleRun(@NonNull Paint paint, int length, boolean isRtl) {
            return this.appendStyleRun(paint, null, length, isRtl);
        }

        @NonNull
        public Builder appendStyleRun(@NonNull Paint paint, @Nullable LineBreakConfig lineBreakConfig, int length, boolean isRtl) {
            Preconditions.checkNotNull(paint);
            Preconditions.checkArgument(length > 0, "length can not be negative");
            int end = this.mCurrentOffset + length;
            Preconditions.checkArgument(end <= this.mText.length, "Style exceeds the text length");
            int lbStyle = LineBreakConfig.getResolvedLineBreakStyle(lineBreakConfig);
            int lbWordStyle = LineBreakConfig.getResolvedLineBreakWordStyle(lineBreakConfig);
            boolean hyphenation = LineBreakConfig.getResolvedHyphenation(lineBreakConfig) == 1;
            Builder.nAddStyleRun(this.mNativePtr, paint.getNativeInstance(), lbStyle, lbWordStyle, hyphenation, this.mCurrentOffset, end, isRtl);
            this.mCurrentOffset = end;
            paint.getFontMetricsInt(this.mCachedMetrics);
            this.mTop = Math.min(this.mTop, this.mCachedMetrics.top);
            this.mBottom = Math.max(this.mBottom, this.mCachedMetrics.bottom);
            return this;
        }

        @NonNull
        public Builder appendReplacementRun(@NonNull Paint paint, int length, float width) {
            Preconditions.checkArgument(length > 0, "length can not be negative");
            int end = this.mCurrentOffset + length;
            Preconditions.checkArgument(end <= this.mText.length, "Replacement exceeds the text length");
            Builder.nAddReplacementRun(this.mNativePtr, paint.getNativeInstance(), this.mCurrentOffset, end, width);
            this.mCurrentOffset = end;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setComputeHyphenation(boolean computeHyphenation) {
            this.setComputeHyphenation(computeHyphenation ? 1 : 0);
            return this;
        }

        @NonNull
        public Builder setComputeHyphenation(int mode) {
            switch (mode) {
                case 0: {
                    this.mComputeHyphenation = false;
                    this.mFastHyphenation = false;
                    break;
                }
                case 1: {
                    this.mComputeHyphenation = true;
                    this.mFastHyphenation = false;
                    break;
                }
                case 2: {
                    this.mComputeHyphenation = true;
                    this.mFastHyphenation = true;
                    break;
                }
                default: {
                    Log.e(MeasuredText.TAG, "Unknown hyphenation mode: " + mode);
                    this.mComputeHyphenation = false;
                    this.mFastHyphenation = false;
                }
            }
            return this;
        }

        @NonNull
        public Builder setComputeLayout(boolean computeLayout) {
            this.mComputeLayout = computeLayout;
            return this;
        }

        @NonNull
        public Builder setComputeBounds(boolean computeBounds) {
            this.mComputeBounds = computeBounds;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public MeasuredText build() {
            this.ensureNativePtrNoReuse();
            if (this.mCurrentOffset != this.mText.length) {
                throw new IllegalStateException("Style info has not been provided for all text.");
            }
            if (this.mHintMt != null && this.mHintMt.mComputeHyphenation != this.mComputeHyphenation) {
                throw new IllegalArgumentException("The hyphenation configuration is different from given hint MeasuredText");
            }
            try {
                long hintPtr = this.mHintMt == null ? 0L : this.mHintMt.getNativePtr();
                long ptr = Builder.nBuildMeasuredText(this.mNativePtr, hintPtr, this.mText, this.mComputeHyphenation, this.mComputeLayout, this.mComputeBounds, this.mFastHyphenation);
                MeasuredText res = new MeasuredText(ptr, this.mText, this.mComputeHyphenation, this.mComputeLayout, this.mComputeBounds, this.mTop, this.mBottom);
                sRegistry.registerNativeAllocation(res, ptr);
                MeasuredText measuredText = res;
                return measuredText;
            }
            finally {
                Builder.nFreeBuilder(this.mNativePtr);
                this.mNativePtr = 0L;
            }
        }

        private void ensureNativePtrNoReuse() {
            if (this.mNativePtr == 0L) {
                throw new IllegalStateException("Builder can not be reused.");
            }
        }

        private static native long nInitBuilder();

        private static native void nAddStyleRun(long var0, long var2, int var4, int var5, boolean var6, int var7, int var8, boolean var9);

        private static native void nAddReplacementRun(long var0, long var2, int var4, int var5, float var6);

        private static native long nBuildMeasuredText(long var0, long var2, @NonNull char[] var4, boolean var5, boolean var6, boolean var7, boolean var8);

        private static native void nFreeBuilder(long var0);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface HyphenationMode {
        }
    }
}

