/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.text.MeasuredText;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class LineBreaker {
    public static final int BREAK_STRATEGY_SIMPLE = 0;
    public static final int BREAK_STRATEGY_HIGH_QUALITY = 1;
    public static final int BREAK_STRATEGY_BALANCED = 2;
    public static final int HYPHENATION_FREQUENCY_NONE = 0;
    public static final int HYPHENATION_FREQUENCY_NORMAL = 1;
    public static final int HYPHENATION_FREQUENCY_FULL = 2;
    public static final int JUSTIFICATION_MODE_NONE = 0;
    public static final int JUSTIFICATION_MODE_INTER_WORD = 1;
    @FlaggedApi(value="com.android.text.flags.letter_spacing_justification")
    public static final int JUSTIFICATION_MODE_INTER_CHARACTER = 2;
    private final long mNativePtr;
    private final int mBreakStrategy;
    private final int mHyphenationFrequency;
    private final int mJustificationMode;
    private final int[] mIndents;
    private final boolean mUseBoundsForWidth;

    private LineBreaker(int breakStrategy, int hyphenationFrequency, int justify, @Nullable int[] indents, boolean useBoundsForWidth) {
        this.mNativePtr = LineBreaker.nInit(breakStrategy, hyphenationFrequency, justify == 1, indents, useBoundsForWidth);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativePtr);
        this.mBreakStrategy = breakStrategy;
        this.mHyphenationFrequency = hyphenationFrequency;
        this.mJustificationMode = justify;
        this.mIndents = indents;
        this.mUseBoundsForWidth = useBoundsForWidth;
    }

    @FlaggedApi(value="com.android.text.flags.missing_getter_apis")
    public int getBreakStrategy() {
        return this.mBreakStrategy;
    }

    @FlaggedApi(value="com.android.text.flags.missing_getter_apis")
    public int getHyphenationFrequency() {
        return this.mHyphenationFrequency;
    }

    @FlaggedApi(value="com.android.text.flags.missing_getter_apis")
    public int getJustificationMode() {
        return this.mJustificationMode;
    }

    @FlaggedApi(value="com.android.text.flags.missing_getter_apis")
    @Nullable
    public int[] getIndents() {
        return this.mIndents;
    }

    @FlaggedApi(value="com.android.text.flags.missing_getter_apis")
    public boolean getUseBoundsForWidth() {
        return this.mUseBoundsForWidth;
    }

    @NonNull
    public Result computeLineBreaks(@NonNull MeasuredText measuredPara, @NonNull ParagraphConstraints constraints, int lineNumber) {
        return new Result(LineBreaker.nComputeLineBreaks(this.mNativePtr, measuredPara.getChars(), measuredPara.getNativePtr(), measuredPara.getChars().length, constraints.mFirstWidth, constraints.mFirstWidthLineCount, constraints.mWidth, constraints.mVariableTabStops, constraints.mDefaultTabStop, lineNumber));
    }

    @FastNative
    private static native long nInit(int var0, int var1, boolean var2, @Nullable int[] var3, boolean var4);

    @CriticalNative
    private static native long nGetReleaseFunc();

    private static native long nComputeLineBreaks(long var0, @NonNull char[] var2, long var3, int var5, float var6, int var7, float var8, @Nullable float[] var9, float var10, int var11);

    @CriticalNative
    private static native int nGetLineCount(long var0);

    @CriticalNative
    private static native int nGetLineBreakOffset(long var0, int var2);

    @CriticalNative
    private static native float nGetLineWidth(long var0, int var2);

    @CriticalNative
    private static native float nGetLineAscent(long var0, int var2);

    @CriticalNative
    private static native float nGetLineDescent(long var0, int var2);

    @CriticalNative
    private static native int nGetLineFlag(long var0, int var2);

    @CriticalNative
    private static native long nGetReleaseResultFunc();

    private static class NoImagePreloadHolder {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(LineBreaker.class.getClassLoader(), LineBreaker.nGetReleaseFunc());

        private NoImagePreloadHolder() {
        }
    }

    public static class Result {
        private static final int TAB_MASK = 0x20000000;
        private static final int HYPHEN_MASK = 255;
        private static final int START_HYPHEN_MASK = 24;
        private static final int END_HYPHEN_MASK = 7;
        private static final int START_HYPHEN_BITS_SHIFT = 3;
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Result.class.getClassLoader(), LineBreaker.nGetReleaseResultFunc());
        private final long mPtr;

        private Result(long ptr) {
            this.mPtr = ptr;
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        public int getLineCount() {
            return LineBreaker.nGetLineCount(this.mPtr);
        }

        public int getLineBreakOffset(int lineIndex) {
            return LineBreaker.nGetLineBreakOffset(this.mPtr, lineIndex);
        }

        public float getLineWidth(int lineIndex) {
            return LineBreaker.nGetLineWidth(this.mPtr, lineIndex);
        }

        public float getLineAscent(int lineIndex) {
            return LineBreaker.nGetLineAscent(this.mPtr, lineIndex);
        }

        public float getLineDescent(int lineIndex) {
            return LineBreaker.nGetLineDescent(this.mPtr, lineIndex);
        }

        public boolean hasLineTab(int lineIndex) {
            return (LineBreaker.nGetLineFlag(this.mPtr, lineIndex) & 0x20000000) != 0;
        }

        public int getStartLineHyphenEdit(int lineIndex) {
            return (LineBreaker.nGetLineFlag(this.mPtr, lineIndex) & 0x18) >> 3;
        }

        public int getEndLineHyphenEdit(int lineIndex) {
            return LineBreaker.nGetLineFlag(this.mPtr, lineIndex) & 7;
        }
    }

    public static class ParagraphConstraints {
        private float mWidth = 0.0f;
        private float mFirstWidth = 0.0f;
        private int mFirstWidthLineCount = 0;
        @Nullable
        private float[] mVariableTabStops = null;
        private float mDefaultTabStop = 0.0f;

        public void setWidth(float width) {
            this.mWidth = width;
        }

        public void setIndent(float firstWidth, int firstWidthLineCount) {
            this.mFirstWidth = firstWidth;
            this.mFirstWidthLineCount = firstWidthLineCount;
        }

        public void setTabStops(@Nullable float[] tabStops, float defaultTabStop) {
            this.mVariableTabStops = tabStops;
            this.mDefaultTabStop = defaultTabStop;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getFirstWidth() {
            return this.mFirstWidth;
        }

        public int getFirstWidthLineCount() {
            return this.mFirstWidthLineCount;
        }

        @Nullable
        public float[] getTabStops() {
            return this.mVariableTabStops;
        }

        public float getDefaultTabStop() {
            return this.mDefaultTabStop;
        }
    }

    public static class Builder {
        private int mBreakStrategy = 0;
        private int mHyphenationFrequency = 0;
        private int mJustificationMode = 0;
        @Nullable
        private int[] mIndents = null;
        private boolean mUseBoundsForWidth = false;

        @NonNull
        public Builder setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        @NonNull
        public Builder setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        @NonNull
        public Builder setJustificationMode(int justificationMode) {
            this.mJustificationMode = justificationMode;
            return this;
        }

        @NonNull
        public Builder setIndents(@Nullable int[] indents) {
            this.mIndents = indents;
            return this;
        }

        @FlaggedApi(value="com.android.text.flags.use_bounds_for_width")
        @NonNull
        public Builder setUseBoundsForWidth(boolean useBoundsForWidth) {
            this.mUseBoundsForWidth = useBoundsForWidth;
            return this;
        }

        @NonNull
        public LineBreaker build() {
            return new LineBreaker(this.mBreakStrategy, this.mHyphenationFrequency, this.mJustificationMode, this.mIndents, this.mUseBoundsForWidth);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JustificationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HyphenationFrequency {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BreakStrategy {
    }
}

