/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

@RavenwoodKeepWholeClass
public class FontVariationAxis {
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final int mTag;
    private final String mTagString;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final float mStyleValue;
    private static final Pattern TAG_PATTERN = Pattern.compile("[ -~]{4}");
    private static final Pattern STYLE_VALUE_PATTERN = Pattern.compile("-?(([0-9]+(\\.[0-9]+)?)|(\\.[0-9]+))");

    public FontVariationAxis(@NonNull String tagString, float styleValue) {
        if (!FontVariationAxis.isValidTag(tagString)) {
            throw new IllegalArgumentException("Illegal tag pattern: " + tagString);
        }
        this.mTag = FontVariationAxis.makeTag(tagString);
        this.mTagString = tagString;
        this.mStyleValue = styleValue;
    }

    public int getOpenTypeTagValue() {
        return this.mTag;
    }

    public String getTag() {
        return this.mTagString;
    }

    public float getStyleValue() {
        return this.mStyleValue;
    }

    @NonNull
    public String toString() {
        return "'" + this.mTagString + "' " + Float.toString(this.mStyleValue);
    }

    private static boolean isValidTag(String tagString) {
        return tagString != null && TAG_PATTERN.matcher(tagString).matches();
    }

    private static boolean isValidValueFormat(String valueString) {
        return valueString != null && STYLE_VALUE_PATTERN.matcher(valueString).matches();
    }

    public static int makeTag(String tagString) {
        char c1 = tagString.charAt(0);
        char c2 = tagString.charAt(1);
        char c3 = tagString.charAt(2);
        char c4 = tagString.charAt(3);
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    @Nullable
    public static FontVariationAxis[] fromFontVariationSettings(@Nullable String settings) {
        List<FontVariationAxis> result = FontVariationAxis.fromFontVariationSettingsForList(settings);
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new FontVariationAxis[0]);
    }

    @NonNull
    public static List<FontVariationAxis> fromFontVariationSettingsForList(@Nullable String settings) {
        if (settings == null || settings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FontVariationAxis> axisList = new ArrayList<FontVariationAxis>();
        int length = settings.length();
        for (int i = 0; i < length; ++i) {
            float value;
            char c = settings.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != '\'' && c != '\"' || length < i + 6 || settings.charAt(i + 5) != c) {
                throw new IllegalArgumentException("Tag should be wrapped with double or single quote: " + settings);
            }
            String tagString = settings.substring(i + 1, i + 5);
            int endOfValueString = settings.indexOf(44, i += 6);
            if (endOfValueString == -1) {
                endOfValueString = length;
            }
            try {
                value = Float.parseFloat(settings.substring(i, endOfValueString));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse float string: " + e.getMessage());
            }
            axisList.add(new FontVariationAxis(tagString, value));
            i = endOfValueString;
        }
        if (axisList.isEmpty()) {
            return Collections.emptyList();
        }
        return axisList;
    }

    @NonNull
    public static String toFontVariationSettings(@Nullable FontVariationAxis[] axes) {
        if (axes == null) {
            return "";
        }
        return TextUtils.join((CharSequence)",", axes);
    }

    @NonNull
    public static String toFontVariationSettings(@Nullable List<FontVariationAxis> axes) {
        if (axes == null) {
            return "";
        }
        return TextUtils.join((CharSequence)",", axes);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof FontVariationAxis)) {
            return false;
        }
        FontVariationAxis axis = (FontVariationAxis)o;
        return axis.mTag == this.mTag && axis.mStyleValue == this.mStyleValue;
    }

    public int hashCode() {
        return Objects.hash(this.mTag, Float.valueOf(this.mStyleValue));
    }
}

