/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.graphics.fonts.FontFileUpdateRequest;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RavenwoodKeepWholeClass
public class FontFamilyUpdateRequest {
    @NonNull
    private final List<FontFileUpdateRequest> mFontFiles;
    @NonNull
    private final List<FontFamily> mFontFamilies;

    private FontFamilyUpdateRequest(@NonNull List<FontFileUpdateRequest> fontFiles, @NonNull List<FontFamily> fontFamilies) {
        this.mFontFiles = fontFiles;
        this.mFontFamilies = fontFamilies;
    }

    @NonNull
    public List<FontFileUpdateRequest> getFontFileUpdateRequests() {
        return this.mFontFiles;
    }

    @NonNull
    public List<FontFamily> getFontFamilies() {
        return this.mFontFamilies;
    }

    public static class Builder {
        @NonNull
        private final List<FontFileUpdateRequest> mFontFileUpdateRequests = new ArrayList<FontFileUpdateRequest>();
        @NonNull
        private final List<FontFamily> mFontFamilies = new ArrayList<FontFamily>();

        @NonNull
        public Builder addFontFileUpdateRequest(@NonNull FontFileUpdateRequest request) {
            Objects.requireNonNull(request);
            this.mFontFileUpdateRequests.add(request);
            return this;
        }

        @NonNull
        public Builder addFontFamily(@NonNull FontFamily fontFamily) {
            Objects.requireNonNull(fontFamily);
            this.mFontFamilies.add(fontFamily);
            return this;
        }

        @NonNull
        public FontFamilyUpdateRequest build() {
            return new FontFamilyUpdateRequest(this.mFontFileUpdateRequests, this.mFontFamilies);
        }
    }

    public static class Font {
        @NonNull
        private final String mPostScriptName;
        @NonNull
        private final FontStyle mStyle;
        @NonNull
        private final List<FontVariationAxis> mAxes;
        private final int mIndex;

        private Font(@NonNull String postScriptName, @NonNull FontStyle style2, int index, @NonNull List<FontVariationAxis> axes) {
            this.mPostScriptName = postScriptName;
            this.mStyle = style2;
            this.mIndex = index;
            this.mAxes = axes;
        }

        @NonNull
        public String getPostScriptName() {
            return this.mPostScriptName;
        }

        @NonNull
        public FontStyle getStyle() {
            return this.mStyle;
        }

        @NonNull
        public List<FontVariationAxis> getAxes() {
            return this.mAxes;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public static class Builder {
            @NonNull
            private final String mPostScriptName;
            @NonNull
            private final FontStyle mStyle;
            @NonNull
            private List<FontVariationAxis> mAxes = Collections.emptyList();
            private int mIndex = 0;

            public Builder(@NonNull String postScriptName, @NonNull FontStyle style2) {
                Objects.requireNonNull(postScriptName);
                Preconditions.checkStringNotEmpty(postScriptName);
                Objects.requireNonNull(style2);
                this.mPostScriptName = postScriptName;
                this.mStyle = style2;
            }

            @NonNull
            public Builder setAxes(@NonNull List<FontVariationAxis> axes) {
                Objects.requireNonNull(axes);
                Preconditions.checkCollectionElementsNotNull(axes, "axes");
                this.mAxes = axes;
                return this;
            }

            @NonNull
            public Builder setIndex(int index) {
                Preconditions.checkArgumentNonnegative(index);
                this.mIndex = index;
                return this;
            }

            @NonNull
            public Font build() {
                return new Font(this.mPostScriptName, this.mStyle, this.mIndex, this.mAxes);
            }
        }
    }

    public static class FontFamily {
        @NonNull
        private final String mName;
        @NonNull
        private final List<Font> mFonts;

        private FontFamily(@NonNull String name, @NonNull List<Font> fonts) {
            this.mName = name;
            this.mFonts = fonts;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        @NonNull
        public List<Font> getFonts() {
            return this.mFonts;
        }

        public static class Builder {
            @NonNull
            private final String mName;
            @NonNull
            private final List<Font> mFonts;

            public Builder(@NonNull String name, @NonNull List<Font> fonts) {
                Objects.requireNonNull(name);
                Preconditions.checkStringNotEmpty(name);
                Objects.requireNonNull(fonts);
                Preconditions.checkCollectionElementsNotNull(fonts, "fonts");
                Preconditions.checkCollectionNotEmpty(fonts, "fonts");
                this.mName = name;
                this.mFonts = new ArrayList<Font>(fonts);
            }

            @NonNull
            public Builder addFont(@NonNull Font font) {
                this.mFonts.add(font);
                return this;
            }

            @NonNull
            public FontFamily build() {
                return new FontFamily(this.mName, this.mFonts);
            }
        }
    }
}

