/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewDebug;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorDrawable
extends Drawable {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final Paint mPaint = new Paint(1);
    @ViewDebug.ExportedProperty(deepExport=true, prefix="state_")
    private ColorState mColorState;
    private BlendModeColorFilter mBlendModeColorFilter;
    private boolean mMutated;

    public ColorDrawable() {
        this.mColorState = new ColorState();
    }

    public ColorDrawable(int color2) {
        this.mColorState = new ColorState();
        this.setColor(color2);
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mColorState.getChangingConfigurations();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mColorState = new ColorState(this.mColorState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    public void draw(Canvas canvas) {
        ColorFilter colorFilter = this.mPaint.getColorFilter();
        if (this.mColorState.mUseColor >>> 24 != 0 || colorFilter != null || this.mBlendModeColorFilter != null) {
            if (colorFilter == null) {
                this.mPaint.setColorFilter(this.mBlendModeColorFilter);
            }
            this.mPaint.setColor(this.mColorState.mUseColor);
            canvas.drawRect(this.getBounds(), this.mPaint);
            this.mPaint.setColorFilter(colorFilter);
        }
    }

    public int getColor() {
        return this.mColorState.mUseColor;
    }

    public void setColor(int color2) {
        if (this.mColorState.mBaseColor != color2 || this.mColorState.mUseColor != color2) {
            this.mColorState.mBaseColor = this.mColorState.mUseColor = color2;
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mColorState.mUseColor >>> 24;
    }

    @Override
    public void setAlpha(int alpha) {
        int useAlpha;
        int useColor;
        int baseAlpha = this.mColorState.mBaseColor >>> 24;
        if (this.mColorState.mUseColor != (useColor = this.mColorState.mBaseColor << 8 >>> 8 | (useAlpha = baseAlpha * (alpha += alpha >> 7) >> 8) << 24)) {
            this.mColorState.mUseColor = useColor;
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    @Override
    @Nullable
    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    @Override
    public void setTintList(ColorStateList tint) {
        this.mColorState.mTint = tint;
        this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, tint, this.mColorState.mBlendMode);
        this.invalidateSelf();
    }

    @Override
    public void setTintBlendMode(@NonNull BlendMode blendMode) {
        this.mColorState.mBlendMode = blendMode;
        this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, this.mColorState.mTint, blendMode);
        this.invalidateSelf();
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        ColorState state = this.mColorState;
        if (state.mTint != null && state.mBlendMode != null) {
            this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, state.mTint, state.mBlendMode);
            return true;
        }
        return false;
    }

    @Override
    public boolean isStateful() {
        return this.mColorState.mTint != null && this.mColorState.mTint.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mColorState.mTint != null && this.mColorState.mTint.hasFocusStateSpecified();
    }

    @Override
    public void setXfermode(@Nullable Xfermode mode) {
        this.mPaint.setXfermode(mode);
        this.invalidateSelf();
    }

    public Xfermode getXfermode() {
        return this.mPaint.getXfermode();
    }

    @Override
    public int getOpacity() {
        if (this.mBlendModeColorFilter != null || this.mPaint.getColorFilter() != null) {
            return -3;
        }
        switch (this.mColorState.mUseColor >>> 24) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }

    @Override
    public void getOutline(@NonNull Outline outline) {
        outline.setRect(this.getBounds());
        outline.setAlpha((float)this.getAlpha() / 255.0f);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = ColorDrawable.obtainAttributes(r, theme, attrs, R.styleable.ColorDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.updateLocalState(r);
    }

    private void updateStateFromTypedArray(TypedArray a) {
        ColorState state = this.mColorState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mUseColor = state.mBaseColor = a.getColor(0, state.mBaseColor);
    }

    @Override
    public boolean canApplyTheme() {
        return this.mColorState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        ColorState state = this.mColorState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.ColorDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        this.updateLocalState(t.getResources());
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mColorState;
    }

    private ColorDrawable(ColorState state, Resources res) {
        this.mColorState = state;
        this.updateLocalState(res);
    }

    private void updateLocalState(Resources r) {
        this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, this.mColorState.mTint, this.mColorState.mBlendMode);
    }

    static class ColorState
    extends Drawable.ConstantState {
        int[] mThemeAttrs;
        int mBaseColor;
        @ViewDebug.ExportedProperty
        @UnsupportedAppUsage
        int mUseColor;
        int mChangingConfigurations;
        ColorStateList mTint = null;
        BlendMode mBlendMode = Drawable.DEFAULT_BLEND_MODE;

        ColorState() {
        }

        ColorState(ColorState state) {
            this.mThemeAttrs = state.mThemeAttrs;
            this.mBaseColor = state.mBaseColor;
            this.mUseColor = state.mUseColor;
            this.mChangingConfigurations = state.mChangingConfigurations;
            this.mTint = state.mTint;
            this.mBlendMode = state.mBlendMode;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mTint != null && this.mTint.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new ColorDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new ColorDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }
    }
}

