/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@RavenwoodKeepWholeClass
public class Point
implements Parcelable {
    public int x;
    public int y;
    @NonNull
    public static final Parcelable.Creator<Point> CREATOR = new Parcelable.Creator<Point>(){

        @Override
        public Point createFromParcel(Parcel in) {
            Point r = new Point();
            r.readFromParcel(in);
            return r;
        }

        public Point[] newArray(int size) {
            return new Point[size];
        }
    };

    public Point() {
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(@NonNull Point src) {
        this.set(src);
    }

    public void set(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void set(@NonNull Point src) {
        this.x = src.x;
        this.y = src.y;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public void offset(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public boolean equals(int x, int y) {
        return this.x == x && this.y == y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        if (this.x != point.x) {
            return false;
        }
        return this.y == point.y;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        return result;
    }

    public String toString() {
        return "Point(" + this.x + ", " + this.y + ")";
    }

    @NonNull
    public String flattenToString() {
        return this.x + "x" + this.y;
    }

    @Nullable
    public static Point unflattenFromString(String s) throws NumberFormatException {
        int sep_ix = s.indexOf("x");
        return new Point(Integer.parseInt(s.substring(0, sep_ix)), Integer.parseInt(s.substring(sep_ix + 1)));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.x);
        out.writeInt(this.y);
    }

    public void readFromParcel(@NonNull Parcel in) {
        this.x = in.readInt();
        this.y = in.readInt();
    }
}

