/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.BLASTBufferQueue;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.FrameInfo;
import android.graphics.HardwareRendererObserver;
import android.graphics.Picture;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.graphics.TextureLayer;
import android.hardware.DataSpace;
import android.hardware.OverlayProperties;
import android.hardware.display.DisplayManager;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Trace;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Log;
import android.view.Display;
import android.view.IGraphicsStats;
import android.view.IGraphicsStatsCallback;
import android.view.NativeVectorDrawableAnimator;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.animation.AnimationUtils;
import com.android.internal.util.RateLimitingCache;
import com.android.layoutlib.bridge.libcore.util.Cleaner;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@RavenwoodKeepWholeClass
public class HardwareRenderer {
    private static final String LOG_TAG = "HardwareRenderer";
    public static final int SYNC_OK = 0;
    public static final int SYNC_REDRAW_REQUESTED = 1;
    public static final int SYNC_LOST_SURFACE_REWARD_IF_FOUND = 2;
    public static final int SYNC_CONTEXT_IS_STOPPED = 4;
    public static final int SYNC_FRAME_DROPPED = 8;
    public static final int FLAG_DUMP_FRAMESTATS = 1;
    public static final int FLAG_DUMP_RESET = 2;
    public static final int FLAG_DUMP_ALL = 1;
    public static final int CACHE_TRIM_ALL = 0;
    public static final int CACHE_TRIM_FONT = 1;
    public static final int CACHE_TRIM_RESOURCES = 2;
    private static final String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    private static final String CACHE_PATH_SKIASHADERS = "com.android.skia.shaders_cache";
    private static int sDensityDpi = 0;
    private final long mNativeProxy;
    protected RenderNode mRootNode;
    private boolean mOpaque = true;
    private int mForceDark = 0;
    private int mColorMode = 0;
    private float mDesiredSdrHdrRatio = 1.0f;
    private final NotifyRendererRateLimiter mNotifyExpensiveFrameRateLimiter = this.createNotifyRendererRateLimiter("notifyExpensiveFrame", this::notifyExpensiveFrame);
    private final NotifyRendererRateLimiter mNotifyGpuLoadUpRateLimiter = this.createNotifyRendererRateLimiter("notifyGpuLoadUp", this::notifyGpuLoadUp);
    private FrameRenderRequest mRenderRequest = new FrameRenderRequest();

    private NotifyRendererRateLimiter createNotifyRendererRateLimiter(String reason, Runnable runnable) {
        return new NotifyRendererRateLimiter(reason, runnable, 100L);
    }

    public HardwareRenderer() {
        ProcessInitializer.sInstance.initUsingContext();
        this.mRootNode = RenderNode.adopt(HardwareRenderer.nCreateRootRenderNode());
        this.mRootNode.setClipToBounds(false);
        this.mNativeProxy = HardwareRenderer.nCreateProxy(!this.mOpaque, this.mRootNode.mNativeRenderNode);
        if (this.mNativeProxy == 0L) {
            throw new OutOfMemoryError("Unable to create hardware renderer");
        }
        Cleaner.create(this, new DestroyContextRunnable(this.mNativeProxy));
        ProcessInitializer.sInstance.init(this.mNativeProxy);
    }

    public void destroy() {
        HardwareRenderer.nDestroy(this.mNativeProxy, this.mRootNode.mNativeRenderNode);
    }

    public void setName(@NonNull String name) {
        HardwareRenderer.nSetName(this.mNativeProxy, name);
    }

    public void setLightSourceGeometry(float lightX, float lightY, float lightZ, float lightRadius) {
        HardwareRenderer.validateFinite(lightX, "lightX");
        HardwareRenderer.validateFinite(lightY, "lightY");
        HardwareRenderer.validatePositive(lightZ, "lightZ");
        HardwareRenderer.validatePositive(lightRadius, "lightRadius");
        HardwareRenderer.nSetLightGeometry(this.mNativeProxy, lightX, lightY, lightZ, lightRadius);
    }

    public void setLightSourceAlpha(float ambientShadowAlpha, float spotShadowAlpha) {
        HardwareRenderer.validateAlpha(ambientShadowAlpha, "ambientShadowAlpha");
        HardwareRenderer.validateAlpha(spotShadowAlpha, "spotShadowAlpha");
        HardwareRenderer.nSetLightAlpha(this.mNativeProxy, ambientShadowAlpha, spotShadowAlpha);
    }

    public void setContentRoot(@Nullable RenderNode content) {
        RecordingCanvas canvas = this.mRootNode.beginRecording();
        if (content != null) {
            canvas.drawRenderNode(content);
        }
        this.mRootNode.endRecording();
    }

    public void setSurface(@Nullable Surface surface) {
        this.setSurface(surface, false);
    }

    public void setSurface(@Nullable Surface surface, boolean discardBuffer) {
        if (surface != null && !surface.isValid()) {
            throw new IllegalArgumentException("Surface is invalid. surface.isValid() == false.");
        }
        HardwareRenderer.nSetSurface(this.mNativeProxy, surface, discardBuffer);
    }

    public void setSurfaceControl(@Nullable SurfaceControl surfaceControl, @Nullable BLASTBufferQueue blastBufferQueue) {
        HardwareRenderer.nSetSurfaceControl(this.mNativeProxy, surfaceControl != null ? surfaceControl.mNativeObject : 0L);
    }

    @NonNull
    public FrameRenderRequest createRenderRequest() {
        this.mRenderRequest.reset();
        return this.mRenderRequest;
    }

    public int syncAndDrawFrame(@NonNull FrameInfo frameInfo) {
        return HardwareRenderer.nSyncAndDrawFrame(this.mNativeProxy, frameInfo.frameInfo, frameInfo.frameInfo.length);
    }

    public boolean pause() {
        return HardwareRenderer.nPause(this.mNativeProxy);
    }

    public void setStopped(boolean stopped) {
        HardwareRenderer.nSetStopped(this.mNativeProxy, stopped);
    }

    public void stop() {
        HardwareRenderer.nSetStopped(this.mNativeProxy, true);
    }

    public void start() {
        HardwareRenderer.nSetStopped(this.mNativeProxy, false);
    }

    public void clearContent() {
        HardwareRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    public boolean setForceDark(int type) {
        if (this.mForceDark != type) {
            this.mForceDark = type;
            HardwareRenderer.nSetForceDark(this.mNativeProxy, type);
            return true;
        }
        return false;
    }

    public void allocateBuffers() {
        HardwareRenderer.nAllocateBuffers(this.mNativeProxy);
    }

    public void notifyFramePending() {
        HardwareRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    public void setOpaque(boolean opaque) {
        if (this.mOpaque != opaque) {
            this.mOpaque = opaque;
            HardwareRenderer.nSetOpaque(this.mNativeProxy, this.mOpaque);
        }
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public void setFrameCommitCallback(FrameCommitCallback callback) {
        HardwareRenderer.nSetFrameCommitCallback(this.mNativeProxy, callback);
    }

    public void setFrameCompleteCallback(FrameCompleteCallback callback) {
        HardwareRenderer.nSetFrameCompleteCallback(this.mNativeProxy, callback);
    }

    public void addObserver(HardwareRendererObserver observer) {
        HardwareRenderer.nAddObserver(this.mNativeProxy, observer.getNativeInstance());
    }

    public void addObserver(long nativeObserver) {
        HardwareRenderer.nAddObserver(this.mNativeProxy, nativeObserver);
    }

    public void removeObserver(HardwareRendererObserver observer) {
        HardwareRenderer.nRemoveObserver(this.mNativeProxy, observer.getNativeInstance());
    }

    public void removeObserver(long nativeObserver) {
        HardwareRenderer.nRemoveObserver(this.mNativeProxy, nativeObserver);
    }

    public float setColorMode(int colorMode) {
        if (this.mColorMode != colorMode) {
            this.mColorMode = colorMode;
            this.mDesiredSdrHdrRatio = HardwareRenderer.nSetColorMode(this.mNativeProxy, colorMode);
        }
        return this.mDesiredSdrHdrRatio;
    }

    public void setColorMode(int colorMode, float whitePoint) {
        HardwareRenderer.nSetSdrWhitePoint(this.mNativeProxy, whitePoint);
        this.mColorMode = colorMode;
        HardwareRenderer.nSetColorMode(this.mNativeProxy, colorMode);
    }

    public void setTargetHdrSdrRatio(float ratio) {
        if (ratio < 1.0f || !Float.isFinite(ratio)) {
            ratio = 1.0f;
        }
        HardwareRenderer.nSetTargetSdrHdrRatio(this.mNativeProxy, ratio);
    }

    public void fence() {
        HardwareRenderer.nFence(this.mNativeProxy);
    }

    public void registerAnimatingRenderNode(RenderNode animator2) {
        HardwareRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, animator2.mNativeRenderNode);
    }

    public void registerVectorDrawableAnimator(NativeVectorDrawableAnimator animator2) {
        HardwareRenderer.nRegisterVectorDrawableAnimator(this.mRootNode.mNativeRenderNode, animator2.getAnimatorNativePtr());
    }

    public void stopDrawing() {
        HardwareRenderer.nStopDrawing(this.mNativeProxy);
    }

    public TextureLayer createTextureLayer() {
        long layer = HardwareRenderer.nCreateTextureLayer(this.mNativeProxy);
        return TextureLayer.adoptTextureLayer(this, layer);
    }

    public void detachSurfaceTexture(long hardwareLayer) {
        HardwareRenderer.nDetachSurfaceTexture(this.mNativeProxy, hardwareLayer);
    }

    public void buildLayer(RenderNode node) {
        if (node.hasDisplayList()) {
            HardwareRenderer.nBuildLayer(this.mNativeProxy, node.mNativeRenderNode);
        }
    }

    public boolean copyLayerInto(TextureLayer layer, Bitmap bitmap) {
        return HardwareRenderer.nCopyLayerInto(this.mNativeProxy, layer.getDeferredLayerUpdater(), bitmap.getNativeInstance());
    }

    public void pushLayerUpdate(TextureLayer layer) {
        HardwareRenderer.nPushLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    public void onLayerDestroyed(TextureLayer layer) {
        HardwareRenderer.nCancelLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    protected void setASurfaceTransactionCallback(ASurfaceTransactionCallback callback) {
        HardwareRenderer.nSetASurfaceTransactionCallback(this.mNativeProxy, callback);
    }

    protected void setPrepareSurfaceControlForWebviewCallback(PrepareSurfaceControlForWebviewCallback callback) {
        HardwareRenderer.nSetPrepareSurfaceControlForWebviewCallback(this.mNativeProxy, callback);
    }

    public void setFrameCallback(FrameDrawingCallback callback) {
        HardwareRenderer.nSetFrameCallback(this.mNativeProxy, callback);
    }

    public void addRenderNode(RenderNode node, boolean placeFront) {
        HardwareRenderer.nAddRenderNode(this.mNativeProxy, node.mNativeRenderNode, placeFront);
    }

    public void removeRenderNode(RenderNode node) {
        HardwareRenderer.nRemoveRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    public void drawRenderNode(RenderNode node) {
        HardwareRenderer.nDrawRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    public boolean loadSystemProperties() {
        return HardwareRenderer.nLoadSystemProperties(this.mNativeProxy);
    }

    public static void dumpGlobalProfileInfo(FileDescriptor fd, int dumpFlags) {
        HardwareRenderer.nDumpGlobalProfileInfo(fd, dumpFlags);
    }

    public void dumpProfileInfo(FileDescriptor fd, int dumpFlags) {
        HardwareRenderer.nDumpProfileInfo(this.mNativeProxy, fd, dumpFlags);
    }

    public void setContentDrawBounds(int left, int top, int right, int bottom) {
        HardwareRenderer.nSetContentDrawBounds(this.mNativeProxy, left, top, right, bottom);
    }

    public void forceDrawNextFrame() {
        HardwareRenderer.nForceDrawNextFrame(this.mNativeProxy);
    }

    public void setPictureCaptureCallback(@Nullable PictureCapturedCallback callback) {
        HardwareRenderer.nSetPictureCaptureCallback(this.mNativeProxy, callback);
    }

    static void invokePictureCapturedCallback(long picturePtr, PictureCapturedCallback callback) {
        Picture picture = new Picture(picturePtr);
        callback.onPictureCaptured(picture);
    }

    private static void validateAlpha(float alpha, String argumentName) {
        if (!(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            throw new IllegalArgumentException(argumentName + " must be a valid alpha, " + alpha + " is not in the range of 0.0f to 1.0f");
        }
    }

    private static void validatePositive(float f, String argumentName) {
        if (!Float.isFinite(f) || !(f >= 0.0f)) {
            throw new IllegalArgumentException(argumentName + " must be a finite positive, given=" + f);
        }
    }

    private static void validateFinite(float f, String argumentName) {
        if (!Float.isFinite(f)) {
            throw new IllegalArgumentException(argumentName + " must be finite, given=" + f);
        }
    }

    public void notifyCallbackPending() {
        HardwareRenderer.nNotifyCallbackPending(this.mNativeProxy);
    }

    public void notifyExpensiveFrame() {
        HardwareRenderer.nNotifyExpensiveFrame(this.mNativeProxy);
    }

    public int notifyExpensiveFrameWithRateLimit(String reason) {
        return this.mNotifyExpensiveFrameRateLimiter.notifyIfAllow(reason);
    }

    public int notifyRendererForGpuLoadUp(String reason) {
        return this.mNotifyGpuLoadUpRateLimiter.notifyIfAllow(reason);
    }

    private void notifyGpuLoadUp() {
        HardwareRenderer.nNotifyGpuLoadUp(this.mNativeProxy);
    }

    public static void setFPSDivisor(int divisor) {
        HardwareRenderer.nSetRtAnimationsEnabled(divisor <= 1);
    }

    public static void setContextPriority(int priority) {
        HardwareRenderer.nSetContextPriority(priority);
    }

    public static void setHighContrastText(boolean highContrastText) {
        HardwareRenderer.nSetHighContrastText(highContrastText);
    }

    public static void setIsolatedProcess(boolean isIsolated) {
        HardwareRenderer.nSetIsolatedProcess(isIsolated);
        ProcessInitializer.sInstance.setIsolated(isIsolated);
    }

    public static void sendDeviceConfigurationForDebugging(Configuration config) {
        if (config.densityDpi != 0 && config.densityDpi != sDensityDpi) {
            sDensityDpi = config.densityDpi;
            HardwareRenderer.nSetDisplayDensityDpi(config.densityDpi);
        }
    }

    public static void setDebuggingEnabled(boolean enable) {
        HardwareRenderer.nSetDebuggingEnabled(enable);
    }

    public static void copySurfaceInto(Surface surface, CopyRequest copyRequest) {
        Rect srcRect = copyRequest.mSrcRect;
        HardwareRenderer.nCopySurfaceInto(surface, srcRect.left, srcRect.top, srcRect.right, srcRect.bottom, copyRequest);
    }

    public static Bitmap createHardwareBitmap(RenderNode node, int width, int height) {
        return HardwareRenderer.nCreateHardwareBitmap(node.mNativeRenderNode, width, height);
    }

    public static void trimMemory(int level) {
        HardwareRenderer.nTrimMemory(level);
    }

    public static void trimCaches(int level) {
        HardwareRenderer.nTrimCaches(level);
    }

    public static void overrideProperty(@NonNull String name, @NonNull String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value must be non-null");
        }
        HardwareRenderer.nOverrideProperty(name, value);
    }

    public static void setupDiskCache(File cacheDir) {
        HardwareRenderer.setupShadersDiskCache(new File(cacheDir, CACHE_PATH_SHADERS).getAbsolutePath(), new File(cacheDir, CACHE_PATH_SKIASHADERS).getAbsolutePath());
    }

    public static void setPackageName(String packageName) {
        ProcessInitializer.sInstance.setPackageName(packageName);
    }

    public static void setContextForInit(Context context) {
        ProcessInitializer.sInstance.setContext(context);
    }

    public static void setIsSystemOrPersistent() {
        HardwareRenderer.nSetIsSystemOrPersistent(true);
    }

    public static boolean isDrawingEnabled() {
        return HardwareRenderer.nIsDrawingEnabled();
    }

    public static void setDrawingEnabled(boolean drawingEnabled) {
        HardwareRenderer.nSetDrawingEnabled(drawingEnabled);
    }

    public static void setRtAnimationsEnabled(boolean enabled) {
        HardwareRenderer.nSetRtAnimationsEnabled(enabled);
    }

    public static native void disableVsync();

    public static native void preload();

    public static native void preInitBufferAllocator();

    protected static native boolean isWebViewOverlaysEnabled();

    protected static native void setupShadersDiskCache(String var0, String var1);

    private static native void nRotateProcessStatsBuffer();

    private static native void nSetProcessStatsBuffer(int var0);

    private static native int nGetRenderThreadTid(long var0);

    private static native long nCreateRootRenderNode();

    private static native long nCreateProxy(boolean var0, long var1);

    private static native void nDeleteProxy(long var0);

    private static native boolean nLoadSystemProperties(long var0);

    private static native void nSetName(long var0, String var2);

    private static native void nSetSurface(long var0, Surface var2, boolean var3);

    private static native void nSetSurfaceControl(long var0, long var2);

    private static native boolean nPause(long var0);

    private static native void nSetStopped(long var0, boolean var2);

    private static native void nSetLightGeometry(long var0, float var2, float var3, float var4, float var5);

    private static native void nSetLightAlpha(long var0, float var2, float var3);

    private static native void nSetOpaque(long var0, boolean var2);

    private static native float nSetColorMode(long var0, int var2);

    private static native void nSetTargetSdrHdrRatio(long var0, float var2);

    private static native void nSetSdrWhitePoint(long var0, float var2);

    private static native void nSetIsHighEndGfx(boolean var0);

    private static native void nSetIsLowRam(boolean var0);

    private static native void nSetIsSystemOrPersistent(boolean var0);

    private static native int nSyncAndDrawFrame(long var0, long[] var2, int var3);

    private static native void nDestroy(long var0, long var2);

    private static native void nRegisterAnimatingRenderNode(long var0, long var2);

    private static native void nRegisterVectorDrawableAnimator(long var0, long var2);

    private static native long nCreateTextureLayer(long var0);

    private static native void nBuildLayer(long var0, long var2);

    private static native boolean nCopyLayerInto(long var0, long var2, long var4);

    private static native void nPushLayerUpdate(long var0, long var2);

    private static native void nCancelLayerUpdate(long var0, long var2);

    private static native void nDetachSurfaceTexture(long var0, long var2);

    private static native void nDestroyHardwareResources(long var0);

    private static native void nTrimMemory(int var0);

    private static native void nTrimCaches(int var0);

    private static native void nOverrideProperty(String var0, String var1);

    private static native void nFence(long var0);

    private static native void nStopDrawing(long var0);

    private static native void nNotifyFramePending(long var0);

    private static native void nDumpProfileInfo(long var0, FileDescriptor var2, int var3);

    private static native void nDumpGlobalProfileInfo(FileDescriptor var0, int var1);

    private static native void nAddRenderNode(long var0, long var2, boolean var4);

    private static native void nRemoveRenderNode(long var0, long var2);

    private static native void nDrawRenderNode(long var0, long var2);

    private static native void nSetContentDrawBounds(long var0, int var2, int var3, int var4, int var5);

    private static native void nForceDrawNextFrame(long var0);

    private static native void nSetPictureCaptureCallback(long var0, PictureCapturedCallback var2);

    private static native void nSetASurfaceTransactionCallback(long var0, ASurfaceTransactionCallback var2);

    private static native void nSetPrepareSurfaceControlForWebviewCallback(long var0, PrepareSurfaceControlForWebviewCallback var2);

    private static native void nSetFrameCallback(long var0, FrameDrawingCallback var2);

    private static native void nSetFrameCommitCallback(long var0, FrameCommitCallback var2);

    private static native void nSetFrameCompleteCallback(long var0, FrameCompleteCallback var2);

    private static native void nAddObserver(long var0, long var2);

    private static native void nRemoveObserver(long var0, long var2);

    private static native void nCopySurfaceInto(Surface var0, int var1, int var2, int var3, int var4, CopyRequest var5);

    private static native Bitmap nCreateHardwareBitmap(long var0, int var2, int var3);

    private static native void nSetHighContrastText(boolean var0);

    private static native void nSetDebuggingEnabled(boolean var0);

    private static native void nSetIsolatedProcess(boolean var0);

    private static native void nSetContextPriority(int var0);

    private static native void nAllocateBuffers(long var0);

    private static native void nSetForceDark(long var0, int var2);

    private static native void nSetDisplayDensityDpi(int var0);

    private static native void nInitDisplayInfo(int var0, int var1, float var2, int var3, long var4, long var6, boolean var8, boolean var9, boolean var10);

    private static native void nSetDrawingEnabled(boolean var0);

    private static native boolean nIsDrawingEnabled();

    private static native void nSetRtAnimationsEnabled(boolean var0);

    private static native void nNotifyCallbackPending(long var0);

    private static native void nNotifyExpensiveFrame(long var0);

    private static native void nNotifyGpuLoadUp(long var0);

    private static class NotifyRendererRateLimiter
    extends RateLimitingCache<Void> {
        private static final long DEFAULT_NOTIFY_PERIOD_MILLIS = 100L;
        @NonNull
        private final RateLimitingCache.ValueFetcher<Void> mNotifyRendererRunnable;
        @NonNull
        private final Runnable mRunnable;
        private int mNotifyCount;
        @Nullable
        private String mNotifyReason;

        NotifyRendererRateLimiter(String reason, @NonNull Runnable runnable, long periodMillis) {
            super(periodMillis);
            this.mRunnable = runnable;
            this.mNotifyRendererRunnable = () -> {
                String notifyReason = this.getNotifyReason();
                boolean logForReason = notifyReason != null && !notifyReason.isEmpty();
                try {
                    String traceReason = logForReason ? reason + ":" + notifyReason : reason;
                    Trace.traceBegin(8L, traceReason);
                    this.mRunnable.run();
                }
                finally {
                    Trace.traceEnd(8L);
                }
                this.incrementNotifyCount();
                return null;
            };
        }

        private int notifyIfAllow(String reason) {
            this.mNotifyReason = reason;
            this.get(this.mNotifyRendererRunnable);
            return this.mNotifyCount;
        }

        private void incrementNotifyCount() {
            ++this.mNotifyCount;
        }

        @Nullable
        private String getNotifyReason() {
            return this.mNotifyReason;
        }
    }

    public class FrameRenderRequest {
        private FrameInfo mFrameInfo = new FrameInfo();
        private boolean mWaitForPresent;

        private FrameRenderRequest() {
        }

        private void reset() {
            this.mWaitForPresent = false;
            HardwareRenderer.this.mRenderRequest.setVsyncTime(AnimationUtils.currentAnimationTimeMillis() * 1000000L);
        }

        public void setFrameInfo(FrameInfo info) {
            System.arraycopy(info.frameInfo, 0, this.mFrameInfo.frameInfo, 0, info.frameInfo.length);
        }

        @NonNull
        public FrameRenderRequest setVsyncTime(long vsyncTime) {
            this.mFrameInfo.setVsync(vsyncTime, vsyncTime, -1L, Long.MAX_VALUE, vsyncTime, -1L);
            this.mFrameInfo.addFlags(4L);
            return this;
        }

        @NonNull
        public FrameRenderRequest setFrameCommitCallback(@NonNull Executor executor, @NonNull Runnable frameCommitCallback) {
            HardwareRenderer.nSetFrameCommitCallback(HardwareRenderer.this.mNativeProxy, didProduceBuffer -> executor.execute(frameCommitCallback));
            return this;
        }

        @NonNull
        public FrameRenderRequest setWaitForPresent(boolean shouldWait) {
            this.mWaitForPresent = shouldWait;
            return this;
        }

        public int syncAndDraw() {
            int syncResult = HardwareRenderer.this.syncAndDrawFrame(this.mFrameInfo);
            if (this.mWaitForPresent && (syncResult & 8) == 0) {
                HardwareRenderer.this.fence();
            }
            return syncResult;
        }
    }

    private static class ProcessInitializer {
        static ProcessInitializer sInstance = new ProcessInitializer();
        private boolean mInitialized = false;
        private boolean mDisplayInitialized = false;
        private boolean mIsolated = false;
        private Context mContext;
        private String mPackageName;
        private IGraphicsStats mGraphicsStatsService;
        private IGraphicsStatsCallback mGraphicsStatsCallback = new IGraphicsStatsCallback.Stub(){

            @Override
            public void onRotateGraphicsStatsBuffer() throws RemoteException {
                this.rotateBuffer();
            }
        };

        private ProcessInitializer() {
        }

        synchronized void setPackageName(String name) {
            if (this.mInitialized) {
                return;
            }
            this.mPackageName = name;
        }

        synchronized void setIsolated(boolean isolated) {
            if (this.mInitialized) {
                return;
            }
            this.mIsolated = isolated;
        }

        synchronized void setContext(Context context) {
            if (this.mInitialized) {
                return;
            }
            this.mContext = context;
        }

        synchronized void init(long renderProxy) {
            if (this.mInitialized) {
                return;
            }
            this.mInitialized = true;
            this.initSched(renderProxy);
            this.initGraphicsStats();
        }

        private void initSched(long renderProxy) {
            try {
                int tid = HardwareRenderer.nGetRenderThreadTid(renderProxy);
                ActivityManager.getService().setRenderThread(tid);
            }
            catch (Throwable t) {
                Log.w(HardwareRenderer.LOG_TAG, "Failed to set scheduler for RenderThread", t);
            }
        }

        private void initGraphicsStats() {
            if (this.mPackageName == null) {
                return;
            }
            try {
                IBinder binder = ServiceManager.getService("graphicsstats");
                if (binder == null) {
                    return;
                }
                this.mGraphicsStatsService = IGraphicsStats.Stub.asInterface(binder);
                this.requestBuffer();
            }
            catch (Throwable t) {
                Log.w(HardwareRenderer.LOG_TAG, "Could not acquire gfx stats buffer", t);
            }
        }

        synchronized void initUsingContext() {
            if (this.mContext == null) {
                return;
            }
            this.initDisplayInfo();
            HardwareRenderer.nSetIsHighEndGfx(ActivityManager.isHighEndGfx());
            HardwareRenderer.nSetIsLowRam(ActivityManager.isLowRamDeviceStatic());
            this.mContext = null;
        }

        private void initDisplayInfo() {
            if (this.mDisplayInitialized) {
                return;
            }
            if (this.mIsolated) {
                this.mDisplayInitialized = true;
                return;
            }
            DisplayManager dm = (DisplayManager)this.mContext.getSystemService("display");
            if (dm == null) {
                Log.d(HardwareRenderer.LOG_TAG, "Failed to find DisplayManager for display-based configuration");
                return;
            }
            Display defaultDisplay = dm.getDisplay(0);
            if (defaultDisplay == null) {
                Log.d(HardwareRenderer.LOG_TAG, "Failed to find default display for display-based configuration");
                return;
            }
            Display[] allDisplays = dm.getDisplays();
            if (allDisplays.length == 0) {
                Log.d(HardwareRenderer.LOG_TAG, "Failed to query displays");
                return;
            }
            Display.Mode activeMode = defaultDisplay.getMode();
            ColorSpace defaultWideColorSpace = defaultDisplay.getPreferredWideGamutColorSpace();
            int wideColorDataspace = defaultWideColorSpace != null ? defaultWideColorSpace.getDataSpace() : 0;
            int largestWidth = activeMode.getPhysicalWidth();
            int largestHeight = activeMode.getPhysicalHeight();
            OverlayProperties overlayProperties = defaultDisplay.getOverlaySupport();
            for (int i = 0; i < allDisplays.length; ++i) {
                ColorSpace cs;
                Display display = allDisplays[i];
                if (wideColorDataspace == 0 && (cs = display.getPreferredWideGamutColorSpace()) != null) {
                    wideColorDataspace = cs.getDataSpace();
                }
                Display.Mode[] modes = display.getSupportedModes();
                for (int j = 0; j < modes.length; ++j) {
                    int height;
                    Display.Mode mode = modes[j];
                    int width = mode.getPhysicalWidth();
                    if (width * (height = mode.getPhysicalHeight()) <= largestWidth * largestHeight) continue;
                    largestWidth = width;
                    largestHeight = height;
                }
            }
            HardwareRenderer.nInitDisplayInfo(largestWidth, largestHeight, defaultDisplay.getRefreshRate(), wideColorDataspace, defaultDisplay.getAppVsyncOffsetNanos(), defaultDisplay.getPresentationDeadlineNanos(), overlayProperties.isCombinationSupported(0x18810000, 22), overlayProperties.isCombinationSupported(DataSpace.pack(655360, 0x800000, 0x18000000), 59), overlayProperties.isMixedColorSpacesSupported());
            this.mDisplayInitialized = true;
        }

        private void rotateBuffer() {
            HardwareRenderer.nRotateProcessStatsBuffer();
            this.requestBuffer();
        }

        private void requestBuffer() {
            try {
                ParcelFileDescriptor pfd = this.mGraphicsStatsService.requestBufferForProcess(this.mPackageName, this.mGraphicsStatsCallback);
                HardwareRenderer.nSetProcessStatsBuffer(pfd.getFd());
                pfd.close();
            }
            catch (Throwable t) {
                Log.w(HardwareRenderer.LOG_TAG, "Could not acquire gfx stats buffer", t);
            }
        }
    }

    private static class DestroyContextRunnable
    implements Runnable {
        private final long mNativeInstance;

        DestroyContextRunnable(long nativeInstance) {
            this.mNativeInstance = nativeInstance;
        }

        @Override
        public void run() {
            HardwareRenderer.nDeleteProxy(this.mNativeInstance);
        }
    }

    public static interface FrameCommitCallback {
        public void onFrameCommit(boolean var1);
    }

    public static interface FrameCompleteCallback {
        public void onFrameComplete();
    }

    public static interface ASurfaceTransactionCallback {
        public boolean onMergeTransaction(long var1, long var3, long var5);
    }

    public static interface PrepareSurfaceControlForWebviewCallback {
        public void prepare();
    }

    public static interface FrameDrawingCallback {
        public void onFrameDraw(long var1);

        default public FrameCommitCallback onFrameDraw(int syncResult, long frame) {
            this.onFrameDraw(frame);
            return null;
        }
    }

    public static interface PictureCapturedCallback {
        public void onPictureCaptured(Picture var1);
    }

    public static abstract class CopyRequest {
        protected Bitmap mDestinationBitmap;
        final Rect mSrcRect;

        protected CopyRequest(Rect srcRect, Bitmap destinationBitmap) {
            this.mDestinationBitmap = destinationBitmap;
            this.mSrcRect = srcRect != null ? srcRect : new Rect();
        }

        public long getDestinationBitmap(int srcWidth, int srcHeight) {
            if (this.mDestinationBitmap == null) {
                this.mDestinationBitmap = Bitmap.createBitmap(srcWidth, srcHeight, Bitmap.Config.ARGB_8888);
            }
            return this.mDestinationBitmap.getNativeInstance();
        }

        public abstract void onCopyFinished(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CacheTrimLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DumpFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SyncAndDrawResult {
    }
}

