/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.BaseCanvas;
import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.Canvas_Delegate;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Matrix44;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RenderNode;
import android.graphics.Shader;
import android.graphics.fonts.Font;
import android.graphics.text.MeasuredText;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class Canvas
extends BaseCanvas {
    private static int sCompatibilityVersion = 0;
    private static boolean sCompatibilityRestore = false;
    private static boolean sCompatibilitySetBitmap = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=117521088L)
    private Bitmap mBitmap;
    private DrawFilter mDrawFilter;
    private static final int MAXIMUM_BITMAP_SIZE = 32766;
    private Runnable mFinalizer;
    public static final int MATRIX_SAVE_FLAG = 1;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int ALL_SAVE_FLAG = 31;

    @UnsupportedAppUsage
    public long getNativeCanvasWrapper() {
        return this.mNativeCanvasWrapper;
    }

    public Canvas() {
        if (!this.isHardwareAccelerated()) {
            this.mNativeCanvasWrapper = Canvas.nInitRaster(0L);
            this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeCanvasWrapper);
        } else {
            this.mFinalizer = null;
        }
    }

    public Canvas(@NonNull Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        this.throwIfCannotDraw(bitmap);
        bitmap.setGainmap(null);
        this.mNativeCanvasWrapper = Canvas.nInitRaster(bitmap.getNativeInstance());
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeCanvasWrapper);
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public Canvas(long nativeCanvas) {
        if (nativeCanvas == 0L) {
            throw new IllegalStateException();
        }
        this.mNativeCanvasWrapper = nativeCanvas;
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeCanvasWrapper);
        this.mDensity = Bitmap.getDefaultDensity();
    }

    @Override
    public boolean isHardwareAccelerated() {
        return false;
    }

    public boolean isHighContrastTextEnabled() {
        return Canvas.nIsHighContrastText(this.mNativeCanvasWrapper);
    }

    public void setBitmap(@Nullable Bitmap bitmap) {
        if (this.isHardwareAccelerated()) {
            throw new RuntimeException("Can't set a bitmap device on a HW accelerated canvas");
        }
        Matrix preservedMatrix = null;
        if (bitmap != null && sCompatibilitySetBitmap) {
            preservedMatrix = this.getMatrix();
        }
        if (bitmap == null) {
            Canvas.nSetBitmap(this.mNativeCanvasWrapper, 0L);
            this.mDensity = 0;
        } else {
            if (!bitmap.isMutable()) {
                throw new IllegalStateException();
            }
            this.throwIfCannotDraw(bitmap);
            bitmap.setGainmap(null);
            Canvas.nSetBitmap(this.mNativeCanvasWrapper, bitmap.getNativeInstance());
            this.mDensity = bitmap.mDensity;
        }
        if (preservedMatrix != null) {
            this.setMatrix(preservedMatrix);
        }
        this.mBitmap = bitmap;
    }

    public void enableZ() {
    }

    public void disableZ() {
    }

    public boolean isOpaque() {
        return Canvas.nIsOpaque(this.mNativeCanvasWrapper);
    }

    public int getWidth() {
        return Canvas.nGetWidth(this.mNativeCanvasWrapper);
    }

    public int getHeight() {
        return Canvas.nGetHeight(this.mNativeCanvasWrapper);
    }

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    @UnsupportedAppUsage
    public void setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    public int getMaximumBitmapWidth() {
        return 32766;
    }

    public int getMaximumBitmapHeight() {
        return 32766;
    }

    private static void checkValidSaveFlags(int saveFlags) {
        if (sCompatibilityVersion >= 28 && saveFlags != 31) {
            throw new IllegalArgumentException("Invalid Layer Save Flag - only ALL_SAVE_FLAGS is allowed");
        }
    }

    public int save() {
        return Canvas.nSave(this.mNativeCanvasWrapper, 3);
    }

    public int save(int saveFlags) {
        return Canvas.nSave(this.mNativeCanvasWrapper, saveFlags);
    }

    public int saveLayer(@Nullable RectF bounds, @Nullable Paint paint, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        Canvas.checkValidSaveFlags(saveFlags);
        return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, 31);
    }

    public int saveLayer(@Nullable RectF bounds, @Nullable Paint paint) {
        return this.saveLayer(bounds, paint, 31);
    }

    public int saveUnclippedLayer(int left, int top, int right, int bottom) {
        return Canvas.nSaveUnclippedLayer(this.mNativeCanvasWrapper, left, top, right, bottom);
    }

    public void restoreUnclippedLayer(int saveCount, Paint paint) {
        Canvas.nRestoreUnclippedLayer(this.mNativeCanvasWrapper, saveCount, paint.getNativeInstance());
    }

    public int saveLayer(float left, float top, float right, float bottom, @Nullable Paint paint, int saveFlags) {
        Canvas.checkValidSaveFlags(saveFlags);
        return Canvas.nSaveLayer(this.mNativeCanvasWrapper, left, top, right, bottom, paint != null ? paint.getNativeInstance() : 0L);
    }

    public int saveLayer(float left, float top, float right, float bottom, @Nullable Paint paint) {
        return this.saveLayer(left, top, right, bottom, paint, 31);
    }

    public int saveLayerAlpha(@Nullable RectF bounds, int alpha, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        Canvas.checkValidSaveFlags(saveFlags);
        return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, 31);
    }

    public int saveLayerAlpha(@Nullable RectF bounds, int alpha) {
        return this.saveLayerAlpha(bounds, alpha, 31);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        Canvas.checkValidSaveFlags(saveFlags);
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.nSaveLayerAlpha(this.mNativeCanvasWrapper, left, top, right, bottom, alpha);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha) {
        return this.saveLayerAlpha(left, top, right, bottom, alpha, 31);
    }

    public void restore() {
        if (!(Canvas.nRestore(this.mNativeCanvasWrapper) || sCompatibilityRestore && this.isHardwareAccelerated())) {
            throw new IllegalStateException("Underflow in restore - more restores than saves");
        }
    }

    public int getSaveCount() {
        return Canvas.nGetSaveCount(this.mNativeCanvasWrapper);
    }

    public void restoreToCount(int saveCount) {
        if (saveCount < 1) {
            if (!sCompatibilityRestore || !this.isHardwareAccelerated()) {
                throw new IllegalArgumentException("Underflow in restoreToCount - more restores than saves");
            }
            saveCount = 1;
        }
        Canvas.nRestoreToCount(this.mNativeCanvasWrapper, saveCount);
    }

    public void translate(float dx, float dy) {
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        Canvas.nTranslate(this.mNativeCanvasWrapper, dx, dy);
    }

    public void scale(float sx, float sy) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        Canvas.nScale(this.mNativeCanvasWrapper, sx, sy);
    }

    public final void scale(float sx, float sy, float px, float py) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    public void rotate(float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        Canvas.nRotate(this.mNativeCanvasWrapper, degrees);
    }

    public final void rotate(float degrees, float px, float py) {
        if (degrees == 0.0f) {
            return;
        }
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    public void skew(float sx, float sy) {
        if (sx == 0.0f && sy == 0.0f) {
            return;
        }
        Canvas.nSkew(this.mNativeCanvasWrapper, sx, sy);
    }

    public void concat(@Nullable Matrix matrix) {
        if (matrix != null) {
            Canvas.nConcat(this.mNativeCanvasWrapper, matrix.ni());
        }
    }

    @FlaggedApi(value="com.android.graphics.hwui.flags.matrix_44")
    public void concat(@Nullable Matrix44 m) {
        if (m != null) {
            Canvas.nConcat(this.mNativeCanvasWrapper, m.mBackingArray);
        }
    }

    public void setMatrix(@Nullable Matrix matrix) {
        Canvas.nSetMatrix(this.mNativeCanvasWrapper, matrix == null ? 0L : matrix.ni());
    }

    @Deprecated
    public void getMatrix(@NonNull Matrix ctm) {
        Canvas.nGetMatrix(this.mNativeCanvasWrapper, ctm.ni());
    }

    @Deprecated
    @NonNull
    public final Matrix getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    private static void checkValidClipOp(@NonNull Region.Op op) {
        if (sCompatibilityVersion >= 28 && op != Region.Op.INTERSECT && op != Region.Op.DIFFERENCE) {
            throw new IllegalArgumentException("Invalid Region.Op - only INTERSECT and DIFFERENCE are allowed");
        }
    }

    @Deprecated
    public boolean clipRect(@NonNull RectF rect, @NonNull Region.Op op) {
        Canvas.checkValidClipOp(op);
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Deprecated
    public boolean clipRect(@NonNull Rect rect, @NonNull Region.Op op) {
        Canvas.checkValidClipOp(op);
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRectUnion(@NonNull Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.UNION.nativeInt);
    }

    public boolean clipRect(@NonNull RectF rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(@NonNull RectF rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    public boolean clipRect(@NonNull Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(@NonNull Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    @Deprecated
    public boolean clipRect(float left, float top, float right, float bottom, @NonNull Region.Op op) {
        Canvas.checkValidClipOp(op);
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(float left, float top, float right, float bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(float left, float top, float right, float bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(int left, int top, int right, int bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    @Deprecated
    public boolean clipPath(@NonNull Path path, @NonNull Region.Op op) {
        Canvas.checkValidClipOp(op);
        return Canvas.nClipPath(this.mNativeCanvasWrapper, path.readOnlyNI(), op.nativeInt);
    }

    public boolean clipPath(@NonNull Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipOutPath(@NonNull Path path) {
        return this.clipPath(path, Region.Op.DIFFERENCE);
    }

    @Deprecated
    public boolean clipRegion(@NonNull Region region, @NonNull Region.Op op) {
        return false;
    }

    @Deprecated
    public boolean clipRegion(@NonNull Region region) {
        return false;
    }

    @FlaggedApi(value="com.android.graphics.hwui.flags.clip_shader")
    public void clipShader(@NonNull Shader shader) {
        Canvas.nClipShader(this.mNativeCanvasWrapper, shader.getNativeInstance(), Region.Op.INTERSECT.nativeInt);
    }

    @FlaggedApi(value="com.android.graphics.hwui.flags.clip_shader")
    public void clipOutShader(@NonNull Shader shader) {
        Canvas.nClipShader(this.mNativeCanvasWrapper, shader.getNativeInstance(), Region.Op.DIFFERENCE.nativeInt);
    }

    @Nullable
    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public void setDrawFilter(@Nullable DrawFilter filter) {
        long nativeFilter = 0L;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nSetDrawFilter(this.mNativeCanvasWrapper, nativeFilter);
    }

    @Deprecated
    public boolean quickReject(@NonNull RectF rect, @NonNull EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean quickReject(@NonNull RectF rect) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom);
    }

    @Deprecated
    public boolean quickReject(@NonNull Path path, @NonNull EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, path.readOnlyNI());
    }

    public boolean quickReject(@NonNull Path path) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, path.readOnlyNI());
    }

    @Deprecated
    public boolean quickReject(float left, float top, float right, float bottom, @NonNull EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, left, top, right, bottom);
    }

    public boolean quickReject(float left, float top, float right, float bottom) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, left, top, right, bottom);
    }

    public boolean getClipBounds_Original(@NonNull Rect bounds) {
        return Canvas.nGetClipBounds(this.mNativeCanvasWrapper, bounds);
    }

    @LayoutlibDelegate
    public boolean getClipBounds(Rect rect) {
        return Canvas_Delegate.getClipBounds(this, rect);
    }

    @NonNull
    public final Rect getClipBounds_Original() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    @LayoutlibDelegate
    public final Rect getClipBounds() {
        return Canvas_Delegate.getClipBounds(this);
    }

    public void drawPicture(@NonNull Picture picture) {
        picture.endRecording();
        int restoreCount = this.save();
        picture.draw(this);
        this.restoreToCount(restoreCount);
    }

    public void drawPicture(@NonNull Picture picture, @NonNull RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(@NonNull Picture picture, @NonNull Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void release() {
        this.mNativeCanvasWrapper = 0L;
        if (this.mFinalizer != null) {
            this.mFinalizer.run();
            this.mFinalizer = null;
        }
    }

    @UnsupportedAppUsage
    public static void freeCaches() {
        Canvas.nFreeCaches();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void freeTextLayoutCaches() {
        Canvas.nFreeTextLayoutCaches();
    }

    static void setCompatibilityVersion(int apiLevel) {
        sCompatibilityVersion = apiLevel;
        sCompatibilityRestore = apiLevel < 23;
        sCompatibilitySetBitmap = apiLevel < 26;
        Canvas.nSetCompatibilityVersion(apiLevel);
    }

    private static native void nFreeCaches();

    private static native void nFreeTextLayoutCaches();

    private static native long nGetNativeFinalizer();

    private static native void nSetCompatibilityVersion(int var0);

    @FastNative
    private static native long nInitRaster(long var0);

    @FastNative
    private static native void nSetBitmap(long var0, long var2);

    @FastNative
    private static native boolean nGetClipBounds(long var0, Rect var2);

    @CriticalNative
    private static native boolean nIsOpaque(long var0);

    @CriticalNative
    private static native boolean nIsHighContrastText(long var0);

    @CriticalNative
    private static native int nGetWidth(long var0);

    @CriticalNative
    private static native int nGetHeight(long var0);

    @CriticalNative
    private static native int nSave(long var0, int var2);

    @CriticalNative
    private static native int nSaveLayer(long var0, float var2, float var3, float var4, float var5, long var6);

    @CriticalNative
    private static native int nSaveLayerAlpha(long var0, float var2, float var3, float var4, float var5, int var6);

    @CriticalNative
    private static native int nSaveUnclippedLayer(long var0, int var2, int var3, int var4, int var5);

    @CriticalNative
    private static native void nRestoreUnclippedLayer(long var0, int var2, long var3);

    @CriticalNative
    private static native boolean nRestore(long var0);

    @CriticalNative
    private static native void nRestoreToCount(long var0, int var2);

    @CriticalNative
    private static native int nGetSaveCount(long var0);

    @CriticalNative
    private static native void nTranslate(long var0, float var2, float var3);

    @CriticalNative
    private static native void nScale(long var0, float var2, float var3);

    @CriticalNative
    private static native void nRotate(long var0, float var2);

    @CriticalNative
    private static native void nSkew(long var0, float var2, float var3);

    @CriticalNative
    private static native void nConcat(long var0, long var2);

    @FastNative
    private static native void nConcat(long var0, float[] var2);

    @CriticalNative
    private static native void nSetMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nClipRect(long var0, float var2, float var3, float var4, float var5, int var6);

    @CriticalNative
    private static native boolean nClipPath(long var0, long var2, int var4);

    @CriticalNative
    private static native void nClipShader(long var0, long var2, int var4);

    @CriticalNative
    private static native void nSetDrawFilter(long var0, long var2);

    @CriticalNative
    private static native void nGetMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nQuickReject(long var0, long var2);

    @CriticalNative
    private static native boolean nQuickReject(long var0, float var2, float var3, float var4, float var5);

    @Override
    public void drawArc(@NonNull RectF oval, float startAngle, float sweepAngle, boolean useCenter, @NonNull Paint paint) {
        super.drawArc(oval, startAngle, sweepAngle, useCenter, paint);
    }

    @Override
    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, @NonNull Paint paint) {
        super.drawArc(left, top, right, bottom, startAngle, sweepAngle, useCenter, paint);
    }

    @Override
    public void drawARGB(int a, int r, int g, int b) {
        super.drawARGB(a, r, g, b);
    }

    @Override
    public void drawBitmap(@NonNull Bitmap bitmap, float left, float top, @Nullable Paint paint) {
        super.drawBitmap(bitmap, left, top, paint);
    }

    @Override
    public void drawBitmap(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull RectF dst, @Nullable Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
    }

    @Override
    public void drawBitmap(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull Rect dst, @Nullable Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
    }

    @Override
    @Deprecated
    public void drawBitmap(@NonNull int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, @Nullable Paint paint) {
        super.drawBitmap(colors, offset, stride, x, y, width, height, hasAlpha, paint);
    }

    @Override
    @Deprecated
    public void drawBitmap(@NonNull int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, @Nullable Paint paint) {
        super.drawBitmap(colors, offset, stride, x, y, width, height, hasAlpha, paint);
    }

    @Override
    public void drawBitmap(@NonNull Bitmap bitmap, @NonNull Matrix matrix, @Nullable Paint paint) {
        super.drawBitmap(bitmap, matrix, paint);
    }

    @Override
    public void drawBitmapMesh(@NonNull Bitmap bitmap, int meshWidth, int meshHeight, @NonNull float[] verts, int vertOffset, @Nullable int[] colors, int colorOffset, @Nullable Paint paint) {
        super.drawBitmapMesh(bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint);
    }

    @Override
    public void drawCircle(float cx, float cy, float radius, @NonNull Paint paint) {
        super.drawCircle(cx, cy, radius, paint);
    }

    @Override
    public void drawColor(int color2) {
        super.drawColor(color2);
    }

    public void drawColor(long color2) {
        super.drawColor(color2, BlendMode.SRC_OVER);
    }

    @Override
    public void drawColor(int color2, @NonNull PorterDuff.Mode mode) {
        super.drawColor(color2, mode);
    }

    @Override
    public void drawColor(int color2, @NonNull BlendMode mode) {
        super.drawColor(color2, mode);
    }

    @Override
    public void drawColor(long color2, @NonNull BlendMode mode) {
        super.drawColor(color2, mode);
    }

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, @NonNull Paint paint) {
        super.drawLine(startX, startY, stopX, stopY, paint);
    }

    @Override
    public void drawLines(@NonNull float[] pts, int offset, int count, @NonNull Paint paint) {
        super.drawLines(pts, offset, count, paint);
    }

    @Override
    public void drawLines(@NonNull float[] pts, @NonNull Paint paint) {
        super.drawLines(pts, paint);
    }

    @Override
    public void drawOval(@NonNull RectF oval, @NonNull Paint paint) {
        super.drawOval(oval, paint);
    }

    @Override
    public void drawOval(float left, float top, float right, float bottom, @NonNull Paint paint) {
        super.drawOval(left, top, right, bottom, paint);
    }

    @Override
    public void drawPaint(@NonNull Paint paint) {
        super.drawPaint(paint);
    }

    @Override
    public void drawPatch(@NonNull NinePatch patch, @NonNull Rect dst, @Nullable Paint paint) {
        super.drawPatch(patch, dst, paint);
    }

    @Override
    public void drawPatch(@NonNull NinePatch patch, @NonNull RectF dst, @Nullable Paint paint) {
        super.drawPatch(patch, dst, paint);
    }

    @Override
    public void drawPath(@NonNull Path path, @NonNull Paint paint) {
        super.drawPath(path, paint);
    }

    @Override
    @FlaggedApi(value="com.android.graphics.hwui.flags.draw_region")
    public void drawRegion(@NonNull Region region, @NonNull Paint paint) {
        super.drawRegion(region, paint);
    }

    @Override
    public void drawPoint(float x, float y, @NonNull Paint paint) {
        super.drawPoint(x, y, paint);
    }

    @Override
    public void drawPoints(float[] pts, int offset, int count, @NonNull Paint paint) {
        super.drawPoints(pts, offset, count, paint);
    }

    @Override
    public void drawPoints(@NonNull float[] pts, @NonNull Paint paint) {
        super.drawPoints(pts, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(@NonNull char[] text, int index, int count, @NonNull float[] pos, @NonNull Paint paint) {
        super.drawPosText(text, index, count, pos, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(@NonNull String text, @NonNull float[] pos, @NonNull Paint paint) {
        super.drawPosText(text, pos, paint);
    }

    @Override
    public void drawRect(@NonNull RectF rect, @NonNull Paint paint) {
        super.drawRect(rect, paint);
    }

    @Override
    public void drawRect(@NonNull Rect r, @NonNull Paint paint) {
        super.drawRect(r, paint);
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, @NonNull Paint paint) {
        super.drawRect(left, top, right, bottom, paint);
    }

    @Override
    public void drawRGB(int r, int g, int b) {
        super.drawRGB(r, g, b);
    }

    @Override
    public void drawRoundRect(@NonNull RectF rect, float rx, float ry, @NonNull Paint paint) {
        super.drawRoundRect(rect, rx, ry, paint);
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, @NonNull Paint paint) {
        super.drawRoundRect(left, top, right, bottom, rx, ry, paint);
    }

    @Override
    public void drawDoubleRoundRect(@NonNull RectF outer, float outerRx, float outerRy, @NonNull RectF inner, float innerRx, float innerRy, @NonNull Paint paint) {
        super.drawDoubleRoundRect(outer, outerRx, outerRy, inner, innerRx, innerRy, paint);
    }

    @Override
    public void drawDoubleRoundRect(@NonNull RectF outer, @NonNull float[] outerRadii, @NonNull RectF inner, @NonNull float[] innerRadii, @NonNull Paint paint) {
        super.drawDoubleRoundRect(outer, outerRadii, inner, innerRadii, paint);
    }

    @Override
    public void drawGlyphs(@NonNull int[] glyphIds, int glyphIdOffset, @NonNull float[] positions, int positionOffset, int glyphCount, @NonNull Font font, @NonNull Paint paint) {
        super.drawGlyphs(glyphIds, glyphIdOffset, positions, positionOffset, glyphCount, font, paint);
    }

    @Override
    public void drawText(@NonNull char[] text, int index, int count, float x, float y, @NonNull Paint paint) {
        super.drawText(text, index, count, x, y, paint);
    }

    @Override
    public void drawText(@NonNull String text, float x, float y, @NonNull Paint paint) {
        super.drawText(text, x, y, paint);
    }

    @Override
    public void drawText(@NonNull String text, int start, int end, float x, float y, @NonNull Paint paint) {
        super.drawText(text, start, end, x, y, paint);
    }

    @Override
    public void drawText(@NonNull CharSequence text, int start, int end, float x, float y, @NonNull Paint paint) {
        super.drawText(text, start, end, x, y, paint);
    }

    @Override
    public void drawTextOnPath(@NonNull char[] text, int index, int count, @NonNull Path path, float hOffset, float vOffset, @NonNull Paint paint) {
        super.drawTextOnPath(text, index, count, path, hOffset, vOffset, paint);
    }

    @Override
    public void drawTextOnPath(@NonNull String text, @NonNull Path path, float hOffset, float vOffset, @NonNull Paint paint) {
        super.drawTextOnPath(text, path, hOffset, vOffset, paint);
    }

    @Override
    public void drawTextRun(@NonNull char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, @NonNull Paint paint) {
        super.drawTextRun(text, index, count, contextIndex, contextCount, x, y, isRtl, paint);
    }

    @Override
    public void drawTextRun(@NonNull CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, @NonNull Paint paint) {
        super.drawTextRun(text, start, end, contextStart, contextEnd, x, y, isRtl, paint);
    }

    @Override
    public void drawTextRun(@NonNull MeasuredText text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, @NonNull Paint paint) {
        super.drawTextRun(text, start, end, contextStart, contextEnd, x, y, isRtl, paint);
    }

    @Override
    public void drawVertices(@NonNull VertexMode mode, int vertexCount, @NonNull float[] verts, int vertOffset, @Nullable float[] texs, int texOffset, @Nullable int[] colors, int colorOffset, @Nullable short[] indices, int indexOffset, int indexCount, @NonNull Paint paint) {
        super.drawVertices(mode, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint);
    }

    public void drawRenderNode(@NonNull RenderNode renderNode) {
        throw new IllegalArgumentException("Software rendering doesn't support drawRenderNode");
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Canvas.class.getClassLoader(), Canvas.nGetNativeFinalizer());

        private NoImagePreloadHolder() {
        }
    }

    public static enum VertexMode {
        TRIANGLES(0),
        TRIANGLE_STRIP(1),
        TRIANGLE_FAN(2);

        final int nativeInt;

        private VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum EdgeType {
        BW,
        AA;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Saveflags {
    }
}

