/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.ParcelFileDescriptor;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@RavenwoodKeepWholeClass
public final class BitmapRegionDecoder {
    private long mNativeBitmapRegionDecoder;
    private boolean mRecycled;
    private final Object mNativeLock = new Object();

    @Deprecated
    @NonNull
    public static BitmapRegionDecoder newInstance(@NonNull byte[] data, int offset, int length, boolean isShareable) throws IOException {
        return BitmapRegionDecoder.newInstance(data, offset, length);
    }

    @NonNull
    public static BitmapRegionDecoder newInstance(@NonNull byte[] data, int offset, int length) throws IOException {
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return BitmapRegionDecoder.nativeNewInstance(data, offset, length);
    }

    @Deprecated
    @NonNull
    public static BitmapRegionDecoder newInstance(@NonNull FileDescriptor fd, boolean isShareable) throws IOException {
        return BitmapRegionDecoder.nativeNewInstance(fd);
    }

    @NonNull
    public static BitmapRegionDecoder newInstance(@NonNull ParcelFileDescriptor pfd) throws IOException {
        return BitmapRegionDecoder.nativeNewInstance(pfd.getFileDescriptor());
    }

    @Deprecated
    @Nullable
    public static BitmapRegionDecoder newInstance(@NonNull InputStream is, boolean isShareable) throws IOException {
        return BitmapRegionDecoder.newInstance(is);
    }

    @Nullable
    public static BitmapRegionDecoder newInstance(@NonNull InputStream is) throws IOException {
        if (is instanceof AssetManager.AssetInputStream) {
            return BitmapRegionDecoder.nativeNewInstance(((AssetManager.AssetInputStream)is).getNativeAsset());
        }
        byte[] tempStorage = new byte[16384];
        return BitmapRegionDecoder.nativeNewInstance(is, tempStorage);
    }

    @Deprecated
    @NonNull
    public static BitmapRegionDecoder newInstance(@NonNull String pathName, boolean isShareable) throws IOException {
        return BitmapRegionDecoder.newInstance(pathName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static BitmapRegionDecoder newInstance(@NonNull String pathName) throws IOException {
        BitmapRegionDecoder decoder = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            decoder = BitmapRegionDecoder.newInstance(stream);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return decoder;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private BitmapRegionDecoder(long decoder) {
        this.mNativeBitmapRegionDecoder = decoder;
        this.mRecycled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        BitmapFactory.Options.validate(options);
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("decodeRegion called on recycled region decoder");
            if (rect.right <= 0 || rect.bottom <= 0 || rect.left >= this.getWidth() || rect.top >= this.getHeight()) {
                throw new IllegalArgumentException("rectangle is outside the image");
            }
            return BitmapRegionDecoder.nativeDecodeRegion(this.mNativeBitmapRegionDecoder, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, options, BitmapFactory.Options.nativeInBitmap(options), BitmapFactory.Options.nativeColorSpace(options));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("getWidth called on recycled region decoder");
            return BitmapRegionDecoder.nativeGetWidth(this.mNativeBitmapRegionDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("getHeight called on recycled region decoder");
            return BitmapRegionDecoder.nativeGetHeight(this.mNativeBitmapRegionDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = this.mNativeLock;
        synchronized (object) {
            if (!this.mRecycled) {
                BitmapRegionDecoder.nativeClean(this.mNativeBitmapRegionDecoder);
                this.mRecycled = true;
            }
        }
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    private void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.recycle();
        }
        finally {
            super.finalize();
        }
    }

    private static native Bitmap nativeDecodeRegion(long var0, int var2, int var3, int var4, int var5, BitmapFactory.Options var6, long var7, long var9);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native void nativeClean(long var0);

    private static native BitmapRegionDecoder nativeNewInstance(byte[] var0, int var1, int var2);

    private static native BitmapRegionDecoder nativeNewInstance(FileDescriptor var0);

    private static native BitmapRegionDecoder nativeNewInstance(InputStream var0, byte[] var1);

    private static native BitmapRegionDecoder nativeNewInstance(long var0);
}

