/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.DatabaseUtils;
import android.database.DefaultDatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCompatibilityWalFlags;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabaseConfiguration;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteDirectCursorDriver;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteGlobal;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteRawStatement;
import android.database.sqlite.SQLiteSession;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.os.Looper;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Printer;
import com.android.internal.util.Preconditions;
import dalvik.annotation.optimization.NeverCompile;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public class SQLiteDatabase
extends SQLiteClosable {
    private static final String TAG = "SQLiteDatabase";
    private static final int EVENT_DB_CORRUPT = 75004;
    private static final boolean DEBUG_CLOSE_IDLE_CONNECTIONS = SystemProperties.getBoolean("persist.debug.sqlite.close_idle_connections", false);
    private static WeakHashMap<SQLiteDatabase, Object> sActiveDatabases = new WeakHashMap();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final ThreadLocal<SQLiteSession> mThreadSession = ThreadLocal.withInitial(this::createSession);
    private final CursorFactory mCursorFactory;
    private final DatabaseErrorHandler mErrorHandler;
    private final Object mLock = new Object();
    private final CloseGuard mCloseGuardLocked = CloseGuard.get();
    @UnsupportedAppUsage
    private final SQLiteDatabaseConfiguration mConfigurationLocked;
    @UnsupportedAppUsage
    private SQLiteConnectionPool mConnectionPoolLocked;
    private boolean mHasAttachedDbsLocked;
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_NONE = 0;
    @UnsupportedAppUsage
    public static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static final int OPEN_READWRITE = 0;
    public static final int OPEN_READONLY = 1;
    private static final int OPEN_READ_MASK = 1;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int NO_DOUBLE_QUOTED_STRS = 32;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    public static final int ENABLE_WRITE_AHEAD_LOGGING = 0x20000000;
    public static final int ENABLE_LEGACY_COMPATIBILITY_WAL = Integer.MIN_VALUE;
    public static final int MAX_SQL_CACHE_SIZE = 100;
    public static final String JOURNAL_MODE_WAL = "WAL";
    public static final String JOURNAL_MODE_PERSIST = "PERSIST";
    public static final String JOURNAL_MODE_TRUNCATE = "TRUNCATE";
    public static final String JOURNAL_MODE_MEMORY = "MEMORY";
    public static final String JOURNAL_MODE_DELETE = "DELETE";
    public static final String JOURNAL_MODE_OFF = "OFF";
    @SuppressLint(value={"IntentName"})
    public static final String SYNC_MODE_EXTRA = "EXTRA";
    public static final String SYNC_MODE_FULL = "FULL";
    public static final String SYNC_MODE_NORMAL = "NORMAL";
    public static final String SYNC_MODE_OFF = "OFF";

    private SQLiteDatabase(@Nullable String path, @Nullable int openFlags, @Nullable CursorFactory cursorFactory, @Nullable DatabaseErrorHandler errorHandler, int lookasideSlotSize, int lookasideSlotCount, long idleConnectionTimeoutMs, @Nullable String journalMode, @Nullable String syncMode) {
        this.mTrackClosure = true;
        this.mCursorFactory = cursorFactory;
        this.mErrorHandler = errorHandler != null ? errorHandler : new DefaultDatabaseErrorHandler();
        this.mConfigurationLocked = new SQLiteDatabaseConfiguration(path, openFlags);
        this.mConfigurationLocked.lookasideSlotSize = lookasideSlotSize;
        this.mConfigurationLocked.lookasideSlotCount = lookasideSlotCount;
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.mConfigurationLocked.lookasideSlotCount = 0;
            this.mConfigurationLocked.lookasideSlotSize = 0;
        }
        long effectiveTimeoutMs = Long.MAX_VALUE;
        if (!this.mConfigurationLocked.isInMemoryDb()) {
            if (idleConnectionTimeoutMs >= 0L) {
                effectiveTimeoutMs = idleConnectionTimeoutMs;
            } else if (DEBUG_CLOSE_IDLE_CONNECTIONS) {
                effectiveTimeoutMs = SQLiteGlobal.getIdleConnectionTimeout();
            }
        }
        this.mConfigurationLocked.idleConnectionTimeoutMs = effectiveTimeoutMs;
        if (SQLiteCompatibilityWalFlags.isLegacyCompatibilityWalEnabled()) {
            this.mConfigurationLocked.openFlags |= Integer.MIN_VALUE;
        }
        if (SQLiteDebug.NoPreloadHolder.NO_DOUBLE_QUOTED_STRS) {
            this.mConfigurationLocked.openFlags |= 0x20;
        }
        this.mConfigurationLocked.journalMode = journalMode;
        this.mConfigurationLocked.syncMode = syncMode;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean finalized) {
        SQLiteConnectionPool pool;
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = this.mLock;
        synchronized (weakHashMap) {
            if (this.mCloseGuardLocked != null) {
                if (finalized) {
                    this.mCloseGuardLocked.warnIfOpen();
                }
                this.mCloseGuardLocked.close();
            }
            pool = this.mConnectionPoolLocked;
            this.mConnectionPoolLocked = null;
        }
        if (!finalized) {
            weakHashMap = sActiveDatabases;
            synchronized (weakHashMap) {
                sActiveDatabases.remove(this);
            }
            if (pool != null) {
                pool.close();
            }
        }
    }

    public static int releaseMemory() {
        return SQLiteGlobal.releaseMemory();
    }

    @Deprecated
    public void setLockingEnabled(boolean lockingEnabled) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLabel() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.label;
        }
    }

    void onCorruption() {
        EventLog.writeEvent(75004, this.getLabel());
        this.mErrorHandler.onCorruption(this);
    }

    @UnsupportedAppUsage
    SQLiteSession getThreadSession() {
        return this.mThreadSession.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLiteSession createSession() {
        SQLiteConnectionPool pool;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            pool = this.mConnectionPoolLocked;
        }
        return new SQLiteSession(pool);
    }

    int getThreadDefaultConnectionFlags(boolean readOnly) {
        int flags;
        int n = flags = readOnly ? 1 : 2;
        if (SQLiteDatabase.isMainThread()) {
            flags |= 4;
        }
        return flags;
    }

    private static boolean isMainThread() {
        Looper looper = Looper.myLooper();
        return looper != null && looper == Looper.getMainLooper();
    }

    public void beginTransaction() {
        this.beginTransaction(null, true);
    }

    public void beginTransactionNonExclusive() {
        this.beginTransaction(null, false);
    }

    public void beginTransactionReadOnly() {
        this.beginTransactionWithListenerReadOnly(null);
    }

    @SuppressLint(value={"ExecutorRegistration"})
    public void beginTransactionWithListener(@Nullable SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, true);
    }

    @SuppressLint(value={"ExecutorRegistration"})
    public void beginTransactionWithListenerNonExclusive(@Nullable SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, false);
    }

    @SuppressLint(value={"ExecutorRegistration"})
    public void beginTransactionWithListenerReadOnly(@Nullable SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, 0);
    }

    @UnsupportedAppUsage
    private void beginTransaction(SQLiteTransactionListener transactionListener, boolean exclusive) {
        this.beginTransaction(transactionListener, exclusive ? 2 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginTransaction(@Nullable SQLiteTransactionListener listener, int mode) {
        this.acquireReference();
        try {
            boolean readOnly = mode == 0;
            this.getThreadSession().beginTransaction(mode, listener, this.getThreadDefaultConnectionFlags(readOnly), null);
        }
        finally {
            this.releaseReference();
        }
    }

    public void endTransaction() {
        this.acquireReference();
        try {
            this.getThreadSession().endTransaction(null);
        }
        finally {
            this.releaseReference();
        }
    }

    public void setTransactionSuccessful() {
        this.acquireReference();
        try {
            this.getThreadSession().setTransactionSuccessful();
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean inTransaction() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasTransaction();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean isDbLockedByCurrentThread() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasConnection();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean isDbLockedByOtherThreads() {
        return false;
    }

    @Deprecated
    public boolean yieldIfContended() {
        return this.yieldIfContendedHelper(false, -1L);
    }

    public boolean yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true, -1L);
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        return this.yieldIfContendedHelper(true, sleepAfterYieldDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean yieldIfContendedHelper(boolean throwIfUnsafe, long sleepAfterYieldDelay) {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().yieldTransaction(sleepAfterYieldDelay, throwIfUnsafe, null);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public Map<String, String> getSyncedTables() {
        return new HashMap<String, String>(0);
    }

    public static SQLiteDatabase openDatabase(@NonNull String path, @Nullable CursorFactory factory, int flags) {
        return SQLiteDatabase.openDatabase(path, factory, flags, null);
    }

    public static SQLiteDatabase openDatabase(@NonNull File path, @NonNull OpenParams openParams) {
        return SQLiteDatabase.openDatabase(path.getPath(), openParams);
    }

    @UnsupportedAppUsage
    private static SQLiteDatabase openDatabase(@NonNull String path, @NonNull OpenParams openParams) {
        Preconditions.checkArgument(openParams != null, "OpenParams cannot be null");
        SQLiteDatabase db = new SQLiteDatabase(path, openParams.mOpenFlags, openParams.mCursorFactory, openParams.mErrorHandler, openParams.mLookasideSlotSize, openParams.mLookasideSlotCount, openParams.mIdleConnectionTimeout, openParams.mJournalMode, openParams.mSyncMode);
        db.open();
        return db;
    }

    public static SQLiteDatabase openDatabase(@NonNull String path, @Nullable CursorFactory factory, int flags, @Nullable DatabaseErrorHandler errorHandler) {
        SQLiteDatabase db = new SQLiteDatabase(path, flags, factory, errorHandler, -1, -1, -1L, null, null);
        db.open();
        return db;
    }

    public static SQLiteDatabase openOrCreateDatabase(@NonNull File file, @Nullable CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), factory);
    }

    public static SQLiteDatabase openOrCreateDatabase(@NonNull String path, @Nullable CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000, null);
    }

    public static SQLiteDatabase openOrCreateDatabase(@NonNull String path, @Nullable CursorFactory factory, @Nullable DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000, errorHandler);
    }

    public static boolean deleteDatabase(@NonNull File file) {
        return SQLiteDatabase.deleteDatabase(file, true);
    }

    public static boolean deleteDatabase(@NonNull File file, boolean removeCheckFile) {
        String prefix;
        File[] files;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        boolean deleted = false;
        deleted |= file.delete();
        deleted |= new File(file.getPath() + "-journal").delete();
        deleted |= new File(file.getPath() + "-shm").delete();
        deleted |= new File(file.getPath() + "-wal").delete();
        new File(file.getPath() + "-wipecheck").delete();
        File dir = file.getParentFile();
        if (dir != null && (files = dir.listFiles(new FileFilter(prefix = file.getName() + "-mj"){
            final /* synthetic */ String val$prefix;
            {
                this.val$prefix = string2;
            }

            @Override
            public boolean accept(File candidate) {
                return candidate.getName().startsWith(this.val$prefix);
            }
        })) != null) {
            for (File masterJournal : files) {
                deleted |= masterJournal.delete();
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void reopenReadWrite() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (!this.isReadOnlyLocked()) {
                return;
            }
            int oldOpenFlags = this.mConfigurationLocked.openFlags;
            this.mConfigurationLocked.openFlags = this.mConfigurationLocked.openFlags & 0xFFFFFFFE | 0;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags = oldOpenFlags;
                throw ex;
            }
        }
    }

    private void open() {
        block5: {
            try {
                try {
                    this.openInner();
                }
                catch (RuntimeException ex) {
                    if (SQLiteDatabaseCorruptException.isCorruptException(ex)) {
                        Log.e(TAG, "Database corruption detected in open()", ex);
                        this.onCorruption();
                        this.openInner();
                        break block5;
                    }
                    throw ex;
                }
            }
            catch (SQLiteException ex) {
                Log.e(TAG, "Failed to open database '" + this.getLabel() + "'.", ex);
                this.close();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openInner() {
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = this.mLock;
        synchronized (weakHashMap) {
            assert (this.mConnectionPoolLocked == null);
            this.mConnectionPoolLocked = SQLiteConnectionPool.open(this.mConfigurationLocked);
            this.mCloseGuardLocked.open("close");
        }
        weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            sActiveDatabases.put(this, null);
        }
    }

    @NonNull
    public static SQLiteDatabase create(@Nullable CursorFactory factory) {
        return SQLiteDatabase.openDatabase(":memory:", factory, 0x10000000);
    }

    @NonNull
    public static SQLiteDatabase createInMemory(@NonNull OpenParams openParams) {
        return SQLiteDatabase.openDatabase(":memory:", openParams.toBuilder().addOpenFlags(0x10000000).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomScalarFunction(@NonNull String functionName, @NonNull UnaryOperator<String> scalarFunction) throws SQLiteException {
        Objects.requireNonNull(functionName);
        Objects.requireNonNull(scalarFunction);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            this.mConfigurationLocked.customScalarFunctions.put(functionName, scalarFunction);
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.customScalarFunctions.remove(functionName);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomAggregateFunction(@NonNull String functionName, @NonNull BinaryOperator<String> aggregateFunction) throws SQLiteException {
        Objects.requireNonNull(functionName);
        Objects.requireNonNull(aggregateFunction);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            this.mConfigurationLocked.customAggregateFunctions.put(functionName, aggregateFunction);
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.customAggregateFunctions.remove(functionName);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execPerConnectionSQL(@NonNull String sql, @Nullable Object[] bindArgs) throws SQLException {
        Objects.requireNonNull(sql);
        bindArgs = DatabaseUtils.deepCopyOf(bindArgs);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            int index = this.mConfigurationLocked.perConnectionSql.size();
            this.mConfigurationLocked.perConnectionSql.add(Pair.create(sql, bindArgs));
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.perConnectionSql.remove(index);
                throw ex;
            }
        }
    }

    public int getVersion() {
        return Long.valueOf(DatabaseUtils.longForQuery(this, "PRAGMA user_version;", null)).intValue();
    }

    public void setVersion(int version) {
        this.execSQL("PRAGMA user_version = " + version);
    }

    public long getMaximumSize() {
        long pageCount = DatabaseUtils.longForQuery(this, "PRAGMA max_page_count;", null);
        return pageCount * this.getPageSize();
    }

    public long setMaximumSize(long numBytes) {
        long pageSize = this.getPageSize();
        long numPages = numBytes / pageSize;
        if (numBytes % pageSize != 0L) {
            ++numPages;
        }
        long newPageCount = DatabaseUtils.longForQuery(this, "PRAGMA max_page_count = " + numPages, null);
        return newPageCount * pageSize;
    }

    public long getPageSize() {
        return DatabaseUtils.longForQuery(this, "PRAGMA page_size;", null);
    }

    public void setPageSize(long numBytes) {
        this.execSQL("PRAGMA page_size = " + numBytes);
    }

    @Deprecated
    public void markTableSyncable(String table, String deletedTable) {
    }

    @Deprecated
    public void markTableSyncable(String table, String foreignKey, String updateTable) {
    }

    public static String findEditTable(String tables) {
        if (!TextUtils.isEmpty(tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    public SQLiteStatement compileStatement(String sql) throws SQLException {
        this.acquireReference();
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, sql, null);
            return sQLiteStatement;
        }
        finally {
            this.releaseReference();
        }
    }

    @NonNull
    public Cursor query(boolean distinct, @NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    @NonNull
    public Cursor query(boolean distinct, @NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit, @Nullable CancellationSignal cancellationSignal) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, cancellationSignal);
    }

    @SuppressLint(value={"SamShouldBeLast"})
    @NonNull
    public Cursor queryWithFactory(@Nullable CursorFactory cursorFactory, boolean distinct, @NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        return this.queryWithFactory(cursorFactory, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"SamShouldBeLast"})
    @NonNull
    public Cursor queryWithFactory(@Nullable CursorFactory cursorFactory, boolean distinct, @NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit, @Nullable CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            String sql = SQLiteQueryBuilder.buildQueryString(distinct, table, columns, selection, groupBy, having, orderBy, limit);
            Cursor cursor = this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(table), cancellationSignal);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    @NonNull
    public Cursor query(@NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    @NonNull
    public Cursor query(@NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    @NonNull
    public Cursor rawQuery(@NonNull String sql, @Nullable String[] selectionArgs) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null, null);
    }

    @NonNull
    public Cursor rawQuery(@NonNull String sql, @Nullable String[] selectionArgs, @Nullable CancellationSignal cancellationSignal) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null, cancellationSignal);
    }

    @NonNull
    public Cursor rawQueryWithFactory(@Nullable CursorFactory cursorFactory, @NonNull String sql, @Nullable String[] selectionArgs, @NonNull String editTable) {
        return this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, editTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cursor rawQueryWithFactory(@Nullable CursorFactory cursorFactory, @NonNull String sql, @Nullable String[] selectionArgs, @NonNull String editTable, @Nullable CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            SQLiteDirectCursorDriver driver = new SQLiteDirectCursorDriver(this, sql, editTable, cancellationSignal);
            Cursor cursor = driver.query(cursorFactory != null ? cursorFactory : this.mCursorFactory, selectionArgs);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    public long insert(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, 0);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting " + values, e);
            return -1L;
        }
    }

    public long insertOrThrow(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    public long replace(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting " + initialValues, e);
            return -1L;
        }
    }

    public long replaceOrThrow(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertWithOnConflict(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues initialValues, int conflictAlgorithm) {
        this.acquireReference();
        try {
            long l;
            int size;
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(" INTO ");
            sql.append(table);
            sql.append('(');
            Object[] bindArgs = null;
            int n = size = initialValues != null && !initialValues.isEmpty() ? initialValues.size() : 0;
            if (size > 0) {
                bindArgs = new Object[size];
                int i = 0;
                for (String colName : initialValues.keySet()) {
                    sql.append(i > 0 ? "," : "");
                    sql.append(colName);
                    bindArgs[i++] = initialValues.get(colName);
                }
                sql.append(')');
                sql.append(" VALUES (");
                for (i = 0; i < size; ++i) {
                    sql.append(i > 0 ? ",?" : "?");
                }
            } else {
                sql.append(nullColumnHack).append(") VALUES (NULL");
            }
            sql.append(')');
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                l = statement.executeInsert();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable String[] whereArgs) {
        this.acquireReference();
        try {
            int n;
            SQLiteStatement statement = new SQLiteStatement(this, "DELETE FROM " + table + (!TextUtils.isEmpty(whereClause) ? " WHERE " + whereClause : ""), whereArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public int update(@NonNull String table, @Nullable ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateWithOnConflict(@NonNull String table, @Nullable ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs, int conflictAlgorithm) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("Empty values");
        }
        this.acquireReference();
        try {
            int n;
            StringBuilder sql = new StringBuilder(120);
            sql.append("UPDATE ");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(table);
            sql.append(" SET ");
            int setValuesSize = values.size();
            int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
            Object[] bindArgs = new Object[bindArgsSize];
            int i = 0;
            for (String colName : values.keySet()) {
                sql.append(i > 0 ? "," : "");
                sql.append(colName);
                bindArgs[i++] = values.get(colName);
                sql.append("=?");
            }
            if (whereArgs != null) {
                for (i = setValuesSize; i < bindArgsSize; ++i) {
                    bindArgs[i] = whereArgs[i - setValuesSize];
                }
            }
            if (!TextUtils.isEmpty(whereClause)) {
                sql.append(" WHERE ");
                sql.append(whereClause);
            }
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public void execSQL(String sql) throws SQLException {
        this.executeSql(sql, null);
    }

    public void execSQL(@NonNull String sql, @NonNull Object[] bindArgs) throws SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        this.executeSql(sql, bindArgs);
    }

    /*
     * Exception decompiling
     */
    public int executeSql(@NonNull String sql, @NonNull Object[] bindArgs) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NonNull
    public SQLiteRawStatement createRawStatement(@NonNull String sql) {
        Objects.requireNonNull(sql);
        return new SQLiteRawStatement(this, sql);
    }

    public long getLastInsertRowId() {
        return this.getThreadSession().getLastInsertRowId();
    }

    public long getLastChangedRowCount() {
        return this.getThreadSession().getLastChangedRowCount();
    }

    public long getTotalChangedRowCount() {
        return this.getThreadSession().getTotalChangedRowCount();
    }

    public void validateSql(@NonNull String sql, @Nullable CancellationSignal cancellationSignal) {
        this.getThreadSession().prepare(sql, this.getThreadDefaultConnectionFlags(true), cancellationSignal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() {
        Object object = this.mLock;
        synchronized (object) {
            return this.isReadOnlyLocked();
        }
    }

    private boolean isReadOnlyLocked() {
        return (this.mConfigurationLocked.openFlags & 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInMemoryDatabase() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.isInMemoryDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConnectionPoolLocked != null;
        }
    }

    public boolean needUpgrade(int newVersion) {
        return newVersion > this.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            Locale oldLocale = this.mConfigurationLocked.locale;
            this.mConfigurationLocked.locale = locale;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.locale = oldLocale;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSqlCacheSize(int cacheSize) {
        if (cacheSize > 100 || cacheSize < 0) {
            throw new IllegalStateException("expected value between 0 and 100");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            int oldMaxSqlCacheSize = this.mConfigurationLocked.maxSqlCacheSize;
            this.mConfigurationLocked.maxSqlCacheSize = cacheSize;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.maxSqlCacheSize = oldMaxSqlCacheSize;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverCompile
    public double getStatementCacheMissRate() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            return this.mConnectionPoolLocked.getStatementCacheMissRate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeignKeyConstraintsEnabled(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (this.mConfigurationLocked.foreignKeyConstraintsEnabled == enable) {
                return;
            }
            this.mConfigurationLocked.foreignKeyConstraintsEnabled = enable;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.foreignKeyConstraintsEnabled = !enable;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (this.mConfigurationLocked.resolveJournalMode().equalsIgnoreCase(JOURNAL_MODE_WAL)) {
                return true;
            }
            if (this.isReadOnlyLocked()) {
                return false;
            }
            if (this.mConfigurationLocked.isInMemoryDb()) {
                Log.i(TAG, "can't enable WAL for memory databases.");
                return false;
            }
            if (this.mHasAttachedDbsLocked) {
                if (Log.isLoggable(TAG, 3)) {
                    Log.d(TAG, "this database: " + this.mConfigurationLocked.label + " has attached databases. can't  enable WAL.");
                }
                return false;
            }
            this.mConfigurationLocked.openFlags |= 0x20000000;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags &= 0xDFFFFFFF;
                throw ex;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            int oldFlags = this.mConfigurationLocked.openFlags;
            if (!this.mConfigurationLocked.resolveJournalMode().equalsIgnoreCase(JOURNAL_MODE_WAL)) {
                return;
            }
            this.mConfigurationLocked.openFlags &= 0xDFFFFFFF;
            this.mConfigurationLocked.openFlags &= Integer.MAX_VALUE;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags = oldFlags;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteAheadLoggingEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            return this.mConfigurationLocked.resolveJournalMode().equalsIgnoreCase(JOURNAL_MODE_WAL);
        }
    }

    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        ArrayList<SQLiteDebug.DbStats> dbStatsList = new ArrayList<SQLiteDebug.DbStats>();
        for (SQLiteDatabase db : SQLiteDatabase.getActiveDatabases()) {
            db.collectDbStats(dbStatsList);
        }
        return dbStatsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private void collectDbStats(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                this.mConnectionPoolLocked.collectDbStats(dbStatsList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private static ArrayList<SQLiteDatabase> getActiveDatabases() {
        ArrayList<SQLiteDatabase> databases = new ArrayList<SQLiteDatabase>();
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            databases.addAll(sActiveDatabases.keySet());
        }
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<SQLiteConnectionPool> getActiveDatabasePools() {
        ArrayList<SQLiteConnectionPool> connectionPools = new ArrayList<SQLiteConnectionPool>();
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            for (SQLiteDatabase db : sActiveDatabases.keySet()) {
                Object object = db.mLock;
                synchronized (object) {
                    if (db.mConnectionPoolLocked != null) {
                        connectionPools.add(db.mConnectionPoolLocked);
                    }
                }
            }
        }
        return connectionPools;
    }

    @NeverCompile
    public int getTotalPreparedStatements() {
        this.throwIfNotOpenLocked();
        return this.mConnectionPoolLocked.mTotalPrepareStatements;
    }

    @NeverCompile
    public int getTotalStatementCacheMisses() {
        this.throwIfNotOpenLocked();
        return this.mConnectionPoolLocked.mTotalPrepareStatementCacheMiss;
    }

    static void dumpAll(Printer printer, boolean verbose, boolean isSystem) {
        ArraySet<String> directories = new ArraySet<String>();
        long totalStatementsTimeInMs = 0L;
        long totalStatementsCount = 0L;
        ArrayList<SQLiteConnectionPool> activeConnectionPools = SQLiteDatabase.getActiveDatabasePools();
        activeConnectionPools.sort((a, b) -> Long.compare(b.getTotalStatementsCount(), a.getTotalStatementsCount()));
        for (SQLiteConnectionPool dbPool : activeConnectionPools) {
            dbPool.dump(printer, verbose, directories);
            totalStatementsTimeInMs += dbPool.getTotalStatementsTime();
            totalStatementsCount += dbPool.getTotalStatementsCount();
        }
        if (totalStatementsCount > 0L) {
            printer.println("Statements Executed per Database");
            for (SQLiteConnectionPool dbPool : activeConnectionPools) {
                printer.println("  " + dbPool.getPath() + " :    " + dbPool.getTotalStatementsCount());
            }
            printer.println("");
            printer.println("Total Statements Executed for all Active Databases: " + totalStatementsCount);
            activeConnectionPools.sort((a, b) -> Long.compare(b.getTotalStatementsTime(), a.getTotalStatementsTime()));
            printer.println("");
            printer.println("");
            printer.println("Statement Time per Database (ms)");
            for (SQLiteConnectionPool dbPool : activeConnectionPools) {
                printer.println("  " + dbPool.getPath() + " :    " + dbPool.getTotalStatementsTime());
            }
            printer.println("Total Statements Time for all Active Databases (ms): " + totalStatementsTimeInMs);
        }
        if (directories.size() > 0) {
            Object[] dirs = directories.toArray(new String[directories.size()]);
            Arrays.sort(dirs);
            for (Object dir : dirs) {
                SQLiteDatabase.dumpDatabaseDirectory(printer, new File((String)dir), isSystem);
            }
        }
    }

    private static void dumpDatabaseDirectory(Printer pw, File dir, boolean isSystem) {
        pw.println("");
        pw.println("Database files in " + dir.getAbsolutePath() + ":");
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            pw.println("  [none]");
            return;
        }
        Arrays.sort(files, (a, b) -> a.getName().compareTo(b.getName()));
        for (File f : files) {
            String name;
            if (isSystem && !(name = f.getName()).endsWith(".db") && !name.endsWith(".db-wal") && !name.endsWith(".db-journal") && !name.endsWith("-wipecheck")) continue;
            pw.println(String.format("  %-40s %7db %s", f.getName(), f.length(), SQLiteDatabase.getFileTimestamps(f.getAbsolutePath())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, String>> getAttachedDbs() {
        ArrayList<Pair<String, String>> attachedDbs = new ArrayList<Pair<String, String>>();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked == null) {
                return null;
            }
            if (!this.mHasAttachedDbsLocked) {
                attachedDbs.add(new Pair<String, String>("main", this.mConfigurationLocked.path));
                return attachedDbs;
            }
            this.acquireReference();
        }
        try {
            try (Cursor c = null;){
                c = this.rawQuery("pragma database_list;", null);
                while (c.moveToNext()) {
                    attachedDbs.add(new Pair<String, String>(c.getString(1), c.getString(2)));
                }
            }
            ArrayList<Pair<String, String>> arrayList = attachedDbs;
            return arrayList;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseIntegrityOk() {
        this.acquireReference();
        try {
            List<Pair<String, String>> attachedDbs = null;
            try {
                attachedDbs = this.getAttachedDbs();
                if (attachedDbs == null) {
                    throw new IllegalStateException("databaselist for: " + this.getPath() + " couldn't be retrieved. probably because the database is closed");
                }
            }
            catch (SQLiteException e) {
                attachedDbs = new ArrayList<Pair<String, String>>();
                attachedDbs.add(new Pair<String, String>("main", this.getPath()));
            }
            for (int i = 0; i < attachedDbs.size(); ++i) {
                Pair<String, String> p = attachedDbs.get(i);
                try (SQLiteClosable prog = null;){
                    prog = this.compileStatement("PRAGMA " + (String)p.first + ".integrity_check(1);");
                    String rslt = ((SQLiteStatement)prog).simpleQueryForString();
                    if (rslt.equalsIgnoreCase("ok")) continue;
                    Log.e(TAG, "PRAGMA integrity_check on " + (String)p.second + " returned: " + rslt);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.releaseReference();
        }
        return true;
    }

    public String toString() {
        return "SQLiteDatabase: " + this.getPath();
    }

    private void throwIfNotOpenLocked() {
        if (this.mConnectionPoolLocked == null) {
            throw new IllegalStateException("The database '" + this.mConfigurationLocked.label + "' is not open.");
        }
    }

    public static void wipeDetected(String filename, String reason) {
        SQLiteDatabase.wtfAsSystemServer(TAG, "DB wipe detected: package=" + ActivityThread.currentPackageName() + " reason=" + reason + " file=" + filename + " " + SQLiteDatabase.getFileTimestamps(filename) + " checkfile " + SQLiteDatabase.getFileTimestamps(filename + "-wipecheck"), new Throwable("STACKTRACE"));
    }

    public static String getFileTimestamps(String path) {
        try {
            BasicFileAttributes attr2 = Files.readAttributes(FileSystems.getDefault().getPath(path, new String[0]), BasicFileAttributes.class, new LinkOption[0]);
            return "ctime=" + attr2.creationTime() + " mtime=" + attr2.lastModifiedTime() + " atime=" + attr2.lastAccessTime();
        }
        catch (IOException e) {
            return "[unable to obtain timestamp]";
        }
    }

    static void wtfAsSystemServer(String tag, String message, Throwable stacktrace) {
        Log.e(tag, message, stacktrace);
        ContentResolver.onDbCorruption(tag, message, stacktrace);
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }

    public static class OpenParams {
        private final int mOpenFlags;
        private final CursorFactory mCursorFactory;
        private final DatabaseErrorHandler mErrorHandler;
        private final int mLookasideSlotSize;
        private final int mLookasideSlotCount;
        private final long mIdleConnectionTimeout;
        private final String mJournalMode;
        private final String mSyncMode;

        private OpenParams(int openFlags, CursorFactory cursorFactory, DatabaseErrorHandler errorHandler, int lookasideSlotSize, int lookasideSlotCount, long idleConnectionTimeout, String journalMode, String syncMode) {
            this.mOpenFlags = openFlags;
            this.mCursorFactory = cursorFactory;
            this.mErrorHandler = errorHandler;
            this.mLookasideSlotSize = lookasideSlotSize;
            this.mLookasideSlotCount = lookasideSlotCount;
            this.mIdleConnectionTimeout = idleConnectionTimeout;
            this.mJournalMode = journalMode;
            this.mSyncMode = syncMode;
        }

        public int getLookasideSlotSize() {
            return this.mLookasideSlotSize;
        }

        public int getLookasideSlotCount() {
            return this.mLookasideSlotCount;
        }

        public int getOpenFlags() {
            return this.mOpenFlags;
        }

        @Nullable
        public CursorFactory getCursorFactory() {
            return this.mCursorFactory;
        }

        @Nullable
        public DatabaseErrorHandler getErrorHandler() {
            return this.mErrorHandler;
        }

        public long getIdleConnectionTimeout() {
            return this.mIdleConnectionTimeout;
        }

        @Nullable
        public String getJournalMode() {
            return this.mJournalMode;
        }

        @Nullable
        public String getSynchronousMode() {
            return this.mSyncMode;
        }

        @NonNull
        public Builder toBuilder() {
            return new Builder(this);
        }

        public static class Builder {
            private int mLookasideSlotSize = -1;
            private int mLookasideSlotCount = -1;
            private long mIdleConnectionTimeout = -1L;
            private int mOpenFlags;
            private CursorFactory mCursorFactory;
            private DatabaseErrorHandler mErrorHandler;
            private String mJournalMode;
            private String mSyncMode;

            public Builder() {
            }

            public Builder(OpenParams params) {
                this.mLookasideSlotSize = params.mLookasideSlotSize;
                this.mLookasideSlotCount = params.mLookasideSlotCount;
                this.mOpenFlags = params.mOpenFlags;
                this.mCursorFactory = params.mCursorFactory;
                this.mErrorHandler = params.mErrorHandler;
                this.mJournalMode = params.mJournalMode;
                this.mSyncMode = params.mSyncMode;
            }

            public Builder setLookasideConfig(int slotSize, int slotCount) {
                Preconditions.checkArgument(slotSize >= 0, "lookasideSlotCount cannot be negative");
                Preconditions.checkArgument(slotCount >= 0, "lookasideSlotSize cannot be negative");
                Preconditions.checkArgument(slotSize > 0 && slotCount > 0 || slotCount == 0 && slotSize == 0, "Invalid configuration: %d, %d", slotSize, slotCount);
                this.mLookasideSlotSize = slotSize;
                this.mLookasideSlotCount = slotCount;
                return this;
            }

            public boolean isWriteAheadLoggingEnabled() {
                return (this.mOpenFlags & 0x20000000) != 0;
            }

            @NonNull
            public Builder setOpenFlags(int openFlags) {
                this.mOpenFlags = openFlags;
                return this;
            }

            @NonNull
            public Builder addOpenFlags(int openFlags) {
                this.mOpenFlags |= openFlags;
                return this;
            }

            @NonNull
            public Builder removeOpenFlags(int openFlags) {
                this.mOpenFlags &= ~openFlags;
                return this;
            }

            public void setWriteAheadLoggingEnabled(boolean enabled) {
                if (enabled) {
                    this.addOpenFlags(0x20000000);
                } else {
                    this.removeOpenFlags(0x20000000);
                }
            }

            @NonNull
            public Builder setCursorFactory(@Nullable CursorFactory cursorFactory) {
                this.mCursorFactory = cursorFactory;
                return this;
            }

            @NonNull
            public Builder setErrorHandler(@Nullable DatabaseErrorHandler errorHandler) {
                this.mErrorHandler = errorHandler;
                return this;
            }

            @Deprecated
            @NonNull
            public Builder setIdleConnectionTimeout(long idleConnectionTimeoutMs) {
                Preconditions.checkArgument(idleConnectionTimeoutMs >= 0L, "idle connection timeout cannot be negative");
                this.mIdleConnectionTimeout = idleConnectionTimeoutMs;
                return this;
            }

            @NonNull
            public Builder setJournalMode(@NonNull String journalMode) {
                Objects.requireNonNull(journalMode);
                this.mJournalMode = journalMode;
                return this;
            }

            @NonNull
            public Builder setSynchronousMode(@NonNull String syncMode) {
                Objects.requireNonNull(syncMode);
                this.mSyncMode = syncMode;
                return this;
            }

            @NonNull
            public OpenParams build() {
                return new OpenParams(this.mOpenFlags, this.mCursorFactory, this.mErrorHandler, this.mLookasideSlotSize, this.mLookasideSlotCount, this.mIdleConnectionTimeout, this.mJournalMode, this.mSyncMode);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DatabaseOpenFlags {
    }

    public static interface CustomFunction {
        public void callback(String[] var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SyncMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JournalMode {
    }
}

